/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourceDefinitionsResponse extends GreengrassResponse implements
        ToCopyableBuilder<ListResourceDefinitionsResponse.Builder, ListResourceDefinitionsResponse> {
    private static final SdkField<List<DefinitionInformation>> DEFINITIONS_FIELD = SdkField
            .<List<DefinitionInformation>> builder(MarshallingType.LIST)
            .memberName("Definitions")
            .getter(getter(ListResourceDefinitionsResponse::definitions))
            .setter(setter(Builder::definitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DefinitionInformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(DefinitionInformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListResourceDefinitionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINITIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DefinitionInformation> definitions;

    private final String nextToken;

    private ListResourceDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.definitions = builder.definitions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Definitions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDefinitions() {
        return definitions != null && !(definitions instanceof SdkAutoConstructList);
    }

    /**
     * Information about a definition.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDefinitions} method.
     * </p>
     * 
     * @return Information about a definition.
     */
    public final List<DefinitionInformation> definitions() {
        return definitions;
    }

    /**
     * The token for the next set of results, or ''null'' if there are no additional results.
     * 
     * @return The token for the next set of results, or ''null'' if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDefinitions() ? definitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceDefinitionsResponse)) {
            return false;
        }
        ListResourceDefinitionsResponse other = (ListResourceDefinitionsResponse) obj;
        return hasDefinitions() == other.hasDefinitions() && Objects.equals(definitions(), other.definitions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResourceDefinitionsResponse").add("Definitions", hasDefinitions() ? definitions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Definitions":
            return Optional.ofNullable(clazz.cast(definitions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourceDefinitionsResponse, T> g) {
        return obj -> g.apply((ListResourceDefinitionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListResourceDefinitionsResponse> {
        /**
         * Information about a definition.
         * 
         * @param definitions
         *        Information about a definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definitions(Collection<DefinitionInformation> definitions);

        /**
         * Information about a definition.
         * 
         * @param definitions
         *        Information about a definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definitions(DefinitionInformation... definitions);

        /**
         * Information about a definition. This is a convenience that creates an instance of the {@link List
         * <DefinitionInformation>.Builder} avoiding the need to create one manually via {@link List
         * <DefinitionInformation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DefinitionInformation>.Builder#build()} is called
         * immediately and its result is passed to {@link #definitions(List<DefinitionInformation>)}.
         * 
         * @param definitions
         *        a consumer that will call methods on {@link List<DefinitionInformation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definitions(List<DefinitionInformation>)
         */
        Builder definitions(Consumer<DefinitionInformation.Builder>... definitions);

        /**
         * The token for the next set of results, or ''null'' if there are no additional results.
         * 
         * @param nextToken
         *        The token for the next set of results, or ''null'' if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GreengrassResponse.BuilderImpl implements Builder {
        private List<DefinitionInformation> definitions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceDefinitionsResponse model) {
            super(model);
            definitions(model.definitions);
            nextToken(model.nextToken);
        }

        public final List<DefinitionInformation.Builder> getDefinitions() {
            List<DefinitionInformation.Builder> result = ___listOfDefinitionInformationCopier.copyToBuilder(this.definitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDefinitions(Collection<DefinitionInformation.BuilderImpl> definitions) {
            this.definitions = ___listOfDefinitionInformationCopier.copyFromBuilder(definitions);
        }

        @Override
        @Transient
        public final Builder definitions(Collection<DefinitionInformation> definitions) {
            this.definitions = ___listOfDefinitionInformationCopier.copy(definitions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder definitions(DefinitionInformation... definitions) {
            definitions(Arrays.asList(definitions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder definitions(Consumer<DefinitionInformation.Builder>... definitions) {
            definitions(Stream.of(definitions).map(c -> DefinitionInformation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListResourceDefinitionsResponse build() {
            return new ListResourceDefinitionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
