/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.grafana.GrafanaAsyncClient;
import software.amazon.awssdk.services.grafana.internal.UserAgentUtils;
import software.amazon.awssdk.services.grafana.model.ListWorkspaceServiceAccountTokensRequest;
import software.amazon.awssdk.services.grafana.model.ListWorkspaceServiceAccountTokensResponse;
import software.amazon.awssdk.services.grafana.model.ServiceAccountTokenSummary;

public class ListWorkspaceServiceAccountTokensPublisher
implements SdkPublisher<ListWorkspaceServiceAccountTokensResponse> {
    private final GrafanaAsyncClient client;
    private final ListWorkspaceServiceAccountTokensRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkspaceServiceAccountTokensPublisher(GrafanaAsyncClient client, ListWorkspaceServiceAccountTokensRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkspaceServiceAccountTokensPublisher(GrafanaAsyncClient client, ListWorkspaceServiceAccountTokensRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkspaceServiceAccountTokensResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkspaceServiceAccountTokensResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServiceAccountTokenSummary> serviceAccountTokens() {
        Function<ListWorkspaceServiceAccountTokensResponse, Iterator> getIterator = response -> {
            if (response != null && response.serviceAccountTokens() != null) {
                return response.serviceAccountTokens().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWorkspaceServiceAccountTokensResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWorkspaceServiceAccountTokensResponseFetcher
    implements AsyncPageFetcher<ListWorkspaceServiceAccountTokensResponse> {
        private ListWorkspaceServiceAccountTokensResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkspaceServiceAccountTokensResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkspaceServiceAccountTokensResponse> nextPage(ListWorkspaceServiceAccountTokensResponse previousPage) {
            if (previousPage == null) {
                return ListWorkspaceServiceAccountTokensPublisher.this.client.listWorkspaceServiceAccountTokens(ListWorkspaceServiceAccountTokensPublisher.this.firstRequest);
            }
            return ListWorkspaceServiceAccountTokensPublisher.this.client.listWorkspaceServiceAccountTokens((ListWorkspaceServiceAccountTokensRequest)((Object)ListWorkspaceServiceAccountTokensPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

