/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.grafana.GrafanaClient;
import software.amazon.awssdk.services.grafana.internal.UserAgentUtils;
import software.amazon.awssdk.services.grafana.model.ListWorkspaceServiceAccountsRequest;
import software.amazon.awssdk.services.grafana.model.ListWorkspaceServiceAccountsResponse;
import software.amazon.awssdk.services.grafana.model.ServiceAccountSummary;

public class ListWorkspaceServiceAccountsIterable
implements SdkIterable<ListWorkspaceServiceAccountsResponse> {
    private final GrafanaClient client;
    private final ListWorkspaceServiceAccountsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkspaceServiceAccountsIterable(GrafanaClient client, ListWorkspaceServiceAccountsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWorkspaceServiceAccountsResponseFetcher();
    }

    public Iterator<ListWorkspaceServiceAccountsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServiceAccountSummary> serviceAccounts() {
        Function<ListWorkspaceServiceAccountsResponse, Iterator> getIterator = response -> {
            if (response != null && response.serviceAccounts() != null) {
                return response.serviceAccounts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkspaceServiceAccountsResponseFetcher
    implements SyncPageFetcher<ListWorkspaceServiceAccountsResponse> {
        private ListWorkspaceServiceAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkspaceServiceAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkspaceServiceAccountsResponse nextPage(ListWorkspaceServiceAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkspaceServiceAccountsIterable.this.client.listWorkspaceServiceAccounts(ListWorkspaceServiceAccountsIterable.this.firstRequest);
            }
            return ListWorkspaceServiceAccountsIterable.this.client.listWorkspaceServiceAccounts((ListWorkspaceServiceAccountsRequest)((Object)ListWorkspaceServiceAccountsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

