/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WorkspaceStatus {
    ACTIVE("ACTIVE"),
    CREATING("CREATING"),
    DELETING("DELETING"),
    FAILED("FAILED"),
    UPDATING("UPDATING"),
    UPGRADING("UPGRADING"),
    DELETION_FAILED("DELETION_FAILED"),
    CREATION_FAILED("CREATION_FAILED"),
    UPDATE_FAILED("UPDATE_FAILED"),
    UPGRADE_FAILED("UPGRADE_FAILED"),
    LICENSE_REMOVAL_FAILED("LICENSE_REMOVAL_FAILED"),
    VERSION_UPDATING("VERSION_UPDATING"),
    VERSION_UPDATE_FAILED("VERSION_UPDATE_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WorkspaceStatus> VALUE_MAP;
    private final String value;

    private WorkspaceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorkspaceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorkspaceStatus> knownValues() {
        EnumSet<WorkspaceStatus> knownValues = EnumSet.allOf(WorkspaceStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WorkspaceStatus.class, WorkspaceStatus::toString);
    }
}

