/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.Capabilities;
import software.amazon.awssdk.services.glue.model.ConnectionType;
import software.amazon.awssdk.services.glue.model.ConnectionTypeVariant;
import software.amazon.awssdk.services.glue.model.ConnectionTypeVariantListCopier;
import software.amazon.awssdk.services.glue.model.ListOfStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionTypeBrief
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectionTypeBrief> {
    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionType").getter(ConnectionTypeBrief.getter(ConnectionTypeBrief::connectionTypeAsString)).setter(ConnectionTypeBrief.setter(Builder::connectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(ConnectionTypeBrief.getter(ConnectionTypeBrief::displayName)).setter(ConnectionTypeBrief.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> VENDOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Vendor").getter(ConnectionTypeBrief.getter(ConnectionTypeBrief::vendor)).setter(ConnectionTypeBrief.setter(Builder::vendor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vendor").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ConnectionTypeBrief.getter(ConnectionTypeBrief::description)).setter(ConnectionTypeBrief.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<String>> CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Categories").getter(ConnectionTypeBrief.getter(ConnectionTypeBrief::categories)).setter(ConnectionTypeBrief.setter(Builder::categories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Categories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Capabilities> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Capabilities").getter(ConnectionTypeBrief.getter(ConnectionTypeBrief::capabilities)).setter(ConnectionTypeBrief.setter(Builder::capabilities)).constructor(Capabilities::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build()}).build();
    private static final SdkField<String> LOGO_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogoUrl").getter(ConnectionTypeBrief.getter(ConnectionTypeBrief::logoUrl)).setter(ConnectionTypeBrief.setter(Builder::logoUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogoUrl").build()}).build();
    private static final SdkField<List<ConnectionTypeVariant>> CONNECTION_TYPE_VARIANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConnectionTypeVariants").getter(ConnectionTypeBrief.getter(ConnectionTypeBrief::connectionTypeVariants)).setter(ConnectionTypeBrief.setter(Builder::connectionTypeVariants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionTypeVariants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConnectionTypeVariant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_TYPE_FIELD, DISPLAY_NAME_FIELD, VENDOR_FIELD, DESCRIPTION_FIELD, CATEGORIES_FIELD, CAPABILITIES_FIELD, LOGO_URL_FIELD, CONNECTION_TYPE_VARIANTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConnectionTypeBrief.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String connectionType;
    private final String displayName;
    private final String vendor;
    private final String description;
    private final List<String> categories;
    private final Capabilities capabilities;
    private final String logoUrl;
    private final List<ConnectionTypeVariant> connectionTypeVariants;

    private ConnectionTypeBrief(BuilderImpl builder) {
        this.connectionType = builder.connectionType;
        this.displayName = builder.displayName;
        this.vendor = builder.vendor;
        this.description = builder.description;
        this.categories = builder.categories;
        this.capabilities = builder.capabilities;
        this.logoUrl = builder.logoUrl;
        this.connectionTypeVariants = builder.connectionTypeVariants;
    }

    public final ConnectionType connectionType() {
        return ConnectionType.fromValue(this.connectionType);
    }

    public final String connectionTypeAsString() {
        return this.connectionType;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String vendor() {
        return this.vendor;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasCategories() {
        return this.categories != null && !(this.categories instanceof SdkAutoConstructList);
    }

    public final List<String> categories() {
        return this.categories;
    }

    public final Capabilities capabilities() {
        return this.capabilities;
    }

    public final String logoUrl() {
        return this.logoUrl;
    }

    public final boolean hasConnectionTypeVariants() {
        return this.connectionTypeVariants != null && !(this.connectionTypeVariants instanceof SdkAutoConstructList);
    }

    public final List<ConnectionTypeVariant> connectionTypeVariants() {
        return this.connectionTypeVariants;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vendor());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategories() ? this.categories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilities());
        hashCode = 31 * hashCode + Objects.hashCode(this.logoUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionTypeVariants() ? this.connectionTypeVariants() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionTypeBrief)) {
            return false;
        }
        ConnectionTypeBrief other = (ConnectionTypeBrief)obj;
        return Objects.equals(this.connectionTypeAsString(), other.connectionTypeAsString()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.vendor(), other.vendor()) && Objects.equals(this.description(), other.description()) && this.hasCategories() == other.hasCategories() && Objects.equals(this.categories(), other.categories()) && Objects.equals(this.capabilities(), other.capabilities()) && Objects.equals(this.logoUrl(), other.logoUrl()) && this.hasConnectionTypeVariants() == other.hasConnectionTypeVariants() && Objects.equals(this.connectionTypeVariants(), other.connectionTypeVariants());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectionTypeBrief").add("ConnectionType", (Object)this.connectionTypeAsString()).add("DisplayName", (Object)this.displayName()).add("Vendor", (Object)this.vendor()).add("Description", (Object)this.description()).add("Categories", this.hasCategories() ? this.categories() : null).add("Capabilities", (Object)this.capabilities()).add("LogoUrl", (Object)this.logoUrl()).add("ConnectionTypeVariants", this.hasConnectionTypeVariants() ? this.connectionTypeVariants() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionType": {
                return Optional.ofNullable(clazz.cast(this.connectionTypeAsString()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "Vendor": {
                return Optional.ofNullable(clazz.cast(this.vendor()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Categories": {
                return Optional.ofNullable(clazz.cast(this.categories()));
            }
            case "Capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilities()));
            }
            case "LogoUrl": {
                return Optional.ofNullable(clazz.cast(this.logoUrl()));
            }
            case "ConnectionTypeVariants": {
                return Optional.ofNullable(clazz.cast(this.connectionTypeVariants()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConnectionType", CONNECTION_TYPE_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("Vendor", VENDOR_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Categories", CATEGORIES_FIELD);
        map.put("Capabilities", CAPABILITIES_FIELD);
        map.put("LogoUrl", LOGO_URL_FIELD);
        map.put("ConnectionTypeVariants", CONNECTION_TYPE_VARIANTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionTypeBrief, T> g) {
        return obj -> g.apply((ConnectionTypeBrief)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectionType;
        private String displayName;
        private String vendor;
        private String description;
        private List<String> categories = DefaultSdkAutoConstructList.getInstance();
        private Capabilities capabilities;
        private String logoUrl;
        private List<ConnectionTypeVariant> connectionTypeVariants = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionTypeBrief model) {
            this.connectionType(model.connectionType);
            this.displayName(model.displayName);
            this.vendor(model.vendor);
            this.description(model.description);
            this.categories(model.categories);
            this.capabilities(model.capabilities);
            this.logoUrl(model.logoUrl);
            this.connectionTypeVariants(model.connectionTypeVariants);
        }

        public final String getConnectionType() {
            return this.connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getVendor() {
            return this.vendor;
        }

        public final void setVendor(String vendor) {
            this.vendor = vendor;
        }

        @Override
        public final Builder vendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getCategories() {
            if (this.categories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.categories;
        }

        public final void setCategories(Collection<String> categories) {
            this.categories = ListOfStringCopier.copy(categories);
        }

        @Override
        public final Builder categories(Collection<String> categories) {
            this.categories = ListOfStringCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(String ... categories) {
            this.categories(Arrays.asList(categories));
            return this;
        }

        public final Capabilities.Builder getCapabilities() {
            return this.capabilities != null ? this.capabilities.toBuilder() : null;
        }

        public final void setCapabilities(Capabilities.BuilderImpl capabilities) {
            this.capabilities = capabilities != null ? capabilities.build() : null;
        }

        @Override
        public final Builder capabilities(Capabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public final String getLogoUrl() {
            return this.logoUrl;
        }

        public final void setLogoUrl(String logoUrl) {
            this.logoUrl = logoUrl;
        }

        @Override
        public final Builder logoUrl(String logoUrl) {
            this.logoUrl = logoUrl;
            return this;
        }

        public final List<ConnectionTypeVariant.Builder> getConnectionTypeVariants() {
            List<ConnectionTypeVariant.Builder> result = ConnectionTypeVariantListCopier.copyToBuilder(this.connectionTypeVariants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnectionTypeVariants(Collection<ConnectionTypeVariant.BuilderImpl> connectionTypeVariants) {
            this.connectionTypeVariants = ConnectionTypeVariantListCopier.copyFromBuilder(connectionTypeVariants);
        }

        @Override
        public final Builder connectionTypeVariants(Collection<ConnectionTypeVariant> connectionTypeVariants) {
            this.connectionTypeVariants = ConnectionTypeVariantListCopier.copy(connectionTypeVariants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionTypeVariants(ConnectionTypeVariant ... connectionTypeVariants) {
            this.connectionTypeVariants(Arrays.asList(connectionTypeVariants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionTypeVariants(Consumer<ConnectionTypeVariant.Builder> ... connectionTypeVariants) {
            this.connectionTypeVariants(Stream.of(connectionTypeVariants).map(c -> (ConnectionTypeVariant)((ConnectionTypeVariant.Builder)ConnectionTypeVariant.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ConnectionTypeBrief build() {
            return new ConnectionTypeBrief(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectionTypeBrief> {
        public Builder connectionType(String var1);

        public Builder connectionType(ConnectionType var1);

        public Builder displayName(String var1);

        public Builder vendor(String var1);

        public Builder description(String var1);

        public Builder categories(Collection<String> var1);

        public Builder categories(String ... var1);

        public Builder capabilities(Capabilities var1);

        default public Builder capabilities(Consumer<Capabilities.Builder> capabilities) {
            return this.capabilities((Capabilities)((Capabilities.Builder)Capabilities.builder().applyMutation(capabilities)).build());
        }

        public Builder logoUrl(String var1);

        public Builder connectionTypeVariants(Collection<ConnectionTypeVariant> var1);

        public Builder connectionTypeVariants(ConnectionTypeVariant ... var1);

        public Builder connectionTypeVariants(Consumer<ConnectionTypeVariant.Builder> ... var1);
    }
}

