/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SettingSource {
    CATALOG("CATALOG"),
    TABLE("TABLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SettingSource> VALUE_MAP;
    private final String value;

    private SettingSource(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SettingSource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SettingSource> knownValues() {
        EnumSet<SettingSource> knownValues = EnumSet.allOf(SettingSource.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SettingSource.class, SettingSource::toString);
    }
}

