/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamingDataPreviewOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreamingDataPreviewOptions> {
    private static final SdkField<Long> POLLING_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("PollingTime").getter(StreamingDataPreviewOptions.getter(StreamingDataPreviewOptions::pollingTime)).setter(StreamingDataPreviewOptions.setter(Builder::pollingTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PollingTime").build()}).build();
    private static final SdkField<Long> RECORD_POLLING_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("RecordPollingLimit").getter(StreamingDataPreviewOptions.getter(StreamingDataPreviewOptions::recordPollingLimit)).setter(StreamingDataPreviewOptions.setter(Builder::recordPollingLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordPollingLimit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLLING_TIME_FIELD, RECORD_POLLING_LIMIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StreamingDataPreviewOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long pollingTime;
    private final Long recordPollingLimit;

    private StreamingDataPreviewOptions(BuilderImpl builder) {
        this.pollingTime = builder.pollingTime;
        this.recordPollingLimit = builder.recordPollingLimit;
    }

    public final Long pollingTime() {
        return this.pollingTime;
    }

    public final Long recordPollingLimit() {
        return this.recordPollingLimit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pollingTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordPollingLimit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingDataPreviewOptions)) {
            return false;
        }
        StreamingDataPreviewOptions other = (StreamingDataPreviewOptions)obj;
        return Objects.equals(this.pollingTime(), other.pollingTime()) && Objects.equals(this.recordPollingLimit(), other.recordPollingLimit());
    }

    public final String toString() {
        return ToString.builder((String)"StreamingDataPreviewOptions").add("PollingTime", (Object)this.pollingTime()).add("RecordPollingLimit", (Object)this.recordPollingLimit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PollingTime": {
                return Optional.ofNullable(clazz.cast(this.pollingTime()));
            }
            case "RecordPollingLimit": {
                return Optional.ofNullable(clazz.cast(this.recordPollingLimit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Long>> map = new HashMap<String, SdkField<Long>>();
        map.put("PollingTime", POLLING_TIME_FIELD);
        map.put("RecordPollingLimit", RECORD_POLLING_LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StreamingDataPreviewOptions, T> g) {
        return obj -> g.apply((StreamingDataPreviewOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long pollingTime;
        private Long recordPollingLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingDataPreviewOptions model) {
            this.pollingTime(model.pollingTime);
            this.recordPollingLimit(model.recordPollingLimit);
        }

        public final Long getPollingTime() {
            return this.pollingTime;
        }

        public final void setPollingTime(Long pollingTime) {
            this.pollingTime = pollingTime;
        }

        @Override
        public final Builder pollingTime(Long pollingTime) {
            this.pollingTime = pollingTime;
            return this;
        }

        public final Long getRecordPollingLimit() {
            return this.recordPollingLimit;
        }

        public final void setRecordPollingLimit(Long recordPollingLimit) {
            this.recordPollingLimit = recordPollingLimit;
        }

        @Override
        public final Builder recordPollingLimit(Long recordPollingLimit) {
            this.recordPollingLimit = recordPollingLimit;
            return this;
        }

        public StreamingDataPreviewOptions build() {
            return new StreamingDataPreviewOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreamingDataPreviewOptions> {
        public Builder pollingTime(Long var1);

        public Builder recordPollingLimit(Long var1);
    }
}

