/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.ExecutionClass;
import software.amazon.awssdk.services.glue.model.GenericMapCopier;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.NotificationProperty;
import software.amazon.awssdk.services.glue.model.WorkerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartJobRunRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, StartJobRunRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(StartJobRunRequest.getter(StartJobRunRequest::jobName)).setter(StartJobRunRequest.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<Boolean> JOB_RUN_QUEUING_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("JobRunQueuingEnabled").getter(StartJobRunRequest.getter(StartJobRunRequest::jobRunQueuingEnabled)).setter(StartJobRunRequest.setter(Builder::jobRunQueuingEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobRunQueuingEnabled").build()}).build();
    private static final SdkField<String> JOB_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobRunId").getter(StartJobRunRequest.getter(StartJobRunRequest::jobRunId)).setter(StartJobRunRequest.setter(Builder::jobRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobRunId").build()}).build();
    private static final SdkField<Map<String, String>> ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Arguments").getter(StartJobRunRequest.getter(StartJobRunRequest::arguments)).setter(StartJobRunRequest.setter(Builder::arguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arguments").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> ALLOCATED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocatedCapacity").getter(StartJobRunRequest.getter(StartJobRunRequest::allocatedCapacity)).setter(StartJobRunRequest.setter(Builder::allocatedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedCapacity").build()}).build();
    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Timeout").getter(StartJobRunRequest.getter(StartJobRunRequest::timeout)).setter(StartJobRunRequest.setter(Builder::timeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()}).build();
    private static final SdkField<Double> MAX_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MaxCapacity").getter(StartJobRunRequest.getter(StartJobRunRequest::maxCapacity)).setter(StartJobRunRequest.setter(Builder::maxCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()}).build();
    private static final SdkField<String> SECURITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityConfiguration").getter(StartJobRunRequest.getter(StartJobRunRequest::securityConfiguration)).setter(StartJobRunRequest.setter(Builder::securityConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfiguration").build()}).build();
    private static final SdkField<NotificationProperty> NOTIFICATION_PROPERTY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotificationProperty").getter(StartJobRunRequest.getter(StartJobRunRequest::notificationProperty)).setter(StartJobRunRequest.setter(Builder::notificationProperty)).constructor(NotificationProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationProperty").build()}).build();
    private static final SdkField<String> WORKER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkerType").getter(StartJobRunRequest.getter(StartJobRunRequest::workerTypeAsString)).setter(StartJobRunRequest.setter(Builder::workerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerType").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_WORKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfWorkers").getter(StartJobRunRequest.getter(StartJobRunRequest::numberOfWorkers)).setter(StartJobRunRequest.setter(Builder::numberOfWorkers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfWorkers").build()}).build();
    private static final SdkField<String> EXECUTION_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionClass").getter(StartJobRunRequest.getter(StartJobRunRequest::executionClassAsString)).setter(StartJobRunRequest.setter(Builder::executionClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionClass").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_SESSION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleSessionPolicy").getter(StartJobRunRequest.getter(StartJobRunRequest::executionRoleSessionPolicy)).setter(StartJobRunRequest.setter(Builder::executionRoleSessionPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleSessionPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, JOB_RUN_QUEUING_ENABLED_FIELD, JOB_RUN_ID_FIELD, ARGUMENTS_FIELD, ALLOCATED_CAPACITY_FIELD, TIMEOUT_FIELD, MAX_CAPACITY_FIELD, SECURITY_CONFIGURATION_FIELD, NOTIFICATION_PROPERTY_FIELD, WORKER_TYPE_FIELD, NUMBER_OF_WORKERS_FIELD, EXECUTION_CLASS_FIELD, EXECUTION_ROLE_SESSION_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartJobRunRequest.memberNameToFieldInitializer();
    private final String jobName;
    private final Boolean jobRunQueuingEnabled;
    private final String jobRunId;
    private final Map<String, String> arguments;
    private final Integer allocatedCapacity;
    private final Integer timeout;
    private final Double maxCapacity;
    private final String securityConfiguration;
    private final NotificationProperty notificationProperty;
    private final String workerType;
    private final Integer numberOfWorkers;
    private final String executionClass;
    private final String executionRoleSessionPolicy;

    private StartJobRunRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.jobRunQueuingEnabled = builder.jobRunQueuingEnabled;
        this.jobRunId = builder.jobRunId;
        this.arguments = builder.arguments;
        this.allocatedCapacity = builder.allocatedCapacity;
        this.timeout = builder.timeout;
        this.maxCapacity = builder.maxCapacity;
        this.securityConfiguration = builder.securityConfiguration;
        this.notificationProperty = builder.notificationProperty;
        this.workerType = builder.workerType;
        this.numberOfWorkers = builder.numberOfWorkers;
        this.executionClass = builder.executionClass;
        this.executionRoleSessionPolicy = builder.executionRoleSessionPolicy;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final Boolean jobRunQueuingEnabled() {
        return this.jobRunQueuingEnabled;
    }

    public final String jobRunId() {
        return this.jobRunId;
    }

    public final boolean hasArguments() {
        return this.arguments != null && !(this.arguments instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> arguments() {
        return this.arguments;
    }

    @Deprecated
    public final Integer allocatedCapacity() {
        return this.allocatedCapacity;
    }

    public final Integer timeout() {
        return this.timeout;
    }

    public final Double maxCapacity() {
        return this.maxCapacity;
    }

    public final String securityConfiguration() {
        return this.securityConfiguration;
    }

    public final NotificationProperty notificationProperty() {
        return this.notificationProperty;
    }

    public final WorkerType workerType() {
        return WorkerType.fromValue(this.workerType);
    }

    public final String workerTypeAsString() {
        return this.workerType;
    }

    public final Integer numberOfWorkers() {
        return this.numberOfWorkers;
    }

    public final ExecutionClass executionClass() {
        return ExecutionClass.fromValue(this.executionClass);
    }

    public final String executionClassAsString() {
        return this.executionClass;
    }

    public final String executionRoleSessionPolicy() {
        return this.executionRoleSessionPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobRunQueuingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArguments() ? this.arguments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationProperty());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleSessionPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartJobRunRequest)) {
            return false;
        }
        StartJobRunRequest other = (StartJobRunRequest)((Object)obj);
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobRunQueuingEnabled(), other.jobRunQueuingEnabled()) && Objects.equals(this.jobRunId(), other.jobRunId()) && this.hasArguments() == other.hasArguments() && Objects.equals(this.arguments(), other.arguments()) && Objects.equals(this.allocatedCapacity(), other.allocatedCapacity()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.maxCapacity(), other.maxCapacity()) && Objects.equals(this.securityConfiguration(), other.securityConfiguration()) && Objects.equals(this.notificationProperty(), other.notificationProperty()) && Objects.equals(this.workerTypeAsString(), other.workerTypeAsString()) && Objects.equals(this.numberOfWorkers(), other.numberOfWorkers()) && Objects.equals(this.executionClassAsString(), other.executionClassAsString()) && Objects.equals(this.executionRoleSessionPolicy(), other.executionRoleSessionPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"StartJobRunRequest").add("JobName", (Object)this.jobName()).add("JobRunQueuingEnabled", (Object)this.jobRunQueuingEnabled()).add("JobRunId", (Object)this.jobRunId()).add("Arguments", this.hasArguments() ? this.arguments() : null).add("AllocatedCapacity", (Object)this.allocatedCapacity()).add("Timeout", (Object)this.timeout()).add("MaxCapacity", (Object)this.maxCapacity()).add("SecurityConfiguration", (Object)this.securityConfiguration()).add("NotificationProperty", (Object)this.notificationProperty()).add("WorkerType", (Object)this.workerTypeAsString()).add("NumberOfWorkers", (Object)this.numberOfWorkers()).add("ExecutionClass", (Object)this.executionClassAsString()).add("ExecutionRoleSessionPolicy", (Object)this.executionRoleSessionPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "JobRunQueuingEnabled": {
                return Optional.ofNullable(clazz.cast(this.jobRunQueuingEnabled()));
            }
            case "JobRunId": {
                return Optional.ofNullable(clazz.cast(this.jobRunId()));
            }
            case "Arguments": {
                return Optional.ofNullable(clazz.cast(this.arguments()));
            }
            case "AllocatedCapacity": {
                return Optional.ofNullable(clazz.cast(this.allocatedCapacity()));
            }
            case "Timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "MaxCapacity": {
                return Optional.ofNullable(clazz.cast(this.maxCapacity()));
            }
            case "SecurityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.securityConfiguration()));
            }
            case "NotificationProperty": {
                return Optional.ofNullable(clazz.cast(this.notificationProperty()));
            }
            case "WorkerType": {
                return Optional.ofNullable(clazz.cast(this.workerTypeAsString()));
            }
            case "NumberOfWorkers": {
                return Optional.ofNullable(clazz.cast(this.numberOfWorkers()));
            }
            case "ExecutionClass": {
                return Optional.ofNullable(clazz.cast(this.executionClassAsString()));
            }
            case "ExecutionRoleSessionPolicy": {
                return Optional.ofNullable(clazz.cast(this.executionRoleSessionPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JobName", JOB_NAME_FIELD);
        map.put("JobRunQueuingEnabled", JOB_RUN_QUEUING_ENABLED_FIELD);
        map.put("JobRunId", JOB_RUN_ID_FIELD);
        map.put("Arguments", ARGUMENTS_FIELD);
        map.put("AllocatedCapacity", ALLOCATED_CAPACITY_FIELD);
        map.put("Timeout", TIMEOUT_FIELD);
        map.put("MaxCapacity", MAX_CAPACITY_FIELD);
        map.put("SecurityConfiguration", SECURITY_CONFIGURATION_FIELD);
        map.put("NotificationProperty", NOTIFICATION_PROPERTY_FIELD);
        map.put("WorkerType", WORKER_TYPE_FIELD);
        map.put("NumberOfWorkers", NUMBER_OF_WORKERS_FIELD);
        map.put("ExecutionClass", EXECUTION_CLASS_FIELD);
        map.put("ExecutionRoleSessionPolicy", EXECUTION_ROLE_SESSION_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartJobRunRequest, T> g) {
        return obj -> g.apply((StartJobRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String jobName;
        private Boolean jobRunQueuingEnabled;
        private String jobRunId;
        private Map<String, String> arguments = DefaultSdkAutoConstructMap.getInstance();
        private Integer allocatedCapacity;
        private Integer timeout;
        private Double maxCapacity;
        private String securityConfiguration;
        private NotificationProperty notificationProperty;
        private String workerType;
        private Integer numberOfWorkers;
        private String executionClass;
        private String executionRoleSessionPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(StartJobRunRequest model) {
            super(model);
            this.jobName(model.jobName);
            this.jobRunQueuingEnabled(model.jobRunQueuingEnabled);
            this.jobRunId(model.jobRunId);
            this.arguments(model.arguments);
            this.allocatedCapacity(model.allocatedCapacity);
            this.timeout(model.timeout);
            this.maxCapacity(model.maxCapacity);
            this.securityConfiguration(model.securityConfiguration);
            this.notificationProperty(model.notificationProperty);
            this.workerType(model.workerType);
            this.numberOfWorkers(model.numberOfWorkers);
            this.executionClass(model.executionClass);
            this.executionRoleSessionPolicy(model.executionRoleSessionPolicy);
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final Boolean getJobRunQueuingEnabled() {
            return this.jobRunQueuingEnabled;
        }

        public final void setJobRunQueuingEnabled(Boolean jobRunQueuingEnabled) {
            this.jobRunQueuingEnabled = jobRunQueuingEnabled;
        }

        @Override
        public final Builder jobRunQueuingEnabled(Boolean jobRunQueuingEnabled) {
            this.jobRunQueuingEnabled = jobRunQueuingEnabled;
            return this;
        }

        public final String getJobRunId() {
            return this.jobRunId;
        }

        public final void setJobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
        }

        @Override
        public final Builder jobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
            return this;
        }

        public final Map<String, String> getArguments() {
            if (this.arguments instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.arguments;
        }

        public final void setArguments(Map<String, String> arguments) {
            this.arguments = GenericMapCopier.copy(arguments);
        }

        @Override
        public final Builder arguments(Map<String, String> arguments) {
            this.arguments = GenericMapCopier.copy(arguments);
            return this;
        }

        @Deprecated
        public final Integer getAllocatedCapacity() {
            return this.allocatedCapacity;
        }

        @Deprecated
        public final void setAllocatedCapacity(Integer allocatedCapacity) {
            this.allocatedCapacity = allocatedCapacity;
        }

        @Override
        @Deprecated
        public final Builder allocatedCapacity(Integer allocatedCapacity) {
            this.allocatedCapacity = allocatedCapacity;
            return this;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final Double getMaxCapacity() {
            return this.maxCapacity;
        }

        public final void setMaxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final String getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final NotificationProperty.Builder getNotificationProperty() {
            return this.notificationProperty != null ? this.notificationProperty.toBuilder() : null;
        }

        public final void setNotificationProperty(NotificationProperty.BuilderImpl notificationProperty) {
            this.notificationProperty = notificationProperty != null ? notificationProperty.build() : null;
        }

        @Override
        public final Builder notificationProperty(NotificationProperty notificationProperty) {
            this.notificationProperty = notificationProperty;
            return this;
        }

        public final String getWorkerType() {
            return this.workerType;
        }

        public final void setWorkerType(String workerType) {
            this.workerType = workerType;
        }

        @Override
        public final Builder workerType(String workerType) {
            this.workerType = workerType;
            return this;
        }

        @Override
        public final Builder workerType(WorkerType workerType) {
            this.workerType(workerType == null ? null : workerType.toString());
            return this;
        }

        public final Integer getNumberOfWorkers() {
            return this.numberOfWorkers;
        }

        public final void setNumberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        @Override
        public final Builder numberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public final String getExecutionClass() {
            return this.executionClass;
        }

        public final void setExecutionClass(String executionClass) {
            this.executionClass = executionClass;
        }

        @Override
        public final Builder executionClass(String executionClass) {
            this.executionClass = executionClass;
            return this;
        }

        @Override
        public final Builder executionClass(ExecutionClass executionClass) {
            this.executionClass(executionClass == null ? null : executionClass.toString());
            return this;
        }

        public final String getExecutionRoleSessionPolicy() {
            return this.executionRoleSessionPolicy;
        }

        public final void setExecutionRoleSessionPolicy(String executionRoleSessionPolicy) {
            this.executionRoleSessionPolicy = executionRoleSessionPolicy;
        }

        @Override
        public final Builder executionRoleSessionPolicy(String executionRoleSessionPolicy) {
            this.executionRoleSessionPolicy = executionRoleSessionPolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartJobRunRequest build() {
            return new StartJobRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartJobRunRequest> {
        public Builder jobName(String var1);

        public Builder jobRunQueuingEnabled(Boolean var1);

        public Builder jobRunId(String var1);

        public Builder arguments(Map<String, String> var1);

        @Deprecated
        public Builder allocatedCapacity(Integer var1);

        public Builder timeout(Integer var1);

        public Builder maxCapacity(Double var1);

        public Builder securityConfiguration(String var1);

        public Builder notificationProperty(NotificationProperty var1);

        default public Builder notificationProperty(Consumer<NotificationProperty.Builder> notificationProperty) {
            return this.notificationProperty((NotificationProperty)((NotificationProperty.Builder)NotificationProperty.builder().applyMutation(notificationProperty)).build());
        }

        public Builder workerType(String var1);

        public Builder workerType(WorkerType var1);

        public Builder numberOfWorkers(Integer var1);

        public Builder executionClass(String var1);

        public Builder executionClass(ExecutionClass var1);

        public Builder executionRoleSessionPolicy(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

