/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.ParametersMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IcebergOptimizationProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IcebergOptimizationProperties> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(IcebergOptimizationProperties.getter(IcebergOptimizationProperties::roleArn)).setter(IcebergOptimizationProperties.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<Map<String, String>> COMPACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Compaction").getter(IcebergOptimizationProperties.getter(IcebergOptimizationProperties::compaction)).setter(IcebergOptimizationProperties.setter(Builder::compaction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compaction").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> RETENTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Retention").getter(IcebergOptimizationProperties.getter(IcebergOptimizationProperties::retention)).setter(IcebergOptimizationProperties.setter(Builder::retention)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Retention").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> ORPHAN_FILE_DELETION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("OrphanFileDeletion").getter(IcebergOptimizationProperties.getter(IcebergOptimizationProperties::orphanFileDeletion)).setter(IcebergOptimizationProperties.setter(Builder::orphanFileDeletion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrphanFileDeletion").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, COMPACTION_FIELD, RETENTION_FIELD, ORPHAN_FILE_DELETION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IcebergOptimizationProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final Map<String, String> compaction;
    private final Map<String, String> retention;
    private final Map<String, String> orphanFileDeletion;

    private IcebergOptimizationProperties(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.compaction = builder.compaction;
        this.retention = builder.retention;
        this.orphanFileDeletion = builder.orphanFileDeletion;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasCompaction() {
        return this.compaction != null && !(this.compaction instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> compaction() {
        return this.compaction;
    }

    public final boolean hasRetention() {
        return this.retention != null && !(this.retention instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> retention() {
        return this.retention;
    }

    public final boolean hasOrphanFileDeletion() {
        return this.orphanFileDeletion != null && !(this.orphanFileDeletion instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> orphanFileDeletion() {
        return this.orphanFileDeletion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCompaction() ? this.compaction() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRetention() ? this.retention() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrphanFileDeletion() ? this.orphanFileDeletion() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergOptimizationProperties)) {
            return false;
        }
        IcebergOptimizationProperties other = (IcebergOptimizationProperties)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && this.hasCompaction() == other.hasCompaction() && Objects.equals(this.compaction(), other.compaction()) && this.hasRetention() == other.hasRetention() && Objects.equals(this.retention(), other.retention()) && this.hasOrphanFileDeletion() == other.hasOrphanFileDeletion() && Objects.equals(this.orphanFileDeletion(), other.orphanFileDeletion());
    }

    public final String toString() {
        return ToString.builder((String)"IcebergOptimizationProperties").add("RoleArn", (Object)this.roleArn()).add("Compaction", this.hasCompaction() ? this.compaction() : null).add("Retention", this.hasRetention() ? this.retention() : null).add("OrphanFileDeletion", this.hasOrphanFileDeletion() ? this.orphanFileDeletion() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Compaction": {
                return Optional.ofNullable(clazz.cast(this.compaction()));
            }
            case "Retention": {
                return Optional.ofNullable(clazz.cast(this.retention()));
            }
            case "OrphanFileDeletion": {
                return Optional.ofNullable(clazz.cast(this.orphanFileDeletion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("Compaction", COMPACTION_FIELD);
        map.put("Retention", RETENTION_FIELD);
        map.put("OrphanFileDeletion", ORPHAN_FILE_DELETION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IcebergOptimizationProperties, T> g) {
        return obj -> g.apply((IcebergOptimizationProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private Map<String, String> compaction = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> retention = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> orphanFileDeletion = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergOptimizationProperties model) {
            this.roleArn(model.roleArn);
            this.compaction(model.compaction);
            this.retention(model.retention);
            this.orphanFileDeletion(model.orphanFileDeletion);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Map<String, String> getCompaction() {
            if (this.compaction instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.compaction;
        }

        public final void setCompaction(Map<String, String> compaction) {
            this.compaction = ParametersMapCopier.copy(compaction);
        }

        @Override
        public final Builder compaction(Map<String, String> compaction) {
            this.compaction = ParametersMapCopier.copy(compaction);
            return this;
        }

        public final Map<String, String> getRetention() {
            if (this.retention instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.retention;
        }

        public final void setRetention(Map<String, String> retention) {
            this.retention = ParametersMapCopier.copy(retention);
        }

        @Override
        public final Builder retention(Map<String, String> retention) {
            this.retention = ParametersMapCopier.copy(retention);
            return this;
        }

        public final Map<String, String> getOrphanFileDeletion() {
            if (this.orphanFileDeletion instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.orphanFileDeletion;
        }

        public final void setOrphanFileDeletion(Map<String, String> orphanFileDeletion) {
            this.orphanFileDeletion = ParametersMapCopier.copy(orphanFileDeletion);
        }

        @Override
        public final Builder orphanFileDeletion(Map<String, String> orphanFileDeletion) {
            this.orphanFileDeletion = ParametersMapCopier.copy(orphanFileDeletion);
            return this;
        }

        public IcebergOptimizationProperties build() {
            return new IcebergOptimizationProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IcebergOptimizationProperties> {
        public Builder roleArn(String var1);

        public Builder compaction(Map<String, String> var1);

        public Builder retention(Map<String, String> var1);

        public Builder orphanFileDeletion(Map<String, String> var1);
    }
}

