/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum JDBCConnectionType {
    SQLSERVER("sqlserver"),
    MYSQL("mysql"),
    ORACLE("oracle"),
    POSTGRESQL("postgresql"),
    REDSHIFT("redshift"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, JDBCConnectionType> VALUE_MAP;
    private final String value;

    private JDBCConnectionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JDBCConnectionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<JDBCConnectionType> knownValues() {
        EnumSet<JDBCConnectionType> knownValues = EnumSet.allOf(JDBCConnectionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(JDBCConnectionType.class, JDBCConnectionType::toString);
    }
}

