/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BackfillErrorCode {
    ENCRYPTED_PARTITION_ERROR("ENCRYPTED_PARTITION_ERROR"),
    INTERNAL_ERROR("INTERNAL_ERROR"),
    INVALID_PARTITION_TYPE_DATA_ERROR("INVALID_PARTITION_TYPE_DATA_ERROR"),
    MISSING_PARTITION_VALUE_ERROR("MISSING_PARTITION_VALUE_ERROR"),
    UNSUPPORTED_PARTITION_CHARACTER_ERROR("UNSUPPORTED_PARTITION_CHARACTER_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BackfillErrorCode> VALUE_MAP;
    private final String value;

    private BackfillErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BackfillErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BackfillErrorCode> knownValues() {
        EnumSet<BackfillErrorCode> knownValues = EnumSet.allOf(BackfillErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BackfillErrorCode.class, BackfillErrorCode::toString);
    }
}

