/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.ListTableOptimizerRunsRequest;
import software.amazon.awssdk.services.glue.model.ListTableOptimizerRunsResponse;
import software.amazon.awssdk.services.glue.model.TableOptimizerRun;

public class ListTableOptimizerRunsPublisher
implements SdkPublisher<ListTableOptimizerRunsResponse> {
    private final GlueAsyncClient client;
    private final ListTableOptimizerRunsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTableOptimizerRunsPublisher(GlueAsyncClient client, ListTableOptimizerRunsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTableOptimizerRunsPublisher(GlueAsyncClient client, ListTableOptimizerRunsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTableOptimizerRunsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTableOptimizerRunsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TableOptimizerRun> tableOptimizerRuns() {
        Function<ListTableOptimizerRunsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tableOptimizerRuns() != null) {
                return response.tableOptimizerRuns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTableOptimizerRunsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTableOptimizerRunsResponseFetcher
    implements AsyncPageFetcher<ListTableOptimizerRunsResponse> {
        private ListTableOptimizerRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListTableOptimizerRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTableOptimizerRunsResponse> nextPage(ListTableOptimizerRunsResponse previousPage) {
            if (previousPage == null) {
                return ListTableOptimizerRunsPublisher.this.client.listTableOptimizerRuns(ListTableOptimizerRunsPublisher.this.firstRequest);
            }
            return ListTableOptimizerRunsPublisher.this.client.listTableOptimizerRuns((ListTableOptimizerRunsRequest)((Object)ListTableOptimizerRunsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

