/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.DataQualityModelStatus;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDataQualityModelResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetDataQualityModelResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetDataQualityModelResponse.getter(GetDataQualityModelResponse::statusAsString)).setter(GetDataQualityModelResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> STARTED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedOn").getter(GetDataQualityModelResponse.getter(GetDataQualityModelResponse::startedOn)).setter(GetDataQualityModelResponse.setter(Builder::startedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedOn").build()}).build();
    private static final SdkField<Instant> COMPLETED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletedOn").getter(GetDataQualityModelResponse.getter(GetDataQualityModelResponse::completedOn)).setter(GetDataQualityModelResponse.setter(Builder::completedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedOn").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(GetDataQualityModelResponse.getter(GetDataQualityModelResponse::failureReason)).setter(GetDataQualityModelResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, STARTED_ON_FIELD, COMPLETED_ON_FIELD, FAILURE_REASON_FIELD));
    private final String status;
    private final Instant startedOn;
    private final Instant completedOn;
    private final String failureReason;

    private GetDataQualityModelResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.startedOn = builder.startedOn;
        this.completedOn = builder.completedOn;
        this.failureReason = builder.failureReason;
    }

    public final DataQualityModelStatus status() {
        return DataQualityModelStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant startedOn() {
        return this.startedOn;
    }

    public final Instant completedOn() {
        return this.completedOn;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataQualityModelResponse)) {
            return false;
        }
        GetDataQualityModelResponse other = (GetDataQualityModelResponse)((Object)obj);
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startedOn(), other.startedOn()) && Objects.equals(this.completedOn(), other.completedOn()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public final String toString() {
        return ToString.builder((String)"GetDataQualityModelResponse").add("Status", (Object)this.statusAsString()).add("StartedOn", (Object)this.startedOn()).add("CompletedOn", (Object)this.completedOn()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StartedOn": {
                return Optional.ofNullable(clazz.cast(this.startedOn()));
            }
            case "CompletedOn": {
                return Optional.ofNullable(clazz.cast(this.completedOn()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDataQualityModelResponse, T> g) {
        return obj -> g.apply((GetDataQualityModelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private String status;
        private Instant startedOn;
        private Instant completedOn;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataQualityModelResponse model) {
            super(model);
            this.status(model.status);
            this.startedOn(model.startedOn);
            this.completedOn(model.completedOn);
            this.failureReason(model.failureReason);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataQualityModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartedOn() {
            return this.startedOn;
        }

        public final void setStartedOn(Instant startedOn) {
            this.startedOn = startedOn;
        }

        @Override
        public final Builder startedOn(Instant startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        public final Instant getCompletedOn() {
            return this.completedOn;
        }

        public final void setCompletedOn(Instant completedOn) {
            this.completedOn = completedOn;
        }

        @Override
        public final Builder completedOn(Instant completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public GetDataQualityModelResponse build() {
            return new GetDataQualityModelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDataQualityModelResponse> {
        public Builder status(String var1);

        public Builder status(DataQualityModelStatus var1);

        public Builder startedOn(Instant var1);

        public Builder completedOn(Instant var1);

        public Builder failureReason(String var1);
    }
}

