/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.UpdateCatalogBehavior;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DirectSchemaChangePolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DirectSchemaChangePolicy> {
    private static final SdkField<Boolean> ENABLE_UPDATE_CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableUpdateCatalog").getter(DirectSchemaChangePolicy.getter(DirectSchemaChangePolicy::enableUpdateCatalog)).setter(DirectSchemaChangePolicy.setter(Builder::enableUpdateCatalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableUpdateCatalog").build()}).build();
    private static final SdkField<String> UPDATE_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateBehavior").getter(DirectSchemaChangePolicy.getter(DirectSchemaChangePolicy::updateBehaviorAsString)).setter(DirectSchemaChangePolicy.setter(Builder::updateBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateBehavior").build()}).build();
    private static final SdkField<String> TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Table").getter(DirectSchemaChangePolicy.getter(DirectSchemaChangePolicy::table)).setter(DirectSchemaChangePolicy.setter(Builder::table)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Database").getter(DirectSchemaChangePolicy.getter(DirectSchemaChangePolicy::database)).setter(DirectSchemaChangePolicy.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_UPDATE_CATALOG_FIELD, UPDATE_BEHAVIOR_FIELD, TABLE_FIELD, DATABASE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enableUpdateCatalog;
    private final String updateBehavior;
    private final String table;
    private final String database;

    private DirectSchemaChangePolicy(BuilderImpl builder) {
        this.enableUpdateCatalog = builder.enableUpdateCatalog;
        this.updateBehavior = builder.updateBehavior;
        this.table = builder.table;
        this.database = builder.database;
    }

    public final Boolean enableUpdateCatalog() {
        return this.enableUpdateCatalog;
    }

    public final UpdateCatalogBehavior updateBehavior() {
        return UpdateCatalogBehavior.fromValue(this.updateBehavior);
    }

    public final String updateBehaviorAsString() {
        return this.updateBehavior;
    }

    public final String table() {
        return this.table;
    }

    public final String database() {
        return this.database;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enableUpdateCatalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.table());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectSchemaChangePolicy)) {
            return false;
        }
        DirectSchemaChangePolicy other = (DirectSchemaChangePolicy)obj;
        return Objects.equals(this.enableUpdateCatalog(), other.enableUpdateCatalog()) && Objects.equals(this.updateBehaviorAsString(), other.updateBehaviorAsString()) && Objects.equals(this.table(), other.table()) && Objects.equals(this.database(), other.database());
    }

    public final String toString() {
        return ToString.builder((String)"DirectSchemaChangePolicy").add("EnableUpdateCatalog", (Object)this.enableUpdateCatalog()).add("UpdateBehavior", (Object)this.updateBehaviorAsString()).add("Table", (Object)this.table()).add("Database", (Object)this.database()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnableUpdateCatalog": {
                return Optional.ofNullable(clazz.cast(this.enableUpdateCatalog()));
            }
            case "UpdateBehavior": {
                return Optional.ofNullable(clazz.cast(this.updateBehaviorAsString()));
            }
            case "Table": {
                return Optional.ofNullable(clazz.cast(this.table()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DirectSchemaChangePolicy, T> g) {
        return obj -> g.apply((DirectSchemaChangePolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enableUpdateCatalog;
        private String updateBehavior;
        private String table;
        private String database;

        private BuilderImpl() {
        }

        private BuilderImpl(DirectSchemaChangePolicy model) {
            this.enableUpdateCatalog(model.enableUpdateCatalog);
            this.updateBehavior(model.updateBehavior);
            this.table(model.table);
            this.database(model.database);
        }

        public final Boolean getEnableUpdateCatalog() {
            return this.enableUpdateCatalog;
        }

        public final void setEnableUpdateCatalog(Boolean enableUpdateCatalog) {
            this.enableUpdateCatalog = enableUpdateCatalog;
        }

        @Override
        public final Builder enableUpdateCatalog(Boolean enableUpdateCatalog) {
            this.enableUpdateCatalog = enableUpdateCatalog;
            return this;
        }

        public final String getUpdateBehavior() {
            return this.updateBehavior;
        }

        public final void setUpdateBehavior(String updateBehavior) {
            this.updateBehavior = updateBehavior;
        }

        @Override
        public final Builder updateBehavior(String updateBehavior) {
            this.updateBehavior = updateBehavior;
            return this;
        }

        @Override
        public final Builder updateBehavior(UpdateCatalogBehavior updateBehavior) {
            this.updateBehavior(updateBehavior == null ? null : updateBehavior.toString());
            return this;
        }

        public final String getTable() {
            return this.table;
        }

        public final void setTable(String table) {
            this.table = table;
        }

        @Override
        public final Builder table(String table) {
            this.table = table;
            return this;
        }

        public final String getDatabase() {
            return this.database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public DirectSchemaChangePolicy build() {
            return new DirectSchemaChangePolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DirectSchemaChangePolicy> {
        public Builder enableUpdateCatalog(Boolean var1);

        public Builder updateBehavior(String var1);

        public Builder updateBehavior(UpdateCatalogBehavior var1);

        public Builder table(String var1);

        public Builder database(String var1);
    }
}

