/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing information about the state of an asynchronous change to a table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableStatus implements SdkPojo, Serializable, ToCopyableBuilder<TableStatus.Builder, TableStatus> {
    private static final SdkField<String> REQUESTED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestedBy").getter(getter(TableStatus::requestedBy)).setter(setter(Builder::requestedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedBy").build()).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdatedBy").getter(getter(TableStatus::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedBy").build()).build();

    private static final SdkField<Instant> REQUEST_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RequestTime").getter(getter(TableStatus::requestTime)).setter(setter(Builder::requestTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdateTime").getter(getter(TableStatus::updateTime)).setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(TableStatus::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(TableStatus::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<ErrorDetail> ERROR_FIELD = SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
            .memberName("Error").getter(getter(TableStatus::error)).setter(setter(Builder::error))
            .constructor(ErrorDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final SdkField<StatusDetails> DETAILS_FIELD = SdkField.<StatusDetails> builder(MarshallingType.SDK_POJO)
            .memberName("Details").getter(getter(TableStatus::details)).setter(setter(Builder::details))
            .constructor(StatusDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUESTED_BY_FIELD,
            UPDATED_BY_FIELD, REQUEST_TIME_FIELD, UPDATE_TIME_FIELD, ACTION_FIELD, STATE_FIELD, ERROR_FIELD, DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String requestedBy;

    private final String updatedBy;

    private final Instant requestTime;

    private final Instant updateTime;

    private final String action;

    private final String state;

    private final ErrorDetail error;

    private final StatusDetails details;

    private TableStatus(BuilderImpl builder) {
        this.requestedBy = builder.requestedBy;
        this.updatedBy = builder.updatedBy;
        this.requestTime = builder.requestTime;
        this.updateTime = builder.updateTime;
        this.action = builder.action;
        this.state = builder.state;
        this.error = builder.error;
        this.details = builder.details;
    }

    /**
     * <p>
     * The ARN of the user who requested the asynchronous change.
     * </p>
     * 
     * @return The ARN of the user who requested the asynchronous change.
     */
    public final String requestedBy() {
        return requestedBy;
    }

    /**
     * <p>
     * The ARN of the user to last manually alter the asynchronous change (requesting cancellation, etc).
     * </p>
     * 
     * @return The ARN of the user to last manually alter the asynchronous change (requesting cancellation, etc).
     */
    public final String updatedBy() {
        return updatedBy;
    }

    /**
     * <p>
     * An ISO 8601 formatted date string indicating the time that the change was initiated.
     * </p>
     * 
     * @return An ISO 8601 formatted date string indicating the time that the change was initiated.
     */
    public final Instant requestTime() {
        return requestTime;
    }

    /**
     * <p>
     * An ISO 8601 formatted date string indicating the time that the state was last updated.
     * </p>
     * 
     * @return An ISO 8601 formatted date string indicating the time that the state was last updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * Indicates which action was called on the table, currently only <code>CREATE</code> or <code>UPDATE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ResourceAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Indicates which action was called on the table, currently only <code>CREATE</code> or <code>UPDATE</code>
     *         .
     * @see ResourceAction
     */
    public final ResourceAction action() {
        return ResourceAction.fromValue(action);
    }

    /**
     * <p>
     * Indicates which action was called on the table, currently only <code>CREATE</code> or <code>UPDATE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ResourceAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Indicates which action was called on the table, currently only <code>CREATE</code> or <code>UPDATE</code>
     *         .
     * @see ResourceAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * A generic status for the change in progress, such as QUEUED, IN_PROGRESS, SUCCESS, or FAILED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ResourceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return A generic status for the change in progress, such as QUEUED, IN_PROGRESS, SUCCESS, or FAILED.
     * @see ResourceState
     */
    public final ResourceState state() {
        return ResourceState.fromValue(state);
    }

    /**
     * <p>
     * A generic status for the change in progress, such as QUEUED, IN_PROGRESS, SUCCESS, or FAILED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ResourceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return A generic status for the change in progress, such as QUEUED, IN_PROGRESS, SUCCESS, or FAILED.
     * @see ResourceState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * An error that will only appear when the state is "FAILED". This is a parent level exception message, there may be
     * different <code>Error</code>s for each dialect.
     * </p>
     * 
     * @return An error that will only appear when the state is "FAILED". This is a parent level exception message,
     *         there may be different <code>Error</code>s for each dialect.
     */
    public final ErrorDetail error() {
        return error;
    }

    /**
     * <p>
     * A <code>StatusDetails</code> object with information about the requested change.
     * </p>
     * 
     * @return A <code>StatusDetails</code> object with information about the requested change.
     */
    public final StatusDetails details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(requestedBy());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(requestTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableStatus)) {
            return false;
        }
        TableStatus other = (TableStatus) obj;
        return Objects.equals(requestedBy(), other.requestedBy()) && Objects.equals(updatedBy(), other.updatedBy())
                && Objects.equals(requestTime(), other.requestTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(error(), other.error())
                && Objects.equals(details(), other.details());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableStatus").add("RequestedBy", requestedBy()).add("UpdatedBy", updatedBy())
                .add("RequestTime", requestTime()).add("UpdateTime", updateTime()).add("Action", actionAsString())
                .add("State", stateAsString()).add("Error", error()).add("Details", details()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequestedBy":
            return Optional.ofNullable(clazz.cast(requestedBy()));
        case "UpdatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        case "RequestTime":
            return Optional.ofNullable(clazz.cast(requestTime()));
        case "UpdateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        case "Details":
            return Optional.ofNullable(clazz.cast(details()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableStatus, T> g) {
        return obj -> g.apply((TableStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableStatus> {
        /**
         * <p>
         * The ARN of the user who requested the asynchronous change.
         * </p>
         * 
         * @param requestedBy
         *        The ARN of the user who requested the asynchronous change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedBy(String requestedBy);

        /**
         * <p>
         * The ARN of the user to last manually alter the asynchronous change (requesting cancellation, etc).
         * </p>
         * 
         * @param updatedBy
         *        The ARN of the user to last manually alter the asynchronous change (requesting cancellation, etc).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);

        /**
         * <p>
         * An ISO 8601 formatted date string indicating the time that the change was initiated.
         * </p>
         * 
         * @param requestTime
         *        An ISO 8601 formatted date string indicating the time that the change was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestTime(Instant requestTime);

        /**
         * <p>
         * An ISO 8601 formatted date string indicating the time that the state was last updated.
         * </p>
         * 
         * @param updateTime
         *        An ISO 8601 formatted date string indicating the time that the state was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * Indicates which action was called on the table, currently only <code>CREATE</code> or <code>UPDATE</code>.
         * </p>
         * 
         * @param action
         *        Indicates which action was called on the table, currently only <code>CREATE</code> or
         *        <code>UPDATE</code>.
         * @see ResourceAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceAction
         */
        Builder action(String action);

        /**
         * <p>
         * Indicates which action was called on the table, currently only <code>CREATE</code> or <code>UPDATE</code>.
         * </p>
         * 
         * @param action
         *        Indicates which action was called on the table, currently only <code>CREATE</code> or
         *        <code>UPDATE</code>.
         * @see ResourceAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceAction
         */
        Builder action(ResourceAction action);

        /**
         * <p>
         * A generic status for the change in progress, such as QUEUED, IN_PROGRESS, SUCCESS, or FAILED.
         * </p>
         * 
         * @param state
         *        A generic status for the change in progress, such as QUEUED, IN_PROGRESS, SUCCESS, or FAILED.
         * @see ResourceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceState
         */
        Builder state(String state);

        /**
         * <p>
         * A generic status for the change in progress, such as QUEUED, IN_PROGRESS, SUCCESS, or FAILED.
         * </p>
         * 
         * @param state
         *        A generic status for the change in progress, such as QUEUED, IN_PROGRESS, SUCCESS, or FAILED.
         * @see ResourceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceState
         */
        Builder state(ResourceState state);

        /**
         * <p>
         * An error that will only appear when the state is "FAILED". This is a parent level exception message, there
         * may be different <code>Error</code>s for each dialect.
         * </p>
         * 
         * @param error
         *        An error that will only appear when the state is "FAILED". This is a parent level exception message,
         *        there may be different <code>Error</code>s for each dialect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorDetail error);

        /**
         * <p>
         * An error that will only appear when the state is "FAILED". This is a parent level exception message, there
         * may be different <code>Error</code>s for each dialect.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorDetail.Builder} avoiding the need to
         * create one manually via {@link ErrorDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #error(ErrorDetail)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorDetail)
         */
        default Builder error(Consumer<ErrorDetail.Builder> error) {
            return error(ErrorDetail.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * A <code>StatusDetails</code> object with information about the requested change.
         * </p>
         * 
         * @param details
         *        A <code>StatusDetails</code> object with information about the requested change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(StatusDetails details);

        /**
         * <p>
         * A <code>StatusDetails</code> object with information about the requested change.
         * </p>
         * This is a convenience method that creates an instance of the {@link StatusDetails.Builder} avoiding the need
         * to create one manually via {@link StatusDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StatusDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #details(StatusDetails)}.
         * 
         * @param details
         *        a consumer that will call methods on {@link StatusDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(StatusDetails)
         */
        default Builder details(Consumer<StatusDetails.Builder> details) {
            return details(StatusDetails.builder().applyMutation(details).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String requestedBy;

        private String updatedBy;

        private Instant requestTime;

        private Instant updateTime;

        private String action;

        private String state;

        private ErrorDetail error;

        private StatusDetails details;

        private BuilderImpl() {
        }

        private BuilderImpl(TableStatus model) {
            requestedBy(model.requestedBy);
            updatedBy(model.updatedBy);
            requestTime(model.requestTime);
            updateTime(model.updateTime);
            action(model.action);
            state(model.state);
            error(model.error);
            details(model.details);
        }

        public final String getRequestedBy() {
            return requestedBy;
        }

        public final void setRequestedBy(String requestedBy) {
            this.requestedBy = requestedBy;
        }

        @Override
        public final Builder requestedBy(String requestedBy) {
            this.requestedBy = requestedBy;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final Instant getRequestTime() {
            return requestTime;
        }

        public final void setRequestTime(Instant requestTime) {
            this.requestTime = requestTime;
        }

        @Override
        public final Builder requestTime(Instant requestTime) {
            this.requestTime = requestTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ResourceAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ResourceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final ErrorDetail.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetail error) {
            this.error = error;
            return this;
        }

        public final StatusDetails.Builder getDetails() {
            return details != null ? details.toBuilder() : null;
        }

        public final void setDetails(StatusDetails.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        public final Builder details(StatusDetails details) {
            this.details = details;
            return this;
        }

        @Override
        public TableStatus build() {
            return new TableStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
