/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTableOptimizerRunsResponse extends GlueResponse implements
        ToCopyableBuilder<ListTableOptimizerRunsResponse.Builder, ListTableOptimizerRunsResponse> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(ListTableOptimizerRunsResponse::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(ListTableOptimizerRunsResponse::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(ListTableOptimizerRunsResponse::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTableOptimizerRunsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<TableOptimizerRun>> TABLE_OPTIMIZER_RUNS_FIELD = SdkField
            .<List<TableOptimizerRun>> builder(MarshallingType.LIST)
            .memberName("TableOptimizerRuns")
            .getter(getter(ListTableOptimizerRunsResponse::tableOptimizerRuns))
            .setter(setter(Builder::tableOptimizerRuns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableOptimizerRuns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TableOptimizerRun> builder(MarshallingType.SDK_POJO)
                                            .constructor(TableOptimizerRun::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            DATABASE_NAME_FIELD, TABLE_NAME_FIELD, NEXT_TOKEN_FIELD, TABLE_OPTIMIZER_RUNS_FIELD));

    private final String catalogId;

    private final String databaseName;

    private final String tableName;

    private final String nextToken;

    private final List<TableOptimizerRun> tableOptimizerRuns;

    private ListTableOptimizerRunsResponse(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.nextToken = builder.nextToken;
        this.tableOptimizerRuns = builder.tableOptimizerRuns;
    }

    /**
     * <p>
     * The Catalog ID of the table.
     * </p>
     * 
     * @return The Catalog ID of the table.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The name of the database in the catalog in which the table resides.
     * </p>
     * 
     * @return The name of the database in the catalog in which the table resides.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of the table.
     * </p>
     * 
     * @return The name of the table.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * A continuation token for paginating the returned list of optimizer runs, returned if the current segment of the
     * list is not the last.
     * </p>
     * 
     * @return A continuation token for paginating the returned list of optimizer runs, returned if the current segment
     *         of the list is not the last.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TableOptimizerRuns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTableOptimizerRuns() {
        return tableOptimizerRuns != null && !(tableOptimizerRuns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the optimizer runs associated with a table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTableOptimizerRuns} method.
     * </p>
     * 
     * @return A list of the optimizer runs associated with a table.
     */
    public final List<TableOptimizerRun> tableOptimizerRuns() {
        return tableOptimizerRuns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTableOptimizerRuns() ? tableOptimizerRuns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTableOptimizerRunsResponse)) {
            return false;
        }
        ListTableOptimizerRunsResponse other = (ListTableOptimizerRunsResponse) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(tableName(), other.tableName()) && Objects.equals(nextToken(), other.nextToken())
                && hasTableOptimizerRuns() == other.hasTableOptimizerRuns()
                && Objects.equals(tableOptimizerRuns(), other.tableOptimizerRuns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTableOptimizerRunsResponse").add("CatalogId", catalogId())
                .add("DatabaseName", databaseName()).add("TableName", tableName()).add("NextToken", nextToken())
                .add("TableOptimizerRuns", hasTableOptimizerRuns() ? tableOptimizerRuns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "TableOptimizerRuns":
            return Optional.ofNullable(clazz.cast(tableOptimizerRuns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTableOptimizerRunsResponse, T> g) {
        return obj -> g.apply((ListTableOptimizerRunsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTableOptimizerRunsResponse> {
        /**
         * <p>
         * The Catalog ID of the table.
         * </p>
         * 
         * @param catalogId
         *        The Catalog ID of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The name of the database in the catalog in which the table resides.
         * </p>
         * 
         * @param databaseName
         *        The name of the database in the catalog in which the table resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of the table.
         * </p>
         * 
         * @param tableName
         *        The name of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * A continuation token for paginating the returned list of optimizer runs, returned if the current segment of
         * the list is not the last.
         * </p>
         * 
         * @param nextToken
         *        A continuation token for paginating the returned list of optimizer runs, returned if the current
         *        segment of the list is not the last.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of the optimizer runs associated with a table.
         * </p>
         * 
         * @param tableOptimizerRuns
         *        A list of the optimizer runs associated with a table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableOptimizerRuns(Collection<TableOptimizerRun> tableOptimizerRuns);

        /**
         * <p>
         * A list of the optimizer runs associated with a table.
         * </p>
         * 
         * @param tableOptimizerRuns
         *        A list of the optimizer runs associated with a table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableOptimizerRuns(TableOptimizerRun... tableOptimizerRuns);

        /**
         * <p>
         * A list of the optimizer runs associated with a table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.TableOptimizerRun.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.TableOptimizerRun#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.TableOptimizerRun.Builder#build()} is called immediately
         * and its result is passed to {@link #tableOptimizerRuns(List<TableOptimizerRun>)}.
         * 
         * @param tableOptimizerRuns
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.TableOptimizerRun.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableOptimizerRuns(java.util.Collection<TableOptimizerRun>)
         */
        Builder tableOptimizerRuns(Consumer<TableOptimizerRun.Builder>... tableOptimizerRuns);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private String catalogId;

        private String databaseName;

        private String tableName;

        private String nextToken;

        private List<TableOptimizerRun> tableOptimizerRuns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTableOptimizerRunsResponse model) {
            super(model);
            catalogId(model.catalogId);
            databaseName(model.databaseName);
            tableName(model.tableName);
            nextToken(model.nextToken);
            tableOptimizerRuns(model.tableOptimizerRuns);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TableOptimizerRun.Builder> getTableOptimizerRuns() {
            List<TableOptimizerRun.Builder> result = TableOptimizerRunsCopier.copyToBuilder(this.tableOptimizerRuns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTableOptimizerRuns(Collection<TableOptimizerRun.BuilderImpl> tableOptimizerRuns) {
            this.tableOptimizerRuns = TableOptimizerRunsCopier.copyFromBuilder(tableOptimizerRuns);
        }

        @Override
        public final Builder tableOptimizerRuns(Collection<TableOptimizerRun> tableOptimizerRuns) {
            this.tableOptimizerRuns = TableOptimizerRunsCopier.copy(tableOptimizerRuns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableOptimizerRuns(TableOptimizerRun... tableOptimizerRuns) {
            tableOptimizerRuns(Arrays.asList(tableOptimizerRuns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableOptimizerRuns(Consumer<TableOptimizerRun.Builder>... tableOptimizerRuns) {
            tableOptimizerRuns(Stream.of(tableOptimizerRuns).map(c -> TableOptimizerRun.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListTableOptimizerRunsResponse build() {
            return new ListTableOptimizerRunsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
