/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDataQualityStatisticsResponse extends GlueResponse implements
        ToCopyableBuilder<ListDataQualityStatisticsResponse.Builder, ListDataQualityStatisticsResponse> {
    private static final SdkField<List<StatisticSummary>> STATISTICS_FIELD = SdkField
            .<List<StatisticSummary>> builder(MarshallingType.LIST)
            .memberName("Statistics")
            .getter(getter(ListDataQualityStatisticsResponse::statistics))
            .setter(setter(Builder::statistics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StatisticSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(StatisticSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDataQualityStatisticsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATISTICS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<StatisticSummary> statistics;

    private final String nextToken;

    private ListDataQualityStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.statistics = builder.statistics;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Statistics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatistics() {
        return statistics != null && !(statistics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A <code>StatisticSummaryList</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatistics} method.
     * </p>
     * 
     * @return A <code>StatisticSummaryList</code>.
     */
    public final List<StatisticSummary> statistics() {
        return statistics;
    }

    /**
     * <p>
     * A pagination token to request the next page of results.
     * </p>
     * 
     * @return A pagination token to request the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStatistics() ? statistics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataQualityStatisticsResponse)) {
            return false;
        }
        ListDataQualityStatisticsResponse other = (ListDataQualityStatisticsResponse) obj;
        return hasStatistics() == other.hasStatistics() && Objects.equals(statistics(), other.statistics())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDataQualityStatisticsResponse").add("Statistics", hasStatistics() ? statistics() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Statistics":
            return Optional.ofNullable(clazz.cast(statistics()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDataQualityStatisticsResponse, T> g) {
        return obj -> g.apply((ListDataQualityStatisticsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDataQualityStatisticsResponse> {
        /**
         * <p>
         * A <code>StatisticSummaryList</code>.
         * </p>
         * 
         * @param statistics
         *        A <code>StatisticSummaryList</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(Collection<StatisticSummary> statistics);

        /**
         * <p>
         * A <code>StatisticSummaryList</code>.
         * </p>
         * 
         * @param statistics
         *        A <code>StatisticSummaryList</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(StatisticSummary... statistics);

        /**
         * <p>
         * A <code>StatisticSummaryList</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.StatisticSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.StatisticSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.StatisticSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #statistics(List<StatisticSummary>)}.
         * 
         * @param statistics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.StatisticSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statistics(java.util.Collection<StatisticSummary>)
         */
        Builder statistics(Consumer<StatisticSummary.Builder>... statistics);

        /**
         * <p>
         * A pagination token to request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        A pagination token to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<StatisticSummary> statistics = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataQualityStatisticsResponse model) {
            super(model);
            statistics(model.statistics);
            nextToken(model.nextToken);
        }

        public final List<StatisticSummary.Builder> getStatistics() {
            List<StatisticSummary.Builder> result = StatisticSummaryListCopier.copyToBuilder(this.statistics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatistics(Collection<StatisticSummary.BuilderImpl> statistics) {
            this.statistics = StatisticSummaryListCopier.copyFromBuilder(statistics);
        }

        @Override
        public final Builder statistics(Collection<StatisticSummary> statistics) {
            this.statistics = StatisticSummaryListCopier.copy(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(StatisticSummary... statistics) {
            statistics(Arrays.asList(statistics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(Consumer<StatisticSummary.Builder>... statistics) {
            statistics(Stream.of(statistics).map(c -> StatisticSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDataQualityStatisticsResponse build() {
            return new ListDataQualityStatisticsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
