/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The database and table in the Glue Data Catalog that is used for input or output data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlueTable implements SdkPojo, Serializable, ToCopyableBuilder<GlueTable.Builder, GlueTable> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(GlueTable::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(GlueTable::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(GlueTable::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionName").getter(getter(GlueTable::connectionName)).setter(setter(Builder::connectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()).build();

    private static final SdkField<Map<String, String>> ADDITIONAL_OPTIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AdditionalOptions")
            .getter(getter(GlueTable::additionalOptions))
            .setter(setter(Builder::additionalOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalOptions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD,
            TABLE_NAME_FIELD, CATALOG_ID_FIELD, CONNECTION_NAME_FIELD, ADDITIONAL_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String databaseName;

    private final String tableName;

    private final String catalogId;

    private final String connectionName;

    private final Map<String, String> additionalOptions;

    private GlueTable(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.catalogId = builder.catalogId;
        this.connectionName = builder.connectionName;
        this.additionalOptions = builder.additionalOptions;
    }

    /**
     * <p>
     * A database name in the Glue Data Catalog.
     * </p>
     * 
     * @return A database name in the Glue Data Catalog.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * A table name in the Glue Data Catalog.
     * </p>
     * 
     * @return A table name in the Glue Data Catalog.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * A unique identifier for the Glue Data Catalog.
     * </p>
     * 
     * @return A unique identifier for the Glue Data Catalog.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The name of the connection to the Glue Data Catalog.
     * </p>
     * 
     * @return The name of the connection to the Glue Data Catalog.
     */
    public final String connectionName() {
        return connectionName;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalOptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalOptions() {
        return additionalOptions != null && !(additionalOptions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Additional options for the table. Currently there are two keys supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>pushDownPredicate</code>: to filter on partitions without having to list and read all the files in your
     * dataset.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>catalogPartitionPredicate</code>: to use server-side partition pruning using partition indexes in the Glue
     * Data Catalog.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalOptions} method.
     * </p>
     * 
     * @return Additional options for the table. Currently there are two keys supported:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>pushDownPredicate</code>: to filter on partitions without having to list and read all the files in
     *         your dataset.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>catalogPartitionPredicate</code>: to use server-side partition pruning using partition indexes in
     *         the Glue Data Catalog.
     *         </p>
     *         </li>
     */
    public final Map<String, String> additionalOptions() {
        return additionalOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalOptions() ? additionalOptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlueTable)) {
            return false;
        }
        GlueTable other = (GlueTable) obj;
        return Objects.equals(databaseName(), other.databaseName()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(catalogId(), other.catalogId()) && Objects.equals(connectionName(), other.connectionName())
                && hasAdditionalOptions() == other.hasAdditionalOptions()
                && Objects.equals(additionalOptions(), other.additionalOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GlueTable").add("DatabaseName", databaseName()).add("TableName", tableName())
                .add("CatalogId", catalogId()).add("ConnectionName", connectionName())
                .add("AdditionalOptions", hasAdditionalOptions() ? additionalOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "ConnectionName":
            return Optional.ofNullable(clazz.cast(connectionName()));
        case "AdditionalOptions":
            return Optional.ofNullable(clazz.cast(additionalOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GlueTable, T> g) {
        return obj -> g.apply((GlueTable) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlueTable> {
        /**
         * <p>
         * A database name in the Glue Data Catalog.
         * </p>
         * 
         * @param databaseName
         *        A database name in the Glue Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * A table name in the Glue Data Catalog.
         * </p>
         * 
         * @param tableName
         *        A table name in the Glue Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * A unique identifier for the Glue Data Catalog.
         * </p>
         * 
         * @param catalogId
         *        A unique identifier for the Glue Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The name of the connection to the Glue Data Catalog.
         * </p>
         * 
         * @param connectionName
         *        The name of the connection to the Glue Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionName(String connectionName);

        /**
         * <p>
         * Additional options for the table. Currently there are two keys supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>pushDownPredicate</code>: to filter on partitions without having to list and read all the files in your
         * dataset.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>catalogPartitionPredicate</code>: to use server-side partition pruning using partition indexes in the
         * Glue Data Catalog.
         * </p>
         * </li>
         * </ul>
         * 
         * @param additionalOptions
         *        Additional options for the table. Currently there are two keys supported:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>pushDownPredicate</code>: to filter on partitions without having to list and read all the files
         *        in your dataset.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>catalogPartitionPredicate</code>: to use server-side partition pruning using partition indexes
         *        in the Glue Data Catalog.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalOptions(Map<String, String> additionalOptions);
    }

    static final class BuilderImpl implements Builder {
        private String databaseName;

        private String tableName;

        private String catalogId;

        private String connectionName;

        private Map<String, String> additionalOptions = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GlueTable model) {
            databaseName(model.databaseName);
            tableName(model.tableName);
            catalogId(model.catalogId);
            connectionName(model.connectionName);
            additionalOptions(model.additionalOptions);
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getConnectionName() {
            return connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final Map<String, String> getAdditionalOptions() {
            if (additionalOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return additionalOptions;
        }

        public final void setAdditionalOptions(Map<String, String> additionalOptions) {
            this.additionalOptions = GlueTableAdditionalOptionsCopier.copy(additionalOptions);
        }

        @Override
        public final Builder additionalOptions(Map<String, String> additionalOptions) {
            this.additionalOptions = GlueTableAdditionalOptionsCopier.copy(additionalOptions);
            return this;
        }

        @Override
        public GlueTable build() {
            return new GlueTable(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
