/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing the authentication configuration in the CreateConnection request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthenticationConfigurationInput implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthenticationConfigurationInput.Builder, AuthenticationConfigurationInput> {
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationType").getter(getter(AuthenticationConfigurationInput::authenticationTypeAsString))
            .setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build())
            .build();

    private static final SdkField<OAuth2PropertiesInput> O_AUTH2_PROPERTIES_FIELD = SdkField
            .<OAuth2PropertiesInput> builder(MarshallingType.SDK_POJO).memberName("OAuth2Properties")
            .getter(getter(AuthenticationConfigurationInput::oAuth2Properties)).setter(setter(Builder::oAuth2Properties))
            .constructor(OAuth2PropertiesInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OAuth2Properties").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(AuthenticationConfigurationInput::secretArn))
            .setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TYPE_FIELD,
            O_AUTH2_PROPERTIES_FIELD, SECRET_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String authenticationType;

    private final OAuth2PropertiesInput oAuth2Properties;

    private final String secretArn;

    private AuthenticationConfigurationInput(BuilderImpl builder) {
        this.authenticationType = builder.authenticationType;
        this.oAuth2Properties = builder.oAuth2Properties;
        this.secretArn = builder.secretArn;
    }

    /**
     * <p>
     * A structure containing the authentication configuration in the CreateConnection request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return A structure containing the authentication configuration in the CreateConnection request.
     * @see AuthenticationType
     */
    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * A structure containing the authentication configuration in the CreateConnection request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return A structure containing the authentication configuration in the CreateConnection request.
     * @see AuthenticationType
     */
    public final String authenticationTypeAsString() {
        return authenticationType;
    }

    /**
     * <p>
     * The properties for OAuth2 authentication in the CreateConnection request.
     * </p>
     * 
     * @return The properties for OAuth2 authentication in the CreateConnection request.
     */
    public final OAuth2PropertiesInput oAuth2Properties() {
        return oAuth2Properties;
    }

    /**
     * <p>
     * The secret manager ARN to store credentials in the CreateConnection request.
     * </p>
     * 
     * @return The secret manager ARN to store credentials in the CreateConnection request.
     */
    public final String secretArn() {
        return secretArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(oAuth2Properties());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationConfigurationInput)) {
            return false;
        }
        AuthenticationConfigurationInput other = (AuthenticationConfigurationInput) obj;
        return Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString())
                && Objects.equals(oAuth2Properties(), other.oAuth2Properties()) && Objects.equals(secretArn(), other.secretArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthenticationConfigurationInput").add("AuthenticationType", authenticationTypeAsString())
                .add("OAuth2Properties", oAuth2Properties()).add("SecretArn", secretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        case "OAuth2Properties":
            return Optional.ofNullable(clazz.cast(oAuth2Properties()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationConfigurationInput, T> g) {
        return obj -> g.apply((AuthenticationConfigurationInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthenticationConfigurationInput> {
        /**
         * <p>
         * A structure containing the authentication configuration in the CreateConnection request.
         * </p>
         * 
         * @param authenticationType
         *        A structure containing the authentication configuration in the CreateConnection request.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * A structure containing the authentication configuration in the CreateConnection request.
         * </p>
         * 
         * @param authenticationType
         *        A structure containing the authentication configuration in the CreateConnection request.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(AuthenticationType authenticationType);

        /**
         * <p>
         * The properties for OAuth2 authentication in the CreateConnection request.
         * </p>
         * 
         * @param oAuth2Properties
         *        The properties for OAuth2 authentication in the CreateConnection request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuth2Properties(OAuth2PropertiesInput oAuth2Properties);

        /**
         * <p>
         * The properties for OAuth2 authentication in the CreateConnection request.
         * </p>
         * This is a convenience method that creates an instance of the {@link OAuth2PropertiesInput.Builder} avoiding
         * the need to create one manually via {@link OAuth2PropertiesInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OAuth2PropertiesInput.Builder#build()} is called immediately and
         * its result is passed to {@link #oAuth2Properties(OAuth2PropertiesInput)}.
         * 
         * @param oAuth2Properties
         *        a consumer that will call methods on {@link OAuth2PropertiesInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oAuth2Properties(OAuth2PropertiesInput)
         */
        default Builder oAuth2Properties(Consumer<OAuth2PropertiesInput.Builder> oAuth2Properties) {
            return oAuth2Properties(OAuth2PropertiesInput.builder().applyMutation(oAuth2Properties).build());
        }

        /**
         * <p>
         * The secret manager ARN to store credentials in the CreateConnection request.
         * </p>
         * 
         * @param secretArn
         *        The secret manager ARN to store credentials in the CreateConnection request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);
    }

    static final class BuilderImpl implements Builder {
        private String authenticationType;

        private OAuth2PropertiesInput oAuth2Properties;

        private String secretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationConfigurationInput model) {
            authenticationType(model.authenticationType);
            oAuth2Properties(model.oAuth2Properties);
            secretArn(model.secretArn);
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final OAuth2PropertiesInput.Builder getOAuth2Properties() {
            return oAuth2Properties != null ? oAuth2Properties.toBuilder() : null;
        }

        public final void setOAuth2Properties(OAuth2PropertiesInput.BuilderImpl oAuth2Properties) {
            this.oAuth2Properties = oAuth2Properties != null ? oAuth2Properties.build() : null;
        }

        @Override
        public final Builder oAuth2Properties(OAuth2PropertiesInput oAuth2Properties) {
            this.oAuth2Properties = oAuth2Properties;
            return this;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        @Override
        public AuthenticationConfigurationInput build() {
            return new AuthenticationConfigurationInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
