/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.S3SourceAdditionalOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GovernedCatalogSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GovernedCatalogSource> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GovernedCatalogSource.getter(GovernedCatalogSource::name)).setter(GovernedCatalogSource.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Database").getter(GovernedCatalogSource.getter(GovernedCatalogSource::database)).setter(GovernedCatalogSource.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<String> TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Table").getter(GovernedCatalogSource.getter(GovernedCatalogSource::table)).setter(GovernedCatalogSource.setter(Builder::table)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()}).build();
    private static final SdkField<String> PARTITION_PREDICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartitionPredicate").getter(GovernedCatalogSource.getter(GovernedCatalogSource::partitionPredicate)).setter(GovernedCatalogSource.setter(Builder::partitionPredicate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionPredicate").build()}).build();
    private static final SdkField<S3SourceAdditionalOptions> ADDITIONAL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdditionalOptions").getter(GovernedCatalogSource.getter(GovernedCatalogSource::additionalOptions)).setter(GovernedCatalogSource.setter(Builder::additionalOptions)).constructor(S3SourceAdditionalOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DATABASE_FIELD, TABLE_FIELD, PARTITION_PREDICATE_FIELD, ADDITIONAL_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Database", DATABASE_FIELD);
            this.put("Table", TABLE_FIELD);
            this.put("PartitionPredicate", PARTITION_PREDICATE_FIELD);
            this.put("AdditionalOptions", ADDITIONAL_OPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String database;
    private final String table;
    private final String partitionPredicate;
    private final S3SourceAdditionalOptions additionalOptions;

    private GovernedCatalogSource(BuilderImpl builder) {
        this.name = builder.name;
        this.database = builder.database;
        this.table = builder.table;
        this.partitionPredicate = builder.partitionPredicate;
        this.additionalOptions = builder.additionalOptions;
    }

    public final String name() {
        return this.name;
    }

    public final String database() {
        return this.database;
    }

    public final String table() {
        return this.table;
    }

    public final String partitionPredicate() {
        return this.partitionPredicate;
    }

    public final S3SourceAdditionalOptions additionalOptions() {
        return this.additionalOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.table());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionPredicate());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GovernedCatalogSource)) {
            return false;
        }
        GovernedCatalogSource other = (GovernedCatalogSource)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.table(), other.table()) && Objects.equals(this.partitionPredicate(), other.partitionPredicate()) && Objects.equals(this.additionalOptions(), other.additionalOptions());
    }

    public final String toString() {
        return ToString.builder((String)"GovernedCatalogSource").add("Name", (Object)this.name()).add("Database", (Object)this.database()).add("Table", (Object)this.table()).add("PartitionPredicate", (Object)this.partitionPredicate()).add("AdditionalOptions", (Object)this.additionalOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "Table": {
                return Optional.ofNullable(clazz.cast(this.table()));
            }
            case "PartitionPredicate": {
                return Optional.ofNullable(clazz.cast(this.partitionPredicate()));
            }
            case "AdditionalOptions": {
                return Optional.ofNullable(clazz.cast(this.additionalOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GovernedCatalogSource, T> g) {
        return obj -> g.apply((GovernedCatalogSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String database;
        private String table;
        private String partitionPredicate;
        private S3SourceAdditionalOptions additionalOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(GovernedCatalogSource model) {
            this.name(model.name);
            this.database(model.database);
            this.table(model.table);
            this.partitionPredicate(model.partitionPredicate);
            this.additionalOptions(model.additionalOptions);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDatabase() {
            return this.database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getTable() {
            return this.table;
        }

        public final void setTable(String table) {
            this.table = table;
        }

        @Override
        public final Builder table(String table) {
            this.table = table;
            return this;
        }

        public final String getPartitionPredicate() {
            return this.partitionPredicate;
        }

        public final void setPartitionPredicate(String partitionPredicate) {
            this.partitionPredicate = partitionPredicate;
        }

        @Override
        public final Builder partitionPredicate(String partitionPredicate) {
            this.partitionPredicate = partitionPredicate;
            return this;
        }

        public final S3SourceAdditionalOptions.Builder getAdditionalOptions() {
            return this.additionalOptions != null ? this.additionalOptions.toBuilder() : null;
        }

        public final void setAdditionalOptions(S3SourceAdditionalOptions.BuilderImpl additionalOptions) {
            this.additionalOptions = additionalOptions != null ? additionalOptions.build() : null;
        }

        @Override
        public final Builder additionalOptions(S3SourceAdditionalOptions additionalOptions) {
            this.additionalOptions = additionalOptions;
            return this;
        }

        public GovernedCatalogSource build() {
            return new GovernedCatalogSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GovernedCatalogSource> {
        public Builder name(String var1);

        public Builder database(String var1);

        public Builder table(String var1);

        public Builder partitionPredicate(String var1);

        public Builder additionalOptions(S3SourceAdditionalOptions var1);

        default public Builder additionalOptions(Consumer<S3SourceAdditionalOptions.Builder> additionalOptions) {
            return this.additionalOptions((S3SourceAdditionalOptions)((S3SourceAdditionalOptions.Builder)S3SourceAdditionalOptions.builder().applyMutation(additionalOptions)).build());
        }
    }
}

