/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.Database;
import software.amazon.awssdk.services.glue.model.DatabaseListCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDatabasesResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetDatabasesResponse> {
    private static final SdkField<List<Database>> DATABASE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DatabaseList").getter(GetDatabasesResponse.getter(GetDatabasesResponse::databaseList)).setter(GetDatabasesResponse.setter(Builder::databaseList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Database::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetDatabasesResponse.getter(GetDatabasesResponse::nextToken)).setter(GetDatabasesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DatabaseList", DATABASE_LIST_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<Database> databaseList;
    private final String nextToken;

    private GetDatabasesResponse(BuilderImpl builder) {
        super(builder);
        this.databaseList = builder.databaseList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDatabaseList() {
        return this.databaseList != null && !(this.databaseList instanceof SdkAutoConstructList);
    }

    public final List<Database> databaseList() {
        return this.databaseList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatabaseList() ? this.databaseList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDatabasesResponse)) {
            return false;
        }
        GetDatabasesResponse other = (GetDatabasesResponse)((Object)obj);
        return this.hasDatabaseList() == other.hasDatabaseList() && Objects.equals(this.databaseList(), other.databaseList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetDatabasesResponse").add("DatabaseList", this.hasDatabaseList() ? this.databaseList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseList": {
                return Optional.ofNullable(clazz.cast(this.databaseList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetDatabasesResponse, T> g) {
        return obj -> g.apply((GetDatabasesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<Database> databaseList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDatabasesResponse model) {
            super(model);
            this.databaseList(model.databaseList);
            this.nextToken(model.nextToken);
        }

        public final List<Database.Builder> getDatabaseList() {
            List<Database.Builder> result = DatabaseListCopier.copyToBuilder(this.databaseList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatabaseList(Collection<Database.BuilderImpl> databaseList) {
            this.databaseList = DatabaseListCopier.copyFromBuilder(databaseList);
        }

        @Override
        public final Builder databaseList(Collection<Database> databaseList) {
            this.databaseList = DatabaseListCopier.copy(databaseList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databaseList(Database ... databaseList) {
            this.databaseList(Arrays.asList(databaseList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databaseList(Consumer<Database.Builder> ... databaseList) {
            this.databaseList(Stream.of(databaseList).map(c -> (Database)((Database.Builder)Database.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetDatabasesResponse build() {
            return new GetDatabasesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDatabasesResponse> {
        public Builder databaseList(Collection<Database> var1);

        public Builder databaseList(Database ... var1);

        public Builder databaseList(Consumer<Database.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

