/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataLakeAccessProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataLakeAccessProperties> {
    private static final SdkField<Boolean> DATA_LAKE_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DataLakeAccess").getter(DataLakeAccessProperties.getter(DataLakeAccessProperties::dataLakeAccess)).setter(DataLakeAccessProperties.setter(Builder::dataLakeAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLakeAccess").build()}).build();
    private static final SdkField<String> DATA_TRANSFER_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataTransferRole").getter(DataLakeAccessProperties.getter(DataLakeAccessProperties::dataTransferRole)).setter(DataLakeAccessProperties.setter(Builder::dataTransferRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTransferRole").build()}).build();
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKey").getter(DataLakeAccessProperties.getter(DataLakeAccessProperties::kmsKey)).setter(DataLakeAccessProperties.setter(Builder::kmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKey").build()}).build();
    private static final SdkField<String> CATALOG_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogType").getter(DataLakeAccessProperties.getter(DataLakeAccessProperties::catalogType)).setter(DataLakeAccessProperties.setter(Builder::catalogType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_LAKE_ACCESS_FIELD, DATA_TRANSFER_ROLE_FIELD, KMS_KEY_FIELD, CATALOG_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DataLakeAccess", DATA_LAKE_ACCESS_FIELD);
            this.put("DataTransferRole", DATA_TRANSFER_ROLE_FIELD);
            this.put("KmsKey", KMS_KEY_FIELD);
            this.put("CatalogType", CATALOG_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean dataLakeAccess;
    private final String dataTransferRole;
    private final String kmsKey;
    private final String catalogType;

    private DataLakeAccessProperties(BuilderImpl builder) {
        this.dataLakeAccess = builder.dataLakeAccess;
        this.dataTransferRole = builder.dataTransferRole;
        this.kmsKey = builder.kmsKey;
        this.catalogType = builder.catalogType;
    }

    public final Boolean dataLakeAccess() {
        return this.dataLakeAccess;
    }

    public final String dataTransferRole() {
        return this.dataTransferRole;
    }

    public final String kmsKey() {
        return this.kmsKey;
    }

    public final String catalogType() {
        return this.catalogType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLakeAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTransferRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeAccessProperties)) {
            return false;
        }
        DataLakeAccessProperties other = (DataLakeAccessProperties)obj;
        return Objects.equals(this.dataLakeAccess(), other.dataLakeAccess()) && Objects.equals(this.dataTransferRole(), other.dataTransferRole()) && Objects.equals(this.kmsKey(), other.kmsKey()) && Objects.equals(this.catalogType(), other.catalogType());
    }

    public final String toString() {
        return ToString.builder((String)"DataLakeAccessProperties").add("DataLakeAccess", (Object)this.dataLakeAccess()).add("DataTransferRole", (Object)this.dataTransferRole()).add("KmsKey", (Object)this.kmsKey()).add("CatalogType", (Object)this.catalogType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataLakeAccess": {
                return Optional.ofNullable(clazz.cast(this.dataLakeAccess()));
            }
            case "DataTransferRole": {
                return Optional.ofNullable(clazz.cast(this.dataTransferRole()));
            }
            case "KmsKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
            case "CatalogType": {
                return Optional.ofNullable(clazz.cast(this.catalogType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DataLakeAccessProperties, T> g) {
        return obj -> g.apply((DataLakeAccessProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean dataLakeAccess;
        private String dataTransferRole;
        private String kmsKey;
        private String catalogType;

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeAccessProperties model) {
            this.dataLakeAccess(model.dataLakeAccess);
            this.dataTransferRole(model.dataTransferRole);
            this.kmsKey(model.kmsKey);
            this.catalogType(model.catalogType);
        }

        public final Boolean getDataLakeAccess() {
            return this.dataLakeAccess;
        }

        public final void setDataLakeAccess(Boolean dataLakeAccess) {
            this.dataLakeAccess = dataLakeAccess;
        }

        @Override
        public final Builder dataLakeAccess(Boolean dataLakeAccess) {
            this.dataLakeAccess = dataLakeAccess;
            return this;
        }

        public final String getDataTransferRole() {
            return this.dataTransferRole;
        }

        public final void setDataTransferRole(String dataTransferRole) {
            this.dataTransferRole = dataTransferRole;
        }

        @Override
        public final Builder dataTransferRole(String dataTransferRole) {
            this.dataTransferRole = dataTransferRole;
            return this;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final String getCatalogType() {
            return this.catalogType;
        }

        public final void setCatalogType(String catalogType) {
            this.catalogType = catalogType;
        }

        @Override
        public final Builder catalogType(String catalogType) {
            this.catalogType = catalogType;
            return this;
        }

        public DataLakeAccessProperties build() {
            return new DataLakeAccessProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataLakeAccessProperties> {
        public Builder dataLakeAccess(Boolean var1);

        public Builder dataTransferRole(String var1);

        public Builder kmsKey(String var1);

        public Builder catalogType(String var1);
    }
}

