/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.AuthenticationConfiguration;
import software.amazon.awssdk.services.glue.model.ComputeEnvironment;
import software.amazon.awssdk.services.glue.model.ComputeEnvironmentListCopier;
import software.amazon.awssdk.services.glue.model.ConnectionPropertiesCopier;
import software.amazon.awssdk.services.glue.model.ConnectionPropertyKey;
import software.amazon.awssdk.services.glue.model.ConnectionStatus;
import software.amazon.awssdk.services.glue.model.ConnectionType;
import software.amazon.awssdk.services.glue.model.MatchCriteriaCopier;
import software.amazon.awssdk.services.glue.model.PhysicalConnectionRequirements;
import software.amazon.awssdk.services.glue.model.PropertyMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Connection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Connection> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Connection.getter(Connection::name)).setter(Connection.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Connection.getter(Connection::description)).setter(Connection.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionType").getter(Connection.getter(Connection::connectionTypeAsString)).setter(Connection.setter(Builder::connectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()}).build();
    private static final SdkField<List<String>> MATCH_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MatchCriteria").getter(Connection.getter(Connection::matchCriteria)).setter(Connection.setter(Builder::matchCriteria)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchCriteria").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> CONNECTION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ConnectionProperties").getter(Connection.getter(Connection::connectionPropertiesAsStrings)).setter(Connection.setter(Builder::connectionPropertiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> SPARK_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("SparkProperties").getter(Connection.getter(Connection::sparkProperties)).setter(Connection.setter(Builder::sparkProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SparkProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> ATHENA_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AthenaProperties").getter(Connection.getter(Connection::athenaProperties)).setter(Connection.setter(Builder::athenaProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AthenaProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> PYTHON_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("PythonProperties").getter(Connection.getter(Connection::pythonProperties)).setter(Connection.setter(Builder::pythonProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PythonProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<PhysicalConnectionRequirements> PHYSICAL_CONNECTION_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PhysicalConnectionRequirements").getter(Connection.getter(Connection::physicalConnectionRequirements)).setter(Connection.setter(Builder::physicalConnectionRequirements)).constructor(PhysicalConnectionRequirements::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalConnectionRequirements").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(Connection.getter(Connection::creationTime)).setter(Connection.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(Connection.getter(Connection::lastUpdatedTime)).setter(Connection.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastUpdatedBy").getter(Connection.getter(Connection::lastUpdatedBy)).setter(Connection.setter(Builder::lastUpdatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedBy").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Connection.getter(Connection::statusAsString)).setter(Connection.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(Connection.getter(Connection::statusReason)).setter(Connection.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<Instant> LAST_CONNECTION_VALIDATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastConnectionValidationTime").getter(Connection.getter(Connection::lastConnectionValidationTime)).setter(Connection.setter(Builder::lastConnectionValidationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastConnectionValidationTime").build()}).build();
    private static final SdkField<AuthenticationConfiguration> AUTHENTICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuthenticationConfiguration").getter(Connection.getter(Connection::authenticationConfiguration)).setter(Connection.setter(Builder::authenticationConfiguration)).constructor(AuthenticationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationConfiguration").build()}).build();
    private static final SdkField<Integer> CONNECTION_SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ConnectionSchemaVersion").getter(Connection.getter(Connection::connectionSchemaVersion)).setter(Connection.setter(Builder::connectionSchemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionSchemaVersion").build()}).build();
    private static final SdkField<List<String>> COMPATIBLE_COMPUTE_ENVIRONMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CompatibleComputeEnvironments").getter(Connection.getter(Connection::compatibleComputeEnvironmentsAsStrings)).setter(Connection.setter(Builder::compatibleComputeEnvironmentsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompatibleComputeEnvironments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, CONNECTION_TYPE_FIELD, MATCH_CRITERIA_FIELD, CONNECTION_PROPERTIES_FIELD, SPARK_PROPERTIES_FIELD, ATHENA_PROPERTIES_FIELD, PYTHON_PROPERTIES_FIELD, PHYSICAL_CONNECTION_REQUIREMENTS_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD, LAST_UPDATED_BY_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, LAST_CONNECTION_VALIDATION_TIME_FIELD, AUTHENTICATION_CONFIGURATION_FIELD, CONNECTION_SCHEMA_VERSION_FIELD, COMPATIBLE_COMPUTE_ENVIRONMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("ConnectionType", CONNECTION_TYPE_FIELD);
            this.put("MatchCriteria", MATCH_CRITERIA_FIELD);
            this.put("ConnectionProperties", CONNECTION_PROPERTIES_FIELD);
            this.put("SparkProperties", SPARK_PROPERTIES_FIELD);
            this.put("AthenaProperties", ATHENA_PROPERTIES_FIELD);
            this.put("PythonProperties", PYTHON_PROPERTIES_FIELD);
            this.put("PhysicalConnectionRequirements", PHYSICAL_CONNECTION_REQUIREMENTS_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
            this.put("LastUpdatedBy", LAST_UPDATED_BY_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("StatusReason", STATUS_REASON_FIELD);
            this.put("LastConnectionValidationTime", LAST_CONNECTION_VALIDATION_TIME_FIELD);
            this.put("AuthenticationConfiguration", AUTHENTICATION_CONFIGURATION_FIELD);
            this.put("ConnectionSchemaVersion", CONNECTION_SCHEMA_VERSION_FIELD);
            this.put("CompatibleComputeEnvironments", COMPATIBLE_COMPUTE_ENVIRONMENTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String connectionType;
    private final List<String> matchCriteria;
    private final Map<String, String> connectionProperties;
    private final Map<String, String> sparkProperties;
    private final Map<String, String> athenaProperties;
    private final Map<String, String> pythonProperties;
    private final PhysicalConnectionRequirements physicalConnectionRequirements;
    private final Instant creationTime;
    private final Instant lastUpdatedTime;
    private final String lastUpdatedBy;
    private final String status;
    private final String statusReason;
    private final Instant lastConnectionValidationTime;
    private final AuthenticationConfiguration authenticationConfiguration;
    private final Integer connectionSchemaVersion;
    private final List<String> compatibleComputeEnvironments;

    private Connection(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.connectionType = builder.connectionType;
        this.matchCriteria = builder.matchCriteria;
        this.connectionProperties = builder.connectionProperties;
        this.sparkProperties = builder.sparkProperties;
        this.athenaProperties = builder.athenaProperties;
        this.pythonProperties = builder.pythonProperties;
        this.physicalConnectionRequirements = builder.physicalConnectionRequirements;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.lastConnectionValidationTime = builder.lastConnectionValidationTime;
        this.authenticationConfiguration = builder.authenticationConfiguration;
        this.connectionSchemaVersion = builder.connectionSchemaVersion;
        this.compatibleComputeEnvironments = builder.compatibleComputeEnvironments;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final ConnectionType connectionType() {
        return ConnectionType.fromValue(this.connectionType);
    }

    public final String connectionTypeAsString() {
        return this.connectionType;
    }

    public final boolean hasMatchCriteria() {
        return this.matchCriteria != null && !(this.matchCriteria instanceof SdkAutoConstructList);
    }

    public final List<String> matchCriteria() {
        return this.matchCriteria;
    }

    public final Map<ConnectionPropertyKey, String> connectionProperties() {
        return ConnectionPropertiesCopier.copyStringToEnum(this.connectionProperties);
    }

    public final boolean hasConnectionProperties() {
        return this.connectionProperties != null && !(this.connectionProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> connectionPropertiesAsStrings() {
        return this.connectionProperties;
    }

    public final boolean hasSparkProperties() {
        return this.sparkProperties != null && !(this.sparkProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> sparkProperties() {
        return this.sparkProperties;
    }

    public final boolean hasAthenaProperties() {
        return this.athenaProperties != null && !(this.athenaProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> athenaProperties() {
        return this.athenaProperties;
    }

    public final boolean hasPythonProperties() {
        return this.pythonProperties != null && !(this.pythonProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> pythonProperties() {
        return this.pythonProperties;
    }

    public final PhysicalConnectionRequirements physicalConnectionRequirements() {
        return this.physicalConnectionRequirements;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String lastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public final ConnectionStatus status() {
        return ConnectionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final Instant lastConnectionValidationTime() {
        return this.lastConnectionValidationTime;
    }

    public final AuthenticationConfiguration authenticationConfiguration() {
        return this.authenticationConfiguration;
    }

    public final Integer connectionSchemaVersion() {
        return this.connectionSchemaVersion;
    }

    public final List<ComputeEnvironment> compatibleComputeEnvironments() {
        return ComputeEnvironmentListCopier.copyStringToEnum(this.compatibleComputeEnvironments);
    }

    public final boolean hasCompatibleComputeEnvironments() {
        return this.compatibleComputeEnvironments != null && !(this.compatibleComputeEnvironments instanceof SdkAutoConstructList);
    }

    public final List<String> compatibleComputeEnvironmentsAsStrings() {
        return this.compatibleComputeEnvironments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchCriteria() ? this.matchCriteria() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionProperties() ? this.connectionPropertiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSparkProperties() ? this.sparkProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAthenaProperties() ? this.athenaProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPythonProperties() ? this.pythonProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalConnectionRequirements());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastConnectionValidationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionSchemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCompatibleComputeEnvironments() ? this.compatibleComputeEnvironmentsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Connection)) {
            return false;
        }
        Connection other = (Connection)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.connectionTypeAsString(), other.connectionTypeAsString()) && this.hasMatchCriteria() == other.hasMatchCriteria() && Objects.equals(this.matchCriteria(), other.matchCriteria()) && this.hasConnectionProperties() == other.hasConnectionProperties() && Objects.equals(this.connectionPropertiesAsStrings(), other.connectionPropertiesAsStrings()) && this.hasSparkProperties() == other.hasSparkProperties() && Objects.equals(this.sparkProperties(), other.sparkProperties()) && this.hasAthenaProperties() == other.hasAthenaProperties() && Objects.equals(this.athenaProperties(), other.athenaProperties()) && this.hasPythonProperties() == other.hasPythonProperties() && Objects.equals(this.pythonProperties(), other.pythonProperties()) && Objects.equals(this.physicalConnectionRequirements(), other.physicalConnectionRequirements()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.lastUpdatedBy(), other.lastUpdatedBy()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.lastConnectionValidationTime(), other.lastConnectionValidationTime()) && Objects.equals(this.authenticationConfiguration(), other.authenticationConfiguration()) && Objects.equals(this.connectionSchemaVersion(), other.connectionSchemaVersion()) && this.hasCompatibleComputeEnvironments() == other.hasCompatibleComputeEnvironments() && Objects.equals(this.compatibleComputeEnvironmentsAsStrings(), other.compatibleComputeEnvironmentsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"Connection").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("ConnectionType", (Object)this.connectionTypeAsString()).add("MatchCriteria", this.hasMatchCriteria() ? this.matchCriteria() : null).add("ConnectionProperties", this.hasConnectionProperties() ? this.connectionPropertiesAsStrings() : null).add("SparkProperties", this.hasSparkProperties() ? this.sparkProperties() : null).add("AthenaProperties", this.hasAthenaProperties() ? this.athenaProperties() : null).add("PythonProperties", this.hasPythonProperties() ? this.pythonProperties() : null).add("PhysicalConnectionRequirements", (Object)this.physicalConnectionRequirements()).add("CreationTime", (Object)this.creationTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("LastUpdatedBy", (Object)this.lastUpdatedBy()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("LastConnectionValidationTime", (Object)this.lastConnectionValidationTime()).add("AuthenticationConfiguration", (Object)this.authenticationConfiguration()).add("ConnectionSchemaVersion", (Object)this.connectionSchemaVersion()).add("CompatibleComputeEnvironments", this.hasCompatibleComputeEnvironments() ? this.compatibleComputeEnvironmentsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ConnectionType": {
                return Optional.ofNullable(clazz.cast(this.connectionTypeAsString()));
            }
            case "MatchCriteria": {
                return Optional.ofNullable(clazz.cast(this.matchCriteria()));
            }
            case "ConnectionProperties": {
                return Optional.ofNullable(clazz.cast(this.connectionPropertiesAsStrings()));
            }
            case "SparkProperties": {
                return Optional.ofNullable(clazz.cast(this.sparkProperties()));
            }
            case "AthenaProperties": {
                return Optional.ofNullable(clazz.cast(this.athenaProperties()));
            }
            case "PythonProperties": {
                return Optional.ofNullable(clazz.cast(this.pythonProperties()));
            }
            case "PhysicalConnectionRequirements": {
                return Optional.ofNullable(clazz.cast(this.physicalConnectionRequirements()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "LastUpdatedBy": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedBy()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "LastConnectionValidationTime": {
                return Optional.ofNullable(clazz.cast(this.lastConnectionValidationTime()));
            }
            case "AuthenticationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.authenticationConfiguration()));
            }
            case "ConnectionSchemaVersion": {
                return Optional.ofNullable(clazz.cast(this.connectionSchemaVersion()));
            }
            case "CompatibleComputeEnvironments": {
                return Optional.ofNullable(clazz.cast(this.compatibleComputeEnvironmentsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Connection, T> g) {
        return obj -> g.apply((Connection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String connectionType;
        private List<String> matchCriteria = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> connectionProperties = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> sparkProperties = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> athenaProperties = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> pythonProperties = DefaultSdkAutoConstructMap.getInstance();
        private PhysicalConnectionRequirements physicalConnectionRequirements;
        private Instant creationTime;
        private Instant lastUpdatedTime;
        private String lastUpdatedBy;
        private String status;
        private String statusReason;
        private Instant lastConnectionValidationTime;
        private AuthenticationConfiguration authenticationConfiguration;
        private Integer connectionSchemaVersion;
        private List<String> compatibleComputeEnvironments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Connection model) {
            this.name(model.name);
            this.description(model.description);
            this.connectionType(model.connectionType);
            this.matchCriteria(model.matchCriteria);
            this.connectionPropertiesWithStrings(model.connectionProperties);
            this.sparkProperties(model.sparkProperties);
            this.athenaProperties(model.athenaProperties);
            this.pythonProperties(model.pythonProperties);
            this.physicalConnectionRequirements(model.physicalConnectionRequirements);
            this.creationTime(model.creationTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.lastUpdatedBy(model.lastUpdatedBy);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.lastConnectionValidationTime(model.lastConnectionValidationTime);
            this.authenticationConfiguration(model.authenticationConfiguration);
            this.connectionSchemaVersion(model.connectionSchemaVersion);
            this.compatibleComputeEnvironmentsWithStrings(model.compatibleComputeEnvironments);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getConnectionType() {
            return this.connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final Collection<String> getMatchCriteria() {
            if (this.matchCriteria instanceof SdkAutoConstructList) {
                return null;
            }
            return this.matchCriteria;
        }

        public final void setMatchCriteria(Collection<String> matchCriteria) {
            this.matchCriteria = MatchCriteriaCopier.copy(matchCriteria);
        }

        @Override
        public final Builder matchCriteria(Collection<String> matchCriteria) {
            this.matchCriteria = MatchCriteriaCopier.copy(matchCriteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchCriteria(String ... matchCriteria) {
            this.matchCriteria(Arrays.asList(matchCriteria));
            return this;
        }

        public final Map<String, String> getConnectionProperties() {
            if (this.connectionProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.connectionProperties;
        }

        public final void setConnectionProperties(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
        }

        @Override
        public final Builder connectionPropertiesWithStrings(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
            return this;
        }

        @Override
        public final Builder connectionProperties(Map<ConnectionPropertyKey, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copyEnumToString(connectionProperties);
            return this;
        }

        public final Map<String, String> getSparkProperties() {
            if (this.sparkProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.sparkProperties;
        }

        public final void setSparkProperties(Map<String, String> sparkProperties) {
            this.sparkProperties = PropertyMapCopier.copy(sparkProperties);
        }

        @Override
        public final Builder sparkProperties(Map<String, String> sparkProperties) {
            this.sparkProperties = PropertyMapCopier.copy(sparkProperties);
            return this;
        }

        public final Map<String, String> getAthenaProperties() {
            if (this.athenaProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.athenaProperties;
        }

        public final void setAthenaProperties(Map<String, String> athenaProperties) {
            this.athenaProperties = PropertyMapCopier.copy(athenaProperties);
        }

        @Override
        public final Builder athenaProperties(Map<String, String> athenaProperties) {
            this.athenaProperties = PropertyMapCopier.copy(athenaProperties);
            return this;
        }

        public final Map<String, String> getPythonProperties() {
            if (this.pythonProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.pythonProperties;
        }

        public final void setPythonProperties(Map<String, String> pythonProperties) {
            this.pythonProperties = PropertyMapCopier.copy(pythonProperties);
        }

        @Override
        public final Builder pythonProperties(Map<String, String> pythonProperties) {
            this.pythonProperties = PropertyMapCopier.copy(pythonProperties);
            return this;
        }

        public final PhysicalConnectionRequirements.Builder getPhysicalConnectionRequirements() {
            return this.physicalConnectionRequirements != null ? this.physicalConnectionRequirements.toBuilder() : null;
        }

        public final void setPhysicalConnectionRequirements(PhysicalConnectionRequirements.BuilderImpl physicalConnectionRequirements) {
            this.physicalConnectionRequirements = physicalConnectionRequirements != null ? physicalConnectionRequirements.build() : null;
        }

        @Override
        public final Builder physicalConnectionRequirements(PhysicalConnectionRequirements physicalConnectionRequirements) {
            this.physicalConnectionRequirements = physicalConnectionRequirements;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getLastUpdatedBy() {
            return this.lastUpdatedBy;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConnectionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getLastConnectionValidationTime() {
            return this.lastConnectionValidationTime;
        }

        public final void setLastConnectionValidationTime(Instant lastConnectionValidationTime) {
            this.lastConnectionValidationTime = lastConnectionValidationTime;
        }

        @Override
        public final Builder lastConnectionValidationTime(Instant lastConnectionValidationTime) {
            this.lastConnectionValidationTime = lastConnectionValidationTime;
            return this;
        }

        public final AuthenticationConfiguration.Builder getAuthenticationConfiguration() {
            return this.authenticationConfiguration != null ? this.authenticationConfiguration.toBuilder() : null;
        }

        public final void setAuthenticationConfiguration(AuthenticationConfiguration.BuilderImpl authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration != null ? authenticationConfiguration.build() : null;
        }

        @Override
        public final Builder authenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public final Integer getConnectionSchemaVersion() {
            return this.connectionSchemaVersion;
        }

        public final void setConnectionSchemaVersion(Integer connectionSchemaVersion) {
            this.connectionSchemaVersion = connectionSchemaVersion;
        }

        @Override
        public final Builder connectionSchemaVersion(Integer connectionSchemaVersion) {
            this.connectionSchemaVersion = connectionSchemaVersion;
            return this;
        }

        public final Collection<String> getCompatibleComputeEnvironments() {
            if (this.compatibleComputeEnvironments instanceof SdkAutoConstructList) {
                return null;
            }
            return this.compatibleComputeEnvironments;
        }

        public final void setCompatibleComputeEnvironments(Collection<String> compatibleComputeEnvironments) {
            this.compatibleComputeEnvironments = ComputeEnvironmentListCopier.copy(compatibleComputeEnvironments);
        }

        @Override
        public final Builder compatibleComputeEnvironmentsWithStrings(Collection<String> compatibleComputeEnvironments) {
            this.compatibleComputeEnvironments = ComputeEnvironmentListCopier.copy(compatibleComputeEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleComputeEnvironmentsWithStrings(String ... compatibleComputeEnvironments) {
            this.compatibleComputeEnvironmentsWithStrings(Arrays.asList(compatibleComputeEnvironments));
            return this;
        }

        @Override
        public final Builder compatibleComputeEnvironments(Collection<ComputeEnvironment> compatibleComputeEnvironments) {
            this.compatibleComputeEnvironments = ComputeEnvironmentListCopier.copyEnumToString(compatibleComputeEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleComputeEnvironments(ComputeEnvironment ... compatibleComputeEnvironments) {
            this.compatibleComputeEnvironments(Arrays.asList(compatibleComputeEnvironments));
            return this;
        }

        public Connection build() {
            return new Connection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Connection> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder connectionType(String var1);

        public Builder connectionType(ConnectionType var1);

        public Builder matchCriteria(Collection<String> var1);

        public Builder matchCriteria(String ... var1);

        public Builder connectionPropertiesWithStrings(Map<String, String> var1);

        public Builder connectionProperties(Map<ConnectionPropertyKey, String> var1);

        public Builder sparkProperties(Map<String, String> var1);

        public Builder athenaProperties(Map<String, String> var1);

        public Builder pythonProperties(Map<String, String> var1);

        public Builder physicalConnectionRequirements(PhysicalConnectionRequirements var1);

        default public Builder physicalConnectionRequirements(Consumer<PhysicalConnectionRequirements.Builder> physicalConnectionRequirements) {
            return this.physicalConnectionRequirements((PhysicalConnectionRequirements)((PhysicalConnectionRequirements.Builder)PhysicalConnectionRequirements.builder().applyMutation(physicalConnectionRequirements)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder lastUpdatedBy(String var1);

        public Builder status(String var1);

        public Builder status(ConnectionStatus var1);

        public Builder statusReason(String var1);

        public Builder lastConnectionValidationTime(Instant var1);

        public Builder authenticationConfiguration(AuthenticationConfiguration var1);

        default public Builder authenticationConfiguration(Consumer<AuthenticationConfiguration.Builder> authenticationConfiguration) {
            return this.authenticationConfiguration((AuthenticationConfiguration)((AuthenticationConfiguration.Builder)AuthenticationConfiguration.builder().applyMutation(authenticationConfiguration)).build());
        }

        public Builder connectionSchemaVersion(Integer var1);

        public Builder compatibleComputeEnvironmentsWithStrings(Collection<String> var1);

        public Builder compatibleComputeEnvironmentsWithStrings(String ... var1);

        public Builder compatibleComputeEnvironments(Collection<ComputeEnvironment> var1);

        public Builder compatibleComputeEnvironments(ComputeEnvironment ... var1);
    }
}

