/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTableOptimizerRequest extends GlueRequest implements
        ToCopyableBuilder<UpdateTableOptimizerRequest.Builder, UpdateTableOptimizerRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(UpdateTableOptimizerRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(UpdateTableOptimizerRequest::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(UpdateTableOptimizerRequest::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(UpdateTableOptimizerRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<TableOptimizerConfiguration> TABLE_OPTIMIZER_CONFIGURATION_FIELD = SdkField
            .<TableOptimizerConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("TableOptimizerConfiguration")
            .getter(getter(UpdateTableOptimizerRequest::tableOptimizerConfiguration))
            .setter(setter(Builder::tableOptimizerConfiguration))
            .constructor(TableOptimizerConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableOptimizerConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            DATABASE_NAME_FIELD, TABLE_NAME_FIELD, TYPE_FIELD, TABLE_OPTIMIZER_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CatalogId", CATALOG_ID_FIELD);
                    put("DatabaseName", DATABASE_NAME_FIELD);
                    put("TableName", TABLE_NAME_FIELD);
                    put("Type", TYPE_FIELD);
                    put("TableOptimizerConfiguration", TABLE_OPTIMIZER_CONFIGURATION_FIELD);
                }
            });

    private final String catalogId;

    private final String databaseName;

    private final String tableName;

    private final String type;

    private final TableOptimizerConfiguration tableOptimizerConfiguration;

    private UpdateTableOptimizerRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.type = builder.type;
        this.tableOptimizerConfiguration = builder.tableOptimizerConfiguration;
    }

    /**
     * <p>
     * The Catalog ID of the table.
     * </p>
     * 
     * @return The Catalog ID of the table.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The name of the database in the catalog in which the table resides.
     * </p>
     * 
     * @return The name of the database in the catalog in which the table resides.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of the table.
     * </p>
     * 
     * @return The name of the table.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The type of table optimizer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TableOptimizerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of table optimizer.
     * @see TableOptimizerType
     */
    public final TableOptimizerType type() {
        return TableOptimizerType.fromValue(type);
    }

    /**
     * <p>
     * The type of table optimizer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TableOptimizerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of table optimizer.
     * @see TableOptimizerType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A <code>TableOptimizerConfiguration</code> object representing the configuration of a table optimizer.
     * </p>
     * 
     * @return A <code>TableOptimizerConfiguration</code> object representing the configuration of a table optimizer.
     */
    public final TableOptimizerConfiguration tableOptimizerConfiguration() {
        return tableOptimizerConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tableOptimizerConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTableOptimizerRequest)) {
            return false;
        }
        UpdateTableOptimizerRequest other = (UpdateTableOptimizerRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(tableName(), other.tableName()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(tableOptimizerConfiguration(), other.tableOptimizerConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTableOptimizerRequest").add("CatalogId", catalogId()).add("DatabaseName", databaseName())
                .add("TableName", tableName()).add("Type", typeAsString())
                .add("TableOptimizerConfiguration", tableOptimizerConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "TableOptimizerConfiguration":
            return Optional.ofNullable(clazz.cast(tableOptimizerConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTableOptimizerRequest, T> g) {
        return obj -> g.apply((UpdateTableOptimizerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTableOptimizerRequest> {
        /**
         * <p>
         * The Catalog ID of the table.
         * </p>
         * 
         * @param catalogId
         *        The Catalog ID of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The name of the database in the catalog in which the table resides.
         * </p>
         * 
         * @param databaseName
         *        The name of the database in the catalog in which the table resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of the table.
         * </p>
         * 
         * @param tableName
         *        The name of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The type of table optimizer.
         * </p>
         * 
         * @param type
         *        The type of table optimizer.
         * @see TableOptimizerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableOptimizerType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of table optimizer.
         * </p>
         * 
         * @param type
         *        The type of table optimizer.
         * @see TableOptimizerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableOptimizerType
         */
        Builder type(TableOptimizerType type);

        /**
         * <p>
         * A <code>TableOptimizerConfiguration</code> object representing the configuration of a table optimizer.
         * </p>
         * 
         * @param tableOptimizerConfiguration
         *        A <code>TableOptimizerConfiguration</code> object representing the configuration of a table optimizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableOptimizerConfiguration(TableOptimizerConfiguration tableOptimizerConfiguration);

        /**
         * <p>
         * A <code>TableOptimizerConfiguration</code> object representing the configuration of a table optimizer.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableOptimizerConfiguration.Builder}
         * avoiding the need to create one manually via {@link TableOptimizerConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableOptimizerConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #tableOptimizerConfiguration(TableOptimizerConfiguration)}.
         * 
         * @param tableOptimizerConfiguration
         *        a consumer that will call methods on {@link TableOptimizerConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableOptimizerConfiguration(TableOptimizerConfiguration)
         */
        default Builder tableOptimizerConfiguration(Consumer<TableOptimizerConfiguration.Builder> tableOptimizerConfiguration) {
            return tableOptimizerConfiguration(TableOptimizerConfiguration.builder().applyMutation(tableOptimizerConfiguration)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String catalogId;

        private String databaseName;

        private String tableName;

        private String type;

        private TableOptimizerConfiguration tableOptimizerConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTableOptimizerRequest model) {
            super(model);
            catalogId(model.catalogId);
            databaseName(model.databaseName);
            tableName(model.tableName);
            type(model.type);
            tableOptimizerConfiguration(model.tableOptimizerConfiguration);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TableOptimizerType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final TableOptimizerConfiguration.Builder getTableOptimizerConfiguration() {
            return tableOptimizerConfiguration != null ? tableOptimizerConfiguration.toBuilder() : null;
        }

        public final void setTableOptimizerConfiguration(TableOptimizerConfiguration.BuilderImpl tableOptimizerConfiguration) {
            this.tableOptimizerConfiguration = tableOptimizerConfiguration != null ? tableOptimizerConfiguration.build() : null;
        }

        @Override
        public final Builder tableOptimizerConfiguration(TableOptimizerConfiguration tableOptimizerConfiguration) {
            this.tableOptimizerConfiguration = tableOptimizerConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTableOptimizerRequest build() {
            return new UpdateTableOptimizerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
