/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a transform that identifies, removes or masks PII data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PIIDetection implements SdkPojo, Serializable, ToCopyableBuilder<PIIDetection.Builder, PIIDetection> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(PIIDetection::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> INPUTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Inputs")
            .getter(getter(PIIDetection::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PII_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PiiType").getter(getter(PIIDetection::piiTypeAsString)).setter(setter(Builder::piiType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PiiType").build()).build();

    private static final SdkField<List<String>> ENTITY_TYPES_TO_DETECT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EntityTypesToDetect")
            .getter(getter(PIIDetection::entityTypesToDetect))
            .setter(setter(Builder::entityTypesToDetect))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityTypesToDetect").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OUTPUT_COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputColumnName").getter(getter(PIIDetection::outputColumnName))
            .setter(setter(Builder::outputColumnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputColumnName").build()).build();

    private static final SdkField<Double> SAMPLE_FRACTION_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("SampleFraction").getter(getter(PIIDetection::sampleFraction)).setter(setter(Builder::sampleFraction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleFraction").build()).build();

    private static final SdkField<Double> THRESHOLD_FRACTION_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ThresholdFraction").getter(getter(PIIDetection::thresholdFraction))
            .setter(setter(Builder::thresholdFraction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThresholdFraction").build()).build();

    private static final SdkField<String> MASK_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaskValue").getter(getter(PIIDetection::maskValue)).setter(setter(Builder::maskValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaskValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD,
            PII_TYPE_FIELD, ENTITY_TYPES_TO_DETECT_FIELD, OUTPUT_COLUMN_NAME_FIELD, SAMPLE_FRACTION_FIELD,
            THRESHOLD_FRACTION_FIELD, MASK_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Name", NAME_FIELD);
                    put("Inputs", INPUTS_FIELD);
                    put("PiiType", PII_TYPE_FIELD);
                    put("EntityTypesToDetect", ENTITY_TYPES_TO_DETECT_FIELD);
                    put("OutputColumnName", OUTPUT_COLUMN_NAME_FIELD);
                    put("SampleFraction", SAMPLE_FRACTION_FIELD);
                    put("ThresholdFraction", THRESHOLD_FRACTION_FIELD);
                    put("MaskValue", MASK_VALUE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> inputs;

    private final String piiType;

    private final List<String> entityTypesToDetect;

    private final String outputColumnName;

    private final Double sampleFraction;

    private final Double thresholdFraction;

    private final String maskValue;

    private PIIDetection(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.piiType = builder.piiType;
        this.entityTypesToDetect = builder.entityTypesToDetect;
        this.outputColumnName = builder.outputColumnName;
        this.sampleFraction = builder.sampleFraction;
        this.thresholdFraction = builder.thresholdFraction;
        this.maskValue = builder.maskValue;
    }

    /**
     * <p>
     * The name of the transform node.
     * </p>
     * 
     * @return The name of the transform node.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The node ID inputs to the transform.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return The node ID inputs to the transform.
     */
    public final List<String> inputs() {
        return inputs;
    }

    /**
     * <p>
     * Indicates the type of PIIDetection transform.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #piiType} will
     * return {@link PiiType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #piiTypeAsString}.
     * </p>
     * 
     * @return Indicates the type of PIIDetection transform.
     * @see PiiType
     */
    public final PiiType piiType() {
        return PiiType.fromValue(piiType);
    }

    /**
     * <p>
     * Indicates the type of PIIDetection transform.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #piiType} will
     * return {@link PiiType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #piiTypeAsString}.
     * </p>
     * 
     * @return Indicates the type of PIIDetection transform.
     * @see PiiType
     */
    public final String piiTypeAsString() {
        return piiType;
    }

    /**
     * For responses, this returns true if the service returned a value for the EntityTypesToDetect property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEntityTypesToDetect() {
        return entityTypesToDetect != null && !(entityTypesToDetect instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates the types of entities the PIIDetection transform will identify as PII data.
     * </p>
     * <p>
     * PII type entities include: PERSON_NAME, DATE, USA_SNN, EMAIL, USA_ITIN, USA_PASSPORT_NUMBER, PHONE_NUMBER,
     * BANK_ACCOUNT, IP_ADDRESS, MAC_ADDRESS, USA_CPT_CODE, USA_HCPCS_CODE, USA_NATIONAL_DRUG_CODE,
     * USA_MEDICARE_BENEFICIARY_IDENTIFIER,
     * USA_HEALTH_INSURANCE_CLAIM_NUMBER,CREDIT_CARD,USA_NATIONAL_PROVIDER_IDENTIFIER,USA_DEA_NUMBER,USA_DRIVING_LICENSE
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntityTypesToDetect} method.
     * </p>
     * 
     * @return Indicates the types of entities the PIIDetection transform will identify as PII data. </p>
     *         <p>
     *         PII type entities include: PERSON_NAME, DATE, USA_SNN, EMAIL, USA_ITIN, USA_PASSPORT_NUMBER,
     *         PHONE_NUMBER, BANK_ACCOUNT, IP_ADDRESS, MAC_ADDRESS, USA_CPT_CODE, USA_HCPCS_CODE,
     *         USA_NATIONAL_DRUG_CODE, USA_MEDICARE_BENEFICIARY_IDENTIFIER,
     *         USA_HEALTH_INSURANCE_CLAIM_NUMBER,CREDIT_CARD
     *         ,USA_NATIONAL_PROVIDER_IDENTIFIER,USA_DEA_NUMBER,USA_DRIVING_LICENSE
     */
    public final List<String> entityTypesToDetect() {
        return entityTypesToDetect;
    }

    /**
     * <p>
     * Indicates the output column name that will contain any entity type detected in that row.
     * </p>
     * 
     * @return Indicates the output column name that will contain any entity type detected in that row.
     */
    public final String outputColumnName() {
        return outputColumnName;
    }

    /**
     * <p>
     * Indicates the fraction of the data to sample when scanning for PII entities.
     * </p>
     * 
     * @return Indicates the fraction of the data to sample when scanning for PII entities.
     */
    public final Double sampleFraction() {
        return sampleFraction;
    }

    /**
     * <p>
     * Indicates the fraction of the data that must be met in order for a column to be identified as PII data.
     * </p>
     * 
     * @return Indicates the fraction of the data that must be met in order for a column to be identified as PII data.
     */
    public final Double thresholdFraction() {
        return thresholdFraction;
    }

    /**
     * <p>
     * Indicates the value that will replace the detected entity.
     * </p>
     * 
     * @return Indicates the value that will replace the detected entity.
     */
    public final String maskValue() {
        return maskValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(piiTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntityTypesToDetect() ? entityTypesToDetect() : null);
        hashCode = 31 * hashCode + Objects.hashCode(outputColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(sampleFraction());
        hashCode = 31 * hashCode + Objects.hashCode(thresholdFraction());
        hashCode = 31 * hashCode + Objects.hashCode(maskValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PIIDetection)) {
            return false;
        }
        PIIDetection other = (PIIDetection) obj;
        return Objects.equals(name(), other.name()) && hasInputs() == other.hasInputs()
                && Objects.equals(inputs(), other.inputs()) && Objects.equals(piiTypeAsString(), other.piiTypeAsString())
                && hasEntityTypesToDetect() == other.hasEntityTypesToDetect()
                && Objects.equals(entityTypesToDetect(), other.entityTypesToDetect())
                && Objects.equals(outputColumnName(), other.outputColumnName())
                && Objects.equals(sampleFraction(), other.sampleFraction())
                && Objects.equals(thresholdFraction(), other.thresholdFraction())
                && Objects.equals(maskValue(), other.maskValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PIIDetection").add("Name", name()).add("Inputs", hasInputs() ? inputs() : null)
                .add("PiiType", piiTypeAsString())
                .add("EntityTypesToDetect", hasEntityTypesToDetect() ? entityTypesToDetect() : null)
                .add("OutputColumnName", outputColumnName()).add("SampleFraction", sampleFraction())
                .add("ThresholdFraction", thresholdFraction()).add("MaskValue", maskValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "PiiType":
            return Optional.ofNullable(clazz.cast(piiTypeAsString()));
        case "EntityTypesToDetect":
            return Optional.ofNullable(clazz.cast(entityTypesToDetect()));
        case "OutputColumnName":
            return Optional.ofNullable(clazz.cast(outputColumnName()));
        case "SampleFraction":
            return Optional.ofNullable(clazz.cast(sampleFraction()));
        case "ThresholdFraction":
            return Optional.ofNullable(clazz.cast(thresholdFraction()));
        case "MaskValue":
            return Optional.ofNullable(clazz.cast(maskValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PIIDetection, T> g) {
        return obj -> g.apply((PIIDetection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PIIDetection> {
        /**
         * <p>
         * The name of the transform node.
         * </p>
         * 
         * @param name
         *        The name of the transform node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The node ID inputs to the transform.
         * </p>
         * 
         * @param inputs
         *        The node ID inputs to the transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<String> inputs);

        /**
         * <p>
         * The node ID inputs to the transform.
         * </p>
         * 
         * @param inputs
         *        The node ID inputs to the transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(String... inputs);

        /**
         * <p>
         * Indicates the type of PIIDetection transform.
         * </p>
         * 
         * @param piiType
         *        Indicates the type of PIIDetection transform.
         * @see PiiType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PiiType
         */
        Builder piiType(String piiType);

        /**
         * <p>
         * Indicates the type of PIIDetection transform.
         * </p>
         * 
         * @param piiType
         *        Indicates the type of PIIDetection transform.
         * @see PiiType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PiiType
         */
        Builder piiType(PiiType piiType);

        /**
         * <p>
         * Indicates the types of entities the PIIDetection transform will identify as PII data.
         * </p>
         * <p>
         * PII type entities include: PERSON_NAME, DATE, USA_SNN, EMAIL, USA_ITIN, USA_PASSPORT_NUMBER, PHONE_NUMBER,
         * BANK_ACCOUNT, IP_ADDRESS, MAC_ADDRESS, USA_CPT_CODE, USA_HCPCS_CODE, USA_NATIONAL_DRUG_CODE,
         * USA_MEDICARE_BENEFICIARY_IDENTIFIER,
         * USA_HEALTH_INSURANCE_CLAIM_NUMBER,CREDIT_CARD,USA_NATIONAL_PROVIDER_IDENTIFIER
         * ,USA_DEA_NUMBER,USA_DRIVING_LICENSE
         * </p>
         * 
         * @param entityTypesToDetect
         *        Indicates the types of entities the PIIDetection transform will identify as PII data. </p>
         *        <p>
         *        PII type entities include: PERSON_NAME, DATE, USA_SNN, EMAIL, USA_ITIN, USA_PASSPORT_NUMBER,
         *        PHONE_NUMBER, BANK_ACCOUNT, IP_ADDRESS, MAC_ADDRESS, USA_CPT_CODE, USA_HCPCS_CODE,
         *        USA_NATIONAL_DRUG_CODE, USA_MEDICARE_BENEFICIARY_IDENTIFIER,
         *        USA_HEALTH_INSURANCE_CLAIM_NUMBER,CREDIT_CARD
         *        ,USA_NATIONAL_PROVIDER_IDENTIFIER,USA_DEA_NUMBER,USA_DRIVING_LICENSE
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityTypesToDetect(Collection<String> entityTypesToDetect);

        /**
         * <p>
         * Indicates the types of entities the PIIDetection transform will identify as PII data.
         * </p>
         * <p>
         * PII type entities include: PERSON_NAME, DATE, USA_SNN, EMAIL, USA_ITIN, USA_PASSPORT_NUMBER, PHONE_NUMBER,
         * BANK_ACCOUNT, IP_ADDRESS, MAC_ADDRESS, USA_CPT_CODE, USA_HCPCS_CODE, USA_NATIONAL_DRUG_CODE,
         * USA_MEDICARE_BENEFICIARY_IDENTIFIER,
         * USA_HEALTH_INSURANCE_CLAIM_NUMBER,CREDIT_CARD,USA_NATIONAL_PROVIDER_IDENTIFIER
         * ,USA_DEA_NUMBER,USA_DRIVING_LICENSE
         * </p>
         * 
         * @param entityTypesToDetect
         *        Indicates the types of entities the PIIDetection transform will identify as PII data. </p>
         *        <p>
         *        PII type entities include: PERSON_NAME, DATE, USA_SNN, EMAIL, USA_ITIN, USA_PASSPORT_NUMBER,
         *        PHONE_NUMBER, BANK_ACCOUNT, IP_ADDRESS, MAC_ADDRESS, USA_CPT_CODE, USA_HCPCS_CODE,
         *        USA_NATIONAL_DRUG_CODE, USA_MEDICARE_BENEFICIARY_IDENTIFIER,
         *        USA_HEALTH_INSURANCE_CLAIM_NUMBER,CREDIT_CARD
         *        ,USA_NATIONAL_PROVIDER_IDENTIFIER,USA_DEA_NUMBER,USA_DRIVING_LICENSE
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityTypesToDetect(String... entityTypesToDetect);

        /**
         * <p>
         * Indicates the output column name that will contain any entity type detected in that row.
         * </p>
         * 
         * @param outputColumnName
         *        Indicates the output column name that will contain any entity type detected in that row.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputColumnName(String outputColumnName);

        /**
         * <p>
         * Indicates the fraction of the data to sample when scanning for PII entities.
         * </p>
         * 
         * @param sampleFraction
         *        Indicates the fraction of the data to sample when scanning for PII entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleFraction(Double sampleFraction);

        /**
         * <p>
         * Indicates the fraction of the data that must be met in order for a column to be identified as PII data.
         * </p>
         * 
         * @param thresholdFraction
         *        Indicates the fraction of the data that must be met in order for a column to be identified as PII
         *        data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thresholdFraction(Double thresholdFraction);

        /**
         * <p>
         * Indicates the value that will replace the detected entity.
         * </p>
         * 
         * @param maskValue
         *        Indicates the value that will replace the detected entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maskValue(String maskValue);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();

        private String piiType;

        private List<String> entityTypesToDetect = DefaultSdkAutoConstructList.getInstance();

        private String outputColumnName;

        private Double sampleFraction;

        private Double thresholdFraction;

        private String maskValue;

        private BuilderImpl() {
        }

        private BuilderImpl(PIIDetection model) {
            name(model.name);
            inputs(model.inputs);
            piiType(model.piiType);
            entityTypesToDetect(model.entityTypesToDetect);
            outputColumnName(model.outputColumnName);
            sampleFraction(model.sampleFraction);
            thresholdFraction(model.thresholdFraction);
            maskValue(model.maskValue);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        public final String getPiiType() {
            return piiType;
        }

        public final void setPiiType(String piiType) {
            this.piiType = piiType;
        }

        @Override
        public final Builder piiType(String piiType) {
            this.piiType = piiType;
            return this;
        }

        @Override
        public final Builder piiType(PiiType piiType) {
            this.piiType(piiType == null ? null : piiType.toString());
            return this;
        }

        public final Collection<String> getEntityTypesToDetect() {
            if (entityTypesToDetect instanceof SdkAutoConstructList) {
                return null;
            }
            return entityTypesToDetect;
        }

        public final void setEntityTypesToDetect(Collection<String> entityTypesToDetect) {
            this.entityTypesToDetect = EnclosedInStringPropertiesCopier.copy(entityTypesToDetect);
        }

        @Override
        public final Builder entityTypesToDetect(Collection<String> entityTypesToDetect) {
            this.entityTypesToDetect = EnclosedInStringPropertiesCopier.copy(entityTypesToDetect);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityTypesToDetect(String... entityTypesToDetect) {
            entityTypesToDetect(Arrays.asList(entityTypesToDetect));
            return this;
        }

        public final String getOutputColumnName() {
            return outputColumnName;
        }

        public final void setOutputColumnName(String outputColumnName) {
            this.outputColumnName = outputColumnName;
        }

        @Override
        public final Builder outputColumnName(String outputColumnName) {
            this.outputColumnName = outputColumnName;
            return this;
        }

        public final Double getSampleFraction() {
            return sampleFraction;
        }

        public final void setSampleFraction(Double sampleFraction) {
            this.sampleFraction = sampleFraction;
        }

        @Override
        public final Builder sampleFraction(Double sampleFraction) {
            this.sampleFraction = sampleFraction;
            return this;
        }

        public final Double getThresholdFraction() {
            return thresholdFraction;
        }

        public final void setThresholdFraction(Double thresholdFraction) {
            this.thresholdFraction = thresholdFraction;
        }

        @Override
        public final Builder thresholdFraction(Double thresholdFraction) {
            this.thresholdFraction = thresholdFraction;
            return this;
        }

        public final String getMaskValue() {
            return maskValue;
        }

        public final void setMaskValue(String maskValue) {
            this.maskValue = maskValue;
        }

        @Override
        public final Builder maskValue(String maskValue) {
            this.maskValue = maskValue;
            return this;
        }

        @Override
        public PIIDetection build() {
            return new PIIDetection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
