/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the sort order of a sorted column.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Order implements SdkPojo, Serializable, ToCopyableBuilder<Order.Builder, Order> {
    private static final SdkField<String> COLUMN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Column")
            .getter(getter(Order::column)).setter(setter(Builder::column))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()).build();

    private static final SdkField<Integer> SORT_ORDER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SortOrder").getter(getter(Order::sortOrder)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(COLUMN_FIELD, SORT_ORDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Column", COLUMN_FIELD);
                    put("SortOrder", SORT_ORDER_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String column;

    private final Integer sortOrder;

    private Order(BuilderImpl builder) {
        this.column = builder.column;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * <p>
     * The name of the column.
     * </p>
     * 
     * @return The name of the column.
     */
    public final String column() {
        return column;
    }

    /**
     * <p>
     * Indicates that the column is sorted in ascending order (<code>== 1</code>), or in descending order (
     * <code>==0</code>).
     * </p>
     * 
     * @return Indicates that the column is sorted in ascending order (<code>== 1</code>), or in descending order (
     *         <code>==0</code>).
     */
    public final Integer sortOrder() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(column());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrder());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Order)) {
            return false;
        }
        Order other = (Order) obj;
        return Objects.equals(column(), other.column()) && Objects.equals(sortOrder(), other.sortOrder());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Order").add("Column", column()).add("SortOrder", sortOrder()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Column":
            return Optional.ofNullable(clazz.cast(column()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrder()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Order, T> g) {
        return obj -> g.apply((Order) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Order> {
        /**
         * <p>
         * The name of the column.
         * </p>
         * 
         * @param column
         *        The name of the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder column(String column);

        /**
         * <p>
         * Indicates that the column is sorted in ascending order (<code>== 1</code>), or in descending order (
         * <code>==0</code>).
         * </p>
         * 
         * @param sortOrder
         *        Indicates that the column is sorted in ascending order (<code>== 1</code>), or in descending order (
         *        <code>==0</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortOrder(Integer sortOrder);
    }

    static final class BuilderImpl implements Builder {
        private String column;

        private Integer sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(Order model) {
            column(model.column);
            sortOrder(model.sortOrder);
        }

        public final String getColumn() {
            return column;
        }

        public final void setColumn(String column) {
            this.column = column;
        }

        @Override
        public final Builder column(String column) {
            this.column = column;
            return this;
        }

        public final Integer getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(Integer sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(Integer sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public Order build() {
            return new Order(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
