/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The credentials used when the authentication type is OAuth2 authentication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OAuth2Credentials implements SdkPojo, Serializable,
        ToCopyableBuilder<OAuth2Credentials.Builder, OAuth2Credentials> {
    private static final SdkField<String> USER_MANAGED_CLIENT_APPLICATION_CLIENT_SECRET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UserManagedClientApplicationClientSecret")
            .getter(getter(OAuth2Credentials::userManagedClientApplicationClientSecret))
            .setter(setter(Builder::userManagedClientApplicationClientSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("UserManagedClientApplicationClientSecret").build()).build();

    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessToken").getter(getter(OAuth2Credentials::accessToken)).setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessToken").build()).build();

    private static final SdkField<String> REFRESH_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RefreshToken").getter(getter(OAuth2Credentials::refreshToken)).setter(setter(Builder::refreshToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshToken").build()).build();

    private static final SdkField<String> JWT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JwtToken").getter(getter(OAuth2Credentials::jwtToken)).setter(setter(Builder::jwtToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JwtToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            USER_MANAGED_CLIENT_APPLICATION_CLIENT_SECRET_FIELD, ACCESS_TOKEN_FIELD, REFRESH_TOKEN_FIELD, JWT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("UserManagedClientApplicationClientSecret", USER_MANAGED_CLIENT_APPLICATION_CLIENT_SECRET_FIELD);
                    put("AccessToken", ACCESS_TOKEN_FIELD);
                    put("RefreshToken", REFRESH_TOKEN_FIELD);
                    put("JwtToken", JWT_TOKEN_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String userManagedClientApplicationClientSecret;

    private final String accessToken;

    private final String refreshToken;

    private final String jwtToken;

    private OAuth2Credentials(BuilderImpl builder) {
        this.userManagedClientApplicationClientSecret = builder.userManagedClientApplicationClientSecret;
        this.accessToken = builder.accessToken;
        this.refreshToken = builder.refreshToken;
        this.jwtToken = builder.jwtToken;
    }

    /**
     * <p>
     * The client application client secret if the client application is user managed.
     * </p>
     * 
     * @return The client application client secret if the client application is user managed.
     */
    public final String userManagedClientApplicationClientSecret() {
        return userManagedClientApplicationClientSecret;
    }

    /**
     * <p>
     * The access token used when the authentication type is OAuth2.
     * </p>
     * 
     * @return The access token used when the authentication type is OAuth2.
     */
    public final String accessToken() {
        return accessToken;
    }

    /**
     * <p>
     * The refresh token used when the authentication type is OAuth2.
     * </p>
     * 
     * @return The refresh token used when the authentication type is OAuth2.
     */
    public final String refreshToken() {
        return refreshToken;
    }

    /**
     * <p>
     * The JSON Web Token (JWT) used when the authentication type is OAuth2.
     * </p>
     * 
     * @return The JSON Web Token (JWT) used when the authentication type is OAuth2.
     */
    public final String jwtToken() {
        return jwtToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userManagedClientApplicationClientSecret());
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(refreshToken());
        hashCode = 31 * hashCode + Objects.hashCode(jwtToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuth2Credentials)) {
            return false;
        }
        OAuth2Credentials other = (OAuth2Credentials) obj;
        return Objects.equals(userManagedClientApplicationClientSecret(), other.userManagedClientApplicationClientSecret())
                && Objects.equals(accessToken(), other.accessToken()) && Objects.equals(refreshToken(), other.refreshToken())
                && Objects.equals(jwtToken(), other.jwtToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("OAuth2Credentials")
                .add("UserManagedClientApplicationClientSecret",
                        userManagedClientApplicationClientSecret() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AccessToken", accessToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RefreshToken", refreshToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("JwtToken", jwtToken() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserManagedClientApplicationClientSecret":
            return Optional.ofNullable(clazz.cast(userManagedClientApplicationClientSecret()));
        case "AccessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        case "RefreshToken":
            return Optional.ofNullable(clazz.cast(refreshToken()));
        case "JwtToken":
            return Optional.ofNullable(clazz.cast(jwtToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OAuth2Credentials, T> g) {
        return obj -> g.apply((OAuth2Credentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OAuth2Credentials> {
        /**
         * <p>
         * The client application client secret if the client application is user managed.
         * </p>
         * 
         * @param userManagedClientApplicationClientSecret
         *        The client application client secret if the client application is user managed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userManagedClientApplicationClientSecret(String userManagedClientApplicationClientSecret);

        /**
         * <p>
         * The access token used when the authentication type is OAuth2.
         * </p>
         * 
         * @param accessToken
         *        The access token used when the authentication type is OAuth2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        /**
         * <p>
         * The refresh token used when the authentication type is OAuth2.
         * </p>
         * 
         * @param refreshToken
         *        The refresh token used when the authentication type is OAuth2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshToken(String refreshToken);

        /**
         * <p>
         * The JSON Web Token (JWT) used when the authentication type is OAuth2.
         * </p>
         * 
         * @param jwtToken
         *        The JSON Web Token (JWT) used when the authentication type is OAuth2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jwtToken(String jwtToken);
    }

    static final class BuilderImpl implements Builder {
        private String userManagedClientApplicationClientSecret;

        private String accessToken;

        private String refreshToken;

        private String jwtToken;

        private BuilderImpl() {
        }

        private BuilderImpl(OAuth2Credentials model) {
            userManagedClientApplicationClientSecret(model.userManagedClientApplicationClientSecret);
            accessToken(model.accessToken);
            refreshToken(model.refreshToken);
            jwtToken(model.jwtToken);
        }

        public final String getUserManagedClientApplicationClientSecret() {
            return userManagedClientApplicationClientSecret;
        }

        public final void setUserManagedClientApplicationClientSecret(String userManagedClientApplicationClientSecret) {
            this.userManagedClientApplicationClientSecret = userManagedClientApplicationClientSecret;
        }

        @Override
        public final Builder userManagedClientApplicationClientSecret(String userManagedClientApplicationClientSecret) {
            this.userManagedClientApplicationClientSecret = userManagedClientApplicationClientSecret;
            return this;
        }

        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final String getRefreshToken() {
            return refreshToken;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @Override
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public final String getJwtToken() {
            return jwtToken;
        }

        public final void setJwtToken(String jwtToken) {
            this.jwtToken = jwtToken;
        }

        @Override
        public final Builder jwtToken(String jwtToken) {
            this.jwtToken = jwtToken;
            return this;
        }

        @Override
        public OAuth2Credentials build() {
            return new OAuth2Credentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
