/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that describes how data is partitioned on the target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IntegrationPartition implements SdkPojo, Serializable,
        ToCopyableBuilder<IntegrationPartition.Builder, IntegrationPartition> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldName").getter(getter(IntegrationPartition::fieldName)).setter(setter(Builder::fieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldName").build()).build();

    private static final SdkField<String> FUNCTION_SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionSpec").getter(getter(IntegrationPartition::functionSpec)).setter(setter(Builder::functionSpec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionSpec").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAME_FIELD,
            FUNCTION_SPEC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("FieldName", FIELD_NAME_FIELD);
                    put("FunctionSpec", FUNCTION_SPEC_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String fieldName;

    private final String functionSpec;

    private IntegrationPartition(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.functionSpec = builder.functionSpec;
    }

    /**
     * <p>
     * The field name used to partition data on the target.
     * </p>
     * 
     * @return The field name used to partition data on the target.
     */
    public final String fieldName() {
        return fieldName;
    }

    /**
     * <p>
     * Specifies a function used to partition data on the target.
     * </p>
     * 
     * @return Specifies a function used to partition data on the target.
     */
    public final String functionSpec() {
        return functionSpec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(functionSpec());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegrationPartition)) {
            return false;
        }
        IntegrationPartition other = (IntegrationPartition) obj;
        return Objects.equals(fieldName(), other.fieldName()) && Objects.equals(functionSpec(), other.functionSpec());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IntegrationPartition").add("FieldName", fieldName()).add("FunctionSpec", functionSpec()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldName":
            return Optional.ofNullable(clazz.cast(fieldName()));
        case "FunctionSpec":
            return Optional.ofNullable(clazz.cast(functionSpec()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IntegrationPartition, T> g) {
        return obj -> g.apply((IntegrationPartition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IntegrationPartition> {
        /**
         * <p>
         * The field name used to partition data on the target.
         * </p>
         * 
         * @param fieldName
         *        The field name used to partition data on the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldName(String fieldName);

        /**
         * <p>
         * Specifies a function used to partition data on the target.
         * </p>
         * 
         * @param functionSpec
         *        Specifies a function used to partition data on the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionSpec(String functionSpec);
    }

    static final class BuilderImpl implements Builder {
        private String fieldName;

        private String functionSpec;

        private BuilderImpl() {
        }

        private BuilderImpl(IntegrationPartition model) {
            fieldName(model.fieldName);
            functionSpec(model.functionSpec);
        }

        public final String getFieldName() {
            return fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final String getFunctionSpec() {
            return functionSpec;
        }

        public final void setFunctionSpec(String functionSpec) {
            this.functionSpec = functionSpec;
        }

        @Override
        public final Builder functionSpec(String functionSpec) {
            this.functionSpec = functionSpec;
            return this;
        }

        @Override
        public IntegrationPartition build() {
            return new IntegrationPartition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
