/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for an Iceberg snapshot retention optimizer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IcebergRetentionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<IcebergRetentionConfiguration.Builder, IcebergRetentionConfiguration> {
    private static final SdkField<Integer> SNAPSHOT_RETENTION_PERIOD_IN_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("snapshotRetentionPeriodInDays")
            .getter(getter(IcebergRetentionConfiguration::snapshotRetentionPeriodInDays))
            .setter(setter(Builder::snapshotRetentionPeriodInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotRetentionPeriodInDays")
                    .build()).build();

    private static final SdkField<Integer> NUMBER_OF_SNAPSHOTS_TO_RETAIN_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("numberOfSnapshotsToRetain")
            .getter(getter(IcebergRetentionConfiguration::numberOfSnapshotsToRetain))
            .setter(setter(Builder::numberOfSnapshotsToRetain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfSnapshotsToRetain").build())
            .build();

    private static final SdkField<Boolean> CLEAN_EXPIRED_FILES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("cleanExpiredFiles").getter(getter(IcebergRetentionConfiguration::cleanExpiredFiles))
            .setter(setter(Builder::cleanExpiredFiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cleanExpiredFiles").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SNAPSHOT_RETENTION_PERIOD_IN_DAYS_FIELD, NUMBER_OF_SNAPSHOTS_TO_RETAIN_FIELD, CLEAN_EXPIRED_FILES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("snapshotRetentionPeriodInDays", SNAPSHOT_RETENTION_PERIOD_IN_DAYS_FIELD);
                    put("numberOfSnapshotsToRetain", NUMBER_OF_SNAPSHOTS_TO_RETAIN_FIELD);
                    put("cleanExpiredFiles", CLEAN_EXPIRED_FILES_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer snapshotRetentionPeriodInDays;

    private final Integer numberOfSnapshotsToRetain;

    private final Boolean cleanExpiredFiles;

    private IcebergRetentionConfiguration(BuilderImpl builder) {
        this.snapshotRetentionPeriodInDays = builder.snapshotRetentionPeriodInDays;
        this.numberOfSnapshotsToRetain = builder.numberOfSnapshotsToRetain;
        this.cleanExpiredFiles = builder.cleanExpiredFiles;
    }

    /**
     * <p>
     * The number of days to retain the Iceberg snapshots. If an input is not provided, the corresponding Iceberg table
     * configuration field will be used or if not present, the default value 5 will be used.
     * </p>
     * 
     * @return The number of days to retain the Iceberg snapshots. If an input is not provided, the corresponding
     *         Iceberg table configuration field will be used or if not present, the default value 5 will be used.
     */
    public final Integer snapshotRetentionPeriodInDays() {
        return snapshotRetentionPeriodInDays;
    }

    /**
     * <p>
     * The number of Iceberg snapshots to retain within the retention period. If an input is not provided, the
     * corresponding Iceberg table configuration field will be used or if not present, the default value 1 will be used.
     * </p>
     * 
     * @return The number of Iceberg snapshots to retain within the retention period. If an input is not provided, the
     *         corresponding Iceberg table configuration field will be used or if not present, the default value 1 will
     *         be used.
     */
    public final Integer numberOfSnapshotsToRetain() {
        return numberOfSnapshotsToRetain;
    }

    /**
     * <p>
     * If set to false, snapshots are only deleted from table metadata, and the underlying data and metadata files are
     * not deleted.
     * </p>
     * 
     * @return If set to false, snapshots are only deleted from table metadata, and the underlying data and metadata
     *         files are not deleted.
     */
    public final Boolean cleanExpiredFiles() {
        return cleanExpiredFiles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snapshotRetentionPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfSnapshotsToRetain());
        hashCode = 31 * hashCode + Objects.hashCode(cleanExpiredFiles());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergRetentionConfiguration)) {
            return false;
        }
        IcebergRetentionConfiguration other = (IcebergRetentionConfiguration) obj;
        return Objects.equals(snapshotRetentionPeriodInDays(), other.snapshotRetentionPeriodInDays())
                && Objects.equals(numberOfSnapshotsToRetain(), other.numberOfSnapshotsToRetain())
                && Objects.equals(cleanExpiredFiles(), other.cleanExpiredFiles());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IcebergRetentionConfiguration")
                .add("SnapshotRetentionPeriodInDays", snapshotRetentionPeriodInDays())
                .add("NumberOfSnapshotsToRetain", numberOfSnapshotsToRetain()).add("CleanExpiredFiles", cleanExpiredFiles())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "snapshotRetentionPeriodInDays":
            return Optional.ofNullable(clazz.cast(snapshotRetentionPeriodInDays()));
        case "numberOfSnapshotsToRetain":
            return Optional.ofNullable(clazz.cast(numberOfSnapshotsToRetain()));
        case "cleanExpiredFiles":
            return Optional.ofNullable(clazz.cast(cleanExpiredFiles()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IcebergRetentionConfiguration, T> g) {
        return obj -> g.apply((IcebergRetentionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IcebergRetentionConfiguration> {
        /**
         * <p>
         * The number of days to retain the Iceberg snapshots. If an input is not provided, the corresponding Iceberg
         * table configuration field will be used or if not present, the default value 5 will be used.
         * </p>
         * 
         * @param snapshotRetentionPeriodInDays
         *        The number of days to retain the Iceberg snapshots. If an input is not provided, the corresponding
         *        Iceberg table configuration field will be used or if not present, the default value 5 will be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotRetentionPeriodInDays(Integer snapshotRetentionPeriodInDays);

        /**
         * <p>
         * The number of Iceberg snapshots to retain within the retention period. If an input is not provided, the
         * corresponding Iceberg table configuration field will be used or if not present, the default value 1 will be
         * used.
         * </p>
         * 
         * @param numberOfSnapshotsToRetain
         *        The number of Iceberg snapshots to retain within the retention period. If an input is not provided,
         *        the corresponding Iceberg table configuration field will be used or if not present, the default value
         *        1 will be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfSnapshotsToRetain(Integer numberOfSnapshotsToRetain);

        /**
         * <p>
         * If set to false, snapshots are only deleted from table metadata, and the underlying data and metadata files
         * are not deleted.
         * </p>
         * 
         * @param cleanExpiredFiles
         *        If set to false, snapshots are only deleted from table metadata, and the underlying data and metadata
         *        files are not deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cleanExpiredFiles(Boolean cleanExpiredFiles);
    }

    static final class BuilderImpl implements Builder {
        private Integer snapshotRetentionPeriodInDays;

        private Integer numberOfSnapshotsToRetain;

        private Boolean cleanExpiredFiles;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergRetentionConfiguration model) {
            snapshotRetentionPeriodInDays(model.snapshotRetentionPeriodInDays);
            numberOfSnapshotsToRetain(model.numberOfSnapshotsToRetain);
            cleanExpiredFiles(model.cleanExpiredFiles);
        }

        public final Integer getSnapshotRetentionPeriodInDays() {
            return snapshotRetentionPeriodInDays;
        }

        public final void setSnapshotRetentionPeriodInDays(Integer snapshotRetentionPeriodInDays) {
            this.snapshotRetentionPeriodInDays = snapshotRetentionPeriodInDays;
        }

        @Override
        public final Builder snapshotRetentionPeriodInDays(Integer snapshotRetentionPeriodInDays) {
            this.snapshotRetentionPeriodInDays = snapshotRetentionPeriodInDays;
            return this;
        }

        public final Integer getNumberOfSnapshotsToRetain() {
            return numberOfSnapshotsToRetain;
        }

        public final void setNumberOfSnapshotsToRetain(Integer numberOfSnapshotsToRetain) {
            this.numberOfSnapshotsToRetain = numberOfSnapshotsToRetain;
        }

        @Override
        public final Builder numberOfSnapshotsToRetain(Integer numberOfSnapshotsToRetain) {
            this.numberOfSnapshotsToRetain = numberOfSnapshotsToRetain;
            return this;
        }

        public final Boolean getCleanExpiredFiles() {
            return cleanExpiredFiles;
        }

        public final void setCleanExpiredFiles(Boolean cleanExpiredFiles) {
            this.cleanExpiredFiles = cleanExpiredFiles;
        }

        @Override
        public final Builder cleanExpiredFiles(Boolean cleanExpiredFiles) {
            this.cleanExpiredFiles = cleanExpiredFiles;
            return this;
        }

        @Override
        public IcebergRetentionConfiguration build() {
            return new IcebergRetentionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
