/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUserDefinedFunctionsResponse extends GlueResponse implements
        ToCopyableBuilder<GetUserDefinedFunctionsResponse.Builder, GetUserDefinedFunctionsResponse> {
    private static final SdkField<List<UserDefinedFunction>> USER_DEFINED_FUNCTIONS_FIELD = SdkField
            .<List<UserDefinedFunction>> builder(MarshallingType.LIST)
            .memberName("UserDefinedFunctions")
            .getter(getter(GetUserDefinedFunctionsResponse::userDefinedFunctions))
            .setter(setter(Builder::userDefinedFunctions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserDefinedFunctions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserDefinedFunction> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserDefinedFunction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetUserDefinedFunctionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_DEFINED_FUNCTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("UserDefinedFunctions", USER_DEFINED_FUNCTIONS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<UserDefinedFunction> userDefinedFunctions;

    private final String nextToken;

    private GetUserDefinedFunctionsResponse(BuilderImpl builder) {
        super(builder);
        this.userDefinedFunctions = builder.userDefinedFunctions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserDefinedFunctions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserDefinedFunctions() {
        return userDefinedFunctions != null && !(userDefinedFunctions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of requested function definitions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserDefinedFunctions} method.
     * </p>
     * 
     * @return A list of requested function definitions.
     */
    public final List<UserDefinedFunction> userDefinedFunctions() {
        return userDefinedFunctions;
    }

    /**
     * <p>
     * A continuation token, if the list of functions returned does not include the last requested function.
     * </p>
     * 
     * @return A continuation token, if the list of functions returned does not include the last requested function.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUserDefinedFunctions() ? userDefinedFunctions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUserDefinedFunctionsResponse)) {
            return false;
        }
        GetUserDefinedFunctionsResponse other = (GetUserDefinedFunctionsResponse) obj;
        return hasUserDefinedFunctions() == other.hasUserDefinedFunctions()
                && Objects.equals(userDefinedFunctions(), other.userDefinedFunctions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetUserDefinedFunctionsResponse")
                .add("UserDefinedFunctions", hasUserDefinedFunctions() ? userDefinedFunctions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserDefinedFunctions":
            return Optional.ofNullable(clazz.cast(userDefinedFunctions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetUserDefinedFunctionsResponse, T> g) {
        return obj -> g.apply((GetUserDefinedFunctionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetUserDefinedFunctionsResponse> {
        /**
         * <p>
         * A list of requested function definitions.
         * </p>
         * 
         * @param userDefinedFunctions
         *        A list of requested function definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userDefinedFunctions(Collection<UserDefinedFunction> userDefinedFunctions);

        /**
         * <p>
         * A list of requested function definitions.
         * </p>
         * 
         * @param userDefinedFunctions
         *        A list of requested function definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userDefinedFunctions(UserDefinedFunction... userDefinedFunctions);

        /**
         * <p>
         * A list of requested function definitions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.UserDefinedFunction.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.glue.model.UserDefinedFunction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.UserDefinedFunction.Builder#build()} is called immediately
         * and its result is passed to {@link #userDefinedFunctions(List<UserDefinedFunction>)}.
         * 
         * @param userDefinedFunctions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.UserDefinedFunction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userDefinedFunctions(java.util.Collection<UserDefinedFunction>)
         */
        Builder userDefinedFunctions(Consumer<UserDefinedFunction.Builder>... userDefinedFunctions);

        /**
         * <p>
         * A continuation token, if the list of functions returned does not include the last requested function.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if the list of functions returned does not include the last requested function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<UserDefinedFunction> userDefinedFunctions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUserDefinedFunctionsResponse model) {
            super(model);
            userDefinedFunctions(model.userDefinedFunctions);
            nextToken(model.nextToken);
        }

        public final List<UserDefinedFunction.Builder> getUserDefinedFunctions() {
            List<UserDefinedFunction.Builder> result = UserDefinedFunctionListCopier.copyToBuilder(this.userDefinedFunctions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserDefinedFunctions(Collection<UserDefinedFunction.BuilderImpl> userDefinedFunctions) {
            this.userDefinedFunctions = UserDefinedFunctionListCopier.copyFromBuilder(userDefinedFunctions);
        }

        @Override
        public final Builder userDefinedFunctions(Collection<UserDefinedFunction> userDefinedFunctions) {
            this.userDefinedFunctions = UserDefinedFunctionListCopier.copy(userDefinedFunctions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userDefinedFunctions(UserDefinedFunction... userDefinedFunctions) {
            userDefinedFunctions(Arrays.asList(userDefinedFunctions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userDefinedFunctions(Consumer<UserDefinedFunction.Builder>... userDefinedFunctions) {
            userDefinedFunctions(Stream.of(userDefinedFunctions).map(c -> UserDefinedFunction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetUserDefinedFunctionsResponse build() {
            return new GetUserDefinedFunctionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
