/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCatalogsRequest extends GlueRequest implements
        ToCopyableBuilder<GetCatalogsRequest.Builder, GetCatalogsRequest> {
    private static final SdkField<String> PARENT_CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentCatalogId").getter(getter(GetCatalogsRequest::parentCatalogId))
            .setter(setter(Builder::parentCatalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentCatalogId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetCatalogsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetCatalogsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<Boolean> RECURSIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Recursive").getter(getter(GetCatalogsRequest::recursive)).setter(setter(Builder::recursive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recursive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARENT_CATALOG_ID_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, RECURSIVE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ParentCatalogId", PARENT_CATALOG_ID_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                    put("MaxResults", MAX_RESULTS_FIELD);
                    put("Recursive", RECURSIVE_FIELD);
                }
            });

    private final String parentCatalogId;

    private final String nextToken;

    private final Integer maxResults;

    private final Boolean recursive;

    private GetCatalogsRequest(BuilderImpl builder) {
        super(builder);
        this.parentCatalogId = builder.parentCatalogId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.recursive = builder.recursive;
    }

    /**
     * <p>
     * The ID of the parent catalog in which the catalog resides. If none is provided, the Amazon Web Services Account
     * Number is used by default.
     * </p>
     * 
     * @return The ID of the parent catalog in which the catalog resides. If none is provided, the Amazon Web Services
     *         Account Number is used by default.
     */
    public final String parentCatalogId() {
        return parentCatalogId;
    }

    /**
     * <p>
     * A continuation token, if this is a continuation call.
     * </p>
     * 
     * @return A continuation token, if this is a continuation call.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of catalogs to return in one response.
     * </p>
     * 
     * @return The maximum number of catalogs to return in one response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * When specified as true, iterates through the account and returns all catalog resources (including top-level
     * resources and child resources)
     * </p>
     * 
     * @return When specified as true, iterates through the account and returns all catalog resources (including
     *         top-level resources and child resources)
     */
    public final Boolean recursive() {
        return recursive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(parentCatalogId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(recursive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCatalogsRequest)) {
            return false;
        }
        GetCatalogsRequest other = (GetCatalogsRequest) obj;
        return Objects.equals(parentCatalogId(), other.parentCatalogId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(recursive(), other.recursive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCatalogsRequest").add("ParentCatalogId", parentCatalogId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("Recursive", recursive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParentCatalogId":
            return Optional.ofNullable(clazz.cast(parentCatalogId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Recursive":
            return Optional.ofNullable(clazz.cast(recursive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetCatalogsRequest, T> g) {
        return obj -> g.apply((GetCatalogsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetCatalogsRequest> {
        /**
         * <p>
         * The ID of the parent catalog in which the catalog resides. If none is provided, the Amazon Web Services
         * Account Number is used by default.
         * </p>
         * 
         * @param parentCatalogId
         *        The ID of the parent catalog in which the catalog resides. If none is provided, the Amazon Web
         *        Services Account Number is used by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentCatalogId(String parentCatalogId);

        /**
         * <p>
         * A continuation token, if this is a continuation call.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if this is a continuation call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of catalogs to return in one response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of catalogs to return in one response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * When specified as true, iterates through the account and returns all catalog resources (including top-level
         * resources and child resources)
         * </p>
         * 
         * @param recursive
         *        When specified as true, iterates through the account and returns all catalog resources (including
         *        top-level resources and child resources)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recursive(Boolean recursive);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String parentCatalogId;

        private String nextToken;

        private Integer maxResults;

        private Boolean recursive;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCatalogsRequest model) {
            super(model);
            parentCatalogId(model.parentCatalogId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            recursive(model.recursive);
        }

        public final String getParentCatalogId() {
            return parentCatalogId;
        }

        public final void setParentCatalogId(String parentCatalogId) {
            this.parentCatalogId = parentCatalogId;
        }

        @Override
        public final Builder parentCatalogId(String parentCatalogId) {
            this.parentCatalogId = parentCatalogId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Boolean getRecursive() {
            return recursive;
        }

        public final void setRecursive(Boolean recursive) {
            this.recursive = recursive;
        }

        @Override
        public final Builder recursive(Boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCatalogsRequest build() {
            return new GetCatalogsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
