/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies configuration properties for an exporting labels task run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportLabelsTaskRunProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportLabelsTaskRunProperties.Builder, ExportLabelsTaskRunProperties> {
    private static final SdkField<String> OUTPUT_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputS3Path").getter(getter(ExportLabelsTaskRunProperties::outputS3Path))
            .setter(setter(Builder::outputS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputS3Path").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_S3_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("OutputS3Path", OUTPUT_S3_PATH_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String outputS3Path;

    private ExportLabelsTaskRunProperties(BuilderImpl builder) {
        this.outputS3Path = builder.outputS3Path;
    }

    /**
     * <p>
     * The Amazon Simple Storage Service (Amazon S3) path where you will export the labels.
     * </p>
     * 
     * @return The Amazon Simple Storage Service (Amazon S3) path where you will export the labels.
     */
    public final String outputS3Path() {
        return outputS3Path;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputS3Path());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportLabelsTaskRunProperties)) {
            return false;
        }
        ExportLabelsTaskRunProperties other = (ExportLabelsTaskRunProperties) obj;
        return Objects.equals(outputS3Path(), other.outputS3Path());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportLabelsTaskRunProperties").add("OutputS3Path", outputS3Path()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutputS3Path":
            return Optional.ofNullable(clazz.cast(outputS3Path()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ExportLabelsTaskRunProperties, T> g) {
        return obj -> g.apply((ExportLabelsTaskRunProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportLabelsTaskRunProperties> {
        /**
         * <p>
         * The Amazon Simple Storage Service (Amazon S3) path where you will export the labels.
         * </p>
         * 
         * @param outputS3Path
         *        The Amazon Simple Storage Service (Amazon S3) path where you will export the labels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3Path(String outputS3Path);
    }

    static final class BuilderImpl implements Builder {
        private String outputS3Path;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportLabelsTaskRunProperties model) {
            outputS3Path(model.outputS3Path);
        }

        public final String getOutputS3Path() {
            return outputS3Path;
        }

        public final void setOutputS3Path(String outputS3Path) {
            this.outputS3Path = outputS3Path;
        }

        @Override
        public final Builder outputS3Path(String outputS3Path) {
            this.outputS3Path = outputS3Path;
            return this;
        }

        @Override
        public ExportLabelsTaskRunProperties build() {
            return new ExportLabelsTaskRunProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
