/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Custom libraries to be loaded into a development endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DevEndpointCustomLibraries implements SdkPojo, Serializable,
        ToCopyableBuilder<DevEndpointCustomLibraries.Builder, DevEndpointCustomLibraries> {
    private static final SdkField<String> EXTRA_PYTHON_LIBS_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExtraPythonLibsS3Path").getter(getter(DevEndpointCustomLibraries::extraPythonLibsS3Path))
            .setter(setter(Builder::extraPythonLibsS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtraPythonLibsS3Path").build())
            .build();

    private static final SdkField<String> EXTRA_JARS_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExtraJarsS3Path").getter(getter(DevEndpointCustomLibraries::extraJarsS3Path))
            .setter(setter(Builder::extraJarsS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtraJarsS3Path").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EXTRA_PYTHON_LIBS_S3_PATH_FIELD, EXTRA_JARS_S3_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ExtraPythonLibsS3Path", EXTRA_PYTHON_LIBS_S3_PATH_FIELD);
                    put("ExtraJarsS3Path", EXTRA_JARS_S3_PATH_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String extraPythonLibsS3Path;

    private final String extraJarsS3Path;

    private DevEndpointCustomLibraries(BuilderImpl builder) {
        this.extraPythonLibsS3Path = builder.extraPythonLibsS3Path;
        this.extraJarsS3Path = builder.extraJarsS3Path;
    }

    /**
     * <p>
     * The paths to one or more Python libraries in an Amazon Simple Storage Service (Amazon S3) bucket that should be
     * loaded in your <code>DevEndpoint</code>. Multiple values must be complete paths separated by a comma.
     * </p>
     * <note>
     * <p>
     * You can only use pure Python libraries with a <code>DevEndpoint</code>. Libraries that rely on C extensions, such
     * as the <a href="http://pandas.pydata.org/">pandas</a> Python data analysis library, are not currently supported.
     * </p>
     * </note>
     * 
     * @return The paths to one or more Python libraries in an Amazon Simple Storage Service (Amazon S3) bucket that
     *         should be loaded in your <code>DevEndpoint</code>. Multiple values must be complete paths separated by a
     *         comma.</p> <note>
     *         <p>
     *         You can only use pure Python libraries with a <code>DevEndpoint</code>. Libraries that rely on C
     *         extensions, such as the <a href="http://pandas.pydata.org/">pandas</a> Python data analysis library, are
     *         not currently supported.
     *         </p>
     */
    public final String extraPythonLibsS3Path() {
        return extraPythonLibsS3Path;
    }

    /**
     * <p>
     * The path to one or more Java <code>.jar</code> files in an S3 bucket that should be loaded in your
     * <code>DevEndpoint</code>.
     * </p>
     * <note>
     * <p>
     * You can only use pure Java/Scala libraries with a <code>DevEndpoint</code>.
     * </p>
     * </note>
     * 
     * @return The path to one or more Java <code>.jar</code> files in an S3 bucket that should be loaded in your
     *         <code>DevEndpoint</code>.</p> <note>
     *         <p>
     *         You can only use pure Java/Scala libraries with a <code>DevEndpoint</code>.
     *         </p>
     */
    public final String extraJarsS3Path() {
        return extraJarsS3Path;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(extraPythonLibsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(extraJarsS3Path());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DevEndpointCustomLibraries)) {
            return false;
        }
        DevEndpointCustomLibraries other = (DevEndpointCustomLibraries) obj;
        return Objects.equals(extraPythonLibsS3Path(), other.extraPythonLibsS3Path())
                && Objects.equals(extraJarsS3Path(), other.extraJarsS3Path());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DevEndpointCustomLibraries").add("ExtraPythonLibsS3Path", extraPythonLibsS3Path())
                .add("ExtraJarsS3Path", extraJarsS3Path()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExtraPythonLibsS3Path":
            return Optional.ofNullable(clazz.cast(extraPythonLibsS3Path()));
        case "ExtraJarsS3Path":
            return Optional.ofNullable(clazz.cast(extraJarsS3Path()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DevEndpointCustomLibraries, T> g) {
        return obj -> g.apply((DevEndpointCustomLibraries) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DevEndpointCustomLibraries> {
        /**
         * <p>
         * The paths to one or more Python libraries in an Amazon Simple Storage Service (Amazon S3) bucket that should
         * be loaded in your <code>DevEndpoint</code>. Multiple values must be complete paths separated by a comma.
         * </p>
         * <note>
         * <p>
         * You can only use pure Python libraries with a <code>DevEndpoint</code>. Libraries that rely on C extensions,
         * such as the <a href="http://pandas.pydata.org/">pandas</a> Python data analysis library, are not currently
         * supported.
         * </p>
         * </note>
         * 
         * @param extraPythonLibsS3Path
         *        The paths to one or more Python libraries in an Amazon Simple Storage Service (Amazon S3) bucket that
         *        should be loaded in your <code>DevEndpoint</code>. Multiple values must be complete paths separated by
         *        a comma.</p> <note>
         *        <p>
         *        You can only use pure Python libraries with a <code>DevEndpoint</code>. Libraries that rely on C
         *        extensions, such as the <a href="http://pandas.pydata.org/">pandas</a> Python data analysis library,
         *        are not currently supported.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraPythonLibsS3Path(String extraPythonLibsS3Path);

        /**
         * <p>
         * The path to one or more Java <code>.jar</code> files in an S3 bucket that should be loaded in your
         * <code>DevEndpoint</code>.
         * </p>
         * <note>
         * <p>
         * You can only use pure Java/Scala libraries with a <code>DevEndpoint</code>.
         * </p>
         * </note>
         * 
         * @param extraJarsS3Path
         *        The path to one or more Java <code>.jar</code> files in an S3 bucket that should be loaded in your
         *        <code>DevEndpoint</code>.</p> <note>
         *        <p>
         *        You can only use pure Java/Scala libraries with a <code>DevEndpoint</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraJarsS3Path(String extraJarsS3Path);
    }

    static final class BuilderImpl implements Builder {
        private String extraPythonLibsS3Path;

        private String extraJarsS3Path;

        private BuilderImpl() {
        }

        private BuilderImpl(DevEndpointCustomLibraries model) {
            extraPythonLibsS3Path(model.extraPythonLibsS3Path);
            extraJarsS3Path(model.extraJarsS3Path);
        }

        public final String getExtraPythonLibsS3Path() {
            return extraPythonLibsS3Path;
        }

        public final void setExtraPythonLibsS3Path(String extraPythonLibsS3Path) {
            this.extraPythonLibsS3Path = extraPythonLibsS3Path;
        }

        @Override
        public final Builder extraPythonLibsS3Path(String extraPythonLibsS3Path) {
            this.extraPythonLibsS3Path = extraPythonLibsS3Path;
            return this;
        }

        public final String getExtraJarsS3Path() {
            return extraJarsS3Path;
        }

        public final void setExtraJarsS3Path(String extraJarsS3Path) {
            this.extraJarsS3Path = extraJarsS3Path;
        }

        @Override
        public final Builder extraJarsS3Path(String extraJarsS3Path) {
            this.extraJarsS3Path = extraJarsS3Path;
            return this;
        }

        @Override
        public DevEndpointCustomLibraries build() {
            return new DevEndpointCustomLibraries(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
