/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeIntegrationsResponse extends GlueResponse implements
        ToCopyableBuilder<DescribeIntegrationsResponse.Builder, DescribeIntegrationsResponse> {
    private static final SdkField<List<Integration>> INTEGRATIONS_FIELD = SdkField
            .<List<Integration>> builder(MarshallingType.LIST)
            .memberName("Integrations")
            .getter(getter(DescribeIntegrationsResponse::integrations))
            .setter(setter(Builder::integrations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Integrations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integration> builder(MarshallingType.SDK_POJO)
                                            .constructor(Integration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeIntegrationsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATIONS_FIELD,
            MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Integrations", INTEGRATIONS_FIELD);
                    put("Marker", MARKER_FIELD);
                }
            });

    private final List<Integration> integrations;

    private final String marker;

    private DescribeIntegrationsResponse(BuilderImpl builder) {
        super(builder);
        this.integrations = builder.integrations;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the Integrations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIntegrations() {
        return integrations != null && !(integrations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of zero-ETL integrations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIntegrations} method.
     * </p>
     * 
     * @return A list of zero-ETL integrations.
     */
    public final List<Integration> integrations() {
        return integrations;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of response records in a subsequent request.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIntegrations() ? integrations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIntegrationsResponse)) {
            return false;
        }
        DescribeIntegrationsResponse other = (DescribeIntegrationsResponse) obj;
        return hasIntegrations() == other.hasIntegrations() && Objects.equals(integrations(), other.integrations())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeIntegrationsResponse").add("Integrations", hasIntegrations() ? integrations() : null)
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Integrations":
            return Optional.ofNullable(clazz.cast(integrations()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIntegrationsResponse, T> g) {
        return obj -> g.apply((DescribeIntegrationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeIntegrationsResponse> {
        /**
         * <p>
         * A list of zero-ETL integrations.
         * </p>
         * 
         * @param integrations
         *        A list of zero-ETL integrations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrations(Collection<Integration> integrations);

        /**
         * <p>
         * A list of zero-ETL integrations.
         * </p>
         * 
         * @param integrations
         *        A list of zero-ETL integrations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrations(Integration... integrations);

        /**
         * <p>
         * A list of zero-ETL integrations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.Integration.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.Integration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.Integration.Builder#build()} is called immediately and its
         * result is passed to {@link #integrations(List<Integration>)}.
         * 
         * @param integrations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.Integration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integrations(java.util.Collection<Integration>)
         */
        Builder integrations(Consumer<Integration.Builder>... integrations);

        /**
         * <p>
         * A value that indicates the starting point for the next set of response records in a subsequent request.
         * </p>
         * 
         * @param marker
         *        A value that indicates the starting point for the next set of response records in a subsequent
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<Integration> integrations = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIntegrationsResponse model) {
            super(model);
            integrations(model.integrations);
            marker(model.marker);
        }

        public final List<Integration.Builder> getIntegrations() {
            List<Integration.Builder> result = IntegrationsListCopier.copyToBuilder(this.integrations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntegrations(Collection<Integration.BuilderImpl> integrations) {
            this.integrations = IntegrationsListCopier.copyFromBuilder(integrations);
        }

        @Override
        public final Builder integrations(Collection<Integration> integrations) {
            this.integrations = IntegrationsListCopier.copy(integrations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrations(Integration... integrations) {
            integrations(Arrays.asList(integrations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrations(Consumer<Integration.Builder>... integrations) {
            integrations(Stream.of(integrations).map(c -> Integration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeIntegrationsResponse build() {
            return new DescribeIntegrationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
