/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeIntegrationsRequest extends GlueRequest implements
        ToCopyableBuilder<DescribeIntegrationsRequest.Builder, DescribeIntegrationsRequest> {
    private static final SdkField<String> INTEGRATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationIdentifier").getter(getter(DescribeIntegrationsRequest::integrationIdentifier))
            .setter(setter(Builder::integrationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationIdentifier").build())
            .build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeIntegrationsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeIntegrationsRequest::maxRecords)).setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<List<IntegrationFilter>> FILTERS_FIELD = SdkField
            .<List<IntegrationFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeIntegrationsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IntegrationFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(IntegrationFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_IDENTIFIER_FIELD,
            MARKER_FIELD, MAX_RECORDS_FIELD, FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("IntegrationIdentifier", INTEGRATION_IDENTIFIER_FIELD);
                    put("Marker", MARKER_FIELD);
                    put("MaxRecords", MAX_RECORDS_FIELD);
                    put("Filters", FILTERS_FIELD);
                }
            });

    private final String integrationIdentifier;

    private final String marker;

    private final Integer maxRecords;

    private final List<IntegrationFilter> filters;

    private DescribeIntegrationsRequest(BuilderImpl builder) {
        super(builder);
        this.integrationIdentifier = builder.integrationIdentifier;
        this.marker = builder.marker;
        this.maxRecords = builder.maxRecords;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the integration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the integration.
     */
    public final String integrationIdentifier() {
        return integrationIdentifier;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of response records in a subsequent request.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The total number of items to return in the output.
     * </p>
     * 
     * @return The total number of items to return in the output.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key and values, to filter down the results. Supported keys are "Status", "IntegrationName", and
     * "SourceArn". IntegrationName is limited to only one value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return A list of key and values, to filter down the results. Supported keys are "Status", "IntegrationName", and
     *         "SourceArn". IntegrationName is limited to only one value.
     */
    public final List<IntegrationFilter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(integrationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIntegrationsRequest)) {
            return false;
        }
        DescribeIntegrationsRequest other = (DescribeIntegrationsRequest) obj;
        return Objects.equals(integrationIdentifier(), other.integrationIdentifier()) && Objects.equals(marker(), other.marker())
                && Objects.equals(maxRecords(), other.maxRecords()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeIntegrationsRequest").add("IntegrationIdentifier", integrationIdentifier())
                .add("Marker", marker()).add("MaxRecords", maxRecords()).add("Filters", hasFilters() ? filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IntegrationIdentifier":
            return Optional.ofNullable(clazz.cast(integrationIdentifier()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIntegrationsRequest, T> g) {
        return obj -> g.apply((DescribeIntegrationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeIntegrationsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the integration.
         * </p>
         * 
         * @param integrationIdentifier
         *        The Amazon Resource Name (ARN) for the integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationIdentifier(String integrationIdentifier);

        /**
         * <p>
         * A value that indicates the starting point for the next set of response records in a subsequent request.
         * </p>
         * 
         * @param marker
         *        A value that indicates the starting point for the next set of response records in a subsequent
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The total number of items to return in the output.
         * </p>
         * 
         * @param maxRecords
         *        The total number of items to return in the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * A list of key and values, to filter down the results. Supported keys are "Status", "IntegrationName", and
         * "SourceArn". IntegrationName is limited to only one value.
         * </p>
         * 
         * @param filters
         *        A list of key and values, to filter down the results. Supported keys are "Status", "IntegrationName",
         *        and "SourceArn". IntegrationName is limited to only one value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<IntegrationFilter> filters);

        /**
         * <p>
         * A list of key and values, to filter down the results. Supported keys are "Status", "IntegrationName", and
         * "SourceArn". IntegrationName is limited to only one value.
         * </p>
         * 
         * @param filters
         *        A list of key and values, to filter down the results. Supported keys are "Status", "IntegrationName",
         *        and "SourceArn". IntegrationName is limited to only one value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(IntegrationFilter... filters);

        /**
         * <p>
         * A list of key and values, to filter down the results. Supported keys are "Status", "IntegrationName", and
         * "SourceArn". IntegrationName is limited to only one value.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.IntegrationFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.IntegrationFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.IntegrationFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #filters(List<IntegrationFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.IntegrationFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<IntegrationFilter>)
         */
        Builder filters(Consumer<IntegrationFilter.Builder>... filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String integrationIdentifier;

        private String marker;

        private Integer maxRecords;

        private List<IntegrationFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIntegrationsRequest model) {
            super(model);
            integrationIdentifier(model.integrationIdentifier);
            marker(model.marker);
            maxRecords(model.maxRecords);
            filters(model.filters);
        }

        public final String getIntegrationIdentifier() {
            return integrationIdentifier;
        }

        public final void setIntegrationIdentifier(String integrationIdentifier) {
            this.integrationIdentifier = integrationIdentifier;
        }

        @Override
        public final Builder integrationIdentifier(String integrationIdentifier) {
            this.integrationIdentifier = integrationIdentifier;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final List<IntegrationFilter.Builder> getFilters() {
            List<IntegrationFilter.Builder> result = IntegrationFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<IntegrationFilter.BuilderImpl> filters) {
            this.filters = IntegrationFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<IntegrationFilter> filters) {
            this.filters = IntegrationFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(IntegrationFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<IntegrationFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> IntegrationFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeIntegrationsRequest build() {
            return new DescribeIntegrationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
