/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the supported authentication types returned by the <code>DescribeConnectionType</code> API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Capabilities implements SdkPojo, Serializable, ToCopyableBuilder<Capabilities.Builder, Capabilities> {
    private static final SdkField<List<String>> SUPPORTED_AUTHENTICATION_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedAuthenticationTypes")
            .getter(getter(Capabilities::supportedAuthenticationTypesAsStrings))
            .setter(setter(Builder::supportedAuthenticationTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedAuthenticationTypes")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_DATA_OPERATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedDataOperations")
            .getter(getter(Capabilities::supportedDataOperationsAsStrings))
            .setter(setter(Builder::supportedDataOperationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedDataOperations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_COMPUTE_ENVIRONMENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedComputeEnvironments")
            .getter(getter(Capabilities::supportedComputeEnvironmentsAsStrings))
            .setter(setter(Builder::supportedComputeEnvironmentsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedComputeEnvironments")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SUPPORTED_AUTHENTICATION_TYPES_FIELD, SUPPORTED_DATA_OPERATIONS_FIELD, SUPPORTED_COMPUTE_ENVIRONMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("SupportedAuthenticationTypes", SUPPORTED_AUTHENTICATION_TYPES_FIELD);
                    put("SupportedDataOperations", SUPPORTED_DATA_OPERATIONS_FIELD);
                    put("SupportedComputeEnvironments", SUPPORTED_COMPUTE_ENVIRONMENTS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<String> supportedAuthenticationTypes;

    private final List<String> supportedDataOperations;

    private final List<String> supportedComputeEnvironments;

    private Capabilities(BuilderImpl builder) {
        this.supportedAuthenticationTypes = builder.supportedAuthenticationTypes;
        this.supportedDataOperations = builder.supportedDataOperations;
        this.supportedComputeEnvironments = builder.supportedComputeEnvironments;
    }

    /**
     * <p>
     * A list of supported authentication types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedAuthenticationTypes} method.
     * </p>
     * 
     * @return A list of supported authentication types.
     */
    public final List<AuthenticationType> supportedAuthenticationTypes() {
        return AuthenticationTypesCopier.copyStringToEnum(supportedAuthenticationTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedAuthenticationTypes property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedAuthenticationTypes() {
        return supportedAuthenticationTypes != null && !(supportedAuthenticationTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of supported authentication types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedAuthenticationTypes} method.
     * </p>
     * 
     * @return A list of supported authentication types.
     */
    public final List<String> supportedAuthenticationTypesAsStrings() {
        return supportedAuthenticationTypes;
    }

    /**
     * <p>
     * A list of supported data operations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedDataOperations} method.
     * </p>
     * 
     * @return A list of supported data operations.
     */
    public final List<DataOperation> supportedDataOperations() {
        return DataOperationsCopier.copyStringToEnum(supportedDataOperations);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedDataOperations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedDataOperations() {
        return supportedDataOperations != null && !(supportedDataOperations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of supported data operations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedDataOperations} method.
     * </p>
     * 
     * @return A list of supported data operations.
     */
    public final List<String> supportedDataOperationsAsStrings() {
        return supportedDataOperations;
    }

    /**
     * <p>
     * A list of supported compute environments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedComputeEnvironments} method.
     * </p>
     * 
     * @return A list of supported compute environments.
     */
    public final List<ComputeEnvironment> supportedComputeEnvironments() {
        return ComputeEnvironmentsCopier.copyStringToEnum(supportedComputeEnvironments);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedComputeEnvironments property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedComputeEnvironments() {
        return supportedComputeEnvironments != null && !(supportedComputeEnvironments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of supported compute environments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedComputeEnvironments} method.
     * </p>
     * 
     * @return A list of supported compute environments.
     */
    public final List<String> supportedComputeEnvironmentsAsStrings() {
        return supportedComputeEnvironments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSupportedAuthenticationTypes() ? supportedAuthenticationTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedDataOperations() ? supportedDataOperationsAsStrings() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSupportedComputeEnvironments() ? supportedComputeEnvironmentsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Capabilities)) {
            return false;
        }
        Capabilities other = (Capabilities) obj;
        return hasSupportedAuthenticationTypes() == other.hasSupportedAuthenticationTypes()
                && Objects.equals(supportedAuthenticationTypesAsStrings(), other.supportedAuthenticationTypesAsStrings())
                && hasSupportedDataOperations() == other.hasSupportedDataOperations()
                && Objects.equals(supportedDataOperationsAsStrings(), other.supportedDataOperationsAsStrings())
                && hasSupportedComputeEnvironments() == other.hasSupportedComputeEnvironments()
                && Objects.equals(supportedComputeEnvironmentsAsStrings(), other.supportedComputeEnvironmentsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("Capabilities")
                .add("SupportedAuthenticationTypes",
                        hasSupportedAuthenticationTypes() ? supportedAuthenticationTypesAsStrings() : null)
                .add("SupportedDataOperations", hasSupportedDataOperations() ? supportedDataOperationsAsStrings() : null)
                .add("SupportedComputeEnvironments",
                        hasSupportedComputeEnvironments() ? supportedComputeEnvironmentsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SupportedAuthenticationTypes":
            return Optional.ofNullable(clazz.cast(supportedAuthenticationTypesAsStrings()));
        case "SupportedDataOperations":
            return Optional.ofNullable(clazz.cast(supportedDataOperationsAsStrings()));
        case "SupportedComputeEnvironments":
            return Optional.ofNullable(clazz.cast(supportedComputeEnvironmentsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Capabilities, T> g) {
        return obj -> g.apply((Capabilities) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Capabilities> {
        /**
         * <p>
         * A list of supported authentication types.
         * </p>
         * 
         * @param supportedAuthenticationTypes
         *        A list of supported authentication types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedAuthenticationTypesWithStrings(Collection<String> supportedAuthenticationTypes);

        /**
         * <p>
         * A list of supported authentication types.
         * </p>
         * 
         * @param supportedAuthenticationTypes
         *        A list of supported authentication types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedAuthenticationTypesWithStrings(String... supportedAuthenticationTypes);

        /**
         * <p>
         * A list of supported authentication types.
         * </p>
         * 
         * @param supportedAuthenticationTypes
         *        A list of supported authentication types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedAuthenticationTypes(Collection<AuthenticationType> supportedAuthenticationTypes);

        /**
         * <p>
         * A list of supported authentication types.
         * </p>
         * 
         * @param supportedAuthenticationTypes
         *        A list of supported authentication types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedAuthenticationTypes(AuthenticationType... supportedAuthenticationTypes);

        /**
         * <p>
         * A list of supported data operations.
         * </p>
         * 
         * @param supportedDataOperations
         *        A list of supported data operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDataOperationsWithStrings(Collection<String> supportedDataOperations);

        /**
         * <p>
         * A list of supported data operations.
         * </p>
         * 
         * @param supportedDataOperations
         *        A list of supported data operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDataOperationsWithStrings(String... supportedDataOperations);

        /**
         * <p>
         * A list of supported data operations.
         * </p>
         * 
         * @param supportedDataOperations
         *        A list of supported data operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDataOperations(Collection<DataOperation> supportedDataOperations);

        /**
         * <p>
         * A list of supported data operations.
         * </p>
         * 
         * @param supportedDataOperations
         *        A list of supported data operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDataOperations(DataOperation... supportedDataOperations);

        /**
         * <p>
         * A list of supported compute environments.
         * </p>
         * 
         * @param supportedComputeEnvironments
         *        A list of supported compute environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedComputeEnvironmentsWithStrings(Collection<String> supportedComputeEnvironments);

        /**
         * <p>
         * A list of supported compute environments.
         * </p>
         * 
         * @param supportedComputeEnvironments
         *        A list of supported compute environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedComputeEnvironmentsWithStrings(String... supportedComputeEnvironments);

        /**
         * <p>
         * A list of supported compute environments.
         * </p>
         * 
         * @param supportedComputeEnvironments
         *        A list of supported compute environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedComputeEnvironments(Collection<ComputeEnvironment> supportedComputeEnvironments);

        /**
         * <p>
         * A list of supported compute environments.
         * </p>
         * 
         * @param supportedComputeEnvironments
         *        A list of supported compute environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedComputeEnvironments(ComputeEnvironment... supportedComputeEnvironments);
    }

    static final class BuilderImpl implements Builder {
        private List<String> supportedAuthenticationTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedDataOperations = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedComputeEnvironments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Capabilities model) {
            supportedAuthenticationTypesWithStrings(model.supportedAuthenticationTypes);
            supportedDataOperationsWithStrings(model.supportedDataOperations);
            supportedComputeEnvironmentsWithStrings(model.supportedComputeEnvironments);
        }

        public final Collection<String> getSupportedAuthenticationTypes() {
            if (supportedAuthenticationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedAuthenticationTypes;
        }

        public final void setSupportedAuthenticationTypes(Collection<String> supportedAuthenticationTypes) {
            this.supportedAuthenticationTypes = AuthenticationTypesCopier.copy(supportedAuthenticationTypes);
        }

        @Override
        public final Builder supportedAuthenticationTypesWithStrings(Collection<String> supportedAuthenticationTypes) {
            this.supportedAuthenticationTypes = AuthenticationTypesCopier.copy(supportedAuthenticationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedAuthenticationTypesWithStrings(String... supportedAuthenticationTypes) {
            supportedAuthenticationTypesWithStrings(Arrays.asList(supportedAuthenticationTypes));
            return this;
        }

        @Override
        public final Builder supportedAuthenticationTypes(Collection<AuthenticationType> supportedAuthenticationTypes) {
            this.supportedAuthenticationTypes = AuthenticationTypesCopier.copyEnumToString(supportedAuthenticationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedAuthenticationTypes(AuthenticationType... supportedAuthenticationTypes) {
            supportedAuthenticationTypes(Arrays.asList(supportedAuthenticationTypes));
            return this;
        }

        public final Collection<String> getSupportedDataOperations() {
            if (supportedDataOperations instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedDataOperations;
        }

        public final void setSupportedDataOperations(Collection<String> supportedDataOperations) {
            this.supportedDataOperations = DataOperationsCopier.copy(supportedDataOperations);
        }

        @Override
        public final Builder supportedDataOperationsWithStrings(Collection<String> supportedDataOperations) {
            this.supportedDataOperations = DataOperationsCopier.copy(supportedDataOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDataOperationsWithStrings(String... supportedDataOperations) {
            supportedDataOperationsWithStrings(Arrays.asList(supportedDataOperations));
            return this;
        }

        @Override
        public final Builder supportedDataOperations(Collection<DataOperation> supportedDataOperations) {
            this.supportedDataOperations = DataOperationsCopier.copyEnumToString(supportedDataOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDataOperations(DataOperation... supportedDataOperations) {
            supportedDataOperations(Arrays.asList(supportedDataOperations));
            return this;
        }

        public final Collection<String> getSupportedComputeEnvironments() {
            if (supportedComputeEnvironments instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedComputeEnvironments;
        }

        public final void setSupportedComputeEnvironments(Collection<String> supportedComputeEnvironments) {
            this.supportedComputeEnvironments = ComputeEnvironmentsCopier.copy(supportedComputeEnvironments);
        }

        @Override
        public final Builder supportedComputeEnvironmentsWithStrings(Collection<String> supportedComputeEnvironments) {
            this.supportedComputeEnvironments = ComputeEnvironmentsCopier.copy(supportedComputeEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedComputeEnvironmentsWithStrings(String... supportedComputeEnvironments) {
            supportedComputeEnvironmentsWithStrings(Arrays.asList(supportedComputeEnvironments));
            return this;
        }

        @Override
        public final Builder supportedComputeEnvironments(Collection<ComputeEnvironment> supportedComputeEnvironments) {
            this.supportedComputeEnvironments = ComputeEnvironmentsCopier.copyEnumToString(supportedComputeEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedComputeEnvironments(ComputeEnvironment... supportedComputeEnvironments) {
            supportedComputeEnvironments(Arrays.asList(supportedComputeEnvironments));
            return this;
        }

        @Override
        public Capabilities build() {
            return new Capabilities(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
