/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetDevEndpointsResponse extends GlueResponse implements
        ToCopyableBuilder<BatchGetDevEndpointsResponse.Builder, BatchGetDevEndpointsResponse> {
    private static final SdkField<List<DevEndpoint>> DEV_ENDPOINTS_FIELD = SdkField
            .<List<DevEndpoint>> builder(MarshallingType.LIST)
            .memberName("DevEndpoints")
            .getter(getter(BatchGetDevEndpointsResponse::devEndpoints))
            .setter(setter(Builder::devEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DevEndpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DevEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(DevEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DEV_ENDPOINTS_NOT_FOUND_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DevEndpointsNotFound")
            .getter(getter(BatchGetDevEndpointsResponse::devEndpointsNotFound))
            .setter(setter(Builder::devEndpointsNotFound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DevEndpointsNotFound").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEV_ENDPOINTS_FIELD,
            DEV_ENDPOINTS_NOT_FOUND_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DevEndpoints", DEV_ENDPOINTS_FIELD);
                    put("DevEndpointsNotFound", DEV_ENDPOINTS_NOT_FOUND_FIELD);
                }
            });

    private final List<DevEndpoint> devEndpoints;

    private final List<String> devEndpointsNotFound;

    private BatchGetDevEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.devEndpoints = builder.devEndpoints;
        this.devEndpointsNotFound = builder.devEndpointsNotFound;
    }

    /**
     * For responses, this returns true if the service returned a value for the DevEndpoints property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDevEndpoints() {
        return devEndpoints != null && !(devEndpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DevEndpoint</code> definitions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDevEndpoints} method.
     * </p>
     * 
     * @return A list of <code>DevEndpoint</code> definitions.
     */
    public final List<DevEndpoint> devEndpoints() {
        return devEndpoints;
    }

    /**
     * For responses, this returns true if the service returned a value for the DevEndpointsNotFound property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDevEndpointsNotFound() {
        return devEndpointsNotFound != null && !(devEndpointsNotFound instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DevEndpoints</code> not found.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDevEndpointsNotFound} method.
     * </p>
     * 
     * @return A list of <code>DevEndpoints</code> not found.
     */
    public final List<String> devEndpointsNotFound() {
        return devEndpointsNotFound;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDevEndpoints() ? devEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDevEndpointsNotFound() ? devEndpointsNotFound() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDevEndpointsResponse)) {
            return false;
        }
        BatchGetDevEndpointsResponse other = (BatchGetDevEndpointsResponse) obj;
        return hasDevEndpoints() == other.hasDevEndpoints() && Objects.equals(devEndpoints(), other.devEndpoints())
                && hasDevEndpointsNotFound() == other.hasDevEndpointsNotFound()
                && Objects.equals(devEndpointsNotFound(), other.devEndpointsNotFound());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetDevEndpointsResponse").add("DevEndpoints", hasDevEndpoints() ? devEndpoints() : null)
                .add("DevEndpointsNotFound", hasDevEndpointsNotFound() ? devEndpointsNotFound() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DevEndpoints":
            return Optional.ofNullable(clazz.cast(devEndpoints()));
        case "DevEndpointsNotFound":
            return Optional.ofNullable(clazz.cast(devEndpointsNotFound()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetDevEndpointsResponse, T> g) {
        return obj -> g.apply((BatchGetDevEndpointsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetDevEndpointsResponse> {
        /**
         * <p>
         * A list of <code>DevEndpoint</code> definitions.
         * </p>
         * 
         * @param devEndpoints
         *        A list of <code>DevEndpoint</code> definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devEndpoints(Collection<DevEndpoint> devEndpoints);

        /**
         * <p>
         * A list of <code>DevEndpoint</code> definitions.
         * </p>
         * 
         * @param devEndpoints
         *        A list of <code>DevEndpoint</code> definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devEndpoints(DevEndpoint... devEndpoints);

        /**
         * <p>
         * A list of <code>DevEndpoint</code> definitions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.DevEndpoint.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.DevEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.DevEndpoint.Builder#build()} is called immediately and its
         * result is passed to {@link #devEndpoints(List<DevEndpoint>)}.
         * 
         * @param devEndpoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.DevEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #devEndpoints(java.util.Collection<DevEndpoint>)
         */
        Builder devEndpoints(Consumer<DevEndpoint.Builder>... devEndpoints);

        /**
         * <p>
         * A list of <code>DevEndpoints</code> not found.
         * </p>
         * 
         * @param devEndpointsNotFound
         *        A list of <code>DevEndpoints</code> not found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devEndpointsNotFound(Collection<String> devEndpointsNotFound);

        /**
         * <p>
         * A list of <code>DevEndpoints</code> not found.
         * </p>
         * 
         * @param devEndpointsNotFound
         *        A list of <code>DevEndpoints</code> not found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devEndpointsNotFound(String... devEndpointsNotFound);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<DevEndpoint> devEndpoints = DefaultSdkAutoConstructList.getInstance();

        private List<String> devEndpointsNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDevEndpointsResponse model) {
            super(model);
            devEndpoints(model.devEndpoints);
            devEndpointsNotFound(model.devEndpointsNotFound);
        }

        public final List<DevEndpoint.Builder> getDevEndpoints() {
            List<DevEndpoint.Builder> result = DevEndpointListCopier.copyToBuilder(this.devEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDevEndpoints(Collection<DevEndpoint.BuilderImpl> devEndpoints) {
            this.devEndpoints = DevEndpointListCopier.copyFromBuilder(devEndpoints);
        }

        @Override
        public final Builder devEndpoints(Collection<DevEndpoint> devEndpoints) {
            this.devEndpoints = DevEndpointListCopier.copy(devEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devEndpoints(DevEndpoint... devEndpoints) {
            devEndpoints(Arrays.asList(devEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devEndpoints(Consumer<DevEndpoint.Builder>... devEndpoints) {
            devEndpoints(Stream.of(devEndpoints).map(c -> DevEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getDevEndpointsNotFound() {
            if (devEndpointsNotFound instanceof SdkAutoConstructList) {
                return null;
            }
            return devEndpointsNotFound;
        }

        public final void setDevEndpointsNotFound(Collection<String> devEndpointsNotFound) {
            this.devEndpointsNotFound = DevEndpointNamesCopier.copy(devEndpointsNotFound);
        }

        @Override
        public final Builder devEndpointsNotFound(Collection<String> devEndpointsNotFound) {
            this.devEndpointsNotFound = DevEndpointNamesCopier.copy(devEndpointsNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devEndpointsNotFound(String... devEndpointsNotFound) {
            devEndpointsNotFound(Arrays.asList(devEndpointsNotFound));
            return this;
        }

        @Override
        public BatchGetDevEndpointsResponse build() {
            return new BatchGetDevEndpointsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
