/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies an Amazon Redshift node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AmazonRedshiftNodeData implements SdkPojo, Serializable,
        ToCopyableBuilder<AmazonRedshiftNodeData.Builder, AmazonRedshiftNodeData> {
    private static final SdkField<String> ACCESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessType").getter(getter(AmazonRedshiftNodeData::accessType)).setter(setter(Builder::accessType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessType").build()).build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(AmazonRedshiftNodeData::sourceType)).setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final SdkField<Option> CONNECTION_FIELD = SdkField.<Option> builder(MarshallingType.SDK_POJO)
            .memberName("Connection").getter(getter(AmazonRedshiftNodeData::connection)).setter(setter(Builder::connection))
            .constructor(Option::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connection").build()).build();

    private static final SdkField<Option> SCHEMA_FIELD = SdkField.<Option> builder(MarshallingType.SDK_POJO).memberName("Schema")
            .getter(getter(AmazonRedshiftNodeData::schema)).setter(setter(Builder::schema)).constructor(Option::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()).build();

    private static final SdkField<Option> TABLE_FIELD = SdkField.<Option> builder(MarshallingType.SDK_POJO).memberName("Table")
            .getter(getter(AmazonRedshiftNodeData::table)).setter(setter(Builder::table)).constructor(Option::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()).build();

    private static final SdkField<Option> CATALOG_DATABASE_FIELD = SdkField.<Option> builder(MarshallingType.SDK_POJO)
            .memberName("CatalogDatabase").getter(getter(AmazonRedshiftNodeData::catalogDatabase))
            .setter(setter(Builder::catalogDatabase)).constructor(Option::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogDatabase").build()).build();

    private static final SdkField<Option> CATALOG_TABLE_FIELD = SdkField.<Option> builder(MarshallingType.SDK_POJO)
            .memberName("CatalogTable").getter(getter(AmazonRedshiftNodeData::catalogTable))
            .setter(setter(Builder::catalogTable)).constructor(Option::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogTable").build()).build();

    private static final SdkField<String> CATALOG_REDSHIFT_SCHEMA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogRedshiftSchema").getter(getter(AmazonRedshiftNodeData::catalogRedshiftSchema))
            .setter(setter(Builder::catalogRedshiftSchema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogRedshiftSchema").build())
            .build();

    private static final SdkField<String> CATALOG_REDSHIFT_TABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogRedshiftTable").getter(getter(AmazonRedshiftNodeData::catalogRedshiftTable))
            .setter(setter(Builder::catalogRedshiftTable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogRedshiftTable").build())
            .build();

    private static final SdkField<String> TEMP_DIR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TempDir").getter(getter(AmazonRedshiftNodeData::tempDir)).setter(setter(Builder::tempDir))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TempDir").build()).build();

    private static final SdkField<Option> IAM_ROLE_FIELD = SdkField.<Option> builder(MarshallingType.SDK_POJO)
            .memberName("IamRole").getter(getter(AmazonRedshiftNodeData::iamRole)).setter(setter(Builder::iamRole))
            .constructor(Option::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRole").build()).build();

    private static final SdkField<List<AmazonRedshiftAdvancedOption>> ADVANCED_OPTIONS_FIELD = SdkField
            .<List<AmazonRedshiftAdvancedOption>> builder(MarshallingType.LIST)
            .memberName("AdvancedOptions")
            .getter(getter(AmazonRedshiftNodeData::advancedOptions))
            .setter(setter(Builder::advancedOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AmazonRedshiftAdvancedOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(AmazonRedshiftAdvancedOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SAMPLE_QUERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SampleQuery").getter(getter(AmazonRedshiftNodeData::sampleQuery)).setter(setter(Builder::sampleQuery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleQuery").build()).build();

    private static final SdkField<String> PRE_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreAction").getter(getter(AmazonRedshiftNodeData::preAction)).setter(setter(Builder::preAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreAction").build()).build();

    private static final SdkField<String> POST_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PostAction").getter(getter(AmazonRedshiftNodeData::postAction)).setter(setter(Builder::postAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostAction").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(AmazonRedshiftNodeData::action)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> TABLE_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TablePrefix").getter(getter(AmazonRedshiftNodeData::tablePrefix)).setter(setter(Builder::tablePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablePrefix").build()).build();

    private static final SdkField<Boolean> UPSERT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Upsert").getter(getter(AmazonRedshiftNodeData::upsert)).setter(setter(Builder::upsert))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Upsert").build()).build();

    private static final SdkField<String> MERGE_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MergeAction").getter(getter(AmazonRedshiftNodeData::mergeAction)).setter(setter(Builder::mergeAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MergeAction").build()).build();

    private static final SdkField<String> MERGE_WHEN_MATCHED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MergeWhenMatched").getter(getter(AmazonRedshiftNodeData::mergeWhenMatched))
            .setter(setter(Builder::mergeWhenMatched))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MergeWhenMatched").build()).build();

    private static final SdkField<String> MERGE_WHEN_NOT_MATCHED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MergeWhenNotMatched").getter(getter(AmazonRedshiftNodeData::mergeWhenNotMatched))
            .setter(setter(Builder::mergeWhenNotMatched))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MergeWhenNotMatched").build())
            .build();

    private static final SdkField<String> MERGE_CLAUSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MergeClause").getter(getter(AmazonRedshiftNodeData::mergeClause)).setter(setter(Builder::mergeClause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MergeClause").build()).build();

    private static final SdkField<String> CRAWLER_CONNECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CrawlerConnection").getter(getter(AmazonRedshiftNodeData::crawlerConnection))
            .setter(setter(Builder::crawlerConnection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlerConnection").build()).build();

    private static final SdkField<List<Option>> TABLE_SCHEMA_FIELD = SdkField
            .<List<Option>> builder(MarshallingType.LIST)
            .memberName("TableSchema")
            .getter(getter(AmazonRedshiftNodeData::tableSchema))
            .setter(setter(Builder::tableSchema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableSchema").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Option> builder(MarshallingType.SDK_POJO)
                                            .constructor(Option::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STAGING_TABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StagingTable").getter(getter(AmazonRedshiftNodeData::stagingTable))
            .setter(setter(Builder::stagingTable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StagingTable").build()).build();

    private static final SdkField<List<Option>> SELECTED_COLUMNS_FIELD = SdkField
            .<List<Option>> builder(MarshallingType.LIST)
            .memberName("SelectedColumns")
            .getter(getter(AmazonRedshiftNodeData::selectedColumns))
            .setter(setter(Builder::selectedColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Option> builder(MarshallingType.SDK_POJO)
                                            .constructor(Option::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TYPE_FIELD,
            SOURCE_TYPE_FIELD, CONNECTION_FIELD, SCHEMA_FIELD, TABLE_FIELD, CATALOG_DATABASE_FIELD, CATALOG_TABLE_FIELD,
            CATALOG_REDSHIFT_SCHEMA_FIELD, CATALOG_REDSHIFT_TABLE_FIELD, TEMP_DIR_FIELD, IAM_ROLE_FIELD, ADVANCED_OPTIONS_FIELD,
            SAMPLE_QUERY_FIELD, PRE_ACTION_FIELD, POST_ACTION_FIELD, ACTION_FIELD, TABLE_PREFIX_FIELD, UPSERT_FIELD,
            MERGE_ACTION_FIELD, MERGE_WHEN_MATCHED_FIELD, MERGE_WHEN_NOT_MATCHED_FIELD, MERGE_CLAUSE_FIELD,
            CRAWLER_CONNECTION_FIELD, TABLE_SCHEMA_FIELD, STAGING_TABLE_FIELD, SELECTED_COLUMNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("AccessType", ACCESS_TYPE_FIELD);
                    put("SourceType", SOURCE_TYPE_FIELD);
                    put("Connection", CONNECTION_FIELD);
                    put("Schema", SCHEMA_FIELD);
                    put("Table", TABLE_FIELD);
                    put("CatalogDatabase", CATALOG_DATABASE_FIELD);
                    put("CatalogTable", CATALOG_TABLE_FIELD);
                    put("CatalogRedshiftSchema", CATALOG_REDSHIFT_SCHEMA_FIELD);
                    put("CatalogRedshiftTable", CATALOG_REDSHIFT_TABLE_FIELD);
                    put("TempDir", TEMP_DIR_FIELD);
                    put("IamRole", IAM_ROLE_FIELD);
                    put("AdvancedOptions", ADVANCED_OPTIONS_FIELD);
                    put("SampleQuery", SAMPLE_QUERY_FIELD);
                    put("PreAction", PRE_ACTION_FIELD);
                    put("PostAction", POST_ACTION_FIELD);
                    put("Action", ACTION_FIELD);
                    put("TablePrefix", TABLE_PREFIX_FIELD);
                    put("Upsert", UPSERT_FIELD);
                    put("MergeAction", MERGE_ACTION_FIELD);
                    put("MergeWhenMatched", MERGE_WHEN_MATCHED_FIELD);
                    put("MergeWhenNotMatched", MERGE_WHEN_NOT_MATCHED_FIELD);
                    put("MergeClause", MERGE_CLAUSE_FIELD);
                    put("CrawlerConnection", CRAWLER_CONNECTION_FIELD);
                    put("TableSchema", TABLE_SCHEMA_FIELD);
                    put("StagingTable", STAGING_TABLE_FIELD);
                    put("SelectedColumns", SELECTED_COLUMNS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String accessType;

    private final String sourceType;

    private final Option connection;

    private final Option schema;

    private final Option table;

    private final Option catalogDatabase;

    private final Option catalogTable;

    private final String catalogRedshiftSchema;

    private final String catalogRedshiftTable;

    private final String tempDir;

    private final Option iamRole;

    private final List<AmazonRedshiftAdvancedOption> advancedOptions;

    private final String sampleQuery;

    private final String preAction;

    private final String postAction;

    private final String action;

    private final String tablePrefix;

    private final Boolean upsert;

    private final String mergeAction;

    private final String mergeWhenMatched;

    private final String mergeWhenNotMatched;

    private final String mergeClause;

    private final String crawlerConnection;

    private final List<Option> tableSchema;

    private final String stagingTable;

    private final List<Option> selectedColumns;

    private AmazonRedshiftNodeData(BuilderImpl builder) {
        this.accessType = builder.accessType;
        this.sourceType = builder.sourceType;
        this.connection = builder.connection;
        this.schema = builder.schema;
        this.table = builder.table;
        this.catalogDatabase = builder.catalogDatabase;
        this.catalogTable = builder.catalogTable;
        this.catalogRedshiftSchema = builder.catalogRedshiftSchema;
        this.catalogRedshiftTable = builder.catalogRedshiftTable;
        this.tempDir = builder.tempDir;
        this.iamRole = builder.iamRole;
        this.advancedOptions = builder.advancedOptions;
        this.sampleQuery = builder.sampleQuery;
        this.preAction = builder.preAction;
        this.postAction = builder.postAction;
        this.action = builder.action;
        this.tablePrefix = builder.tablePrefix;
        this.upsert = builder.upsert;
        this.mergeAction = builder.mergeAction;
        this.mergeWhenMatched = builder.mergeWhenMatched;
        this.mergeWhenNotMatched = builder.mergeWhenNotMatched;
        this.mergeClause = builder.mergeClause;
        this.crawlerConnection = builder.crawlerConnection;
        this.tableSchema = builder.tableSchema;
        this.stagingTable = builder.stagingTable;
        this.selectedColumns = builder.selectedColumns;
    }

    /**
     * <p>
     * The access type for the Redshift connection. Can be a direct connection or catalog connections.
     * </p>
     * 
     * @return The access type for the Redshift connection. Can be a direct connection or catalog connections.
     */
    public final String accessType() {
        return accessType;
    }

    /**
     * <p>
     * The source type to specify whether a specific table is the source or a custom query.
     * </p>
     * 
     * @return The source type to specify whether a specific table is the source or a custom query.
     */
    public final String sourceType() {
        return sourceType;
    }

    /**
     * <p>
     * The Glue connection to the Redshift cluster.
     * </p>
     * 
     * @return The Glue connection to the Redshift cluster.
     */
    public final Option connection() {
        return connection;
    }

    /**
     * <p>
     * The Redshift schema name when working with a direct connection.
     * </p>
     * 
     * @return The Redshift schema name when working with a direct connection.
     */
    public final Option schema() {
        return schema;
    }

    /**
     * <p>
     * The Redshift table name when working with a direct connection.
     * </p>
     * 
     * @return The Redshift table name when working with a direct connection.
     */
    public final Option table() {
        return table;
    }

    /**
     * <p>
     * The name of the Glue Data Catalog database when working with a data catalog.
     * </p>
     * 
     * @return The name of the Glue Data Catalog database when working with a data catalog.
     */
    public final Option catalogDatabase() {
        return catalogDatabase;
    }

    /**
     * <p>
     * The Glue Data Catalog table name when working with a data catalog.
     * </p>
     * 
     * @return The Glue Data Catalog table name when working with a data catalog.
     */
    public final Option catalogTable() {
        return catalogTable;
    }

    /**
     * <p>
     * The Redshift schema name when working with a data catalog.
     * </p>
     * 
     * @return The Redshift schema name when working with a data catalog.
     */
    public final String catalogRedshiftSchema() {
        return catalogRedshiftSchema;
    }

    /**
     * <p>
     * The database table to read from.
     * </p>
     * 
     * @return The database table to read from.
     */
    public final String catalogRedshiftTable() {
        return catalogRedshiftTable;
    }

    /**
     * <p>
     * The Amazon S3 path where temporary data can be staged when copying out of the database.
     * </p>
     * 
     * @return The Amazon S3 path where temporary data can be staged when copying out of the database.
     */
    public final String tempDir() {
        return tempDir;
    }

    /**
     * <p>
     * Optional. The role name use when connection to S3. The IAM role ill default to the role on the job when left
     * blank.
     * </p>
     * 
     * @return Optional. The role name use when connection to S3. The IAM role ill default to the role on the job when
     *         left blank.
     */
    public final Option iamRole() {
        return iamRole;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdvancedOptions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdvancedOptions() {
        return advancedOptions != null && !(advancedOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional values when connecting to the Redshift cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdvancedOptions} method.
     * </p>
     * 
     * @return Optional values when connecting to the Redshift cluster.
     */
    public final List<AmazonRedshiftAdvancedOption> advancedOptions() {
        return advancedOptions;
    }

    /**
     * <p>
     * The SQL used to fetch the data from a Redshift sources when the SourceType is 'query'.
     * </p>
     * 
     * @return The SQL used to fetch the data from a Redshift sources when the SourceType is 'query'.
     */
    public final String sampleQuery() {
        return sampleQuery;
    }

    /**
     * <p>
     * The SQL used before a MERGE or APPEND with upsert is run.
     * </p>
     * 
     * @return The SQL used before a MERGE or APPEND with upsert is run.
     */
    public final String preAction() {
        return preAction;
    }

    /**
     * <p>
     * The SQL used before a MERGE or APPEND with upsert is run.
     * </p>
     * 
     * @return The SQL used before a MERGE or APPEND with upsert is run.
     */
    public final String postAction() {
        return postAction;
    }

    /**
     * <p>
     * Specifies how writing to a Redshift cluser will occur.
     * </p>
     * 
     * @return Specifies how writing to a Redshift cluser will occur.
     */
    public final String action() {
        return action;
    }

    /**
     * <p>
     * Specifies the prefix to a table.
     * </p>
     * 
     * @return Specifies the prefix to a table.
     */
    public final String tablePrefix() {
        return tablePrefix;
    }

    /**
     * <p>
     * The action used on Redshift sinks when doing an APPEND.
     * </p>
     * 
     * @return The action used on Redshift sinks when doing an APPEND.
     */
    public final Boolean upsert() {
        return upsert;
    }

    /**
     * <p>
     * The action used when to detemine how a MERGE in a Redshift sink will be handled.
     * </p>
     * 
     * @return The action used when to detemine how a MERGE in a Redshift sink will be handled.
     */
    public final String mergeAction() {
        return mergeAction;
    }

    /**
     * <p>
     * The action used when to detemine how a MERGE in a Redshift sink will be handled when an existing record matches a
     * new record.
     * </p>
     * 
     * @return The action used when to detemine how a MERGE in a Redshift sink will be handled when an existing record
     *         matches a new record.
     */
    public final String mergeWhenMatched() {
        return mergeWhenMatched;
    }

    /**
     * <p>
     * The action used when to detemine how a MERGE in a Redshift sink will be handled when an existing record doesn't
     * match a new record.
     * </p>
     * 
     * @return The action used when to detemine how a MERGE in a Redshift sink will be handled when an existing record
     *         doesn't match a new record.
     */
    public final String mergeWhenNotMatched() {
        return mergeWhenNotMatched;
    }

    /**
     * <p>
     * The SQL used in a custom merge to deal with matching records.
     * </p>
     * 
     * @return The SQL used in a custom merge to deal with matching records.
     */
    public final String mergeClause() {
        return mergeClause;
    }

    /**
     * <p>
     * Specifies the name of the connection that is associated with the catalog table used.
     * </p>
     * 
     * @return Specifies the name of the connection that is associated with the catalog table used.
     */
    public final String crawlerConnection() {
        return crawlerConnection;
    }

    /**
     * For responses, this returns true if the service returned a value for the TableSchema property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTableSchema() {
        return tableSchema != null && !(tableSchema instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of schema output for a given node.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTableSchema} method.
     * </p>
     * 
     * @return The array of schema output for a given node.
     */
    public final List<Option> tableSchema() {
        return tableSchema;
    }

    /**
     * <p>
     * The name of the temporary staging table that is used when doing a MERGE or APPEND with upsert.
     * </p>
     * 
     * @return The name of the temporary staging table that is used when doing a MERGE or APPEND with upsert.
     */
    public final String stagingTable() {
        return stagingTable;
    }

    /**
     * For responses, this returns true if the service returned a value for the SelectedColumns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSelectedColumns() {
        return selectedColumns != null && !(selectedColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of column names used to determine a matching record when doing a MERGE or APPEND with upsert.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelectedColumns} method.
     * </p>
     * 
     * @return The list of column names used to determine a matching record when doing a MERGE or APPEND with upsert.
     */
    public final List<Option> selectedColumns() {
        return selectedColumns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessType());
        hashCode = 31 * hashCode + Objects.hashCode(sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(connection());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(table());
        hashCode = 31 * hashCode + Objects.hashCode(catalogDatabase());
        hashCode = 31 * hashCode + Objects.hashCode(catalogTable());
        hashCode = 31 * hashCode + Objects.hashCode(catalogRedshiftSchema());
        hashCode = 31 * hashCode + Objects.hashCode(catalogRedshiftTable());
        hashCode = 31 * hashCode + Objects.hashCode(tempDir());
        hashCode = 31 * hashCode + Objects.hashCode(iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdvancedOptions() ? advancedOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sampleQuery());
        hashCode = 31 * hashCode + Objects.hashCode(preAction());
        hashCode = 31 * hashCode + Objects.hashCode(postAction());
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(tablePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(upsert());
        hashCode = 31 * hashCode + Objects.hashCode(mergeAction());
        hashCode = 31 * hashCode + Objects.hashCode(mergeWhenMatched());
        hashCode = 31 * hashCode + Objects.hashCode(mergeWhenNotMatched());
        hashCode = 31 * hashCode + Objects.hashCode(mergeClause());
        hashCode = 31 * hashCode + Objects.hashCode(crawlerConnection());
        hashCode = 31 * hashCode + Objects.hashCode(hasTableSchema() ? tableSchema() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stagingTable());
        hashCode = 31 * hashCode + Objects.hashCode(hasSelectedColumns() ? selectedColumns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmazonRedshiftNodeData)) {
            return false;
        }
        AmazonRedshiftNodeData other = (AmazonRedshiftNodeData) obj;
        return Objects.equals(accessType(), other.accessType()) && Objects.equals(sourceType(), other.sourceType())
                && Objects.equals(connection(), other.connection()) && Objects.equals(schema(), other.schema())
                && Objects.equals(table(), other.table()) && Objects.equals(catalogDatabase(), other.catalogDatabase())
                && Objects.equals(catalogTable(), other.catalogTable())
                && Objects.equals(catalogRedshiftSchema(), other.catalogRedshiftSchema())
                && Objects.equals(catalogRedshiftTable(), other.catalogRedshiftTable())
                && Objects.equals(tempDir(), other.tempDir()) && Objects.equals(iamRole(), other.iamRole())
                && hasAdvancedOptions() == other.hasAdvancedOptions()
                && Objects.equals(advancedOptions(), other.advancedOptions())
                && Objects.equals(sampleQuery(), other.sampleQuery()) && Objects.equals(preAction(), other.preAction())
                && Objects.equals(postAction(), other.postAction()) && Objects.equals(action(), other.action())
                && Objects.equals(tablePrefix(), other.tablePrefix()) && Objects.equals(upsert(), other.upsert())
                && Objects.equals(mergeAction(), other.mergeAction())
                && Objects.equals(mergeWhenMatched(), other.mergeWhenMatched())
                && Objects.equals(mergeWhenNotMatched(), other.mergeWhenNotMatched())
                && Objects.equals(mergeClause(), other.mergeClause())
                && Objects.equals(crawlerConnection(), other.crawlerConnection()) && hasTableSchema() == other.hasTableSchema()
                && Objects.equals(tableSchema(), other.tableSchema()) && Objects.equals(stagingTable(), other.stagingTable())
                && hasSelectedColumns() == other.hasSelectedColumns()
                && Objects.equals(selectedColumns(), other.selectedColumns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AmazonRedshiftNodeData").add("AccessType", accessType()).add("SourceType", sourceType())
                .add("Connection", connection()).add("Schema", schema()).add("Table", table())
                .add("CatalogDatabase", catalogDatabase()).add("CatalogTable", catalogTable())
                .add("CatalogRedshiftSchema", catalogRedshiftSchema()).add("CatalogRedshiftTable", catalogRedshiftTable())
                .add("TempDir", tempDir()).add("IamRole", iamRole())
                .add("AdvancedOptions", hasAdvancedOptions() ? advancedOptions() : null).add("SampleQuery", sampleQuery())
                .add("PreAction", preAction()).add("PostAction", postAction()).add("Action", action())
                .add("TablePrefix", tablePrefix()).add("Upsert", upsert()).add("MergeAction", mergeAction())
                .add("MergeWhenMatched", mergeWhenMatched()).add("MergeWhenNotMatched", mergeWhenNotMatched())
                .add("MergeClause", mergeClause()).add("CrawlerConnection", crawlerConnection())
                .add("TableSchema", hasTableSchema() ? tableSchema() : null).add("StagingTable", stagingTable())
                .add("SelectedColumns", hasSelectedColumns() ? selectedColumns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessType":
            return Optional.ofNullable(clazz.cast(accessType()));
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceType()));
        case "Connection":
            return Optional.ofNullable(clazz.cast(connection()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "Table":
            return Optional.ofNullable(clazz.cast(table()));
        case "CatalogDatabase":
            return Optional.ofNullable(clazz.cast(catalogDatabase()));
        case "CatalogTable":
            return Optional.ofNullable(clazz.cast(catalogTable()));
        case "CatalogRedshiftSchema":
            return Optional.ofNullable(clazz.cast(catalogRedshiftSchema()));
        case "CatalogRedshiftTable":
            return Optional.ofNullable(clazz.cast(catalogRedshiftTable()));
        case "TempDir":
            return Optional.ofNullable(clazz.cast(tempDir()));
        case "IamRole":
            return Optional.ofNullable(clazz.cast(iamRole()));
        case "AdvancedOptions":
            return Optional.ofNullable(clazz.cast(advancedOptions()));
        case "SampleQuery":
            return Optional.ofNullable(clazz.cast(sampleQuery()));
        case "PreAction":
            return Optional.ofNullable(clazz.cast(preAction()));
        case "PostAction":
            return Optional.ofNullable(clazz.cast(postAction()));
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        case "TablePrefix":
            return Optional.ofNullable(clazz.cast(tablePrefix()));
        case "Upsert":
            return Optional.ofNullable(clazz.cast(upsert()));
        case "MergeAction":
            return Optional.ofNullable(clazz.cast(mergeAction()));
        case "MergeWhenMatched":
            return Optional.ofNullable(clazz.cast(mergeWhenMatched()));
        case "MergeWhenNotMatched":
            return Optional.ofNullable(clazz.cast(mergeWhenNotMatched()));
        case "MergeClause":
            return Optional.ofNullable(clazz.cast(mergeClause()));
        case "CrawlerConnection":
            return Optional.ofNullable(clazz.cast(crawlerConnection()));
        case "TableSchema":
            return Optional.ofNullable(clazz.cast(tableSchema()));
        case "StagingTable":
            return Optional.ofNullable(clazz.cast(stagingTable()));
        case "SelectedColumns":
            return Optional.ofNullable(clazz.cast(selectedColumns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AmazonRedshiftNodeData, T> g) {
        return obj -> g.apply((AmazonRedshiftNodeData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AmazonRedshiftNodeData> {
        /**
         * <p>
         * The access type for the Redshift connection. Can be a direct connection or catalog connections.
         * </p>
         * 
         * @param accessType
         *        The access type for the Redshift connection. Can be a direct connection or catalog connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessType(String accessType);

        /**
         * <p>
         * The source type to specify whether a specific table is the source or a custom query.
         * </p>
         * 
         * @param sourceType
         *        The source type to specify whether a specific table is the source or a custom query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * The Glue connection to the Redshift cluster.
         * </p>
         * 
         * @param connection
         *        The Glue connection to the Redshift cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connection(Option connection);

        /**
         * <p>
         * The Glue connection to the Redshift cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link Option.Builder} avoiding the need to
         * create one manually via {@link Option#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Option.Builder#build()} is called immediately and its result is
         * passed to {@link #connection(Option)}.
         * 
         * @param connection
         *        a consumer that will call methods on {@link Option.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connection(Option)
         */
        default Builder connection(Consumer<Option.Builder> connection) {
            return connection(Option.builder().applyMutation(connection).build());
        }

        /**
         * <p>
         * The Redshift schema name when working with a direct connection.
         * </p>
         * 
         * @param schema
         *        The Redshift schema name when working with a direct connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(Option schema);

        /**
         * <p>
         * The Redshift schema name when working with a direct connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link Option.Builder} avoiding the need to
         * create one manually via {@link Option#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Option.Builder#build()} is called immediately and its result is
         * passed to {@link #schema(Option)}.
         * 
         * @param schema
         *        a consumer that will call methods on {@link Option.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schema(Option)
         */
        default Builder schema(Consumer<Option.Builder> schema) {
            return schema(Option.builder().applyMutation(schema).build());
        }

        /**
         * <p>
         * The Redshift table name when working with a direct connection.
         * </p>
         * 
         * @param table
         *        The Redshift table name when working with a direct connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder table(Option table);

        /**
         * <p>
         * The Redshift table name when working with a direct connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link Option.Builder} avoiding the need to
         * create one manually via {@link Option#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Option.Builder#build()} is called immediately and its result is
         * passed to {@link #table(Option)}.
         * 
         * @param table
         *        a consumer that will call methods on {@link Option.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #table(Option)
         */
        default Builder table(Consumer<Option.Builder> table) {
            return table(Option.builder().applyMutation(table).build());
        }

        /**
         * <p>
         * The name of the Glue Data Catalog database when working with a data catalog.
         * </p>
         * 
         * @param catalogDatabase
         *        The name of the Glue Data Catalog database when working with a data catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogDatabase(Option catalogDatabase);

        /**
         * <p>
         * The name of the Glue Data Catalog database when working with a data catalog.
         * </p>
         * This is a convenience method that creates an instance of the {@link Option.Builder} avoiding the need to
         * create one manually via {@link Option#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Option.Builder#build()} is called immediately and its result is
         * passed to {@link #catalogDatabase(Option)}.
         * 
         * @param catalogDatabase
         *        a consumer that will call methods on {@link Option.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #catalogDatabase(Option)
         */
        default Builder catalogDatabase(Consumer<Option.Builder> catalogDatabase) {
            return catalogDatabase(Option.builder().applyMutation(catalogDatabase).build());
        }

        /**
         * <p>
         * The Glue Data Catalog table name when working with a data catalog.
         * </p>
         * 
         * @param catalogTable
         *        The Glue Data Catalog table name when working with a data catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogTable(Option catalogTable);

        /**
         * <p>
         * The Glue Data Catalog table name when working with a data catalog.
         * </p>
         * This is a convenience method that creates an instance of the {@link Option.Builder} avoiding the need to
         * create one manually via {@link Option#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Option.Builder#build()} is called immediately and its result is
         * passed to {@link #catalogTable(Option)}.
         * 
         * @param catalogTable
         *        a consumer that will call methods on {@link Option.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #catalogTable(Option)
         */
        default Builder catalogTable(Consumer<Option.Builder> catalogTable) {
            return catalogTable(Option.builder().applyMutation(catalogTable).build());
        }

        /**
         * <p>
         * The Redshift schema name when working with a data catalog.
         * </p>
         * 
         * @param catalogRedshiftSchema
         *        The Redshift schema name when working with a data catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogRedshiftSchema(String catalogRedshiftSchema);

        /**
         * <p>
         * The database table to read from.
         * </p>
         * 
         * @param catalogRedshiftTable
         *        The database table to read from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogRedshiftTable(String catalogRedshiftTable);

        /**
         * <p>
         * The Amazon S3 path where temporary data can be staged when copying out of the database.
         * </p>
         * 
         * @param tempDir
         *        The Amazon S3 path where temporary data can be staged when copying out of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tempDir(String tempDir);

        /**
         * <p>
         * Optional. The role name use when connection to S3. The IAM role ill default to the role on the job when left
         * blank.
         * </p>
         * 
         * @param iamRole
         *        Optional. The role name use when connection to S3. The IAM role ill default to the role on the job
         *        when left blank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRole(Option iamRole);

        /**
         * <p>
         * Optional. The role name use when connection to S3. The IAM role ill default to the role on the job when left
         * blank.
         * </p>
         * This is a convenience method that creates an instance of the {@link Option.Builder} avoiding the need to
         * create one manually via {@link Option#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Option.Builder#build()} is called immediately and its result is
         * passed to {@link #iamRole(Option)}.
         * 
         * @param iamRole
         *        a consumer that will call methods on {@link Option.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamRole(Option)
         */
        default Builder iamRole(Consumer<Option.Builder> iamRole) {
            return iamRole(Option.builder().applyMutation(iamRole).build());
        }

        /**
         * <p>
         * Optional values when connecting to the Redshift cluster.
         * </p>
         * 
         * @param advancedOptions
         *        Optional values when connecting to the Redshift cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedOptions(Collection<AmazonRedshiftAdvancedOption> advancedOptions);

        /**
         * <p>
         * Optional values when connecting to the Redshift cluster.
         * </p>
         * 
         * @param advancedOptions
         *        Optional values when connecting to the Redshift cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedOptions(AmazonRedshiftAdvancedOption... advancedOptions);

        /**
         * <p>
         * Optional values when connecting to the Redshift cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.AmazonRedshiftAdvancedOption.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.glue.model.AmazonRedshiftAdvancedOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.AmazonRedshiftAdvancedOption.Builder#build()} is called
         * immediately and its result is passed to {@link #advancedOptions(List<AmazonRedshiftAdvancedOption>)}.
         * 
         * @param advancedOptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.AmazonRedshiftAdvancedOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #advancedOptions(java.util.Collection<AmazonRedshiftAdvancedOption>)
         */
        Builder advancedOptions(Consumer<AmazonRedshiftAdvancedOption.Builder>... advancedOptions);

        /**
         * <p>
         * The SQL used to fetch the data from a Redshift sources when the SourceType is 'query'.
         * </p>
         * 
         * @param sampleQuery
         *        The SQL used to fetch the data from a Redshift sources when the SourceType is 'query'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleQuery(String sampleQuery);

        /**
         * <p>
         * The SQL used before a MERGE or APPEND with upsert is run.
         * </p>
         * 
         * @param preAction
         *        The SQL used before a MERGE or APPEND with upsert is run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preAction(String preAction);

        /**
         * <p>
         * The SQL used before a MERGE or APPEND with upsert is run.
         * </p>
         * 
         * @param postAction
         *        The SQL used before a MERGE or APPEND with upsert is run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postAction(String postAction);

        /**
         * <p>
         * Specifies how writing to a Redshift cluser will occur.
         * </p>
         * 
         * @param action
         *        Specifies how writing to a Redshift cluser will occur.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);

        /**
         * <p>
         * Specifies the prefix to a table.
         * </p>
         * 
         * @param tablePrefix
         *        Specifies the prefix to a table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tablePrefix(String tablePrefix);

        /**
         * <p>
         * The action used on Redshift sinks when doing an APPEND.
         * </p>
         * 
         * @param upsert
         *        The action used on Redshift sinks when doing an APPEND.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upsert(Boolean upsert);

        /**
         * <p>
         * The action used when to detemine how a MERGE in a Redshift sink will be handled.
         * </p>
         * 
         * @param mergeAction
         *        The action used when to detemine how a MERGE in a Redshift sink will be handled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergeAction(String mergeAction);

        /**
         * <p>
         * The action used when to detemine how a MERGE in a Redshift sink will be handled when an existing record
         * matches a new record.
         * </p>
         * 
         * @param mergeWhenMatched
         *        The action used when to detemine how a MERGE in a Redshift sink will be handled when an existing
         *        record matches a new record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergeWhenMatched(String mergeWhenMatched);

        /**
         * <p>
         * The action used when to detemine how a MERGE in a Redshift sink will be handled when an existing record
         * doesn't match a new record.
         * </p>
         * 
         * @param mergeWhenNotMatched
         *        The action used when to detemine how a MERGE in a Redshift sink will be handled when an existing
         *        record doesn't match a new record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergeWhenNotMatched(String mergeWhenNotMatched);

        /**
         * <p>
         * The SQL used in a custom merge to deal with matching records.
         * </p>
         * 
         * @param mergeClause
         *        The SQL used in a custom merge to deal with matching records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergeClause(String mergeClause);

        /**
         * <p>
         * Specifies the name of the connection that is associated with the catalog table used.
         * </p>
         * 
         * @param crawlerConnection
         *        Specifies the name of the connection that is associated with the catalog table used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlerConnection(String crawlerConnection);

        /**
         * <p>
         * The array of schema output for a given node.
         * </p>
         * 
         * @param tableSchema
         *        The array of schema output for a given node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableSchema(Collection<Option> tableSchema);

        /**
         * <p>
         * The array of schema output for a given node.
         * </p>
         * 
         * @param tableSchema
         *        The array of schema output for a given node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableSchema(Option... tableSchema);

        /**
         * <p>
         * The array of schema output for a given node.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.Option.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.glue.model.Option#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.Option.Builder#build()} is called immediately and its
         * result is passed to {@link #tableSchema(List<Option>)}.
         * 
         * @param tableSchema
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.glue.model.Option.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableSchema(java.util.Collection<Option>)
         */
        Builder tableSchema(Consumer<Option.Builder>... tableSchema);

        /**
         * <p>
         * The name of the temporary staging table that is used when doing a MERGE or APPEND with upsert.
         * </p>
         * 
         * @param stagingTable
         *        The name of the temporary staging table that is used when doing a MERGE or APPEND with upsert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stagingTable(String stagingTable);

        /**
         * <p>
         * The list of column names used to determine a matching record when doing a MERGE or APPEND with upsert.
         * </p>
         * 
         * @param selectedColumns
         *        The list of column names used to determine a matching record when doing a MERGE or APPEND with upsert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedColumns(Collection<Option> selectedColumns);

        /**
         * <p>
         * The list of column names used to determine a matching record when doing a MERGE or APPEND with upsert.
         * </p>
         * 
         * @param selectedColumns
         *        The list of column names used to determine a matching record when doing a MERGE or APPEND with upsert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedColumns(Option... selectedColumns);

        /**
         * <p>
         * The list of column names used to determine a matching record when doing a MERGE or APPEND with upsert.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.Option.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.glue.model.Option#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.Option.Builder#build()} is called immediately and its
         * result is passed to {@link #selectedColumns(List<Option>)}.
         * 
         * @param selectedColumns
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.glue.model.Option.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectedColumns(java.util.Collection<Option>)
         */
        Builder selectedColumns(Consumer<Option.Builder>... selectedColumns);
    }

    static final class BuilderImpl implements Builder {
        private String accessType;

        private String sourceType;

        private Option connection;

        private Option schema;

        private Option table;

        private Option catalogDatabase;

        private Option catalogTable;

        private String catalogRedshiftSchema;

        private String catalogRedshiftTable;

        private String tempDir;

        private Option iamRole;

        private List<AmazonRedshiftAdvancedOption> advancedOptions = DefaultSdkAutoConstructList.getInstance();

        private String sampleQuery;

        private String preAction;

        private String postAction;

        private String action;

        private String tablePrefix;

        private Boolean upsert;

        private String mergeAction;

        private String mergeWhenMatched;

        private String mergeWhenNotMatched;

        private String mergeClause;

        private String crawlerConnection;

        private List<Option> tableSchema = DefaultSdkAutoConstructList.getInstance();

        private String stagingTable;

        private List<Option> selectedColumns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AmazonRedshiftNodeData model) {
            accessType(model.accessType);
            sourceType(model.sourceType);
            connection(model.connection);
            schema(model.schema);
            table(model.table);
            catalogDatabase(model.catalogDatabase);
            catalogTable(model.catalogTable);
            catalogRedshiftSchema(model.catalogRedshiftSchema);
            catalogRedshiftTable(model.catalogRedshiftTable);
            tempDir(model.tempDir);
            iamRole(model.iamRole);
            advancedOptions(model.advancedOptions);
            sampleQuery(model.sampleQuery);
            preAction(model.preAction);
            postAction(model.postAction);
            action(model.action);
            tablePrefix(model.tablePrefix);
            upsert(model.upsert);
            mergeAction(model.mergeAction);
            mergeWhenMatched(model.mergeWhenMatched);
            mergeWhenNotMatched(model.mergeWhenNotMatched);
            mergeClause(model.mergeClause);
            crawlerConnection(model.crawlerConnection);
            tableSchema(model.tableSchema);
            stagingTable(model.stagingTable);
            selectedColumns(model.selectedColumns);
        }

        public final String getAccessType() {
            return accessType;
        }

        public final void setAccessType(String accessType) {
            this.accessType = accessType;
        }

        @Override
        public final Builder accessType(String accessType) {
            this.accessType = accessType;
            return this;
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final Option.Builder getConnection() {
            return connection != null ? connection.toBuilder() : null;
        }

        public final void setConnection(Option.BuilderImpl connection) {
            this.connection = connection != null ? connection.build() : null;
        }

        @Override
        public final Builder connection(Option connection) {
            this.connection = connection;
            return this;
        }

        public final Option.Builder getSchema() {
            return schema != null ? schema.toBuilder() : null;
        }

        public final void setSchema(Option.BuilderImpl schema) {
            this.schema = schema != null ? schema.build() : null;
        }

        @Override
        public final Builder schema(Option schema) {
            this.schema = schema;
            return this;
        }

        public final Option.Builder getTable() {
            return table != null ? table.toBuilder() : null;
        }

        public final void setTable(Option.BuilderImpl table) {
            this.table = table != null ? table.build() : null;
        }

        @Override
        public final Builder table(Option table) {
            this.table = table;
            return this;
        }

        public final Option.Builder getCatalogDatabase() {
            return catalogDatabase != null ? catalogDatabase.toBuilder() : null;
        }

        public final void setCatalogDatabase(Option.BuilderImpl catalogDatabase) {
            this.catalogDatabase = catalogDatabase != null ? catalogDatabase.build() : null;
        }

        @Override
        public final Builder catalogDatabase(Option catalogDatabase) {
            this.catalogDatabase = catalogDatabase;
            return this;
        }

        public final Option.Builder getCatalogTable() {
            return catalogTable != null ? catalogTable.toBuilder() : null;
        }

        public final void setCatalogTable(Option.BuilderImpl catalogTable) {
            this.catalogTable = catalogTable != null ? catalogTable.build() : null;
        }

        @Override
        public final Builder catalogTable(Option catalogTable) {
            this.catalogTable = catalogTable;
            return this;
        }

        public final String getCatalogRedshiftSchema() {
            return catalogRedshiftSchema;
        }

        public final void setCatalogRedshiftSchema(String catalogRedshiftSchema) {
            this.catalogRedshiftSchema = catalogRedshiftSchema;
        }

        @Override
        public final Builder catalogRedshiftSchema(String catalogRedshiftSchema) {
            this.catalogRedshiftSchema = catalogRedshiftSchema;
            return this;
        }

        public final String getCatalogRedshiftTable() {
            return catalogRedshiftTable;
        }

        public final void setCatalogRedshiftTable(String catalogRedshiftTable) {
            this.catalogRedshiftTable = catalogRedshiftTable;
        }

        @Override
        public final Builder catalogRedshiftTable(String catalogRedshiftTable) {
            this.catalogRedshiftTable = catalogRedshiftTable;
            return this;
        }

        public final String getTempDir() {
            return tempDir;
        }

        public final void setTempDir(String tempDir) {
            this.tempDir = tempDir;
        }

        @Override
        public final Builder tempDir(String tempDir) {
            this.tempDir = tempDir;
            return this;
        }

        public final Option.Builder getIamRole() {
            return iamRole != null ? iamRole.toBuilder() : null;
        }

        public final void setIamRole(Option.BuilderImpl iamRole) {
            this.iamRole = iamRole != null ? iamRole.build() : null;
        }

        @Override
        public final Builder iamRole(Option iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final List<AmazonRedshiftAdvancedOption.Builder> getAdvancedOptions() {
            List<AmazonRedshiftAdvancedOption.Builder> result = AmazonRedshiftAdvancedOptionsCopier
                    .copyToBuilder(this.advancedOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdvancedOptions(Collection<AmazonRedshiftAdvancedOption.BuilderImpl> advancedOptions) {
            this.advancedOptions = AmazonRedshiftAdvancedOptionsCopier.copyFromBuilder(advancedOptions);
        }

        @Override
        public final Builder advancedOptions(Collection<AmazonRedshiftAdvancedOption> advancedOptions) {
            this.advancedOptions = AmazonRedshiftAdvancedOptionsCopier.copy(advancedOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedOptions(AmazonRedshiftAdvancedOption... advancedOptions) {
            advancedOptions(Arrays.asList(advancedOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedOptions(Consumer<AmazonRedshiftAdvancedOption.Builder>... advancedOptions) {
            advancedOptions(Stream.of(advancedOptions).map(c -> AmazonRedshiftAdvancedOption.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSampleQuery() {
            return sampleQuery;
        }

        public final void setSampleQuery(String sampleQuery) {
            this.sampleQuery = sampleQuery;
        }

        @Override
        public final Builder sampleQuery(String sampleQuery) {
            this.sampleQuery = sampleQuery;
            return this;
        }

        public final String getPreAction() {
            return preAction;
        }

        public final void setPreAction(String preAction) {
            this.preAction = preAction;
        }

        @Override
        public final Builder preAction(String preAction) {
            this.preAction = preAction;
            return this;
        }

        public final String getPostAction() {
            return postAction;
        }

        public final void setPostAction(String postAction) {
            this.postAction = postAction;
        }

        @Override
        public final Builder postAction(String postAction) {
            this.postAction = postAction;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final String getTablePrefix() {
            return tablePrefix;
        }

        public final void setTablePrefix(String tablePrefix) {
            this.tablePrefix = tablePrefix;
        }

        @Override
        public final Builder tablePrefix(String tablePrefix) {
            this.tablePrefix = tablePrefix;
            return this;
        }

        public final Boolean getUpsert() {
            return upsert;
        }

        public final void setUpsert(Boolean upsert) {
            this.upsert = upsert;
        }

        @Override
        public final Builder upsert(Boolean upsert) {
            this.upsert = upsert;
            return this;
        }

        public final String getMergeAction() {
            return mergeAction;
        }

        public final void setMergeAction(String mergeAction) {
            this.mergeAction = mergeAction;
        }

        @Override
        public final Builder mergeAction(String mergeAction) {
            this.mergeAction = mergeAction;
            return this;
        }

        public final String getMergeWhenMatched() {
            return mergeWhenMatched;
        }

        public final void setMergeWhenMatched(String mergeWhenMatched) {
            this.mergeWhenMatched = mergeWhenMatched;
        }

        @Override
        public final Builder mergeWhenMatched(String mergeWhenMatched) {
            this.mergeWhenMatched = mergeWhenMatched;
            return this;
        }

        public final String getMergeWhenNotMatched() {
            return mergeWhenNotMatched;
        }

        public final void setMergeWhenNotMatched(String mergeWhenNotMatched) {
            this.mergeWhenNotMatched = mergeWhenNotMatched;
        }

        @Override
        public final Builder mergeWhenNotMatched(String mergeWhenNotMatched) {
            this.mergeWhenNotMatched = mergeWhenNotMatched;
            return this;
        }

        public final String getMergeClause() {
            return mergeClause;
        }

        public final void setMergeClause(String mergeClause) {
            this.mergeClause = mergeClause;
        }

        @Override
        public final Builder mergeClause(String mergeClause) {
            this.mergeClause = mergeClause;
            return this;
        }

        public final String getCrawlerConnection() {
            return crawlerConnection;
        }

        public final void setCrawlerConnection(String crawlerConnection) {
            this.crawlerConnection = crawlerConnection;
        }

        @Override
        public final Builder crawlerConnection(String crawlerConnection) {
            this.crawlerConnection = crawlerConnection;
            return this;
        }

        public final List<Option.Builder> getTableSchema() {
            List<Option.Builder> result = OptionListCopier.copyToBuilder(this.tableSchema);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTableSchema(Collection<Option.BuilderImpl> tableSchema) {
            this.tableSchema = OptionListCopier.copyFromBuilder(tableSchema);
        }

        @Override
        public final Builder tableSchema(Collection<Option> tableSchema) {
            this.tableSchema = OptionListCopier.copy(tableSchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableSchema(Option... tableSchema) {
            tableSchema(Arrays.asList(tableSchema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableSchema(Consumer<Option.Builder>... tableSchema) {
            tableSchema(Stream.of(tableSchema).map(c -> Option.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStagingTable() {
            return stagingTable;
        }

        public final void setStagingTable(String stagingTable) {
            this.stagingTable = stagingTable;
        }

        @Override
        public final Builder stagingTable(String stagingTable) {
            this.stagingTable = stagingTable;
            return this;
        }

        public final List<Option.Builder> getSelectedColumns() {
            List<Option.Builder> result = OptionListCopier.copyToBuilder(this.selectedColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSelectedColumns(Collection<Option.BuilderImpl> selectedColumns) {
            this.selectedColumns = OptionListCopier.copyFromBuilder(selectedColumns);
        }

        @Override
        public final Builder selectedColumns(Collection<Option> selectedColumns) {
            this.selectedColumns = OptionListCopier.copy(selectedColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedColumns(Option... selectedColumns) {
            selectedColumns(Arrays.asList(selectedColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedColumns(Consumer<Option.Builder>... selectedColumns) {
            selectedColumns(Stream.of(selectedColumns).map(c -> Option.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AmazonRedshiftNodeData build() {
            return new AmazonRedshiftNodeData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
