/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.glue.model.BatchCreatePartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchCreatePartitionResponse;
import software.amazon.awssdk.services.glue.model.BatchDeleteConnectionRequest;
import software.amazon.awssdk.services.glue.model.BatchDeleteConnectionResponse;
import software.amazon.awssdk.services.glue.model.BatchDeletePartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchDeletePartitionResponse;
import software.amazon.awssdk.services.glue.model.BatchDeleteTableRequest;
import software.amazon.awssdk.services.glue.model.BatchDeleteTableResponse;
import software.amazon.awssdk.services.glue.model.BatchDeleteTableVersionRequest;
import software.amazon.awssdk.services.glue.model.BatchDeleteTableVersionResponse;
import software.amazon.awssdk.services.glue.model.BatchGetBlueprintsRequest;
import software.amazon.awssdk.services.glue.model.BatchGetBlueprintsResponse;
import software.amazon.awssdk.services.glue.model.BatchGetCrawlersRequest;
import software.amazon.awssdk.services.glue.model.BatchGetCrawlersResponse;
import software.amazon.awssdk.services.glue.model.BatchGetCustomEntityTypesRequest;
import software.amazon.awssdk.services.glue.model.BatchGetCustomEntityTypesResponse;
import software.amazon.awssdk.services.glue.model.BatchGetDataQualityResultRequest;
import software.amazon.awssdk.services.glue.model.BatchGetDataQualityResultResponse;
import software.amazon.awssdk.services.glue.model.BatchGetDevEndpointsRequest;
import software.amazon.awssdk.services.glue.model.BatchGetDevEndpointsResponse;
import software.amazon.awssdk.services.glue.model.BatchGetJobsRequest;
import software.amazon.awssdk.services.glue.model.BatchGetJobsResponse;
import software.amazon.awssdk.services.glue.model.BatchGetPartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchGetPartitionResponse;
import software.amazon.awssdk.services.glue.model.BatchGetTableOptimizerRequest;
import software.amazon.awssdk.services.glue.model.BatchGetTableOptimizerResponse;
import software.amazon.awssdk.services.glue.model.BatchGetTriggersRequest;
import software.amazon.awssdk.services.glue.model.BatchGetTriggersResponse;
import software.amazon.awssdk.services.glue.model.BatchGetWorkflowsRequest;
import software.amazon.awssdk.services.glue.model.BatchGetWorkflowsResponse;
import software.amazon.awssdk.services.glue.model.BatchPutDataQualityStatisticAnnotationRequest;
import software.amazon.awssdk.services.glue.model.BatchPutDataQualityStatisticAnnotationResponse;
import software.amazon.awssdk.services.glue.model.BatchStopJobRunRequest;
import software.amazon.awssdk.services.glue.model.BatchStopJobRunResponse;
import software.amazon.awssdk.services.glue.model.BatchUpdatePartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchUpdatePartitionResponse;
import software.amazon.awssdk.services.glue.model.CancelDataQualityRuleRecommendationRunRequest;
import software.amazon.awssdk.services.glue.model.CancelDataQualityRuleRecommendationRunResponse;
import software.amazon.awssdk.services.glue.model.CancelDataQualityRulesetEvaluationRunRequest;
import software.amazon.awssdk.services.glue.model.CancelDataQualityRulesetEvaluationRunResponse;
import software.amazon.awssdk.services.glue.model.CancelMlTaskRunRequest;
import software.amazon.awssdk.services.glue.model.CancelMlTaskRunResponse;
import software.amazon.awssdk.services.glue.model.CancelStatementRequest;
import software.amazon.awssdk.services.glue.model.CancelStatementResponse;
import software.amazon.awssdk.services.glue.model.CheckSchemaVersionValidityRequest;
import software.amazon.awssdk.services.glue.model.CheckSchemaVersionValidityResponse;
import software.amazon.awssdk.services.glue.model.CreateBlueprintRequest;
import software.amazon.awssdk.services.glue.model.CreateBlueprintResponse;
import software.amazon.awssdk.services.glue.model.CreateCatalogRequest;
import software.amazon.awssdk.services.glue.model.CreateCatalogResponse;
import software.amazon.awssdk.services.glue.model.CreateClassifierRequest;
import software.amazon.awssdk.services.glue.model.CreateClassifierResponse;
import software.amazon.awssdk.services.glue.model.CreateColumnStatisticsTaskSettingsRequest;
import software.amazon.awssdk.services.glue.model.CreateColumnStatisticsTaskSettingsResponse;
import software.amazon.awssdk.services.glue.model.CreateConnectionRequest;
import software.amazon.awssdk.services.glue.model.CreateConnectionResponse;
import software.amazon.awssdk.services.glue.model.CreateCrawlerRequest;
import software.amazon.awssdk.services.glue.model.CreateCrawlerResponse;
import software.amazon.awssdk.services.glue.model.CreateCustomEntityTypeRequest;
import software.amazon.awssdk.services.glue.model.CreateCustomEntityTypeResponse;
import software.amazon.awssdk.services.glue.model.CreateDataQualityRulesetRequest;
import software.amazon.awssdk.services.glue.model.CreateDataQualityRulesetResponse;
import software.amazon.awssdk.services.glue.model.CreateDatabaseRequest;
import software.amazon.awssdk.services.glue.model.CreateDatabaseResponse;
import software.amazon.awssdk.services.glue.model.CreateDevEndpointRequest;
import software.amazon.awssdk.services.glue.model.CreateDevEndpointResponse;
import software.amazon.awssdk.services.glue.model.CreateIntegrationRequest;
import software.amazon.awssdk.services.glue.model.CreateIntegrationResourcePropertyRequest;
import software.amazon.awssdk.services.glue.model.CreateIntegrationResourcePropertyResponse;
import software.amazon.awssdk.services.glue.model.CreateIntegrationResponse;
import software.amazon.awssdk.services.glue.model.CreateIntegrationTablePropertiesRequest;
import software.amazon.awssdk.services.glue.model.CreateIntegrationTablePropertiesResponse;
import software.amazon.awssdk.services.glue.model.CreateJobRequest;
import software.amazon.awssdk.services.glue.model.CreateJobResponse;
import software.amazon.awssdk.services.glue.model.CreateMlTransformRequest;
import software.amazon.awssdk.services.glue.model.CreateMlTransformResponse;
import software.amazon.awssdk.services.glue.model.CreatePartitionIndexRequest;
import software.amazon.awssdk.services.glue.model.CreatePartitionIndexResponse;
import software.amazon.awssdk.services.glue.model.CreatePartitionRequest;
import software.amazon.awssdk.services.glue.model.CreatePartitionResponse;
import software.amazon.awssdk.services.glue.model.CreateRegistryRequest;
import software.amazon.awssdk.services.glue.model.CreateRegistryResponse;
import software.amazon.awssdk.services.glue.model.CreateSchemaRequest;
import software.amazon.awssdk.services.glue.model.CreateSchemaResponse;
import software.amazon.awssdk.services.glue.model.CreateScriptRequest;
import software.amazon.awssdk.services.glue.model.CreateScriptResponse;
import software.amazon.awssdk.services.glue.model.CreateSecurityConfigurationRequest;
import software.amazon.awssdk.services.glue.model.CreateSecurityConfigurationResponse;
import software.amazon.awssdk.services.glue.model.CreateSessionRequest;
import software.amazon.awssdk.services.glue.model.CreateSessionResponse;
import software.amazon.awssdk.services.glue.model.CreateTableOptimizerRequest;
import software.amazon.awssdk.services.glue.model.CreateTableOptimizerResponse;
import software.amazon.awssdk.services.glue.model.CreateTableRequest;
import software.amazon.awssdk.services.glue.model.CreateTableResponse;
import software.amazon.awssdk.services.glue.model.CreateTriggerRequest;
import software.amazon.awssdk.services.glue.model.CreateTriggerResponse;
import software.amazon.awssdk.services.glue.model.CreateUsageProfileRequest;
import software.amazon.awssdk.services.glue.model.CreateUsageProfileResponse;
import software.amazon.awssdk.services.glue.model.CreateUserDefinedFunctionRequest;
import software.amazon.awssdk.services.glue.model.CreateUserDefinedFunctionResponse;
import software.amazon.awssdk.services.glue.model.CreateWorkflowRequest;
import software.amazon.awssdk.services.glue.model.CreateWorkflowResponse;
import software.amazon.awssdk.services.glue.model.DeleteBlueprintRequest;
import software.amazon.awssdk.services.glue.model.DeleteBlueprintResponse;
import software.amazon.awssdk.services.glue.model.DeleteCatalogRequest;
import software.amazon.awssdk.services.glue.model.DeleteCatalogResponse;
import software.amazon.awssdk.services.glue.model.DeleteClassifierRequest;
import software.amazon.awssdk.services.glue.model.DeleteClassifierResponse;
import software.amazon.awssdk.services.glue.model.DeleteColumnStatisticsForPartitionRequest;
import software.amazon.awssdk.services.glue.model.DeleteColumnStatisticsForPartitionResponse;
import software.amazon.awssdk.services.glue.model.DeleteColumnStatisticsForTableRequest;
import software.amazon.awssdk.services.glue.model.DeleteColumnStatisticsForTableResponse;
import software.amazon.awssdk.services.glue.model.DeleteColumnStatisticsTaskSettingsRequest;
import software.amazon.awssdk.services.glue.model.DeleteColumnStatisticsTaskSettingsResponse;
import software.amazon.awssdk.services.glue.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.glue.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.glue.model.DeleteCrawlerRequest;
import software.amazon.awssdk.services.glue.model.DeleteCrawlerResponse;
import software.amazon.awssdk.services.glue.model.DeleteCustomEntityTypeRequest;
import software.amazon.awssdk.services.glue.model.DeleteCustomEntityTypeResponse;
import software.amazon.awssdk.services.glue.model.DeleteDataQualityRulesetRequest;
import software.amazon.awssdk.services.glue.model.DeleteDataQualityRulesetResponse;
import software.amazon.awssdk.services.glue.model.DeleteDatabaseRequest;
import software.amazon.awssdk.services.glue.model.DeleteDatabaseResponse;
import software.amazon.awssdk.services.glue.model.DeleteDevEndpointRequest;
import software.amazon.awssdk.services.glue.model.DeleteDevEndpointResponse;
import software.amazon.awssdk.services.glue.model.DeleteIntegrationRequest;
import software.amazon.awssdk.services.glue.model.DeleteIntegrationResponse;
import software.amazon.awssdk.services.glue.model.DeleteIntegrationTablePropertiesRequest;
import software.amazon.awssdk.services.glue.model.DeleteIntegrationTablePropertiesResponse;
import software.amazon.awssdk.services.glue.model.DeleteJobRequest;
import software.amazon.awssdk.services.glue.model.DeleteJobResponse;
import software.amazon.awssdk.services.glue.model.DeleteMlTransformRequest;
import software.amazon.awssdk.services.glue.model.DeleteMlTransformResponse;
import software.amazon.awssdk.services.glue.model.DeletePartitionIndexRequest;
import software.amazon.awssdk.services.glue.model.DeletePartitionIndexResponse;
import software.amazon.awssdk.services.glue.model.DeletePartitionRequest;
import software.amazon.awssdk.services.glue.model.DeletePartitionResponse;
import software.amazon.awssdk.services.glue.model.DeleteRegistryRequest;
import software.amazon.awssdk.services.glue.model.DeleteRegistryResponse;
import software.amazon.awssdk.services.glue.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.glue.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.glue.model.DeleteSchemaRequest;
import software.amazon.awssdk.services.glue.model.DeleteSchemaResponse;
import software.amazon.awssdk.services.glue.model.DeleteSchemaVersionsRequest;
import software.amazon.awssdk.services.glue.model.DeleteSchemaVersionsResponse;
import software.amazon.awssdk.services.glue.model.DeleteSecurityConfigurationRequest;
import software.amazon.awssdk.services.glue.model.DeleteSecurityConfigurationResponse;
import software.amazon.awssdk.services.glue.model.DeleteSessionRequest;
import software.amazon.awssdk.services.glue.model.DeleteSessionResponse;
import software.amazon.awssdk.services.glue.model.DeleteTableOptimizerRequest;
import software.amazon.awssdk.services.glue.model.DeleteTableOptimizerResponse;
import software.amazon.awssdk.services.glue.model.DeleteTableRequest;
import software.amazon.awssdk.services.glue.model.DeleteTableResponse;
import software.amazon.awssdk.services.glue.model.DeleteTableVersionRequest;
import software.amazon.awssdk.services.glue.model.DeleteTableVersionResponse;
import software.amazon.awssdk.services.glue.model.DeleteTriggerRequest;
import software.amazon.awssdk.services.glue.model.DeleteTriggerResponse;
import software.amazon.awssdk.services.glue.model.DeleteUsageProfileRequest;
import software.amazon.awssdk.services.glue.model.DeleteUsageProfileResponse;
import software.amazon.awssdk.services.glue.model.DeleteUserDefinedFunctionRequest;
import software.amazon.awssdk.services.glue.model.DeleteUserDefinedFunctionResponse;
import software.amazon.awssdk.services.glue.model.DeleteWorkflowRequest;
import software.amazon.awssdk.services.glue.model.DeleteWorkflowResponse;
import software.amazon.awssdk.services.glue.model.DescribeConnectionTypeRequest;
import software.amazon.awssdk.services.glue.model.DescribeConnectionTypeResponse;
import software.amazon.awssdk.services.glue.model.DescribeEntityRequest;
import software.amazon.awssdk.services.glue.model.DescribeEntityResponse;
import software.amazon.awssdk.services.glue.model.DescribeInboundIntegrationsRequest;
import software.amazon.awssdk.services.glue.model.DescribeInboundIntegrationsResponse;
import software.amazon.awssdk.services.glue.model.DescribeIntegrationsRequest;
import software.amazon.awssdk.services.glue.model.DescribeIntegrationsResponse;
import software.amazon.awssdk.services.glue.model.GetBlueprintRequest;
import software.amazon.awssdk.services.glue.model.GetBlueprintResponse;
import software.amazon.awssdk.services.glue.model.GetBlueprintRunRequest;
import software.amazon.awssdk.services.glue.model.GetBlueprintRunResponse;
import software.amazon.awssdk.services.glue.model.GetBlueprintRunsRequest;
import software.amazon.awssdk.services.glue.model.GetBlueprintRunsResponse;
import software.amazon.awssdk.services.glue.model.GetCatalogImportStatusRequest;
import software.amazon.awssdk.services.glue.model.GetCatalogImportStatusResponse;
import software.amazon.awssdk.services.glue.model.GetCatalogRequest;
import software.amazon.awssdk.services.glue.model.GetCatalogResponse;
import software.amazon.awssdk.services.glue.model.GetCatalogsRequest;
import software.amazon.awssdk.services.glue.model.GetCatalogsResponse;
import software.amazon.awssdk.services.glue.model.GetClassifierRequest;
import software.amazon.awssdk.services.glue.model.GetClassifierResponse;
import software.amazon.awssdk.services.glue.model.GetClassifiersRequest;
import software.amazon.awssdk.services.glue.model.GetClassifiersResponse;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsForPartitionRequest;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsForPartitionResponse;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsForTableRequest;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsForTableResponse;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsTaskRunRequest;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsTaskRunResponse;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsTaskRunsRequest;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsTaskRunsResponse;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsTaskSettingsRequest;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsTaskSettingsResponse;
import software.amazon.awssdk.services.glue.model.GetConnectionRequest;
import software.amazon.awssdk.services.glue.model.GetConnectionResponse;
import software.amazon.awssdk.services.glue.model.GetConnectionsRequest;
import software.amazon.awssdk.services.glue.model.GetConnectionsResponse;
import software.amazon.awssdk.services.glue.model.GetCrawlerMetricsRequest;
import software.amazon.awssdk.services.glue.model.GetCrawlerMetricsResponse;
import software.amazon.awssdk.services.glue.model.GetCrawlerRequest;
import software.amazon.awssdk.services.glue.model.GetCrawlerResponse;
import software.amazon.awssdk.services.glue.model.GetCrawlersRequest;
import software.amazon.awssdk.services.glue.model.GetCrawlersResponse;
import software.amazon.awssdk.services.glue.model.GetCustomEntityTypeRequest;
import software.amazon.awssdk.services.glue.model.GetCustomEntityTypeResponse;
import software.amazon.awssdk.services.glue.model.GetDataCatalogEncryptionSettingsRequest;
import software.amazon.awssdk.services.glue.model.GetDataCatalogEncryptionSettingsResponse;
import software.amazon.awssdk.services.glue.model.GetDataQualityModelRequest;
import software.amazon.awssdk.services.glue.model.GetDataQualityModelResponse;
import software.amazon.awssdk.services.glue.model.GetDataQualityModelResultRequest;
import software.amazon.awssdk.services.glue.model.GetDataQualityModelResultResponse;
import software.amazon.awssdk.services.glue.model.GetDataQualityResultRequest;
import software.amazon.awssdk.services.glue.model.GetDataQualityResultResponse;
import software.amazon.awssdk.services.glue.model.GetDataQualityRuleRecommendationRunRequest;
import software.amazon.awssdk.services.glue.model.GetDataQualityRuleRecommendationRunResponse;
import software.amazon.awssdk.services.glue.model.GetDataQualityRulesetEvaluationRunRequest;
import software.amazon.awssdk.services.glue.model.GetDataQualityRulesetEvaluationRunResponse;
import software.amazon.awssdk.services.glue.model.GetDataQualityRulesetRequest;
import software.amazon.awssdk.services.glue.model.GetDataQualityRulesetResponse;
import software.amazon.awssdk.services.glue.model.GetDatabaseRequest;
import software.amazon.awssdk.services.glue.model.GetDatabaseResponse;
import software.amazon.awssdk.services.glue.model.GetDatabasesRequest;
import software.amazon.awssdk.services.glue.model.GetDatabasesResponse;
import software.amazon.awssdk.services.glue.model.GetDataflowGraphRequest;
import software.amazon.awssdk.services.glue.model.GetDataflowGraphResponse;
import software.amazon.awssdk.services.glue.model.GetDevEndpointRequest;
import software.amazon.awssdk.services.glue.model.GetDevEndpointResponse;
import software.amazon.awssdk.services.glue.model.GetDevEndpointsRequest;
import software.amazon.awssdk.services.glue.model.GetDevEndpointsResponse;
import software.amazon.awssdk.services.glue.model.GetEntityRecordsRequest;
import software.amazon.awssdk.services.glue.model.GetEntityRecordsResponse;
import software.amazon.awssdk.services.glue.model.GetIntegrationResourcePropertyRequest;
import software.amazon.awssdk.services.glue.model.GetIntegrationResourcePropertyResponse;
import software.amazon.awssdk.services.glue.model.GetIntegrationTablePropertiesRequest;
import software.amazon.awssdk.services.glue.model.GetIntegrationTablePropertiesResponse;
import software.amazon.awssdk.services.glue.model.GetJobBookmarkRequest;
import software.amazon.awssdk.services.glue.model.GetJobBookmarkResponse;
import software.amazon.awssdk.services.glue.model.GetJobRequest;
import software.amazon.awssdk.services.glue.model.GetJobResponse;
import software.amazon.awssdk.services.glue.model.GetJobRunRequest;
import software.amazon.awssdk.services.glue.model.GetJobRunResponse;
import software.amazon.awssdk.services.glue.model.GetJobRunsRequest;
import software.amazon.awssdk.services.glue.model.GetJobRunsResponse;
import software.amazon.awssdk.services.glue.model.GetJobsRequest;
import software.amazon.awssdk.services.glue.model.GetJobsResponse;
import software.amazon.awssdk.services.glue.model.GetMappingRequest;
import software.amazon.awssdk.services.glue.model.GetMappingResponse;
import software.amazon.awssdk.services.glue.model.GetMlTaskRunRequest;
import software.amazon.awssdk.services.glue.model.GetMlTaskRunResponse;
import software.amazon.awssdk.services.glue.model.GetMlTaskRunsRequest;
import software.amazon.awssdk.services.glue.model.GetMlTaskRunsResponse;
import software.amazon.awssdk.services.glue.model.GetMlTransformRequest;
import software.amazon.awssdk.services.glue.model.GetMlTransformResponse;
import software.amazon.awssdk.services.glue.model.GetMlTransformsRequest;
import software.amazon.awssdk.services.glue.model.GetMlTransformsResponse;
import software.amazon.awssdk.services.glue.model.GetPartitionIndexesRequest;
import software.amazon.awssdk.services.glue.model.GetPartitionIndexesResponse;
import software.amazon.awssdk.services.glue.model.GetPartitionRequest;
import software.amazon.awssdk.services.glue.model.GetPartitionResponse;
import software.amazon.awssdk.services.glue.model.GetPartitionsRequest;
import software.amazon.awssdk.services.glue.model.GetPartitionsResponse;
import software.amazon.awssdk.services.glue.model.GetPlanRequest;
import software.amazon.awssdk.services.glue.model.GetPlanResponse;
import software.amazon.awssdk.services.glue.model.GetRegistryRequest;
import software.amazon.awssdk.services.glue.model.GetRegistryResponse;
import software.amazon.awssdk.services.glue.model.GetResourcePoliciesRequest;
import software.amazon.awssdk.services.glue.model.GetResourcePoliciesResponse;
import software.amazon.awssdk.services.glue.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.glue.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.glue.model.GetSchemaByDefinitionRequest;
import software.amazon.awssdk.services.glue.model.GetSchemaByDefinitionResponse;
import software.amazon.awssdk.services.glue.model.GetSchemaRequest;
import software.amazon.awssdk.services.glue.model.GetSchemaResponse;
import software.amazon.awssdk.services.glue.model.GetSchemaVersionRequest;
import software.amazon.awssdk.services.glue.model.GetSchemaVersionResponse;
import software.amazon.awssdk.services.glue.model.GetSchemaVersionsDiffRequest;
import software.amazon.awssdk.services.glue.model.GetSchemaVersionsDiffResponse;
import software.amazon.awssdk.services.glue.model.GetSecurityConfigurationRequest;
import software.amazon.awssdk.services.glue.model.GetSecurityConfigurationResponse;
import software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsRequest;
import software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsResponse;
import software.amazon.awssdk.services.glue.model.GetSessionRequest;
import software.amazon.awssdk.services.glue.model.GetSessionResponse;
import software.amazon.awssdk.services.glue.model.GetStatementRequest;
import software.amazon.awssdk.services.glue.model.GetStatementResponse;
import software.amazon.awssdk.services.glue.model.GetTableOptimizerRequest;
import software.amazon.awssdk.services.glue.model.GetTableOptimizerResponse;
import software.amazon.awssdk.services.glue.model.GetTableRequest;
import software.amazon.awssdk.services.glue.model.GetTableResponse;
import software.amazon.awssdk.services.glue.model.GetTableVersionRequest;
import software.amazon.awssdk.services.glue.model.GetTableVersionResponse;
import software.amazon.awssdk.services.glue.model.GetTableVersionsRequest;
import software.amazon.awssdk.services.glue.model.GetTableVersionsResponse;
import software.amazon.awssdk.services.glue.model.GetTablesRequest;
import software.amazon.awssdk.services.glue.model.GetTablesResponse;
import software.amazon.awssdk.services.glue.model.GetTagsRequest;
import software.amazon.awssdk.services.glue.model.GetTagsResponse;
import software.amazon.awssdk.services.glue.model.GetTriggerRequest;
import software.amazon.awssdk.services.glue.model.GetTriggerResponse;
import software.amazon.awssdk.services.glue.model.GetTriggersRequest;
import software.amazon.awssdk.services.glue.model.GetTriggersResponse;
import software.amazon.awssdk.services.glue.model.GetUnfilteredPartitionMetadataRequest;
import software.amazon.awssdk.services.glue.model.GetUnfilteredPartitionMetadataResponse;
import software.amazon.awssdk.services.glue.model.GetUnfilteredPartitionsMetadataRequest;
import software.amazon.awssdk.services.glue.model.GetUnfilteredPartitionsMetadataResponse;
import software.amazon.awssdk.services.glue.model.GetUnfilteredTableMetadataRequest;
import software.amazon.awssdk.services.glue.model.GetUnfilteredTableMetadataResponse;
import software.amazon.awssdk.services.glue.model.GetUsageProfileRequest;
import software.amazon.awssdk.services.glue.model.GetUsageProfileResponse;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionRequest;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionResponse;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsRequest;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsResponse;
import software.amazon.awssdk.services.glue.model.GetWorkflowRequest;
import software.amazon.awssdk.services.glue.model.GetWorkflowResponse;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunPropertiesRequest;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunPropertiesResponse;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunRequest;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunResponse;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunsRequest;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunsResponse;
import software.amazon.awssdk.services.glue.model.ImportCatalogToGlueRequest;
import software.amazon.awssdk.services.glue.model.ImportCatalogToGlueResponse;
import software.amazon.awssdk.services.glue.model.ListBlueprintsRequest;
import software.amazon.awssdk.services.glue.model.ListBlueprintsResponse;
import software.amazon.awssdk.services.glue.model.ListColumnStatisticsTaskRunsRequest;
import software.amazon.awssdk.services.glue.model.ListColumnStatisticsTaskRunsResponse;
import software.amazon.awssdk.services.glue.model.ListConnectionTypesRequest;
import software.amazon.awssdk.services.glue.model.ListConnectionTypesResponse;
import software.amazon.awssdk.services.glue.model.ListCrawlersRequest;
import software.amazon.awssdk.services.glue.model.ListCrawlersResponse;
import software.amazon.awssdk.services.glue.model.ListCrawlsRequest;
import software.amazon.awssdk.services.glue.model.ListCrawlsResponse;
import software.amazon.awssdk.services.glue.model.ListCustomEntityTypesRequest;
import software.amazon.awssdk.services.glue.model.ListCustomEntityTypesResponse;
import software.amazon.awssdk.services.glue.model.ListDataQualityResultsRequest;
import software.amazon.awssdk.services.glue.model.ListDataQualityResultsResponse;
import software.amazon.awssdk.services.glue.model.ListDataQualityRuleRecommendationRunsRequest;
import software.amazon.awssdk.services.glue.model.ListDataQualityRuleRecommendationRunsResponse;
import software.amazon.awssdk.services.glue.model.ListDataQualityRulesetEvaluationRunsRequest;
import software.amazon.awssdk.services.glue.model.ListDataQualityRulesetEvaluationRunsResponse;
import software.amazon.awssdk.services.glue.model.ListDataQualityRulesetsRequest;
import software.amazon.awssdk.services.glue.model.ListDataQualityRulesetsResponse;
import software.amazon.awssdk.services.glue.model.ListDataQualityStatisticAnnotationsRequest;
import software.amazon.awssdk.services.glue.model.ListDataQualityStatisticAnnotationsResponse;
import software.amazon.awssdk.services.glue.model.ListDataQualityStatisticsRequest;
import software.amazon.awssdk.services.glue.model.ListDataQualityStatisticsResponse;
import software.amazon.awssdk.services.glue.model.ListDevEndpointsRequest;
import software.amazon.awssdk.services.glue.model.ListDevEndpointsResponse;
import software.amazon.awssdk.services.glue.model.ListEntitiesRequest;
import software.amazon.awssdk.services.glue.model.ListEntitiesResponse;
import software.amazon.awssdk.services.glue.model.ListJobsRequest;
import software.amazon.awssdk.services.glue.model.ListJobsResponse;
import software.amazon.awssdk.services.glue.model.ListMlTransformsRequest;
import software.amazon.awssdk.services.glue.model.ListMlTransformsResponse;
import software.amazon.awssdk.services.glue.model.ListRegistriesRequest;
import software.amazon.awssdk.services.glue.model.ListRegistriesResponse;
import software.amazon.awssdk.services.glue.model.ListSchemaVersionsRequest;
import software.amazon.awssdk.services.glue.model.ListSchemaVersionsResponse;
import software.amazon.awssdk.services.glue.model.ListSchemasRequest;
import software.amazon.awssdk.services.glue.model.ListSchemasResponse;
import software.amazon.awssdk.services.glue.model.ListSessionsRequest;
import software.amazon.awssdk.services.glue.model.ListSessionsResponse;
import software.amazon.awssdk.services.glue.model.ListStatementsRequest;
import software.amazon.awssdk.services.glue.model.ListStatementsResponse;
import software.amazon.awssdk.services.glue.model.ListTableOptimizerRunsRequest;
import software.amazon.awssdk.services.glue.model.ListTableOptimizerRunsResponse;
import software.amazon.awssdk.services.glue.model.ListTriggersRequest;
import software.amazon.awssdk.services.glue.model.ListTriggersResponse;
import software.amazon.awssdk.services.glue.model.ListUsageProfilesRequest;
import software.amazon.awssdk.services.glue.model.ListUsageProfilesResponse;
import software.amazon.awssdk.services.glue.model.ListWorkflowsRequest;
import software.amazon.awssdk.services.glue.model.ListWorkflowsResponse;
import software.amazon.awssdk.services.glue.model.ModifyIntegrationRequest;
import software.amazon.awssdk.services.glue.model.ModifyIntegrationResponse;
import software.amazon.awssdk.services.glue.model.PutDataCatalogEncryptionSettingsRequest;
import software.amazon.awssdk.services.glue.model.PutDataCatalogEncryptionSettingsResponse;
import software.amazon.awssdk.services.glue.model.PutDataQualityProfileAnnotationRequest;
import software.amazon.awssdk.services.glue.model.PutDataQualityProfileAnnotationResponse;
import software.amazon.awssdk.services.glue.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.glue.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.glue.model.PutSchemaVersionMetadataRequest;
import software.amazon.awssdk.services.glue.model.PutSchemaVersionMetadataResponse;
import software.amazon.awssdk.services.glue.model.PutWorkflowRunPropertiesRequest;
import software.amazon.awssdk.services.glue.model.PutWorkflowRunPropertiesResponse;
import software.amazon.awssdk.services.glue.model.QuerySchemaVersionMetadataRequest;
import software.amazon.awssdk.services.glue.model.QuerySchemaVersionMetadataResponse;
import software.amazon.awssdk.services.glue.model.RegisterSchemaVersionRequest;
import software.amazon.awssdk.services.glue.model.RegisterSchemaVersionResponse;
import software.amazon.awssdk.services.glue.model.RemoveSchemaVersionMetadataRequest;
import software.amazon.awssdk.services.glue.model.RemoveSchemaVersionMetadataResponse;
import software.amazon.awssdk.services.glue.model.ResetJobBookmarkRequest;
import software.amazon.awssdk.services.glue.model.ResetJobBookmarkResponse;
import software.amazon.awssdk.services.glue.model.ResumeWorkflowRunRequest;
import software.amazon.awssdk.services.glue.model.ResumeWorkflowRunResponse;
import software.amazon.awssdk.services.glue.model.RunStatementRequest;
import software.amazon.awssdk.services.glue.model.RunStatementResponse;
import software.amazon.awssdk.services.glue.model.SearchTablesRequest;
import software.amazon.awssdk.services.glue.model.SearchTablesResponse;
import software.amazon.awssdk.services.glue.model.StartBlueprintRunRequest;
import software.amazon.awssdk.services.glue.model.StartBlueprintRunResponse;
import software.amazon.awssdk.services.glue.model.StartColumnStatisticsTaskRunRequest;
import software.amazon.awssdk.services.glue.model.StartColumnStatisticsTaskRunResponse;
import software.amazon.awssdk.services.glue.model.StartColumnStatisticsTaskRunScheduleRequest;
import software.amazon.awssdk.services.glue.model.StartColumnStatisticsTaskRunScheduleResponse;
import software.amazon.awssdk.services.glue.model.StartCrawlerRequest;
import software.amazon.awssdk.services.glue.model.StartCrawlerResponse;
import software.amazon.awssdk.services.glue.model.StartCrawlerScheduleRequest;
import software.amazon.awssdk.services.glue.model.StartCrawlerScheduleResponse;
import software.amazon.awssdk.services.glue.model.StartDataQualityRuleRecommendationRunRequest;
import software.amazon.awssdk.services.glue.model.StartDataQualityRuleRecommendationRunResponse;
import software.amazon.awssdk.services.glue.model.StartDataQualityRulesetEvaluationRunRequest;
import software.amazon.awssdk.services.glue.model.StartDataQualityRulesetEvaluationRunResponse;
import software.amazon.awssdk.services.glue.model.StartExportLabelsTaskRunRequest;
import software.amazon.awssdk.services.glue.model.StartExportLabelsTaskRunResponse;
import software.amazon.awssdk.services.glue.model.StartImportLabelsTaskRunRequest;
import software.amazon.awssdk.services.glue.model.StartImportLabelsTaskRunResponse;
import software.amazon.awssdk.services.glue.model.StartJobRunRequest;
import software.amazon.awssdk.services.glue.model.StartJobRunResponse;
import software.amazon.awssdk.services.glue.model.StartMlEvaluationTaskRunRequest;
import software.amazon.awssdk.services.glue.model.StartMlEvaluationTaskRunResponse;
import software.amazon.awssdk.services.glue.model.StartMlLabelingSetGenerationTaskRunRequest;
import software.amazon.awssdk.services.glue.model.StartMlLabelingSetGenerationTaskRunResponse;
import software.amazon.awssdk.services.glue.model.StartTriggerRequest;
import software.amazon.awssdk.services.glue.model.StartTriggerResponse;
import software.amazon.awssdk.services.glue.model.StartWorkflowRunRequest;
import software.amazon.awssdk.services.glue.model.StartWorkflowRunResponse;
import software.amazon.awssdk.services.glue.model.StopColumnStatisticsTaskRunRequest;
import software.amazon.awssdk.services.glue.model.StopColumnStatisticsTaskRunResponse;
import software.amazon.awssdk.services.glue.model.StopColumnStatisticsTaskRunScheduleRequest;
import software.amazon.awssdk.services.glue.model.StopColumnStatisticsTaskRunScheduleResponse;
import software.amazon.awssdk.services.glue.model.StopCrawlerRequest;
import software.amazon.awssdk.services.glue.model.StopCrawlerResponse;
import software.amazon.awssdk.services.glue.model.StopCrawlerScheduleRequest;
import software.amazon.awssdk.services.glue.model.StopCrawlerScheduleResponse;
import software.amazon.awssdk.services.glue.model.StopSessionRequest;
import software.amazon.awssdk.services.glue.model.StopSessionResponse;
import software.amazon.awssdk.services.glue.model.StopTriggerRequest;
import software.amazon.awssdk.services.glue.model.StopTriggerResponse;
import software.amazon.awssdk.services.glue.model.StopWorkflowRunRequest;
import software.amazon.awssdk.services.glue.model.StopWorkflowRunResponse;
import software.amazon.awssdk.services.glue.model.TagResourceRequest;
import software.amazon.awssdk.services.glue.model.TagResourceResponse;
import software.amazon.awssdk.services.glue.model.TestConnectionRequest;
import software.amazon.awssdk.services.glue.model.TestConnectionResponse;
import software.amazon.awssdk.services.glue.model.UntagResourceRequest;
import software.amazon.awssdk.services.glue.model.UntagResourceResponse;
import software.amazon.awssdk.services.glue.model.UpdateBlueprintRequest;
import software.amazon.awssdk.services.glue.model.UpdateBlueprintResponse;
import software.amazon.awssdk.services.glue.model.UpdateCatalogRequest;
import software.amazon.awssdk.services.glue.model.UpdateCatalogResponse;
import software.amazon.awssdk.services.glue.model.UpdateClassifierRequest;
import software.amazon.awssdk.services.glue.model.UpdateClassifierResponse;
import software.amazon.awssdk.services.glue.model.UpdateColumnStatisticsForPartitionRequest;
import software.amazon.awssdk.services.glue.model.UpdateColumnStatisticsForPartitionResponse;
import software.amazon.awssdk.services.glue.model.UpdateColumnStatisticsForTableRequest;
import software.amazon.awssdk.services.glue.model.UpdateColumnStatisticsForTableResponse;
import software.amazon.awssdk.services.glue.model.UpdateColumnStatisticsTaskSettingsRequest;
import software.amazon.awssdk.services.glue.model.UpdateColumnStatisticsTaskSettingsResponse;
import software.amazon.awssdk.services.glue.model.UpdateConnectionRequest;
import software.amazon.awssdk.services.glue.model.UpdateConnectionResponse;
import software.amazon.awssdk.services.glue.model.UpdateCrawlerRequest;
import software.amazon.awssdk.services.glue.model.UpdateCrawlerResponse;
import software.amazon.awssdk.services.glue.model.UpdateCrawlerScheduleRequest;
import software.amazon.awssdk.services.glue.model.UpdateCrawlerScheduleResponse;
import software.amazon.awssdk.services.glue.model.UpdateDataQualityRulesetRequest;
import software.amazon.awssdk.services.glue.model.UpdateDataQualityRulesetResponse;
import software.amazon.awssdk.services.glue.model.UpdateDatabaseRequest;
import software.amazon.awssdk.services.glue.model.UpdateDatabaseResponse;
import software.amazon.awssdk.services.glue.model.UpdateDevEndpointRequest;
import software.amazon.awssdk.services.glue.model.UpdateDevEndpointResponse;
import software.amazon.awssdk.services.glue.model.UpdateIntegrationResourcePropertyRequest;
import software.amazon.awssdk.services.glue.model.UpdateIntegrationResourcePropertyResponse;
import software.amazon.awssdk.services.glue.model.UpdateIntegrationTablePropertiesRequest;
import software.amazon.awssdk.services.glue.model.UpdateIntegrationTablePropertiesResponse;
import software.amazon.awssdk.services.glue.model.UpdateJobFromSourceControlRequest;
import software.amazon.awssdk.services.glue.model.UpdateJobFromSourceControlResponse;
import software.amazon.awssdk.services.glue.model.UpdateJobRequest;
import software.amazon.awssdk.services.glue.model.UpdateJobResponse;
import software.amazon.awssdk.services.glue.model.UpdateMlTransformRequest;
import software.amazon.awssdk.services.glue.model.UpdateMlTransformResponse;
import software.amazon.awssdk.services.glue.model.UpdatePartitionRequest;
import software.amazon.awssdk.services.glue.model.UpdatePartitionResponse;
import software.amazon.awssdk.services.glue.model.UpdateRegistryRequest;
import software.amazon.awssdk.services.glue.model.UpdateRegistryResponse;
import software.amazon.awssdk.services.glue.model.UpdateSchemaRequest;
import software.amazon.awssdk.services.glue.model.UpdateSchemaResponse;
import software.amazon.awssdk.services.glue.model.UpdateSourceControlFromJobRequest;
import software.amazon.awssdk.services.glue.model.UpdateSourceControlFromJobResponse;
import software.amazon.awssdk.services.glue.model.UpdateTableOptimizerRequest;
import software.amazon.awssdk.services.glue.model.UpdateTableOptimizerResponse;
import software.amazon.awssdk.services.glue.model.UpdateTableRequest;
import software.amazon.awssdk.services.glue.model.UpdateTableResponse;
import software.amazon.awssdk.services.glue.model.UpdateTriggerRequest;
import software.amazon.awssdk.services.glue.model.UpdateTriggerResponse;
import software.amazon.awssdk.services.glue.model.UpdateUsageProfileRequest;
import software.amazon.awssdk.services.glue.model.UpdateUsageProfileResponse;
import software.amazon.awssdk.services.glue.model.UpdateUserDefinedFunctionRequest;
import software.amazon.awssdk.services.glue.model.UpdateUserDefinedFunctionResponse;
import software.amazon.awssdk.services.glue.model.UpdateWorkflowRequest;
import software.amazon.awssdk.services.glue.model.UpdateWorkflowResponse;
import software.amazon.awssdk.services.glue.paginators.DescribeEntityPublisher;
import software.amazon.awssdk.services.glue.paginators.GetBlueprintRunsPublisher;
import software.amazon.awssdk.services.glue.paginators.GetClassifiersPublisher;
import software.amazon.awssdk.services.glue.paginators.GetColumnStatisticsTaskRunsPublisher;
import software.amazon.awssdk.services.glue.paginators.GetConnectionsPublisher;
import software.amazon.awssdk.services.glue.paginators.GetCrawlerMetricsPublisher;
import software.amazon.awssdk.services.glue.paginators.GetCrawlersPublisher;
import software.amazon.awssdk.services.glue.paginators.GetDatabasesPublisher;
import software.amazon.awssdk.services.glue.paginators.GetDevEndpointsPublisher;
import software.amazon.awssdk.services.glue.paginators.GetJobRunsPublisher;
import software.amazon.awssdk.services.glue.paginators.GetJobsPublisher;
import software.amazon.awssdk.services.glue.paginators.GetMLTaskRunsPublisher;
import software.amazon.awssdk.services.glue.paginators.GetMLTransformsPublisher;
import software.amazon.awssdk.services.glue.paginators.GetPartitionIndexesPublisher;
import software.amazon.awssdk.services.glue.paginators.GetPartitionsPublisher;
import software.amazon.awssdk.services.glue.paginators.GetResourcePoliciesPublisher;
import software.amazon.awssdk.services.glue.paginators.GetSecurityConfigurationsPublisher;
import software.amazon.awssdk.services.glue.paginators.GetTableVersionsPublisher;
import software.amazon.awssdk.services.glue.paginators.GetTablesPublisher;
import software.amazon.awssdk.services.glue.paginators.GetTriggersPublisher;
import software.amazon.awssdk.services.glue.paginators.GetUnfilteredPartitionsMetadataPublisher;
import software.amazon.awssdk.services.glue.paginators.GetUserDefinedFunctionsPublisher;
import software.amazon.awssdk.services.glue.paginators.GetWorkflowRunsPublisher;
import software.amazon.awssdk.services.glue.paginators.ListBlueprintsPublisher;
import software.amazon.awssdk.services.glue.paginators.ListColumnStatisticsTaskRunsPublisher;
import software.amazon.awssdk.services.glue.paginators.ListConnectionTypesPublisher;
import software.amazon.awssdk.services.glue.paginators.ListCrawlersPublisher;
import software.amazon.awssdk.services.glue.paginators.ListCustomEntityTypesPublisher;
import software.amazon.awssdk.services.glue.paginators.ListDataQualityResultsPublisher;
import software.amazon.awssdk.services.glue.paginators.ListDataQualityRuleRecommendationRunsPublisher;
import software.amazon.awssdk.services.glue.paginators.ListDataQualityRulesetEvaluationRunsPublisher;
import software.amazon.awssdk.services.glue.paginators.ListDataQualityRulesetsPublisher;
import software.amazon.awssdk.services.glue.paginators.ListDevEndpointsPublisher;
import software.amazon.awssdk.services.glue.paginators.ListEntitiesPublisher;
import software.amazon.awssdk.services.glue.paginators.ListJobsPublisher;
import software.amazon.awssdk.services.glue.paginators.ListMLTransformsPublisher;
import software.amazon.awssdk.services.glue.paginators.ListRegistriesPublisher;
import software.amazon.awssdk.services.glue.paginators.ListSchemaVersionsPublisher;
import software.amazon.awssdk.services.glue.paginators.ListSchemasPublisher;
import software.amazon.awssdk.services.glue.paginators.ListSessionsPublisher;
import software.amazon.awssdk.services.glue.paginators.ListTableOptimizerRunsPublisher;
import software.amazon.awssdk.services.glue.paginators.ListTriggersPublisher;
import software.amazon.awssdk.services.glue.paginators.ListUsageProfilesPublisher;
import software.amazon.awssdk.services.glue.paginators.ListWorkflowsPublisher;
import software.amazon.awssdk.services.glue.paginators.SearchTablesPublisher;

/**
 * Service client for accessing AWS Glue asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <fullname>Glue</fullname>
 * <p>
 * Defines the public endpoint for the Glue service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface GlueAsyncClient extends AwsClient {
    String SERVICE_NAME = "glue";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "glue";

    /**
     * <p>
     * Creates one or more partitions in a batch operation.
     * </p>
     *
     * @param batchCreatePartitionRequest
     * @return A Java Future containing the result of the BatchCreatePartition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchCreatePartition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchCreatePartition" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchCreatePartitionResponse> batchCreatePartition(
            BatchCreatePartitionRequest batchCreatePartitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates one or more partitions in a batch operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchCreatePartitionRequest.Builder} avoiding the
     * need to create one manually via {@link BatchCreatePartitionRequest#builder()}
     * </p>
     *
     * @param batchCreatePartitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.BatchCreatePartitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchCreatePartition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchCreatePartition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchCreatePartition" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchCreatePartitionResponse> batchCreatePartition(
            Consumer<BatchCreatePartitionRequest.Builder> batchCreatePartitionRequest) {
        return batchCreatePartition(BatchCreatePartitionRequest.builder().applyMutation(batchCreatePartitionRequest).build());
    }

    /**
     * <p>
     * Deletes a list of connection definitions from the Data Catalog.
     * </p>
     *
     * @param batchDeleteConnectionRequest
     * @return A Java Future containing the result of the BatchDeleteConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchDeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteConnection" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchDeleteConnectionResponse> batchDeleteConnection(
            BatchDeleteConnectionRequest batchDeleteConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a list of connection definitions from the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteConnectionRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDeleteConnectionRequest#builder()}
     * </p>
     *
     * @param batchDeleteConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.BatchDeleteConnectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchDeleteConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchDeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteConnection" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchDeleteConnectionResponse> batchDeleteConnection(
            Consumer<BatchDeleteConnectionRequest.Builder> batchDeleteConnectionRequest) {
        return batchDeleteConnection(BatchDeleteConnectionRequest.builder().applyMutation(batchDeleteConnectionRequest).build());
    }

    /**
     * <p>
     * Deletes one or more partitions in a batch operation.
     * </p>
     *
     * @param batchDeletePartitionRequest
     * @return A Java Future containing the result of the BatchDeletePartition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchDeletePartition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeletePartition" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchDeletePartitionResponse> batchDeletePartition(
            BatchDeletePartitionRequest batchDeletePartitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more partitions in a batch operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeletePartitionRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDeletePartitionRequest#builder()}
     * </p>
     *
     * @param batchDeletePartitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.BatchDeletePartitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchDeletePartition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchDeletePartition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeletePartition" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchDeletePartitionResponse> batchDeletePartition(
            Consumer<BatchDeletePartitionRequest.Builder> batchDeletePartitionRequest) {
        return batchDeletePartition(BatchDeletePartitionRequest.builder().applyMutation(batchDeletePartitionRequest).build());
    }

    /**
     * <p>
     * Deletes multiple tables at once.
     * </p>
     * <note>
     * <p>
     * After completing this operation, you no longer have access to the table versions and partitions that belong to
     * the deleted table. Glue deletes these "orphaned" resources asynchronously in a timely manner, at the discretion
     * of the service.
     * </p>
     * <p>
     * To ensure the immediate deletion of all related resources, before calling <code>BatchDeleteTable</code>, use
     * <code>DeleteTableVersion</code> or <code>BatchDeleteTableVersion</code>, and <code>DeletePartition</code> or
     * <code>BatchDeletePartition</code>, to delete any resources that belong to the table.
     * </p>
     * </note>
     *
     * @param batchDeleteTableRequest
     * @return A Java Future containing the result of the BatchDeleteTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>ResourceNotReadyException A resource was not ready for a transaction.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchDeleteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchDeleteTableResponse> batchDeleteTable(BatchDeleteTableRequest batchDeleteTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes multiple tables at once.
     * </p>
     * <note>
     * <p>
     * After completing this operation, you no longer have access to the table versions and partitions that belong to
     * the deleted table. Glue deletes these "orphaned" resources asynchronously in a timely manner, at the discretion
     * of the service.
     * </p>
     * <p>
     * To ensure the immediate deletion of all related resources, before calling <code>BatchDeleteTable</code>, use
     * <code>DeleteTableVersion</code> or <code>BatchDeleteTableVersion</code>, and <code>DeletePartition</code> or
     * <code>BatchDeletePartition</code>, to delete any resources that belong to the table.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteTableRequest.Builder} avoiding the need
     * to create one manually via {@link BatchDeleteTableRequest#builder()}
     * </p>
     *
     * @param batchDeleteTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.BatchDeleteTableRequest.Builder} to create a request.
     * @return A Java Future containing the result of the BatchDeleteTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>ResourceNotReadyException A resource was not ready for a transaction.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchDeleteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchDeleteTableResponse> batchDeleteTable(
            Consumer<BatchDeleteTableRequest.Builder> batchDeleteTableRequest) {
        return batchDeleteTable(BatchDeleteTableRequest.builder().applyMutation(batchDeleteTableRequest).build());
    }

    /**
     * <p>
     * Deletes a specified batch of versions of a table.
     * </p>
     *
     * @param batchDeleteTableVersionRequest
     * @return A Java Future containing the result of the BatchDeleteTableVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchDeleteTableVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteTableVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchDeleteTableVersionResponse> batchDeleteTableVersion(
            BatchDeleteTableVersionRequest batchDeleteTableVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified batch of versions of a table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteTableVersionRequest.Builder} avoiding
     * the need to create one manually via {@link BatchDeleteTableVersionRequest#builder()}
     * </p>
     *
     * @param batchDeleteTableVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.BatchDeleteTableVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchDeleteTableVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchDeleteTableVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteTableVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchDeleteTableVersionResponse> batchDeleteTableVersion(
            Consumer<BatchDeleteTableVersionRequest.Builder> batchDeleteTableVersionRequest) {
        return batchDeleteTableVersion(BatchDeleteTableVersionRequest.builder().applyMutation(batchDeleteTableVersionRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about a list of blueprints.
     * </p>
     *
     * @param batchGetBlueprintsRequest
     * @return A Java Future containing the result of the BatchGetBlueprints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchGetBlueprints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetBlueprints" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchGetBlueprintsResponse> batchGetBlueprints(BatchGetBlueprintsRequest batchGetBlueprintsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a list of blueprints.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetBlueprintsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetBlueprintsRequest#builder()}
     * </p>
     *
     * @param batchGetBlueprintsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.BatchGetBlueprintsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the BatchGetBlueprints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchGetBlueprints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetBlueprints" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchGetBlueprintsResponse> batchGetBlueprints(
            Consumer<BatchGetBlueprintsRequest.Builder> batchGetBlueprintsRequest) {
        return batchGetBlueprints(BatchGetBlueprintsRequest.builder().applyMutation(batchGetBlueprintsRequest).build());
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of crawler names. After calling the
     * <code>ListCrawlers</code> operation, you can call this operation to access the data to which you have been
     * granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     *
     * @param batchGetCrawlersRequest
     * @return A Java Future containing the result of the BatchGetCrawlers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchGetCrawlers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetCrawlers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchGetCrawlersResponse> batchGetCrawlers(BatchGetCrawlersRequest batchGetCrawlersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of crawler names. After calling the
     * <code>ListCrawlers</code> operation, you can call this operation to access the data to which you have been
     * granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetCrawlersRequest.Builder} avoiding the need
     * to create one manually via {@link BatchGetCrawlersRequest#builder()}
     * </p>
     *
     * @param batchGetCrawlersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.BatchGetCrawlersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the BatchGetCrawlers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchGetCrawlers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetCrawlers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchGetCrawlersResponse> batchGetCrawlers(
            Consumer<BatchGetCrawlersRequest.Builder> batchGetCrawlersRequest) {
        return batchGetCrawlers(BatchGetCrawlersRequest.builder().applyMutation(batchGetCrawlersRequest).build());
    }

    /**
     * <p>
     * Retrieves the details for the custom patterns specified by a list of names.
     * </p>
     *
     * @param batchGetCustomEntityTypesRequest
     * @return A Java Future containing the result of the BatchGetCustomEntityTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchGetCustomEntityTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetCustomEntityTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetCustomEntityTypesResponse> batchGetCustomEntityTypes(
            BatchGetCustomEntityTypesRequest batchGetCustomEntityTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details for the custom patterns specified by a list of names.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetCustomEntityTypesRequest.Builder} avoiding
     * the need to create one manually via {@link BatchGetCustomEntityTypesRequest#builder()}
     * </p>
     *
     * @param batchGetCustomEntityTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.BatchGetCustomEntityTypesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchGetCustomEntityTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchGetCustomEntityTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetCustomEntityTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetCustomEntityTypesResponse> batchGetCustomEntityTypes(
            Consumer<BatchGetCustomEntityTypesRequest.Builder> batchGetCustomEntityTypesRequest) {
        return batchGetCustomEntityTypes(BatchGetCustomEntityTypesRequest.builder()
                .applyMutation(batchGetCustomEntityTypesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of data quality results for the specified result IDs.
     * </p>
     *
     * @param batchGetDataQualityResultRequest
     * @return A Java Future containing the result of the BatchGetDataQualityResult operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchGetDataQualityResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetDataQualityResult"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetDataQualityResultResponse> batchGetDataQualityResult(
            BatchGetDataQualityResultRequest batchGetDataQualityResultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of data quality results for the specified result IDs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetDataQualityResultRequest.Builder} avoiding
     * the need to create one manually via {@link BatchGetDataQualityResultRequest#builder()}
     * </p>
     *
     * @param batchGetDataQualityResultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.BatchGetDataQualityResultRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchGetDataQualityResult operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchGetDataQualityResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetDataQualityResult"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetDataQualityResultResponse> batchGetDataQualityResult(
            Consumer<BatchGetDataQualityResultRequest.Builder> batchGetDataQualityResultRequest) {
        return batchGetDataQualityResult(BatchGetDataQualityResultRequest.builder()
                .applyMutation(batchGetDataQualityResultRequest).build());
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of development endpoint names. After calling the
     * <code>ListDevEndpoints</code> operation, you can call this operation to access the data to which you have been
     * granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     *
     * @param batchGetDevEndpointsRequest
     * @return A Java Future containing the result of the BatchGetDevEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchGetDevEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetDevEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchGetDevEndpointsResponse> batchGetDevEndpoints(
            BatchGetDevEndpointsRequest batchGetDevEndpointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of development endpoint names. After calling the
     * <code>ListDevEndpoints</code> operation, you can call this operation to access the data to which you have been
     * granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetDevEndpointsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetDevEndpointsRequest#builder()}
     * </p>
     *
     * @param batchGetDevEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.BatchGetDevEndpointsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchGetDevEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchGetDevEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetDevEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchGetDevEndpointsResponse> batchGetDevEndpoints(
            Consumer<BatchGetDevEndpointsRequest.Builder> batchGetDevEndpointsRequest) {
        return batchGetDevEndpoints(BatchGetDevEndpointsRequest.builder().applyMutation(batchGetDevEndpointsRequest).build());
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of job names. After calling the <code>ListJobs</code>
     * operation, you can call this operation to access the data to which you have been granted permissions. This
     * operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     *
     * @param batchGetJobsRequest
     * @return A Java Future containing the result of the BatchGetJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchGetJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchGetJobsResponse> batchGetJobs(BatchGetJobsRequest batchGetJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of job names. After calling the <code>ListJobs</code>
     * operation, you can call this operation to access the data to which you have been granted permissions. This
     * operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetJobsRequest.Builder} avoiding the need to
     * create one manually via {@link BatchGetJobsRequest#builder()}
     * </p>
     *
     * @param batchGetJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.BatchGetJobsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the BatchGetJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchGetJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchGetJobsResponse> batchGetJobs(Consumer<BatchGetJobsRequest.Builder> batchGetJobsRequest) {
        return batchGetJobs(BatchGetJobsRequest.builder().applyMutation(batchGetJobsRequest).build());
    }

    /**
     * <p>
     * Retrieves partitions in a batch request.
     * </p>
     *
     * @param batchGetPartitionRequest
     * @return A Java Future containing the result of the BatchGetPartition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>InvalidStateException An error that indicates your data is in an invalid state.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchGetPartition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetPartition" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchGetPartitionResponse> batchGetPartition(BatchGetPartitionRequest batchGetPartitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves partitions in a batch request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetPartitionRequest.Builder} avoiding the need
     * to create one manually via {@link BatchGetPartitionRequest#builder()}
     * </p>
     *
     * @param batchGetPartitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.BatchGetPartitionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the BatchGetPartition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>InvalidStateException An error that indicates your data is in an invalid state.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchGetPartition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetPartition" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchGetPartitionResponse> batchGetPartition(
            Consumer<BatchGetPartitionRequest.Builder> batchGetPartitionRequest) {
        return batchGetPartition(BatchGetPartitionRequest.builder().applyMutation(batchGetPartitionRequest).build());
    }

    /**
     * <p>
     * Returns the configuration for the specified table optimizers.
     * </p>
     *
     * @param batchGetTableOptimizerRequest
     * @return A Java Future containing the result of the BatchGetTableOptimizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>ThrottlingException The throttling threshhold was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchGetTableOptimizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetTableOptimizer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchGetTableOptimizerResponse> batchGetTableOptimizer(
            BatchGetTableOptimizerRequest batchGetTableOptimizerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the configuration for the specified table optimizers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetTableOptimizerRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetTableOptimizerRequest#builder()}
     * </p>
     *
     * @param batchGetTableOptimizerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.BatchGetTableOptimizerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchGetTableOptimizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>ThrottlingException The throttling threshhold was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchGetTableOptimizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetTableOptimizer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchGetTableOptimizerResponse> batchGetTableOptimizer(
            Consumer<BatchGetTableOptimizerRequest.Builder> batchGetTableOptimizerRequest) {
        return batchGetTableOptimizer(BatchGetTableOptimizerRequest.builder().applyMutation(batchGetTableOptimizerRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of trigger names. After calling the
     * <code>ListTriggers</code> operation, you can call this operation to access the data to which you have been
     * granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     *
     * @param batchGetTriggersRequest
     * @return A Java Future containing the result of the BatchGetTriggers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchGetTriggers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetTriggers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchGetTriggersResponse> batchGetTriggers(BatchGetTriggersRequest batchGetTriggersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of trigger names. After calling the
     * <code>ListTriggers</code> operation, you can call this operation to access the data to which you have been
     * granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetTriggersRequest.Builder} avoiding the need
     * to create one manually via {@link BatchGetTriggersRequest#builder()}
     * </p>
     *
     * @param batchGetTriggersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.BatchGetTriggersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the BatchGetTriggers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchGetTriggers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetTriggers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchGetTriggersResponse> batchGetTriggers(
            Consumer<BatchGetTriggersRequest.Builder> batchGetTriggersRequest) {
        return batchGetTriggers(BatchGetTriggersRequest.builder().applyMutation(batchGetTriggersRequest).build());
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of workflow names. After calling the
     * <code>ListWorkflows</code> operation, you can call this operation to access the data to which you have been
     * granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     *
     * @param batchGetWorkflowsRequest
     * @return A Java Future containing the result of the BatchGetWorkflows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchGetWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchGetWorkflowsResponse> batchGetWorkflows(BatchGetWorkflowsRequest batchGetWorkflowsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of resource metadata for a given list of workflow names. After calling the
     * <code>ListWorkflows</code> operation, you can call this operation to access the data to which you have been
     * granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetWorkflowsRequest.Builder} avoiding the need
     * to create one manually via {@link BatchGetWorkflowsRequest#builder()}
     * </p>
     *
     * @param batchGetWorkflowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.BatchGetWorkflowsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the BatchGetWorkflows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchGetWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchGetWorkflowsResponse> batchGetWorkflows(
            Consumer<BatchGetWorkflowsRequest.Builder> batchGetWorkflowsRequest) {
        return batchGetWorkflows(BatchGetWorkflowsRequest.builder().applyMutation(batchGetWorkflowsRequest).build());
    }

    /**
     * <p>
     * Annotate datapoints over time for a specific data quality statistic.
     * </p>
     *
     * @param batchPutDataQualityStatisticAnnotationRequest
     * @return A Java Future containing the result of the BatchPutDataQualityStatisticAnnotation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchPutDataQualityStatisticAnnotation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchPutDataQualityStatisticAnnotation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchPutDataQualityStatisticAnnotationResponse> batchPutDataQualityStatisticAnnotation(
            BatchPutDataQualityStatisticAnnotationRequest batchPutDataQualityStatisticAnnotationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Annotate datapoints over time for a specific data quality statistic.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchPutDataQualityStatisticAnnotationRequest.Builder} avoiding the need to create one manually via
     * {@link BatchPutDataQualityStatisticAnnotationRequest#builder()}
     * </p>
     *
     * @param batchPutDataQualityStatisticAnnotationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.BatchPutDataQualityStatisticAnnotationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchPutDataQualityStatisticAnnotation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchPutDataQualityStatisticAnnotation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchPutDataQualityStatisticAnnotation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchPutDataQualityStatisticAnnotationResponse> batchPutDataQualityStatisticAnnotation(
            Consumer<BatchPutDataQualityStatisticAnnotationRequest.Builder> batchPutDataQualityStatisticAnnotationRequest) {
        return batchPutDataQualityStatisticAnnotation(BatchPutDataQualityStatisticAnnotationRequest.builder()
                .applyMutation(batchPutDataQualityStatisticAnnotationRequest).build());
    }

    /**
     * <p>
     * Stops one or more job runs for a specified job definition.
     * </p>
     *
     * @param batchStopJobRunRequest
     * @return A Java Future containing the result of the BatchStopJobRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchStopJobRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchStopJobRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchStopJobRunResponse> batchStopJobRun(BatchStopJobRunRequest batchStopJobRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops one or more job runs for a specified job definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchStopJobRunRequest.Builder} avoiding the need
     * to create one manually via {@link BatchStopJobRunRequest#builder()}
     * </p>
     *
     * @param batchStopJobRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.BatchStopJobRunRequest.Builder} to create a request.
     * @return A Java Future containing the result of the BatchStopJobRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchStopJobRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchStopJobRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchStopJobRunResponse> batchStopJobRun(
            Consumer<BatchStopJobRunRequest.Builder> batchStopJobRunRequest) {
        return batchStopJobRun(BatchStopJobRunRequest.builder().applyMutation(batchStopJobRunRequest).build());
    }

    /**
     * <p>
     * Updates one or more partitions in a batch operation.
     * </p>
     *
     * @param batchUpdatePartitionRequest
     * @return A Java Future containing the result of the BatchUpdatePartition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchUpdatePartition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchUpdatePartition" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchUpdatePartitionResponse> batchUpdatePartition(
            BatchUpdatePartitionRequest batchUpdatePartitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates one or more partitions in a batch operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdatePartitionRequest.Builder} avoiding the
     * need to create one manually via {@link BatchUpdatePartitionRequest#builder()}
     * </p>
     *
     * @param batchUpdatePartitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.BatchUpdatePartitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchUpdatePartition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.BatchUpdatePartition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchUpdatePartition" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchUpdatePartitionResponse> batchUpdatePartition(
            Consumer<BatchUpdatePartitionRequest.Builder> batchUpdatePartitionRequest) {
        return batchUpdatePartition(BatchUpdatePartitionRequest.builder().applyMutation(batchUpdatePartitionRequest).build());
    }

    /**
     * <p>
     * Cancels the specified recommendation run that was being used to generate rules.
     * </p>
     *
     * @param cancelDataQualityRuleRecommendationRunRequest
     * @return A Java Future containing the result of the CancelDataQualityRuleRecommendationRun operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CancelDataQualityRuleRecommendationRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CancelDataQualityRuleRecommendationRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelDataQualityRuleRecommendationRunResponse> cancelDataQualityRuleRecommendationRun(
            CancelDataQualityRuleRecommendationRunRequest cancelDataQualityRuleRecommendationRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the specified recommendation run that was being used to generate rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CancelDataQualityRuleRecommendationRunRequest.Builder} avoiding the need to create one manually via
     * {@link CancelDataQualityRuleRecommendationRunRequest#builder()}
     * </p>
     *
     * @param cancelDataQualityRuleRecommendationRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CancelDataQualityRuleRecommendationRunRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CancelDataQualityRuleRecommendationRun operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CancelDataQualityRuleRecommendationRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CancelDataQualityRuleRecommendationRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelDataQualityRuleRecommendationRunResponse> cancelDataQualityRuleRecommendationRun(
            Consumer<CancelDataQualityRuleRecommendationRunRequest.Builder> cancelDataQualityRuleRecommendationRunRequest) {
        return cancelDataQualityRuleRecommendationRun(CancelDataQualityRuleRecommendationRunRequest.builder()
                .applyMutation(cancelDataQualityRuleRecommendationRunRequest).build());
    }

    /**
     * <p>
     * Cancels a run where a ruleset is being evaluated against a data source.
     * </p>
     *
     * @param cancelDataQualityRulesetEvaluationRunRequest
     * @return A Java Future containing the result of the CancelDataQualityRulesetEvaluationRun operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CancelDataQualityRulesetEvaluationRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CancelDataQualityRulesetEvaluationRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelDataQualityRulesetEvaluationRunResponse> cancelDataQualityRulesetEvaluationRun(
            CancelDataQualityRulesetEvaluationRunRequest cancelDataQualityRulesetEvaluationRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a run where a ruleset is being evaluated against a data source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CancelDataQualityRulesetEvaluationRunRequest.Builder} avoiding the need to create one manually via
     * {@link CancelDataQualityRulesetEvaluationRunRequest#builder()}
     * </p>
     *
     * @param cancelDataQualityRulesetEvaluationRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CancelDataQualityRulesetEvaluationRunRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CancelDataQualityRulesetEvaluationRun operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CancelDataQualityRulesetEvaluationRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CancelDataQualityRulesetEvaluationRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelDataQualityRulesetEvaluationRunResponse> cancelDataQualityRulesetEvaluationRun(
            Consumer<CancelDataQualityRulesetEvaluationRunRequest.Builder> cancelDataQualityRulesetEvaluationRunRequest) {
        return cancelDataQualityRulesetEvaluationRun(CancelDataQualityRulesetEvaluationRunRequest.builder()
                .applyMutation(cancelDataQualityRulesetEvaluationRunRequest).build());
    }

    /**
     * <p>
     * Cancels (stops) a task run. Machine learning task runs are asynchronous tasks that Glue runs on your behalf as
     * part of various machine learning workflows. You can cancel a machine learning task run at any time by calling
     * <code>CancelMLTaskRun</code> with a task run's parent transform's <code>TransformID</code> and the task run's
     * <code>TaskRunId</code>.
     * </p>
     *
     * @param cancelMlTaskRunRequest
     * @return A Java Future containing the result of the CancelMLTaskRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CancelMLTaskRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CancelMLTaskRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelMlTaskRunResponse> cancelMLTaskRun(CancelMlTaskRunRequest cancelMlTaskRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels (stops) a task run. Machine learning task runs are asynchronous tasks that Glue runs on your behalf as
     * part of various machine learning workflows. You can cancel a machine learning task run at any time by calling
     * <code>CancelMLTaskRun</code> with a task run's parent transform's <code>TransformID</code> and the task run's
     * <code>TaskRunId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelMlTaskRunRequest.Builder} avoiding the need
     * to create one manually via {@link CancelMlTaskRunRequest#builder()}
     * </p>
     *
     * @param cancelMlTaskRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CancelMlTaskRunRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CancelMLTaskRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CancelMLTaskRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CancelMLTaskRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelMlTaskRunResponse> cancelMLTaskRun(
            Consumer<CancelMlTaskRunRequest.Builder> cancelMlTaskRunRequest) {
        return cancelMLTaskRun(CancelMlTaskRunRequest.builder().applyMutation(cancelMlTaskRunRequest).build());
    }

    /**
     * <p>
     * Cancels the statement.
     * </p>
     *
     * @param cancelStatementRequest
     * @return A Java Future containing the result of the CancelStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>IllegalSessionStateException The session is in an invalid state to perform a requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CancelStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CancelStatement" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelStatementResponse> cancelStatement(CancelStatementRequest cancelStatementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the statement.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelStatementRequest.Builder} avoiding the need
     * to create one manually via {@link CancelStatementRequest#builder()}
     * </p>
     *
     * @param cancelStatementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CancelStatementRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CancelStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>IllegalSessionStateException The session is in an invalid state to perform a requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CancelStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CancelStatement" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelStatementResponse> cancelStatement(
            Consumer<CancelStatementRequest.Builder> cancelStatementRequest) {
        return cancelStatement(CancelStatementRequest.builder().applyMutation(cancelStatementRequest).build());
    }

    /**
     * <p>
     * Validates the supplied schema. This call has no side effects, it simply validates using the supplied schema using
     * <code>DataFormat</code> as the format. Since it does not take a schema set name, no compatibility checks are
     * performed.
     * </p>
     *
     * @param checkSchemaVersionValidityRequest
     * @return A Java Future containing the result of the CheckSchemaVersionValidity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CheckSchemaVersionValidity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CheckSchemaVersionValidity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CheckSchemaVersionValidityResponse> checkSchemaVersionValidity(
            CheckSchemaVersionValidityRequest checkSchemaVersionValidityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Validates the supplied schema. This call has no side effects, it simply validates using the supplied schema using
     * <code>DataFormat</code> as the format. Since it does not take a schema set name, no compatibility checks are
     * performed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CheckSchemaVersionValidityRequest.Builder} avoiding
     * the need to create one manually via {@link CheckSchemaVersionValidityRequest#builder()}
     * </p>
     *
     * @param checkSchemaVersionValidityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CheckSchemaVersionValidityRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CheckSchemaVersionValidity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CheckSchemaVersionValidity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CheckSchemaVersionValidity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CheckSchemaVersionValidityResponse> checkSchemaVersionValidity(
            Consumer<CheckSchemaVersionValidityRequest.Builder> checkSchemaVersionValidityRequest) {
        return checkSchemaVersionValidity(CheckSchemaVersionValidityRequest.builder()
                .applyMutation(checkSchemaVersionValidityRequest).build());
    }

    /**
     * <p>
     * Registers a blueprint with Glue.
     * </p>
     *
     * @param createBlueprintRequest
     * @return A Java Future containing the result of the CreateBlueprint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateBlueprint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateBlueprintResponse> createBlueprint(CreateBlueprintRequest createBlueprintRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a blueprint with Glue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBlueprintRequest.Builder} avoiding the need
     * to create one manually via {@link CreateBlueprintRequest#builder()}
     * </p>
     *
     * @param createBlueprintRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CreateBlueprintRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateBlueprint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateBlueprint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateBlueprintResponse> createBlueprint(
            Consumer<CreateBlueprintRequest.Builder> createBlueprintRequest) {
        return createBlueprint(CreateBlueprintRequest.builder().applyMutation(createBlueprintRequest).build());
    }

    /**
     * <p>
     * Creates a new catalog in the Glue Data Catalog.
     * </p>
     *
     * @param createCatalogRequest
     * @return A Java Future containing the result of the CreateCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>FederatedResourceAlreadyExistsException A federated resource already exists.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateCatalogResponse> createCatalog(CreateCatalogRequest createCatalogRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new catalog in the Glue Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCatalogRequest.Builder} avoiding the need to
     * create one manually via {@link CreateCatalogRequest#builder()}
     * </p>
     *
     * @param createCatalogRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CreateCatalogRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>FederatedResourceAlreadyExistsException A federated resource already exists.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateCatalogResponse> createCatalog(Consumer<CreateCatalogRequest.Builder> createCatalogRequest) {
        return createCatalog(CreateCatalogRequest.builder().applyMutation(createCatalogRequest).build());
    }

    /**
     * <p>
     * Creates a classifier in the user's account. This can be a <code>GrokClassifier</code>, an
     * <code>XMLClassifier</code>, a <code>JsonClassifier</code>, or a <code>CsvClassifier</code>, depending on which
     * field of the request is present.
     * </p>
     *
     * @param createClassifierRequest
     * @return A Java Future containing the result of the CreateClassifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateClassifier" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateClassifierResponse> createClassifier(CreateClassifierRequest createClassifierRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a classifier in the user's account. This can be a <code>GrokClassifier</code>, an
     * <code>XMLClassifier</code>, a <code>JsonClassifier</code>, or a <code>CsvClassifier</code>, depending on which
     * field of the request is present.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClassifierRequest.Builder} avoiding the need
     * to create one manually via {@link CreateClassifierRequest#builder()}
     * </p>
     *
     * @param createClassifierRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CreateClassifierRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateClassifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateClassifier" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateClassifierResponse> createClassifier(
            Consumer<CreateClassifierRequest.Builder> createClassifierRequest) {
        return createClassifier(CreateClassifierRequest.builder().applyMutation(createClassifierRequest).build());
    }

    /**
     * <p>
     * Creates settings for a column statistics task.
     * </p>
     *
     * @param createColumnStatisticsTaskSettingsRequest
     * @return A Java Future containing the result of the CreateColumnStatisticsTaskSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>ColumnStatisticsTaskRunningException An exception thrown when you try to start another job while
     *         running a column stats generation job.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateColumnStatisticsTaskSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateColumnStatisticsTaskSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateColumnStatisticsTaskSettingsResponse> createColumnStatisticsTaskSettings(
            CreateColumnStatisticsTaskSettingsRequest createColumnStatisticsTaskSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates settings for a column statistics task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateColumnStatisticsTaskSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link CreateColumnStatisticsTaskSettingsRequest#builder()}
     * </p>
     *
     * @param createColumnStatisticsTaskSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CreateColumnStatisticsTaskSettingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateColumnStatisticsTaskSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>ColumnStatisticsTaskRunningException An exception thrown when you try to start another job while
     *         running a column stats generation job.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateColumnStatisticsTaskSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateColumnStatisticsTaskSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateColumnStatisticsTaskSettingsResponse> createColumnStatisticsTaskSettings(
            Consumer<CreateColumnStatisticsTaskSettingsRequest.Builder> createColumnStatisticsTaskSettingsRequest) {
        return createColumnStatisticsTaskSettings(CreateColumnStatisticsTaskSettingsRequest.builder()
                .applyMutation(createColumnStatisticsTaskSettingsRequest).build());
    }

    /**
     * <p>
     * Creates a connection definition in the Data Catalog.
     * </p>
     * <p>
     * Connections used for creating federated resources require the IAM <code>glue:PassConnection</code> permission.
     * </p>
     *
     * @param createConnectionRequest
     * @return A Java Future containing the result of the CreateConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateConnectionResponse> createConnection(CreateConnectionRequest createConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a connection definition in the Data Catalog.
     * </p>
     * <p>
     * Connections used for creating federated resources require the IAM <code>glue:PassConnection</code> permission.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateConnectionRequest#builder()}
     * </p>
     *
     * @param createConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CreateConnectionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateConnectionResponse> createConnection(
            Consumer<CreateConnectionRequest.Builder> createConnectionRequest) {
        return createConnection(CreateConnectionRequest.builder().applyMutation(createConnectionRequest).build());
    }

    /**
     * <p>
     * Creates a new crawler with specified targets, role, configuration, and optional schedule. At least one crawl
     * target must be specified, in the <code>s3Targets</code> field, the <code>jdbcTargets</code> field, or the
     * <code>DynamoDBTargets</code> field.
     * </p>
     *
     * @param createCrawlerRequest
     * @return A Java Future containing the result of the CreateCrawler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateCrawler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateCrawler" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateCrawlerResponse> createCrawler(CreateCrawlerRequest createCrawlerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new crawler with specified targets, role, configuration, and optional schedule. At least one crawl
     * target must be specified, in the <code>s3Targets</code> field, the <code>jdbcTargets</code> field, or the
     * <code>DynamoDBTargets</code> field.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCrawlerRequest.Builder} avoiding the need to
     * create one manually via {@link CreateCrawlerRequest#builder()}
     * </p>
     *
     * @param createCrawlerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CreateCrawlerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateCrawler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateCrawler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateCrawler" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateCrawlerResponse> createCrawler(Consumer<CreateCrawlerRequest.Builder> createCrawlerRequest) {
        return createCrawler(CreateCrawlerRequest.builder().applyMutation(createCrawlerRequest).build());
    }

    /**
     * <p>
     * Creates a custom pattern that is used to detect sensitive data across the columns and rows of your structured
     * data.
     * </p>
     * <p>
     * Each custom pattern you create specifies a regular expression and an optional list of context words. If no
     * context words are passed only a regular expression is checked.
     * </p>
     *
     * @param createCustomEntityTypeRequest
     * @return A Java Future containing the result of the CreateCustomEntityType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>IdempotentParameterMismatchException The same unique identifier was associated with two different
     *         records.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateCustomEntityType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateCustomEntityType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateCustomEntityTypeResponse> createCustomEntityType(
            CreateCustomEntityTypeRequest createCustomEntityTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom pattern that is used to detect sensitive data across the columns and rows of your structured
     * data.
     * </p>
     * <p>
     * Each custom pattern you create specifies a regular expression and an optional list of context words. If no
     * context words are passed only a regular expression is checked.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCustomEntityTypeRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCustomEntityTypeRequest#builder()}
     * </p>
     *
     * @param createCustomEntityTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CreateCustomEntityTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateCustomEntityType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>IdempotentParameterMismatchException The same unique identifier was associated with two different
     *         records.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateCustomEntityType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateCustomEntityType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateCustomEntityTypeResponse> createCustomEntityType(
            Consumer<CreateCustomEntityTypeRequest.Builder> createCustomEntityTypeRequest) {
        return createCustomEntityType(CreateCustomEntityTypeRequest.builder().applyMutation(createCustomEntityTypeRequest)
                .build());
    }

    /**
     * <p>
     * Creates a data quality ruleset with DQDL rules applied to a specified Glue table.
     * </p>
     * <p>
     * You create the ruleset using the Data Quality Definition Language (DQDL). For more information, see the Glue
     * developer guide.
     * </p>
     *
     * @param createDataQualityRulesetRequest
     * @return A Java Future containing the result of the CreateDataQualityRuleset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateDataQualityRuleset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateDataQualityRuleset" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDataQualityRulesetResponse> createDataQualityRuleset(
            CreateDataQualityRulesetRequest createDataQualityRulesetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a data quality ruleset with DQDL rules applied to a specified Glue table.
     * </p>
     * <p>
     * You create the ruleset using the Data Quality Definition Language (DQDL). For more information, see the Glue
     * developer guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataQualityRulesetRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDataQualityRulesetRequest#builder()}
     * </p>
     *
     * @param createDataQualityRulesetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CreateDataQualityRulesetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDataQualityRuleset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateDataQualityRuleset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateDataQualityRuleset" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDataQualityRulesetResponse> createDataQualityRuleset(
            Consumer<CreateDataQualityRulesetRequest.Builder> createDataQualityRulesetRequest) {
        return createDataQualityRuleset(CreateDataQualityRulesetRequest.builder().applyMutation(createDataQualityRulesetRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new database in a Data Catalog.
     * </p>
     *
     * @param createDatabaseRequest
     * @return A Java Future containing the result of the CreateDatabase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>FederatedResourceAlreadyExistsException A federated resource already exists.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDatabaseResponse> createDatabase(CreateDatabaseRequest createDatabaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new database in a Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDatabaseRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDatabaseRequest#builder()}
     * </p>
     *
     * @param createDatabaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CreateDatabaseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDatabase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>FederatedResourceAlreadyExistsException A federated resource already exists.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDatabaseResponse> createDatabase(Consumer<CreateDatabaseRequest.Builder> createDatabaseRequest) {
        return createDatabase(CreateDatabaseRequest.builder().applyMutation(createDatabaseRequest).build());
    }

    /**
     * <p>
     * Creates a new development endpoint.
     * </p>
     *
     * @param createDevEndpointRequest
     * @return A Java Future containing the result of the CreateDevEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>IdempotentParameterMismatchException The same unique identifier was associated with two different
     *         records.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateDevEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateDevEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDevEndpointResponse> createDevEndpoint(CreateDevEndpointRequest createDevEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new development endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDevEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDevEndpointRequest#builder()}
     * </p>
     *
     * @param createDevEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CreateDevEndpointRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDevEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>IdempotentParameterMismatchException The same unique identifier was associated with two different
     *         records.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateDevEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateDevEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDevEndpointResponse> createDevEndpoint(
            Consumer<CreateDevEndpointRequest.Builder> createDevEndpointRequest) {
        return createDevEndpoint(CreateDevEndpointRequest.builder().applyMutation(createDevEndpointRequest).build());
    }

    /**
     * <p>
     * Creates a Zero-ETL integration in the caller's account between two resources with Amazon Resource Names (ARNs):
     * the <code>SourceArn</code> and <code>TargetArn</code>.
     * </p>
     *
     * @param createIntegrationRequest
     * @return A Java Future containing the result of the CreateIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InternalServerException An internal server error occurred.</li>
     *         <li>IntegrationConflictOperationException The requested operation conflicts with another operation.</li>
     *         <li>IntegrationQuotaExceededException The data processed through your integration exceeded your quota.</li>
     *         <li>KmsKeyNotAccessibleException The KMS key specified is not accessible.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>ConflictException The <code>CreatePartitions</code> API was called on a table that has indexes
     *         enabled.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateIntegration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIntegrationResponse> createIntegration(CreateIntegrationRequest createIntegrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Zero-ETL integration in the caller's account between two resources with Amazon Resource Names (ARNs):
     * the <code>SourceArn</code> and <code>TargetArn</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIntegrationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateIntegrationRequest#builder()}
     * </p>
     *
     * @param createIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CreateIntegrationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InternalServerException An internal server error occurred.</li>
     *         <li>IntegrationConflictOperationException The requested operation conflicts with another operation.</li>
     *         <li>IntegrationQuotaExceededException The data processed through your integration exceeded your quota.</li>
     *         <li>KmsKeyNotAccessibleException The KMS key specified is not accessible.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>ConflictException The <code>CreatePartitions</code> API was called on a table that has indexes
     *         enabled.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateIntegration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIntegrationResponse> createIntegration(
            Consumer<CreateIntegrationRequest.Builder> createIntegrationRequest) {
        return createIntegration(CreateIntegrationRequest.builder().applyMutation(createIntegrationRequest).build());
    }

    /**
     * <p>
     * This API can be used for setting up the <code>ResourceProperty</code> of the Glue connection (for the source) or
     * Glue database ARN (for the target). These properties can include the role to access the connection or database.
     * To set both source and target properties the same API needs to be invoked with the Glue connection ARN as
     * <code>ResourceArn</code> with <code>SourceProcessingProperties</code> and the Glue database ARN as
     * <code>ResourceArn</code> with <code>TargetProcessingProperties</code> respectively.
     * </p>
     *
     * @param createIntegrationResourcePropertyRequest
     * @return A Java Future containing the result of the CreateIntegrationResourceProperty operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>ConflictException The <code>CreatePartitions</code> API was called on a table that has indexes
     *         enabled.</li>
     *         <li>InternalServerException An internal server error occurred.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateIntegrationResourceProperty
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateIntegrationResourceProperty"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateIntegrationResourcePropertyResponse> createIntegrationResourceProperty(
            CreateIntegrationResourcePropertyRequest createIntegrationResourcePropertyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API can be used for setting up the <code>ResourceProperty</code> of the Glue connection (for the source) or
     * Glue database ARN (for the target). These properties can include the role to access the connection or database.
     * To set both source and target properties the same API needs to be invoked with the Glue connection ARN as
     * <code>ResourceArn</code> with <code>SourceProcessingProperties</code> and the Glue database ARN as
     * <code>ResourceArn</code> with <code>TargetProcessingProperties</code> respectively.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIntegrationResourcePropertyRequest.Builder}
     * avoiding the need to create one manually via {@link CreateIntegrationResourcePropertyRequest#builder()}
     * </p>
     *
     * @param createIntegrationResourcePropertyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CreateIntegrationResourcePropertyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateIntegrationResourceProperty operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>ConflictException The <code>CreatePartitions</code> API was called on a table that has indexes
     *         enabled.</li>
     *         <li>InternalServerException An internal server error occurred.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateIntegrationResourceProperty
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateIntegrationResourceProperty"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateIntegrationResourcePropertyResponse> createIntegrationResourceProperty(
            Consumer<CreateIntegrationResourcePropertyRequest.Builder> createIntegrationResourcePropertyRequest) {
        return createIntegrationResourceProperty(CreateIntegrationResourcePropertyRequest.builder()
                .applyMutation(createIntegrationResourcePropertyRequest).build());
    }

    /**
     * <p>
     * This API is used to provide optional override properties for the the tables that need to be replicated. These
     * properties can include properties for filtering and partitioning for the source and target tables. To set both
     * source and target properties the same API need to be invoked with the Glue connection ARN as
     * <code>ResourceArn</code> with <code>SourceTableConfig</code>, and the Glue database ARN as
     * <code>ResourceArn</code> with <code>TargetTableConfig</code> respectively.
     * </p>
     *
     * @param createIntegrationTablePropertiesRequest
     * @return A Java Future containing the result of the CreateIntegrationTableProperties operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InternalServerException An internal server error occurred.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateIntegrationTableProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateIntegrationTableProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateIntegrationTablePropertiesResponse> createIntegrationTableProperties(
            CreateIntegrationTablePropertiesRequest createIntegrationTablePropertiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is used to provide optional override properties for the the tables that need to be replicated. These
     * properties can include properties for filtering and partitioning for the source and target tables. To set both
     * source and target properties the same API need to be invoked with the Glue connection ARN as
     * <code>ResourceArn</code> with <code>SourceTableConfig</code>, and the Glue database ARN as
     * <code>ResourceArn</code> with <code>TargetTableConfig</code> respectively.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIntegrationTablePropertiesRequest.Builder}
     * avoiding the need to create one manually via {@link CreateIntegrationTablePropertiesRequest#builder()}
     * </p>
     *
     * @param createIntegrationTablePropertiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CreateIntegrationTablePropertiesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateIntegrationTableProperties operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InternalServerException An internal server error occurred.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateIntegrationTableProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateIntegrationTableProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateIntegrationTablePropertiesResponse> createIntegrationTableProperties(
            Consumer<CreateIntegrationTablePropertiesRequest.Builder> createIntegrationTablePropertiesRequest) {
        return createIntegrationTableProperties(CreateIntegrationTablePropertiesRequest.builder()
                .applyMutation(createIntegrationTablePropertiesRequest).build());
    }

    /**
     * <p>
     * Creates a new job definition.
     * </p>
     *
     * @param createJobRequest
     * @return A Java Future containing the result of the CreateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>IdempotentParameterMismatchException The same unique identifier was associated with two different
     *         records.</li>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateJobResponse> createJob(CreateJobRequest createJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new job definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateJobRequest.Builder} avoiding the need to
     * create one manually via {@link CreateJobRequest#builder()}
     * </p>
     *
     * @param createJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CreateJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>IdempotentParameterMismatchException The same unique identifier was associated with two different
     *         records.</li>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateJobResponse> createJob(Consumer<CreateJobRequest.Builder> createJobRequest) {
        return createJob(CreateJobRequest.builder().applyMutation(createJobRequest).build());
    }

    /**
     * <p>
     * Creates an Glue machine learning transform. This operation creates the transform and all the necessary parameters
     * to train it.
     * </p>
     * <p>
     * Call this operation as the first step in the process of using a machine learning transform (such as the
     * <code>FindMatches</code> transform) for deduplicating data. You can provide an optional <code>Description</code>,
     * in addition to the parameters that you want to use for your algorithm.
     * </p>
     * <p>
     * You must also specify certain parameters for the tasks that Glue runs on your behalf as part of learning from
     * your data and creating a high-quality machine learning transform. These parameters include <code>Role</code>, and
     * optionally, <code>AllocatedCapacity</code>, <code>Timeout</code>, and <code>MaxRetries</code>. For more
     * information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html">Jobs</a>.
     * </p>
     *
     * @param createMlTransformRequest
     * @return A Java Future containing the result of the CreateMLTransform operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>IdempotentParameterMismatchException The same unique identifier was associated with two different
     *         records.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateMLTransform
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateMLTransform" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateMlTransformResponse> createMLTransform(CreateMlTransformRequest createMlTransformRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Glue machine learning transform. This operation creates the transform and all the necessary parameters
     * to train it.
     * </p>
     * <p>
     * Call this operation as the first step in the process of using a machine learning transform (such as the
     * <code>FindMatches</code> transform) for deduplicating data. You can provide an optional <code>Description</code>,
     * in addition to the parameters that you want to use for your algorithm.
     * </p>
     * <p>
     * You must also specify certain parameters for the tasks that Glue runs on your behalf as part of learning from
     * your data and creating a high-quality machine learning transform. These parameters include <code>Role</code>, and
     * optionally, <code>AllocatedCapacity</code>, <code>Timeout</code>, and <code>MaxRetries</code>. For more
     * information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html">Jobs</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMlTransformRequest.Builder} avoiding the need
     * to create one manually via {@link CreateMlTransformRequest#builder()}
     * </p>
     *
     * @param createMlTransformRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CreateMlTransformRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateMLTransform operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>IdempotentParameterMismatchException The same unique identifier was associated with two different
     *         records.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateMLTransform
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateMLTransform" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateMlTransformResponse> createMLTransform(
            Consumer<CreateMlTransformRequest.Builder> createMlTransformRequest) {
        return createMLTransform(CreateMlTransformRequest.builder().applyMutation(createMlTransformRequest).build());
    }

    /**
     * <p>
     * Creates a new partition.
     * </p>
     *
     * @param createPartitionRequest
     * @return A Java Future containing the result of the CreatePartition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreatePartition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreatePartition" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePartitionResponse> createPartition(CreatePartitionRequest createPartitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new partition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePartitionRequest.Builder} avoiding the need
     * to create one manually via {@link CreatePartitionRequest#builder()}
     * </p>
     *
     * @param createPartitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CreatePartitionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreatePartition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreatePartition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreatePartition" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePartitionResponse> createPartition(
            Consumer<CreatePartitionRequest.Builder> createPartitionRequest) {
        return createPartition(CreatePartitionRequest.builder().applyMutation(createPartitionRequest).build());
    }

    /**
     * <p>
     * Creates a specified partition index in an existing table.
     * </p>
     *
     * @param createPartitionIndexRequest
     * @return A Java Future containing the result of the CreatePartitionIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreatePartitionIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreatePartitionIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePartitionIndexResponse> createPartitionIndex(
            CreatePartitionIndexRequest createPartitionIndexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a specified partition index in an existing table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePartitionIndexRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePartitionIndexRequest#builder()}
     * </p>
     *
     * @param createPartitionIndexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CreatePartitionIndexRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreatePartitionIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreatePartitionIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreatePartitionIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePartitionIndexResponse> createPartitionIndex(
            Consumer<CreatePartitionIndexRequest.Builder> createPartitionIndexRequest) {
        return createPartitionIndex(CreatePartitionIndexRequest.builder().applyMutation(createPartitionIndexRequest).build());
    }

    /**
     * <p>
     * Creates a new registry which may be used to hold a collection of schemas.
     * </p>
     *
     * @param createRegistryRequest
     * @return A Java Future containing the result of the CreateRegistry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateRegistry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRegistryResponse> createRegistry(CreateRegistryRequest createRegistryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new registry which may be used to hold a collection of schemas.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRegistryRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRegistryRequest#builder()}
     * </p>
     *
     * @param createRegistryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CreateRegistryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateRegistry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateRegistry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRegistryResponse> createRegistry(Consumer<CreateRegistryRequest.Builder> createRegistryRequest) {
        return createRegistry(CreateRegistryRequest.builder().applyMutation(createRegistryRequest).build());
    }

    /**
     * <p>
     * Creates a new schema set and registers the schema definition. Returns an error if the schema set already exists
     * without actually registering the version.
     * </p>
     * <p>
     * When the schema set is created, a version checkpoint will be set to the first version. Compatibility mode
     * "DISABLED" restricts any additional schema versions from being added after the first schema version. For all
     * other compatibility modes, validation of compatibility settings will be applied only from the second version
     * onwards when the <code>RegisterSchemaVersion</code> API is used.
     * </p>
     * <p>
     * When this API is called without a <code>RegistryId</code>, this will create an entry for a "default-registry" in
     * the registry database tables, if it is not already present.
     * </p>
     *
     * @param createSchemaRequest
     * @return A Java Future containing the result of the CreateSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSchemaResponse> createSchema(CreateSchemaRequest createSchemaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new schema set and registers the schema definition. Returns an error if the schema set already exists
     * without actually registering the version.
     * </p>
     * <p>
     * When the schema set is created, a version checkpoint will be set to the first version. Compatibility mode
     * "DISABLED" restricts any additional schema versions from being added after the first schema version. For all
     * other compatibility modes, validation of compatibility settings will be applied only from the second version
     * onwards when the <code>RegisterSchemaVersion</code> API is used.
     * </p>
     * <p>
     * When this API is called without a <code>RegistryId</code>, this will create an entry for a "default-registry" in
     * the registry database tables, if it is not already present.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSchemaRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSchemaRequest#builder()}
     * </p>
     *
     * @param createSchemaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CreateSchemaRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSchemaResponse> createSchema(Consumer<CreateSchemaRequest.Builder> createSchemaRequest) {
        return createSchema(CreateSchemaRequest.builder().applyMutation(createSchemaRequest).build());
    }

    /**
     * <p>
     * Transforms a directed acyclic graph (DAG) into code.
     * </p>
     *
     * @param createScriptRequest
     * @return A Java Future containing the result of the CreateScript operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateScript" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateScriptResponse> createScript(CreateScriptRequest createScriptRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Transforms a directed acyclic graph (DAG) into code.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateScriptRequest.Builder} avoiding the need to
     * create one manually via {@link CreateScriptRequest#builder()}
     * </p>
     *
     * @param createScriptRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CreateScriptRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateScript operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateScript" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateScriptResponse> createScript(Consumer<CreateScriptRequest.Builder> createScriptRequest) {
        return createScript(CreateScriptRequest.builder().applyMutation(createScriptRequest).build());
    }

    /**
     * <p>
     * Creates a new security configuration. A security configuration is a set of security properties that can be used
     * by Glue. You can use a security configuration to encrypt data at rest. For information about using security
     * configurations in Glue, see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/encryption-security-configuration.html">Encrypting Data Written
     * by Crawlers, Jobs, and Development Endpoints</a>.
     * </p>
     *
     * @param createSecurityConfigurationRequest
     * @return A Java Future containing the result of the CreateSecurityConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateSecurityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateSecurityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSecurityConfigurationResponse> createSecurityConfiguration(
            CreateSecurityConfigurationRequest createSecurityConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new security configuration. A security configuration is a set of security properties that can be used
     * by Glue. You can use a security configuration to encrypt data at rest. For information about using security
     * configurations in Glue, see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/encryption-security-configuration.html">Encrypting Data Written
     * by Crawlers, Jobs, and Development Endpoints</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSecurityConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateSecurityConfigurationRequest#builder()}
     * </p>
     *
     * @param createSecurityConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CreateSecurityConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSecurityConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateSecurityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateSecurityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSecurityConfigurationResponse> createSecurityConfiguration(
            Consumer<CreateSecurityConfigurationRequest.Builder> createSecurityConfigurationRequest) {
        return createSecurityConfiguration(CreateSecurityConfigurationRequest.builder()
                .applyMutation(createSecurityConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a new session.
     * </p>
     *
     * @param createSessionRequest
     *        Request to create a new session.
     * @return A Java Future containing the result of the CreateSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>IdempotentParameterMismatchException The same unique identifier was associated with two different
     *         records.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSessionResponse> createSession(CreateSessionRequest createSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSessionRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSessionRequest#builder()}
     * </p>
     *
     * @param createSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CreateSessionRequest.Builder} to create a request.
     *        Request to create a new session.
     * @return A Java Future containing the result of the CreateSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>IdempotentParameterMismatchException The same unique identifier was associated with two different
     *         records.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSessionResponse> createSession(Consumer<CreateSessionRequest.Builder> createSessionRequest) {
        return createSession(CreateSessionRequest.builder().applyMutation(createSessionRequest).build());
    }

    /**
     * <p>
     * Creates a new table definition in the Data Catalog.
     * </p>
     *
     * @param createTableRequest
     * @return A Java Future containing the result of the CreateTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>ResourceNotReadyException A resource was not ready for a transaction.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTableResponse> createTable(CreateTableRequest createTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new table definition in the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTableRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTableRequest#builder()}
     * </p>
     *
     * @param createTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CreateTableRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>ResourceNotReadyException A resource was not ready for a transaction.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTableResponse> createTable(Consumer<CreateTableRequest.Builder> createTableRequest) {
        return createTable(CreateTableRequest.builder().applyMutation(createTableRequest).build());
    }

    /**
     * <p>
     * Creates a new table optimizer for a specific function.
     * </p>
     *
     * @param createTableOptimizerRequest
     * @return A Java Future containing the result of the CreateTableOptimizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>ThrottlingException The throttling threshhold was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateTableOptimizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateTableOptimizer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTableOptimizerResponse> createTableOptimizer(
            CreateTableOptimizerRequest createTableOptimizerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new table optimizer for a specific function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTableOptimizerRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTableOptimizerRequest#builder()}
     * </p>
     *
     * @param createTableOptimizerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CreateTableOptimizerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateTableOptimizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>ThrottlingException The throttling threshhold was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateTableOptimizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateTableOptimizer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTableOptimizerResponse> createTableOptimizer(
            Consumer<CreateTableOptimizerRequest.Builder> createTableOptimizerRequest) {
        return createTableOptimizer(CreateTableOptimizerRequest.builder().applyMutation(createTableOptimizerRequest).build());
    }

    /**
     * <p>
     * Creates a new trigger.
     * </p>
     *
     * @param createTriggerRequest
     * @return A Java Future containing the result of the CreateTrigger operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>IdempotentParameterMismatchException The same unique identifier was associated with two different
     *         records.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateTrigger
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateTrigger" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTriggerResponse> createTrigger(CreateTriggerRequest createTriggerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new trigger.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTriggerRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTriggerRequest#builder()}
     * </p>
     *
     * @param createTriggerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CreateTriggerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateTrigger operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>IdempotentParameterMismatchException The same unique identifier was associated with two different
     *         records.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateTrigger
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateTrigger" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTriggerResponse> createTrigger(Consumer<CreateTriggerRequest.Builder> createTriggerRequest) {
        return createTrigger(CreateTriggerRequest.builder().applyMutation(createTriggerRequest).build());
    }

    /**
     * <p>
     * Creates an Glue usage profile.
     * </p>
     *
     * @param createUsageProfileRequest
     * @return A Java Future containing the result of the CreateUsageProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>OperationNotSupportedException The operation is not available in the region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateUsageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateUsageProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUsageProfileResponse> createUsageProfile(CreateUsageProfileRequest createUsageProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Glue usage profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUsageProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateUsageProfileRequest#builder()}
     * </p>
     *
     * @param createUsageProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CreateUsageProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateUsageProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>OperationNotSupportedException The operation is not available in the region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateUsageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateUsageProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUsageProfileResponse> createUsageProfile(
            Consumer<CreateUsageProfileRequest.Builder> createUsageProfileRequest) {
        return createUsageProfile(CreateUsageProfileRequest.builder().applyMutation(createUsageProfileRequest).build());
    }

    /**
     * <p>
     * Creates a new function definition in the Data Catalog.
     * </p>
     *
     * @param createUserDefinedFunctionRequest
     * @return A Java Future containing the result of the CreateUserDefinedFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateUserDefinedFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateUserDefinedFunction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUserDefinedFunctionResponse> createUserDefinedFunction(
            CreateUserDefinedFunctionRequest createUserDefinedFunctionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new function definition in the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserDefinedFunctionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateUserDefinedFunctionRequest#builder()}
     * </p>
     *
     * @param createUserDefinedFunctionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CreateUserDefinedFunctionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateUserDefinedFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateUserDefinedFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateUserDefinedFunction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUserDefinedFunctionResponse> createUserDefinedFunction(
            Consumer<CreateUserDefinedFunctionRequest.Builder> createUserDefinedFunctionRequest) {
        return createUserDefinedFunction(CreateUserDefinedFunctionRequest.builder()
                .applyMutation(createUserDefinedFunctionRequest).build());
    }

    /**
     * <p>
     * Creates a new workflow.
     * </p>
     *
     * @param createWorkflowRequest
     * @return A Java Future containing the result of the CreateWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWorkflowResponse> createWorkflow(CreateWorkflowRequest createWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link CreateWorkflowRequest#builder()}
     * </p>
     *
     * @param createWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.CreateWorkflowRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AlreadyExistsException A resource to be created or added already exists.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ResourceNumberLimitExceededException A resource numerical limit was exceeded.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.CreateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWorkflowResponse> createWorkflow(Consumer<CreateWorkflowRequest.Builder> createWorkflowRequest) {
        return createWorkflow(CreateWorkflowRequest.builder().applyMutation(createWorkflowRequest).build());
    }

    /**
     * <p>
     * Deletes an existing blueprint.
     * </p>
     *
     * @param deleteBlueprintRequest
     * @return A Java Future containing the result of the DeleteBlueprint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteBlueprint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteBlueprintResponse> deleteBlueprint(DeleteBlueprintRequest deleteBlueprintRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing blueprint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBlueprintRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteBlueprintRequest#builder()}
     * </p>
     *
     * @param deleteBlueprintRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteBlueprintRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteBlueprint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteBlueprint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteBlueprintResponse> deleteBlueprint(
            Consumer<DeleteBlueprintRequest.Builder> deleteBlueprintRequest) {
        return deleteBlueprint(DeleteBlueprintRequest.builder().applyMutation(deleteBlueprintRequest).build());
    }

    /**
     * <p>
     * Removes the specified catalog from the Glue Data Catalog.
     * </p>
     * <p>
     * After completing this operation, you no longer have access to the databases, tables (and all table versions and
     * partitions that might belong to the tables) and the user-defined functions in the deleted catalog. Glue deletes
     * these "orphaned" resources asynchronously in a timely manner, at the discretion of the service.
     * </p>
     * <p>
     * To ensure the immediate deletion of all related resources before calling the <code>DeleteCatalog</code>
     * operation, use <code>DeleteTableVersion</code> (or <code>BatchDeleteTableVersion</code>),
     * <code>DeletePartition</code> (or <code>BatchDeletePartition</code>), <code>DeleteTable</code> (or
     * <code>BatchDeleteTable</code>), <code>DeleteUserDefinedFunction</code> and <code>DeleteDatabase</code> to delete
     * any resources that belong to the catalog.
     * </p>
     *
     * @param deleteCatalogRequest
     * @return A Java Future containing the result of the DeleteCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteCatalogResponse> deleteCatalog(DeleteCatalogRequest deleteCatalogRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified catalog from the Glue Data Catalog.
     * </p>
     * <p>
     * After completing this operation, you no longer have access to the databases, tables (and all table versions and
     * partitions that might belong to the tables) and the user-defined functions in the deleted catalog. Glue deletes
     * these "orphaned" resources asynchronously in a timely manner, at the discretion of the service.
     * </p>
     * <p>
     * To ensure the immediate deletion of all related resources before calling the <code>DeleteCatalog</code>
     * operation, use <code>DeleteTableVersion</code> (or <code>BatchDeleteTableVersion</code>),
     * <code>DeletePartition</code> (or <code>BatchDeletePartition</code>), <code>DeleteTable</code> (or
     * <code>BatchDeleteTable</code>), <code>DeleteUserDefinedFunction</code> and <code>DeleteDatabase</code> to delete
     * any resources that belong to the catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCatalogRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteCatalogRequest#builder()}
     * </p>
     *
     * @param deleteCatalogRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteCatalogRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteCatalogResponse> deleteCatalog(Consumer<DeleteCatalogRequest.Builder> deleteCatalogRequest) {
        return deleteCatalog(DeleteCatalogRequest.builder().applyMutation(deleteCatalogRequest).build());
    }

    /**
     * <p>
     * Removes a classifier from the Data Catalog.
     * </p>
     *
     * @param deleteClassifierRequest
     * @return A Java Future containing the result of the DeleteClassifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteClassifier" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteClassifierResponse> deleteClassifier(DeleteClassifierRequest deleteClassifierRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a classifier from the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClassifierRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteClassifierRequest#builder()}
     * </p>
     *
     * @param deleteClassifierRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteClassifierRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteClassifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteClassifier" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteClassifierResponse> deleteClassifier(
            Consumer<DeleteClassifierRequest.Builder> deleteClassifierRequest) {
        return deleteClassifier(DeleteClassifierRequest.builder().applyMutation(deleteClassifierRequest).build());
    }

    /**
     * <p>
     * Delete the partition column statistics of a column.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) permission required for this operation is <code>DeletePartition</code>.
     * </p>
     *
     * @param deleteColumnStatisticsForPartitionRequest
     * @return A Java Future containing the result of the DeleteColumnStatisticsForPartition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteColumnStatisticsForPartition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteColumnStatisticsForPartition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteColumnStatisticsForPartitionResponse> deleteColumnStatisticsForPartition(
            DeleteColumnStatisticsForPartitionRequest deleteColumnStatisticsForPartitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the partition column statistics of a column.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) permission required for this operation is <code>DeletePartition</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteColumnStatisticsForPartitionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteColumnStatisticsForPartitionRequest#builder()}
     * </p>
     *
     * @param deleteColumnStatisticsForPartitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteColumnStatisticsForPartitionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteColumnStatisticsForPartition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteColumnStatisticsForPartition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteColumnStatisticsForPartition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteColumnStatisticsForPartitionResponse> deleteColumnStatisticsForPartition(
            Consumer<DeleteColumnStatisticsForPartitionRequest.Builder> deleteColumnStatisticsForPartitionRequest) {
        return deleteColumnStatisticsForPartition(DeleteColumnStatisticsForPartitionRequest.builder()
                .applyMutation(deleteColumnStatisticsForPartitionRequest).build());
    }

    /**
     * <p>
     * Retrieves table statistics of columns.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) permission required for this operation is <code>DeleteTable</code>.
     * </p>
     *
     * @param deleteColumnStatisticsForTableRequest
     * @return A Java Future containing the result of the DeleteColumnStatisticsForTable operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteColumnStatisticsForTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteColumnStatisticsForTable"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteColumnStatisticsForTableResponse> deleteColumnStatisticsForTable(
            DeleteColumnStatisticsForTableRequest deleteColumnStatisticsForTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves table statistics of columns.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) permission required for this operation is <code>DeleteTable</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteColumnStatisticsForTableRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteColumnStatisticsForTableRequest#builder()}
     * </p>
     *
     * @param deleteColumnStatisticsForTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteColumnStatisticsForTableRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteColumnStatisticsForTable operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteColumnStatisticsForTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteColumnStatisticsForTable"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteColumnStatisticsForTableResponse> deleteColumnStatisticsForTable(
            Consumer<DeleteColumnStatisticsForTableRequest.Builder> deleteColumnStatisticsForTableRequest) {
        return deleteColumnStatisticsForTable(DeleteColumnStatisticsForTableRequest.builder()
                .applyMutation(deleteColumnStatisticsForTableRequest).build());
    }

    /**
     * <p>
     * Deletes settings for a column statistics task.
     * </p>
     *
     * @param deleteColumnStatisticsTaskSettingsRequest
     * @return A Java Future containing the result of the DeleteColumnStatisticsTaskSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteColumnStatisticsTaskSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteColumnStatisticsTaskSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteColumnStatisticsTaskSettingsResponse> deleteColumnStatisticsTaskSettings(
            DeleteColumnStatisticsTaskSettingsRequest deleteColumnStatisticsTaskSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes settings for a column statistics task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteColumnStatisticsTaskSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteColumnStatisticsTaskSettingsRequest#builder()}
     * </p>
     *
     * @param deleteColumnStatisticsTaskSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteColumnStatisticsTaskSettingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteColumnStatisticsTaskSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteColumnStatisticsTaskSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteColumnStatisticsTaskSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteColumnStatisticsTaskSettingsResponse> deleteColumnStatisticsTaskSettings(
            Consumer<DeleteColumnStatisticsTaskSettingsRequest.Builder> deleteColumnStatisticsTaskSettingsRequest) {
        return deleteColumnStatisticsTaskSettings(DeleteColumnStatisticsTaskSettingsRequest.builder()
                .applyMutation(deleteColumnStatisticsTaskSettingsRequest).build());
    }

    /**
     * <p>
     * Deletes a connection from the Data Catalog.
     * </p>
     *
     * @param deleteConnectionRequest
     * @return A Java Future containing the result of the DeleteConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteConnectionResponse> deleteConnection(DeleteConnectionRequest deleteConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a connection from the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteConnectionRequest#builder()}
     * </p>
     *
     * @param deleteConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteConnectionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteConnectionResponse> deleteConnection(
            Consumer<DeleteConnectionRequest.Builder> deleteConnectionRequest) {
        return deleteConnection(DeleteConnectionRequest.builder().applyMutation(deleteConnectionRequest).build());
    }

    /**
     * <p>
     * Removes a specified crawler from the Glue Data Catalog, unless the crawler state is <code>RUNNING</code>.
     * </p>
     *
     * @param deleteCrawlerRequest
     * @return A Java Future containing the result of the DeleteCrawler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>CrawlerRunningException The operation cannot be performed because the crawler is already running.</li>
     *         <li>SchedulerTransitioningException The specified scheduler is transitioning.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteCrawler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteCrawler" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteCrawlerResponse> deleteCrawler(DeleteCrawlerRequest deleteCrawlerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a specified crawler from the Glue Data Catalog, unless the crawler state is <code>RUNNING</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCrawlerRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteCrawlerRequest#builder()}
     * </p>
     *
     * @param deleteCrawlerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteCrawlerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteCrawler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>CrawlerRunningException The operation cannot be performed because the crawler is already running.</li>
     *         <li>SchedulerTransitioningException The specified scheduler is transitioning.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteCrawler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteCrawler" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteCrawlerResponse> deleteCrawler(Consumer<DeleteCrawlerRequest.Builder> deleteCrawlerRequest) {
        return deleteCrawler(DeleteCrawlerRequest.builder().applyMutation(deleteCrawlerRequest).build());
    }

    /**
     * <p>
     * Deletes a custom pattern by specifying its name.
     * </p>
     *
     * @param deleteCustomEntityTypeRequest
     * @return A Java Future containing the result of the DeleteCustomEntityType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteCustomEntityType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteCustomEntityType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteCustomEntityTypeResponse> deleteCustomEntityType(
            DeleteCustomEntityTypeRequest deleteCustomEntityTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom pattern by specifying its name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCustomEntityTypeRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCustomEntityTypeRequest#builder()}
     * </p>
     *
     * @param deleteCustomEntityTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteCustomEntityTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteCustomEntityType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteCustomEntityType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteCustomEntityType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteCustomEntityTypeResponse> deleteCustomEntityType(
            Consumer<DeleteCustomEntityTypeRequest.Builder> deleteCustomEntityTypeRequest) {
        return deleteCustomEntityType(DeleteCustomEntityTypeRequest.builder().applyMutation(deleteCustomEntityTypeRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a data quality ruleset.
     * </p>
     *
     * @param deleteDataQualityRulesetRequest
     * @return A Java Future containing the result of the DeleteDataQualityRuleset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteDataQualityRuleset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteDataQualityRuleset" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDataQualityRulesetResponse> deleteDataQualityRuleset(
            DeleteDataQualityRulesetRequest deleteDataQualityRulesetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a data quality ruleset.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataQualityRulesetRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDataQualityRulesetRequest#builder()}
     * </p>
     *
     * @param deleteDataQualityRulesetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteDataQualityRulesetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDataQualityRuleset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteDataQualityRuleset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteDataQualityRuleset" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDataQualityRulesetResponse> deleteDataQualityRuleset(
            Consumer<DeleteDataQualityRulesetRequest.Builder> deleteDataQualityRulesetRequest) {
        return deleteDataQualityRuleset(DeleteDataQualityRulesetRequest.builder().applyMutation(deleteDataQualityRulesetRequest)
                .build());
    }

    /**
     * <p>
     * Removes a specified database from a Data Catalog.
     * </p>
     * <note>
     * <p>
     * After completing this operation, you no longer have access to the tables (and all table versions and partitions
     * that might belong to the tables) and the user-defined functions in the deleted database. Glue deletes these
     * "orphaned" resources asynchronously in a timely manner, at the discretion of the service.
     * </p>
     * <p>
     * To ensure the immediate deletion of all related resources, before calling <code>DeleteDatabase</code>, use
     * <code>DeleteTableVersion</code> or <code>BatchDeleteTableVersion</code>, <code>DeletePartition</code> or
     * <code>BatchDeletePartition</code>, <code>DeleteUserDefinedFunction</code>, and <code>DeleteTable</code> or
     * <code>BatchDeleteTable</code>, to delete any resources that belong to the database.
     * </p>
     * </note>
     *
     * @param deleteDatabaseRequest
     * @return A Java Future containing the result of the DeleteDatabase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDatabaseResponse> deleteDatabase(DeleteDatabaseRequest deleteDatabaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a specified database from a Data Catalog.
     * </p>
     * <note>
     * <p>
     * After completing this operation, you no longer have access to the tables (and all table versions and partitions
     * that might belong to the tables) and the user-defined functions in the deleted database. Glue deletes these
     * "orphaned" resources asynchronously in a timely manner, at the discretion of the service.
     * </p>
     * <p>
     * To ensure the immediate deletion of all related resources, before calling <code>DeleteDatabase</code>, use
     * <code>DeleteTableVersion</code> or <code>BatchDeleteTableVersion</code>, <code>DeletePartition</code> or
     * <code>BatchDeletePartition</code>, <code>DeleteUserDefinedFunction</code>, and <code>DeleteTable</code> or
     * <code>BatchDeleteTable</code>, to delete any resources that belong to the database.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDatabaseRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDatabaseRequest#builder()}
     * </p>
     *
     * @param deleteDatabaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteDatabaseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDatabase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDatabaseResponse> deleteDatabase(Consumer<DeleteDatabaseRequest.Builder> deleteDatabaseRequest) {
        return deleteDatabase(DeleteDatabaseRequest.builder().applyMutation(deleteDatabaseRequest).build());
    }

    /**
     * <p>
     * Deletes a specified development endpoint.
     * </p>
     *
     * @param deleteDevEndpointRequest
     * @return A Java Future containing the result of the DeleteDevEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteDevEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteDevEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDevEndpointResponse> deleteDevEndpoint(DeleteDevEndpointRequest deleteDevEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified development endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDevEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDevEndpointRequest#builder()}
     * </p>
     *
     * @param deleteDevEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteDevEndpointRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDevEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteDevEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteDevEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDevEndpointResponse> deleteDevEndpoint(
            Consumer<DeleteDevEndpointRequest.Builder> deleteDevEndpointRequest) {
        return deleteDevEndpoint(DeleteDevEndpointRequest.builder().applyMutation(deleteDevEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Zero-ETL integration.
     * </p>
     *
     * @param deleteIntegrationRequest
     * @return A Java Future containing the result of the DeleteIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>InternalServerException An internal server error occurred.</li>
     *         <li>IntegrationNotFoundException The specified integration could not be found.</li>
     *         <li>IntegrationConflictOperationException The requested operation conflicts with another operation.</li>
     *         <li>InvalidIntegrationStateException The integration is in an invalid state.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>ConflictException The <code>CreatePartitions</code> API was called on a table that has indexes
     *         enabled.</li>
     *         <li>InvalidStateException An error that indicates your data is in an invalid state.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteIntegration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIntegrationResponse> deleteIntegration(DeleteIntegrationRequest deleteIntegrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Zero-ETL integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIntegrationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteIntegrationRequest#builder()}
     * </p>
     *
     * @param deleteIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteIntegrationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>InternalServerException An internal server error occurred.</li>
     *         <li>IntegrationNotFoundException The specified integration could not be found.</li>
     *         <li>IntegrationConflictOperationException The requested operation conflicts with another operation.</li>
     *         <li>InvalidIntegrationStateException The integration is in an invalid state.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>ConflictException The <code>CreatePartitions</code> API was called on a table that has indexes
     *         enabled.</li>
     *         <li>InvalidStateException An error that indicates your data is in an invalid state.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteIntegration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIntegrationResponse> deleteIntegration(
            Consumer<DeleteIntegrationRequest.Builder> deleteIntegrationRequest) {
        return deleteIntegration(DeleteIntegrationRequest.builder().applyMutation(deleteIntegrationRequest).build());
    }

    /**
     * <p>
     * Deletes the table properties that have been created for the tables that need to be replicated.
     * </p>
     *
     * @param deleteIntegrationTablePropertiesRequest
     * @return A Java Future containing the result of the DeleteIntegrationTableProperties operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InternalServerException An internal server error occurred.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteIntegrationTableProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteIntegrationTableProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteIntegrationTablePropertiesResponse> deleteIntegrationTableProperties(
            DeleteIntegrationTablePropertiesRequest deleteIntegrationTablePropertiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the table properties that have been created for the tables that need to be replicated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIntegrationTablePropertiesRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteIntegrationTablePropertiesRequest#builder()}
     * </p>
     *
     * @param deleteIntegrationTablePropertiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteIntegrationTablePropertiesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteIntegrationTableProperties operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InternalServerException An internal server error occurred.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteIntegrationTableProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteIntegrationTableProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteIntegrationTablePropertiesResponse> deleteIntegrationTableProperties(
            Consumer<DeleteIntegrationTablePropertiesRequest.Builder> deleteIntegrationTablePropertiesRequest) {
        return deleteIntegrationTableProperties(DeleteIntegrationTablePropertiesRequest.builder()
                .applyMutation(deleteIntegrationTablePropertiesRequest).build());
    }

    /**
     * <p>
     * Deletes a specified job definition. If the job definition is not found, no exception is thrown.
     * </p>
     *
     * @param deleteJobRequest
     * @return A Java Future containing the result of the DeleteJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteJobResponse> deleteJob(DeleteJobRequest deleteJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified job definition. If the job definition is not found, no exception is thrown.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteJobRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteJobRequest#builder()}
     * </p>
     *
     * @param deleteJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteJobResponse> deleteJob(Consumer<DeleteJobRequest.Builder> deleteJobRequest) {
        return deleteJob(DeleteJobRequest.builder().applyMutation(deleteJobRequest).build());
    }

    /**
     * <p>
     * Deletes an Glue machine learning transform. Machine learning transforms are a special type of transform that use
     * machine learning to learn the details of the transformation to be performed by learning from examples provided by
     * humans. These transformations are then saved by Glue. If you no longer need a transform, you can delete it by
     * calling <code>DeleteMLTransforms</code>. However, any Glue jobs that still reference the deleted transform will
     * no longer succeed.
     * </p>
     *
     * @param deleteMlTransformRequest
     * @return A Java Future containing the result of the DeleteMLTransform operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteMLTransform
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteMLTransform" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteMlTransformResponse> deleteMLTransform(DeleteMlTransformRequest deleteMlTransformRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Glue machine learning transform. Machine learning transforms are a special type of transform that use
     * machine learning to learn the details of the transformation to be performed by learning from examples provided by
     * humans. These transformations are then saved by Glue. If you no longer need a transform, you can delete it by
     * calling <code>DeleteMLTransforms</code>. However, any Glue jobs that still reference the deleted transform will
     * no longer succeed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMlTransformRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteMlTransformRequest#builder()}
     * </p>
     *
     * @param deleteMlTransformRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteMlTransformRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteMLTransform operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteMLTransform
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteMLTransform" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteMlTransformResponse> deleteMLTransform(
            Consumer<DeleteMlTransformRequest.Builder> deleteMlTransformRequest) {
        return deleteMLTransform(DeleteMlTransformRequest.builder().applyMutation(deleteMlTransformRequest).build());
    }

    /**
     * <p>
     * Deletes a specified partition.
     * </p>
     *
     * @param deletePartitionRequest
     * @return A Java Future containing the result of the DeletePartition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeletePartition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeletePartition" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePartitionResponse> deletePartition(DeletePartitionRequest deletePartitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified partition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePartitionRequest.Builder} avoiding the need
     * to create one manually via {@link DeletePartitionRequest#builder()}
     * </p>
     *
     * @param deletePartitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeletePartitionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeletePartition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeletePartition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeletePartition" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePartitionResponse> deletePartition(
            Consumer<DeletePartitionRequest.Builder> deletePartitionRequest) {
        return deletePartition(DeletePartitionRequest.builder().applyMutation(deletePartitionRequest).build());
    }

    /**
     * <p>
     * Deletes a specified partition index from an existing table.
     * </p>
     *
     * @param deletePartitionIndexRequest
     * @return A Java Future containing the result of the DeletePartitionIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>ConflictException The <code>CreatePartitions</code> API was called on a table that has indexes
     *         enabled.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeletePartitionIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeletePartitionIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePartitionIndexResponse> deletePartitionIndex(
            DeletePartitionIndexRequest deletePartitionIndexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified partition index from an existing table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePartitionIndexRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePartitionIndexRequest#builder()}
     * </p>
     *
     * @param deletePartitionIndexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeletePartitionIndexRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeletePartitionIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>ConflictException The <code>CreatePartitions</code> API was called on a table that has indexes
     *         enabled.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeletePartitionIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeletePartitionIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePartitionIndexResponse> deletePartitionIndex(
            Consumer<DeletePartitionIndexRequest.Builder> deletePartitionIndexRequest) {
        return deletePartitionIndex(DeletePartitionIndexRequest.builder().applyMutation(deletePartitionIndexRequest).build());
    }

    /**
     * <p>
     * Delete the entire registry including schema and all of its versions. To get the status of the delete operation,
     * you can call the <code>GetRegistry</code> API after the asynchronous call. Deleting a registry will deactivate
     * all online operations for the registry such as the <code>UpdateRegistry</code>, <code>CreateSchema</code>,
     * <code>UpdateSchema</code>, and <code>RegisterSchemaVersion</code> APIs.
     * </p>
     *
     * @param deleteRegistryRequest
     * @return A Java Future containing the result of the DeleteRegistry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteRegistry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRegistryResponse> deleteRegistry(DeleteRegistryRequest deleteRegistryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the entire registry including schema and all of its versions. To get the status of the delete operation,
     * you can call the <code>GetRegistry</code> API after the asynchronous call. Deleting a registry will deactivate
     * all online operations for the registry such as the <code>UpdateRegistry</code>, <code>CreateSchema</code>,
     * <code>UpdateSchema</code>, and <code>RegisterSchemaVersion</code> APIs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRegistryRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRegistryRequest#builder()}
     * </p>
     *
     * @param deleteRegistryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteRegistryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRegistry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteRegistry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRegistryResponse> deleteRegistry(Consumer<DeleteRegistryRequest.Builder> deleteRegistryRequest) {
        return deleteRegistry(DeleteRegistryRequest.builder().applyMutation(deleteRegistryRequest).build());
    }

    /**
     * <p>
     * Deletes a specified policy.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>ConditionCheckFailureException A specified condition was not satisfied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteResourcePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>ConditionCheckFailureException A specified condition was not satisfied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the entire schema set, including the schema set and all of its versions. To get the status of the delete
     * operation, you can call <code>GetSchema</code> API after the asynchronous call. Deleting a registry will
     * deactivate all online operations for the schema, such as the <code>GetSchemaByDefinition</code>, and
     * <code>RegisterSchemaVersion</code> APIs.
     * </p>
     *
     * @param deleteSchemaRequest
     * @return A Java Future containing the result of the DeleteSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSchemaResponse> deleteSchema(DeleteSchemaRequest deleteSchemaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the entire schema set, including the schema set and all of its versions. To get the status of the delete
     * operation, you can call <code>GetSchema</code> API after the asynchronous call. Deleting a registry will
     * deactivate all online operations for the schema, such as the <code>GetSchemaByDefinition</code>, and
     * <code>RegisterSchemaVersion</code> APIs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSchemaRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSchemaRequest#builder()}
     * </p>
     *
     * @param deleteSchemaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteSchemaRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSchemaResponse> deleteSchema(Consumer<DeleteSchemaRequest.Builder> deleteSchemaRequest) {
        return deleteSchema(DeleteSchemaRequest.builder().applyMutation(deleteSchemaRequest).build());
    }

    /**
     * <p>
     * Remove versions from the specified schema. A version number or range may be supplied. If the compatibility mode
     * forbids deleting of a version that is necessary, such as BACKWARDS_FULL, an error is returned. Calling the
     * <code>GetSchemaVersions</code> API after this call will list the status of the deleted versions.
     * </p>
     * <p>
     * When the range of version numbers contain check pointed version, the API will return a 409 conflict and will not
     * proceed with the deletion. You have to remove the checkpoint first using the <code>DeleteSchemaCheckpoint</code>
     * API before using this API.
     * </p>
     * <p>
     * You cannot use the <code>DeleteSchemaVersions</code> API to delete the first schema version in the schema set.
     * The first schema version can only be deleted by the <code>DeleteSchema</code> API. This operation will also
     * delete the attached <code>SchemaVersionMetadata</code> under the schema versions. Hard deletes will be enforced
     * on the database.
     * </p>
     * <p>
     * If the compatibility mode forbids deleting of a version that is necessary, such as BACKWARDS_FULL, an error is
     * returned.
     * </p>
     *
     * @param deleteSchemaVersionsRequest
     * @return A Java Future containing the result of the DeleteSchemaVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteSchemaVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteSchemaVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSchemaVersionsResponse> deleteSchemaVersions(
            DeleteSchemaVersionsRequest deleteSchemaVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove versions from the specified schema. A version number or range may be supplied. If the compatibility mode
     * forbids deleting of a version that is necessary, such as BACKWARDS_FULL, an error is returned. Calling the
     * <code>GetSchemaVersions</code> API after this call will list the status of the deleted versions.
     * </p>
     * <p>
     * When the range of version numbers contain check pointed version, the API will return a 409 conflict and will not
     * proceed with the deletion. You have to remove the checkpoint first using the <code>DeleteSchemaCheckpoint</code>
     * API before using this API.
     * </p>
     * <p>
     * You cannot use the <code>DeleteSchemaVersions</code> API to delete the first schema version in the schema set.
     * The first schema version can only be deleted by the <code>DeleteSchema</code> API. This operation will also
     * delete the attached <code>SchemaVersionMetadata</code> under the schema versions. Hard deletes will be enforced
     * on the database.
     * </p>
     * <p>
     * If the compatibility mode forbids deleting of a version that is necessary, such as BACKWARDS_FULL, an error is
     * returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSchemaVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSchemaVersionsRequest#builder()}
     * </p>
     *
     * @param deleteSchemaVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteSchemaVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSchemaVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteSchemaVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteSchemaVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSchemaVersionsResponse> deleteSchemaVersions(
            Consumer<DeleteSchemaVersionsRequest.Builder> deleteSchemaVersionsRequest) {
        return deleteSchemaVersions(DeleteSchemaVersionsRequest.builder().applyMutation(deleteSchemaVersionsRequest).build());
    }

    /**
     * <p>
     * Deletes a specified security configuration.
     * </p>
     *
     * @param deleteSecurityConfigurationRequest
     * @return A Java Future containing the result of the DeleteSecurityConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteSecurityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteSecurityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSecurityConfigurationResponse> deleteSecurityConfiguration(
            DeleteSecurityConfigurationRequest deleteSecurityConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified security configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSecurityConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteSecurityConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteSecurityConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteSecurityConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSecurityConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteSecurityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteSecurityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSecurityConfigurationResponse> deleteSecurityConfiguration(
            Consumer<DeleteSecurityConfigurationRequest.Builder> deleteSecurityConfigurationRequest) {
        return deleteSecurityConfiguration(DeleteSecurityConfigurationRequest.builder()
                .applyMutation(deleteSecurityConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the session.
     * </p>
     *
     * @param deleteSessionRequest
     * @return A Java Future containing the result of the DeleteSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>IllegalSessionStateException The session is in an invalid state to perform a requested operation.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSessionResponse> deleteSession(DeleteSessionRequest deleteSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSessionRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSessionRequest#builder()}
     * </p>
     *
     * @param deleteSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteSessionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>IllegalSessionStateException The session is in an invalid state to perform a requested operation.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSessionResponse> deleteSession(Consumer<DeleteSessionRequest.Builder> deleteSessionRequest) {
        return deleteSession(DeleteSessionRequest.builder().applyMutation(deleteSessionRequest).build());
    }

    /**
     * <p>
     * Removes a table definition from the Data Catalog.
     * </p>
     * <note>
     * <p>
     * After completing this operation, you no longer have access to the table versions and partitions that belong to
     * the deleted table. Glue deletes these "orphaned" resources asynchronously in a timely manner, at the discretion
     * of the service.
     * </p>
     * <p>
     * To ensure the immediate deletion of all related resources, before calling <code>DeleteTable</code>, use
     * <code>DeleteTableVersion</code> or <code>BatchDeleteTableVersion</code>, and <code>DeletePartition</code> or
     * <code>BatchDeletePartition</code>, to delete any resources that belong to the table.
     * </p>
     * </note>
     *
     * @param deleteTableRequest
     * @return A Java Future containing the result of the DeleteTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>ResourceNotReadyException A resource was not ready for a transaction.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTableResponse> deleteTable(DeleteTableRequest deleteTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a table definition from the Data Catalog.
     * </p>
     * <note>
     * <p>
     * After completing this operation, you no longer have access to the table versions and partitions that belong to
     * the deleted table. Glue deletes these "orphaned" resources asynchronously in a timely manner, at the discretion
     * of the service.
     * </p>
     * <p>
     * To ensure the immediate deletion of all related resources, before calling <code>DeleteTable</code>, use
     * <code>DeleteTableVersion</code> or <code>BatchDeleteTableVersion</code>, and <code>DeletePartition</code> or
     * <code>BatchDeletePartition</code>, to delete any resources that belong to the table.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTableRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTableRequest#builder()}
     * </p>
     *
     * @param deleteTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteTableRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>ResourceNotReadyException A resource was not ready for a transaction.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTableResponse> deleteTable(Consumer<DeleteTableRequest.Builder> deleteTableRequest) {
        return deleteTable(DeleteTableRequest.builder().applyMutation(deleteTableRequest).build());
    }

    /**
     * <p>
     * Deletes an optimizer and all associated metadata for a table. The optimization will no longer be performed on the
     * table.
     * </p>
     *
     * @param deleteTableOptimizerRequest
     * @return A Java Future containing the result of the DeleteTableOptimizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>ThrottlingException The throttling threshhold was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteTableOptimizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTableOptimizer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTableOptimizerResponse> deleteTableOptimizer(
            DeleteTableOptimizerRequest deleteTableOptimizerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an optimizer and all associated metadata for a table. The optimization will no longer be performed on the
     * table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTableOptimizerRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTableOptimizerRequest#builder()}
     * </p>
     *
     * @param deleteTableOptimizerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteTableOptimizerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTableOptimizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>ThrottlingException The throttling threshhold was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteTableOptimizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTableOptimizer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTableOptimizerResponse> deleteTableOptimizer(
            Consumer<DeleteTableOptimizerRequest.Builder> deleteTableOptimizerRequest) {
        return deleteTableOptimizer(DeleteTableOptimizerRequest.builder().applyMutation(deleteTableOptimizerRequest).build());
    }

    /**
     * <p>
     * Deletes a specified version of a table.
     * </p>
     *
     * @param deleteTableVersionRequest
     * @return A Java Future containing the result of the DeleteTableVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteTableVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTableVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTableVersionResponse> deleteTableVersion(DeleteTableVersionRequest deleteTableVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified version of a table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTableVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTableVersionRequest#builder()}
     * </p>
     *
     * @param deleteTableVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteTableVersionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteTableVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteTableVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTableVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTableVersionResponse> deleteTableVersion(
            Consumer<DeleteTableVersionRequest.Builder> deleteTableVersionRequest) {
        return deleteTableVersion(DeleteTableVersionRequest.builder().applyMutation(deleteTableVersionRequest).build());
    }

    /**
     * <p>
     * Deletes a specified trigger. If the trigger is not found, no exception is thrown.
     * </p>
     *
     * @param deleteTriggerRequest
     * @return A Java Future containing the result of the DeleteTrigger operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteTrigger
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTrigger" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTriggerResponse> deleteTrigger(DeleteTriggerRequest deleteTriggerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified trigger. If the trigger is not found, no exception is thrown.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTriggerRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTriggerRequest#builder()}
     * </p>
     *
     * @param deleteTriggerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteTriggerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteTrigger operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteTrigger
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTrigger" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTriggerResponse> deleteTrigger(Consumer<DeleteTriggerRequest.Builder> deleteTriggerRequest) {
        return deleteTrigger(DeleteTriggerRequest.builder().applyMutation(deleteTriggerRequest).build());
    }

    /**
     * <p>
     * Deletes the Glue specified usage profile.
     * </p>
     *
     * @param deleteUsageProfileRequest
     * @return A Java Future containing the result of the DeleteUsageProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>OperationNotSupportedException The operation is not available in the region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteUsageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteUsageProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUsageProfileResponse> deleteUsageProfile(DeleteUsageProfileRequest deleteUsageProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the Glue specified usage profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUsageProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteUsageProfileRequest#builder()}
     * </p>
     *
     * @param deleteUsageProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteUsageProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteUsageProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>OperationNotSupportedException The operation is not available in the region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteUsageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteUsageProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUsageProfileResponse> deleteUsageProfile(
            Consumer<DeleteUsageProfileRequest.Builder> deleteUsageProfileRequest) {
        return deleteUsageProfile(DeleteUsageProfileRequest.builder().applyMutation(deleteUsageProfileRequest).build());
    }

    /**
     * <p>
     * Deletes an existing function definition from the Data Catalog.
     * </p>
     *
     * @param deleteUserDefinedFunctionRequest
     * @return A Java Future containing the result of the DeleteUserDefinedFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteUserDefinedFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteUserDefinedFunction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUserDefinedFunctionResponse> deleteUserDefinedFunction(
            DeleteUserDefinedFunctionRequest deleteUserDefinedFunctionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing function definition from the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserDefinedFunctionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteUserDefinedFunctionRequest#builder()}
     * </p>
     *
     * @param deleteUserDefinedFunctionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteUserDefinedFunctionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteUserDefinedFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteUserDefinedFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteUserDefinedFunction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUserDefinedFunctionResponse> deleteUserDefinedFunction(
            Consumer<DeleteUserDefinedFunctionRequest.Builder> deleteUserDefinedFunctionRequest) {
        return deleteUserDefinedFunction(DeleteUserDefinedFunctionRequest.builder()
                .applyMutation(deleteUserDefinedFunctionRequest).build());
    }

    /**
     * <p>
     * Deletes a workflow.
     * </p>
     *
     * @param deleteWorkflowRequest
     * @return A Java Future containing the result of the DeleteWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWorkflowResponse> deleteWorkflow(DeleteWorkflowRequest deleteWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteWorkflowRequest#builder()}
     * </p>
     *
     * @param deleteWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DeleteWorkflowRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ConcurrentModificationException Two processes are trying to modify a resource simultaneously.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DeleteWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWorkflowResponse> deleteWorkflow(Consumer<DeleteWorkflowRequest.Builder> deleteWorkflowRequest) {
        return deleteWorkflow(DeleteWorkflowRequest.builder().applyMutation(deleteWorkflowRequest).build());
    }

    /**
     * <p>
     * The <code>DescribeConnectionType</code> API provides full details of the supported options for a given connection
     * type in Glue.
     * </p>
     *
     * @param describeConnectionTypeRequest
     * @return A Java Future containing the result of the DescribeConnectionType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DescribeConnectionType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DescribeConnectionType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeConnectionTypeResponse> describeConnectionType(
            DescribeConnectionTypeRequest describeConnectionTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>DescribeConnectionType</code> API provides full details of the supported options for a given connection
     * type in Glue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectionTypeRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeConnectionTypeRequest#builder()}
     * </p>
     *
     * @param describeConnectionTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DescribeConnectionTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeConnectionType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DescribeConnectionType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DescribeConnectionType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeConnectionTypeResponse> describeConnectionType(
            Consumer<DescribeConnectionTypeRequest.Builder> describeConnectionTypeRequest) {
        return describeConnectionType(DescribeConnectionTypeRequest.builder().applyMutation(describeConnectionTypeRequest)
                .build());
    }

    /**
     * <p>
     * Provides details regarding the entity used with the connection type, with a description of the data model for
     * each field in the selected entity.
     * </p>
     * <p>
     * The response includes all the fields which make up the entity.
     * </p>
     *
     * @param describeEntityRequest
     * @return A Java Future containing the result of the DescribeEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DescribeEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DescribeEntity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEntityResponse> describeEntity(DescribeEntityRequest describeEntityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details regarding the entity used with the connection type, with a description of the data model for
     * each field in the selected entity.
     * </p>
     * <p>
     * The response includes all the fields which make up the entity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEntityRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEntityRequest#builder()}
     * </p>
     *
     * @param describeEntityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DescribeEntityRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DescribeEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DescribeEntity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEntityResponse> describeEntity(Consumer<DescribeEntityRequest.Builder> describeEntityRequest) {
        return describeEntity(DescribeEntityRequest.builder().applyMutation(describeEntityRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #describeEntity(software.amazon.awssdk.services.glue.model.DescribeEntityRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.DescribeEntityPublisher publisher = client.describeEntityPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.DescribeEntityPublisher publisher = client.describeEntityPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.DescribeEntityResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.DescribeEntityResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEntity(software.amazon.awssdk.services.glue.model.DescribeEntityRequest)} operation.</b>
     * </p>
     *
     * @param describeEntityRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DescribeEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DescribeEntity" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEntityPublisher describeEntityPaginator(DescribeEntityRequest describeEntityRequest) {
        return new DescribeEntityPublisher(this, describeEntityRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #describeEntity(software.amazon.awssdk.services.glue.model.DescribeEntityRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.DescribeEntityPublisher publisher = client.describeEntityPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.DescribeEntityPublisher publisher = client.describeEntityPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.DescribeEntityResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.DescribeEntityResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEntity(software.amazon.awssdk.services.glue.model.DescribeEntityRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEntityRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEntityRequest#builder()}
     * </p>
     *
     * @param describeEntityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DescribeEntityRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DescribeEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DescribeEntity" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEntityPublisher describeEntityPaginator(Consumer<DescribeEntityRequest.Builder> describeEntityRequest) {
        return describeEntityPaginator(DescribeEntityRequest.builder().applyMutation(describeEntityRequest).build());
    }

    /**
     * <p>
     * Returns a list of inbound integrations for the specified integration.
     * </p>
     *
     * @param describeInboundIntegrationsRequest
     * @return A Java Future containing the result of the DescribeInboundIntegrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>InternalServerException An internal server error occurred.</li>
     *         <li>IntegrationNotFoundException The specified integration could not be found.</li>
     *         <li>TargetResourceNotFoundException The target resource could not be found.</li>
     *         <li>OperationNotSupportedException The operation is not available in the region.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DescribeInboundIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DescribeInboundIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInboundIntegrationsResponse> describeInboundIntegrations(
            DescribeInboundIntegrationsRequest describeInboundIntegrationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of inbound integrations for the specified integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInboundIntegrationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInboundIntegrationsRequest#builder()}
     * </p>
     *
     * @param describeInboundIntegrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DescribeInboundIntegrationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeInboundIntegrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>InternalServerException An internal server error occurred.</li>
     *         <li>IntegrationNotFoundException The specified integration could not be found.</li>
     *         <li>TargetResourceNotFoundException The target resource could not be found.</li>
     *         <li>OperationNotSupportedException The operation is not available in the region.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DescribeInboundIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DescribeInboundIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInboundIntegrationsResponse> describeInboundIntegrations(
            Consumer<DescribeInboundIntegrationsRequest.Builder> describeInboundIntegrationsRequest) {
        return describeInboundIntegrations(DescribeInboundIntegrationsRequest.builder()
                .applyMutation(describeInboundIntegrationsRequest).build());
    }

    /**
     * <p>
     * The API is used to retrieve a list of integrations.
     * </p>
     *
     * @param describeIntegrationsRequest
     * @return A Java Future containing the result of the DescribeIntegrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>InternalServerException An internal server error occurred.</li>
     *         <li>IntegrationNotFoundException The specified integration could not be found.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DescribeIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DescribeIntegrations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeIntegrationsResponse> describeIntegrations(
            DescribeIntegrationsRequest describeIntegrationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The API is used to retrieve a list of integrations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIntegrationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeIntegrationsRequest#builder()}
     * </p>
     *
     * @param describeIntegrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.DescribeIntegrationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeIntegrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>InternalServerException An internal server error occurred.</li>
     *         <li>IntegrationNotFoundException The specified integration could not be found.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.DescribeIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DescribeIntegrations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeIntegrationsResponse> describeIntegrations(
            Consumer<DescribeIntegrationsRequest.Builder> describeIntegrationsRequest) {
        return describeIntegrations(DescribeIntegrationsRequest.builder().applyMutation(describeIntegrationsRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of a blueprint.
     * </p>
     *
     * @param getBlueprintRequest
     * @return A Java Future containing the result of the GetBlueprint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetBlueprint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBlueprintResponse> getBlueprint(GetBlueprintRequest getBlueprintRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of a blueprint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBlueprintRequest.Builder} avoiding the need to
     * create one manually via {@link GetBlueprintRequest#builder()}
     * </p>
     *
     * @param getBlueprintRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetBlueprintRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetBlueprint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetBlueprint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetBlueprint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBlueprintResponse> getBlueprint(Consumer<GetBlueprintRequest.Builder> getBlueprintRequest) {
        return getBlueprint(GetBlueprintRequest.builder().applyMutation(getBlueprintRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of a blueprint run.
     * </p>
     *
     * @param getBlueprintRunRequest
     * @return A Java Future containing the result of the GetBlueprintRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetBlueprintRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetBlueprintRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBlueprintRunResponse> getBlueprintRun(GetBlueprintRunRequest getBlueprintRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of a blueprint run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBlueprintRunRequest.Builder} avoiding the need
     * to create one manually via {@link GetBlueprintRunRequest#builder()}
     * </p>
     *
     * @param getBlueprintRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetBlueprintRunRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetBlueprintRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetBlueprintRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetBlueprintRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBlueprintRunResponse> getBlueprintRun(
            Consumer<GetBlueprintRunRequest.Builder> getBlueprintRunRequest) {
        return getBlueprintRun(GetBlueprintRunRequest.builder().applyMutation(getBlueprintRunRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of blueprint runs for a specified blueprint.
     * </p>
     *
     * @param getBlueprintRunsRequest
     * @return A Java Future containing the result of the GetBlueprintRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetBlueprintRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetBlueprintRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBlueprintRunsResponse> getBlueprintRuns(GetBlueprintRunsRequest getBlueprintRunsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of blueprint runs for a specified blueprint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBlueprintRunsRequest.Builder} avoiding the need
     * to create one manually via {@link GetBlueprintRunsRequest#builder()}
     * </p>
     *
     * @param getBlueprintRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetBlueprintRunsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetBlueprintRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetBlueprintRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetBlueprintRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBlueprintRunsResponse> getBlueprintRuns(
            Consumer<GetBlueprintRunsRequest.Builder> getBlueprintRunsRequest) {
        return getBlueprintRuns(GetBlueprintRunsRequest.builder().applyMutation(getBlueprintRunsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getBlueprintRuns(software.amazon.awssdk.services.glue.model.GetBlueprintRunsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetBlueprintRunsPublisher publisher = client.getBlueprintRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetBlueprintRunsPublisher publisher = client.getBlueprintRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetBlueprintRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetBlueprintRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getBlueprintRuns(software.amazon.awssdk.services.glue.model.GetBlueprintRunsRequest)} operation.</b>
     * </p>
     *
     * @param getBlueprintRunsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetBlueprintRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetBlueprintRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBlueprintRunsPublisher getBlueprintRunsPaginator(GetBlueprintRunsRequest getBlueprintRunsRequest) {
        return new GetBlueprintRunsPublisher(this, getBlueprintRunsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getBlueprintRuns(software.amazon.awssdk.services.glue.model.GetBlueprintRunsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetBlueprintRunsPublisher publisher = client.getBlueprintRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetBlueprintRunsPublisher publisher = client.getBlueprintRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetBlueprintRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetBlueprintRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getBlueprintRuns(software.amazon.awssdk.services.glue.model.GetBlueprintRunsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBlueprintRunsRequest.Builder} avoiding the need
     * to create one manually via {@link GetBlueprintRunsRequest#builder()}
     * </p>
     *
     * @param getBlueprintRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetBlueprintRunsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetBlueprintRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetBlueprintRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBlueprintRunsPublisher getBlueprintRunsPaginator(Consumer<GetBlueprintRunsRequest.Builder> getBlueprintRunsRequest) {
        return getBlueprintRunsPaginator(GetBlueprintRunsRequest.builder().applyMutation(getBlueprintRunsRequest).build());
    }

    /**
     * <p>
     * The name of the Catalog to retrieve. This should be all lowercase.
     * </p>
     *
     * @param getCatalogRequest
     * @return A Java Future containing the result of the GetCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCatalogResponse> getCatalog(GetCatalogRequest getCatalogRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The name of the Catalog to retrieve. This should be all lowercase.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCatalogRequest.Builder} avoiding the need to
     * create one manually via {@link GetCatalogRequest#builder()}
     * </p>
     *
     * @param getCatalogRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetCatalogRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetCatalog
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCatalogResponse> getCatalog(Consumer<GetCatalogRequest.Builder> getCatalogRequest) {
        return getCatalog(GetCatalogRequest.builder().applyMutation(getCatalogRequest).build());
    }

    /**
     * <p>
     * Retrieves the status of a migration operation.
     * </p>
     *
     * @param getCatalogImportStatusRequest
     * @return A Java Future containing the result of the GetCatalogImportStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetCatalogImportStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCatalogImportStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCatalogImportStatusResponse> getCatalogImportStatus(
            GetCatalogImportStatusRequest getCatalogImportStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the status of a migration operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCatalogImportStatusRequest.Builder} avoiding the
     * need to create one manually via {@link GetCatalogImportStatusRequest#builder()}
     * </p>
     *
     * @param getCatalogImportStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetCatalogImportStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCatalogImportStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetCatalogImportStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCatalogImportStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCatalogImportStatusResponse> getCatalogImportStatus(
            Consumer<GetCatalogImportStatusRequest.Builder> getCatalogImportStatusRequest) {
        return getCatalogImportStatus(GetCatalogImportStatusRequest.builder().applyMutation(getCatalogImportStatusRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves all catalogs defined in a catalog in the Glue Data Catalog. For a Redshift-federated catalog use case,
     * this operation returns the list of catalogs mapped to Redshift databases in the Redshift namespace catalog.
     * </p>
     *
     * @param getCatalogsRequest
     * @return A Java Future containing the result of the GetCatalogs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetCatalogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCatalogs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCatalogsResponse> getCatalogs(GetCatalogsRequest getCatalogsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all catalogs defined in a catalog in the Glue Data Catalog. For a Redshift-federated catalog use case,
     * this operation returns the list of catalogs mapped to Redshift databases in the Redshift namespace catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCatalogsRequest.Builder} avoiding the need to
     * create one manually via {@link GetCatalogsRequest#builder()}
     * </p>
     *
     * @param getCatalogsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetCatalogsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCatalogs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetCatalogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCatalogs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCatalogsResponse> getCatalogs(Consumer<GetCatalogsRequest.Builder> getCatalogsRequest) {
        return getCatalogs(GetCatalogsRequest.builder().applyMutation(getCatalogsRequest).build());
    }

    /**
     * <p>
     * Retrieve a classifier by name.
     * </p>
     *
     * @param getClassifierRequest
     * @return A Java Future containing the result of the GetClassifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifier" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetClassifierResponse> getClassifier(GetClassifierRequest getClassifierRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve a classifier by name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetClassifierRequest.Builder} avoiding the need to
     * create one manually via {@link GetClassifierRequest#builder()}
     * </p>
     *
     * @param getClassifierRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetClassifierRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetClassifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetClassifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifier" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetClassifierResponse> getClassifier(Consumer<GetClassifierRequest.Builder> getClassifierRequest) {
        return getClassifier(GetClassifierRequest.builder().applyMutation(getClassifierRequest).build());
    }

    /**
     * <p>
     * Lists all classifier objects in the Data Catalog.
     * </p>
     *
     * @param getClassifiersRequest
     * @return A Java Future containing the result of the GetClassifiers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetClassifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifiers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetClassifiersResponse> getClassifiers(GetClassifiersRequest getClassifiersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all classifier objects in the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetClassifiersRequest.Builder} avoiding the need to
     * create one manually via {@link GetClassifiersRequest#builder()}
     * </p>
     *
     * @param getClassifiersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetClassifiersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetClassifiers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetClassifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifiers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetClassifiersResponse> getClassifiers(Consumer<GetClassifiersRequest.Builder> getClassifiersRequest) {
        return getClassifiers(GetClassifiersRequest.builder().applyMutation(getClassifiersRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #getClassifiers(software.amazon.awssdk.services.glue.model.GetClassifiersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetClassifiersPublisher publisher = client.getClassifiersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetClassifiersPublisher publisher = client.getClassifiersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetClassifiersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetClassifiersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getClassifiers(software.amazon.awssdk.services.glue.model.GetClassifiersRequest)} operation.</b>
     * </p>
     *
     * @param getClassifiersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetClassifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifiers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetClassifiersPublisher getClassifiersPaginator(GetClassifiersRequest getClassifiersRequest) {
        return new GetClassifiersPublisher(this, getClassifiersRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #getClassifiers(software.amazon.awssdk.services.glue.model.GetClassifiersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetClassifiersPublisher publisher = client.getClassifiersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetClassifiersPublisher publisher = client.getClassifiersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetClassifiersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetClassifiersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getClassifiers(software.amazon.awssdk.services.glue.model.GetClassifiersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetClassifiersRequest.Builder} avoiding the need to
     * create one manually via {@link GetClassifiersRequest#builder()}
     * </p>
     *
     * @param getClassifiersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetClassifiersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetClassifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifiers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetClassifiersPublisher getClassifiersPaginator(Consumer<GetClassifiersRequest.Builder> getClassifiersRequest) {
        return getClassifiersPaginator(GetClassifiersRequest.builder().applyMutation(getClassifiersRequest).build());
    }

    /**
     * <p>
     * Retrieves partition statistics of columns.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) permission required for this operation is <code>GetPartition</code>.
     * </p>
     *
     * @param getColumnStatisticsForPartitionRequest
     * @return A Java Future containing the result of the GetColumnStatisticsForPartition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetColumnStatisticsForPartition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetColumnStatisticsForPartition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetColumnStatisticsForPartitionResponse> getColumnStatisticsForPartition(
            GetColumnStatisticsForPartitionRequest getColumnStatisticsForPartitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves partition statistics of columns.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) permission required for this operation is <code>GetPartition</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetColumnStatisticsForPartitionRequest.Builder}
     * avoiding the need to create one manually via {@link GetColumnStatisticsForPartitionRequest#builder()}
     * </p>
     *
     * @param getColumnStatisticsForPartitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetColumnStatisticsForPartitionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetColumnStatisticsForPartition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetColumnStatisticsForPartition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetColumnStatisticsForPartition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetColumnStatisticsForPartitionResponse> getColumnStatisticsForPartition(
            Consumer<GetColumnStatisticsForPartitionRequest.Builder> getColumnStatisticsForPartitionRequest) {
        return getColumnStatisticsForPartition(GetColumnStatisticsForPartitionRequest.builder()
                .applyMutation(getColumnStatisticsForPartitionRequest).build());
    }

    /**
     * <p>
     * Retrieves table statistics of columns.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) permission required for this operation is <code>GetTable</code>.
     * </p>
     *
     * @param getColumnStatisticsForTableRequest
     * @return A Java Future containing the result of the GetColumnStatisticsForTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetColumnStatisticsForTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetColumnStatisticsForTable"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetColumnStatisticsForTableResponse> getColumnStatisticsForTable(
            GetColumnStatisticsForTableRequest getColumnStatisticsForTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves table statistics of columns.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) permission required for this operation is <code>GetTable</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetColumnStatisticsForTableRequest.Builder}
     * avoiding the need to create one manually via {@link GetColumnStatisticsForTableRequest#builder()}
     * </p>
     *
     * @param getColumnStatisticsForTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetColumnStatisticsForTableRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetColumnStatisticsForTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetColumnStatisticsForTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetColumnStatisticsForTable"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetColumnStatisticsForTableResponse> getColumnStatisticsForTable(
            Consumer<GetColumnStatisticsForTableRequest.Builder> getColumnStatisticsForTableRequest) {
        return getColumnStatisticsForTable(GetColumnStatisticsForTableRequest.builder()
                .applyMutation(getColumnStatisticsForTableRequest).build());
    }

    /**
     * <p>
     * Get the associated metadata/information for a task run, given a task run ID.
     * </p>
     *
     * @param getColumnStatisticsTaskRunRequest
     * @return A Java Future containing the result of the GetColumnStatisticsTaskRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetColumnStatisticsTaskRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetColumnStatisticsTaskRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetColumnStatisticsTaskRunResponse> getColumnStatisticsTaskRun(
            GetColumnStatisticsTaskRunRequest getColumnStatisticsTaskRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the associated metadata/information for a task run, given a task run ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetColumnStatisticsTaskRunRequest.Builder} avoiding
     * the need to create one manually via {@link GetColumnStatisticsTaskRunRequest#builder()}
     * </p>
     *
     * @param getColumnStatisticsTaskRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetColumnStatisticsTaskRunRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetColumnStatisticsTaskRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetColumnStatisticsTaskRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetColumnStatisticsTaskRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetColumnStatisticsTaskRunResponse> getColumnStatisticsTaskRun(
            Consumer<GetColumnStatisticsTaskRunRequest.Builder> getColumnStatisticsTaskRunRequest) {
        return getColumnStatisticsTaskRun(GetColumnStatisticsTaskRunRequest.builder()
                .applyMutation(getColumnStatisticsTaskRunRequest).build());
    }

    /**
     * <p>
     * Retrieves information about all runs associated with the specified table.
     * </p>
     *
     * @param getColumnStatisticsTaskRunsRequest
     * @return A Java Future containing the result of the GetColumnStatisticsTaskRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetColumnStatisticsTaskRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetColumnStatisticsTaskRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetColumnStatisticsTaskRunsResponse> getColumnStatisticsTaskRuns(
            GetColumnStatisticsTaskRunsRequest getColumnStatisticsTaskRunsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about all runs associated with the specified table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetColumnStatisticsTaskRunsRequest.Builder}
     * avoiding the need to create one manually via {@link GetColumnStatisticsTaskRunsRequest#builder()}
     * </p>
     *
     * @param getColumnStatisticsTaskRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetColumnStatisticsTaskRunsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetColumnStatisticsTaskRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetColumnStatisticsTaskRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetColumnStatisticsTaskRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetColumnStatisticsTaskRunsResponse> getColumnStatisticsTaskRuns(
            Consumer<GetColumnStatisticsTaskRunsRequest.Builder> getColumnStatisticsTaskRunsRequest) {
        return getColumnStatisticsTaskRuns(GetColumnStatisticsTaskRunsRequest.builder()
                .applyMutation(getColumnStatisticsTaskRunsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getColumnStatisticsTaskRuns(software.amazon.awssdk.services.glue.model.GetColumnStatisticsTaskRunsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetColumnStatisticsTaskRunsPublisher publisher = client.getColumnStatisticsTaskRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetColumnStatisticsTaskRunsPublisher publisher = client.getColumnStatisticsTaskRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetColumnStatisticsTaskRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetColumnStatisticsTaskRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getColumnStatisticsTaskRuns(software.amazon.awssdk.services.glue.model.GetColumnStatisticsTaskRunsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getColumnStatisticsTaskRunsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetColumnStatisticsTaskRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetColumnStatisticsTaskRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default GetColumnStatisticsTaskRunsPublisher getColumnStatisticsTaskRunsPaginator(
            GetColumnStatisticsTaskRunsRequest getColumnStatisticsTaskRunsRequest) {
        return new GetColumnStatisticsTaskRunsPublisher(this, getColumnStatisticsTaskRunsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getColumnStatisticsTaskRuns(software.amazon.awssdk.services.glue.model.GetColumnStatisticsTaskRunsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetColumnStatisticsTaskRunsPublisher publisher = client.getColumnStatisticsTaskRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetColumnStatisticsTaskRunsPublisher publisher = client.getColumnStatisticsTaskRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetColumnStatisticsTaskRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetColumnStatisticsTaskRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getColumnStatisticsTaskRuns(software.amazon.awssdk.services.glue.model.GetColumnStatisticsTaskRunsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetColumnStatisticsTaskRunsRequest.Builder}
     * avoiding the need to create one manually via {@link GetColumnStatisticsTaskRunsRequest#builder()}
     * </p>
     *
     * @param getColumnStatisticsTaskRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetColumnStatisticsTaskRunsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetColumnStatisticsTaskRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetColumnStatisticsTaskRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default GetColumnStatisticsTaskRunsPublisher getColumnStatisticsTaskRunsPaginator(
            Consumer<GetColumnStatisticsTaskRunsRequest.Builder> getColumnStatisticsTaskRunsRequest) {
        return getColumnStatisticsTaskRunsPaginator(GetColumnStatisticsTaskRunsRequest.builder()
                .applyMutation(getColumnStatisticsTaskRunsRequest).build());
    }

    /**
     * <p>
     * Gets settings for a column statistics task.
     * </p>
     *
     * @param getColumnStatisticsTaskSettingsRequest
     * @return A Java Future containing the result of the GetColumnStatisticsTaskSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetColumnStatisticsTaskSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetColumnStatisticsTaskSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetColumnStatisticsTaskSettingsResponse> getColumnStatisticsTaskSettings(
            GetColumnStatisticsTaskSettingsRequest getColumnStatisticsTaskSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets settings for a column statistics task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetColumnStatisticsTaskSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link GetColumnStatisticsTaskSettingsRequest#builder()}
     * </p>
     *
     * @param getColumnStatisticsTaskSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetColumnStatisticsTaskSettingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetColumnStatisticsTaskSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetColumnStatisticsTaskSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetColumnStatisticsTaskSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetColumnStatisticsTaskSettingsResponse> getColumnStatisticsTaskSettings(
            Consumer<GetColumnStatisticsTaskSettingsRequest.Builder> getColumnStatisticsTaskSettingsRequest) {
        return getColumnStatisticsTaskSettings(GetColumnStatisticsTaskSettingsRequest.builder()
                .applyMutation(getColumnStatisticsTaskSettingsRequest).build());
    }

    /**
     * <p>
     * Retrieves a connection definition from the Data Catalog.
     * </p>
     *
     * @param getConnectionRequest
     * @return A Java Future containing the result of the GetConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetConnectionResponse> getConnection(GetConnectionRequest getConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a connection definition from the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectionRequest.Builder} avoiding the need to
     * create one manually via {@link GetConnectionRequest#builder()}
     * </p>
     *
     * @param getConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetConnectionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetConnectionResponse> getConnection(Consumer<GetConnectionRequest.Builder> getConnectionRequest) {
        return getConnection(GetConnectionRequest.builder().applyMutation(getConnectionRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of connection definitions from the Data Catalog.
     * </p>
     *
     * @param getConnectionsRequest
     * @return A Java Future containing the result of the GetConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetConnectionsResponse> getConnections(GetConnectionsRequest getConnectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of connection definitions from the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectionsRequest.Builder} avoiding the need to
     * create one manually via {@link GetConnectionsRequest#builder()}
     * </p>
     *
     * @param getConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetConnectionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetConnectionsResponse> getConnections(Consumer<GetConnectionsRequest.Builder> getConnectionsRequest) {
        return getConnections(GetConnectionsRequest.builder().applyMutation(getConnectionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #getConnections(software.amazon.awssdk.services.glue.model.GetConnectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetConnectionsPublisher publisher = client.getConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetConnectionsPublisher publisher = client.getConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getConnections(software.amazon.awssdk.services.glue.model.GetConnectionsRequest)} operation.</b>
     * </p>
     *
     * @param getConnectionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default GetConnectionsPublisher getConnectionsPaginator(GetConnectionsRequest getConnectionsRequest) {
        return new GetConnectionsPublisher(this, getConnectionsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #getConnections(software.amazon.awssdk.services.glue.model.GetConnectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetConnectionsPublisher publisher = client.getConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetConnectionsPublisher publisher = client.getConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getConnections(software.amazon.awssdk.services.glue.model.GetConnectionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectionsRequest.Builder} avoiding the need to
     * create one manually via {@link GetConnectionsRequest#builder()}
     * </p>
     *
     * @param getConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetConnectionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default GetConnectionsPublisher getConnectionsPaginator(Consumer<GetConnectionsRequest.Builder> getConnectionsRequest) {
        return getConnectionsPaginator(GetConnectionsRequest.builder().applyMutation(getConnectionsRequest).build());
    }

    /**
     * <p>
     * Retrieves metadata for a specified crawler.
     * </p>
     *
     * @param getCrawlerRequest
     * @return A Java Future containing the result of the GetCrawler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetCrawler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawler" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCrawlerResponse> getCrawler(GetCrawlerRequest getCrawlerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves metadata for a specified crawler.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCrawlerRequest.Builder} avoiding the need to
     * create one manually via {@link GetCrawlerRequest#builder()}
     * </p>
     *
     * @param getCrawlerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetCrawlerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCrawler operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetCrawler
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawler" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCrawlerResponse> getCrawler(Consumer<GetCrawlerRequest.Builder> getCrawlerRequest) {
        return getCrawler(GetCrawlerRequest.builder().applyMutation(getCrawlerRequest).build());
    }

    /**
     * <p>
     * Retrieves metrics about specified crawlers.
     * </p>
     *
     * @param getCrawlerMetricsRequest
     * @return A Java Future containing the result of the GetCrawlerMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetCrawlerMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlerMetrics" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCrawlerMetricsResponse> getCrawlerMetrics(GetCrawlerMetricsRequest getCrawlerMetricsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves metrics about specified crawlers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCrawlerMetricsRequest.Builder} avoiding the need
     * to create one manually via {@link GetCrawlerMetricsRequest#builder()}
     * </p>
     *
     * @param getCrawlerMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetCrawlerMetricsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCrawlerMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetCrawlerMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlerMetrics" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCrawlerMetricsResponse> getCrawlerMetrics(
            Consumer<GetCrawlerMetricsRequest.Builder> getCrawlerMetricsRequest) {
        return getCrawlerMetrics(GetCrawlerMetricsRequest.builder().applyMutation(getCrawlerMetricsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getCrawlerMetrics(software.amazon.awssdk.services.glue.model.GetCrawlerMetricsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetCrawlerMetricsPublisher publisher = client.getCrawlerMetricsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetCrawlerMetricsPublisher publisher = client.getCrawlerMetricsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetCrawlerMetricsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetCrawlerMetricsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCrawlerMetrics(software.amazon.awssdk.services.glue.model.GetCrawlerMetricsRequest)} operation.</b>
     * </p>
     *
     * @param getCrawlerMetricsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetCrawlerMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlerMetrics" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCrawlerMetricsPublisher getCrawlerMetricsPaginator(GetCrawlerMetricsRequest getCrawlerMetricsRequest) {
        return new GetCrawlerMetricsPublisher(this, getCrawlerMetricsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getCrawlerMetrics(software.amazon.awssdk.services.glue.model.GetCrawlerMetricsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetCrawlerMetricsPublisher publisher = client.getCrawlerMetricsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetCrawlerMetricsPublisher publisher = client.getCrawlerMetricsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetCrawlerMetricsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetCrawlerMetricsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCrawlerMetrics(software.amazon.awssdk.services.glue.model.GetCrawlerMetricsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCrawlerMetricsRequest.Builder} avoiding the need
     * to create one manually via {@link GetCrawlerMetricsRequest#builder()}
     * </p>
     *
     * @param getCrawlerMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetCrawlerMetricsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetCrawlerMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlerMetrics" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCrawlerMetricsPublisher getCrawlerMetricsPaginator(
            Consumer<GetCrawlerMetricsRequest.Builder> getCrawlerMetricsRequest) {
        return getCrawlerMetricsPaginator(GetCrawlerMetricsRequest.builder().applyMutation(getCrawlerMetricsRequest).build());
    }

    /**
     * <p>
     * Retrieves metadata for all crawlers defined in the customer account.
     * </p>
     *
     * @param getCrawlersRequest
     * @return A Java Future containing the result of the GetCrawlers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetCrawlers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCrawlersResponse> getCrawlers(GetCrawlersRequest getCrawlersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves metadata for all crawlers defined in the customer account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCrawlersRequest.Builder} avoiding the need to
     * create one manually via {@link GetCrawlersRequest#builder()}
     * </p>
     *
     * @param getCrawlersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetCrawlersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCrawlers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetCrawlers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCrawlersResponse> getCrawlers(Consumer<GetCrawlersRequest.Builder> getCrawlersRequest) {
        return getCrawlers(GetCrawlersRequest.builder().applyMutation(getCrawlersRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #getCrawlers(software.amazon.awssdk.services.glue.model.GetCrawlersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetCrawlersPublisher publisher = client.getCrawlersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetCrawlersPublisher publisher = client.getCrawlersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetCrawlersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetCrawlersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCrawlers(software.amazon.awssdk.services.glue.model.GetCrawlersRequest)} operation.</b>
     * </p>
     *
     * @param getCrawlersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetCrawlers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCrawlersPublisher getCrawlersPaginator(GetCrawlersRequest getCrawlersRequest) {
        return new GetCrawlersPublisher(this, getCrawlersRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #getCrawlers(software.amazon.awssdk.services.glue.model.GetCrawlersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetCrawlersPublisher publisher = client.getCrawlersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetCrawlersPublisher publisher = client.getCrawlersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetCrawlersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetCrawlersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCrawlers(software.amazon.awssdk.services.glue.model.GetCrawlersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCrawlersRequest.Builder} avoiding the need to
     * create one manually via {@link GetCrawlersRequest#builder()}
     * </p>
     *
     * @param getCrawlersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetCrawlersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetCrawlers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCrawlersPublisher getCrawlersPaginator(Consumer<GetCrawlersRequest.Builder> getCrawlersRequest) {
        return getCrawlersPaginator(GetCrawlersRequest.builder().applyMutation(getCrawlersRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of a custom pattern by specifying its name.
     * </p>
     *
     * @param getCustomEntityTypeRequest
     * @return A Java Future containing the result of the GetCustomEntityType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetCustomEntityType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCustomEntityType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCustomEntityTypeResponse> getCustomEntityType(
            GetCustomEntityTypeRequest getCustomEntityTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of a custom pattern by specifying its name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCustomEntityTypeRequest.Builder} avoiding the
     * need to create one manually via {@link GetCustomEntityTypeRequest#builder()}
     * </p>
     *
     * @param getCustomEntityTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetCustomEntityTypeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCustomEntityType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetCustomEntityType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCustomEntityType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCustomEntityTypeResponse> getCustomEntityType(
            Consumer<GetCustomEntityTypeRequest.Builder> getCustomEntityTypeRequest) {
        return getCustomEntityType(GetCustomEntityTypeRequest.builder().applyMutation(getCustomEntityTypeRequest).build());
    }

    /**
     * <p>
     * Retrieves the security configuration for a specified catalog.
     * </p>
     *
     * @param getDataCatalogEncryptionSettingsRequest
     * @return A Java Future containing the result of the GetDataCatalogEncryptionSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetDataCatalogEncryptionSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataCatalogEncryptionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDataCatalogEncryptionSettingsResponse> getDataCatalogEncryptionSettings(
            GetDataCatalogEncryptionSettingsRequest getDataCatalogEncryptionSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the security configuration for a specified catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataCatalogEncryptionSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link GetDataCatalogEncryptionSettingsRequest#builder()}
     * </p>
     *
     * @param getDataCatalogEncryptionSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetDataCatalogEncryptionSettingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetDataCatalogEncryptionSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetDataCatalogEncryptionSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataCatalogEncryptionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDataCatalogEncryptionSettingsResponse> getDataCatalogEncryptionSettings(
            Consumer<GetDataCatalogEncryptionSettingsRequest.Builder> getDataCatalogEncryptionSettingsRequest) {
        return getDataCatalogEncryptionSettings(GetDataCatalogEncryptionSettingsRequest.builder()
                .applyMutation(getDataCatalogEncryptionSettingsRequest).build());
    }

    /**
     * <p>
     * Retrieve the training status of the model along with more information (CompletedOn, StartedOn, FailureReason).
     * </p>
     *
     * @param getDataQualityModelRequest
     * @return A Java Future containing the result of the GetDataQualityModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetDataQualityModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataQualityModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDataQualityModelResponse> getDataQualityModel(
            GetDataQualityModelRequest getDataQualityModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve the training status of the model along with more information (CompletedOn, StartedOn, FailureReason).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataQualityModelRequest.Builder} avoiding the
     * need to create one manually via {@link GetDataQualityModelRequest#builder()}
     * </p>
     *
     * @param getDataQualityModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetDataQualityModelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDataQualityModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetDataQualityModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataQualityModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDataQualityModelResponse> getDataQualityModel(
            Consumer<GetDataQualityModelRequest.Builder> getDataQualityModelRequest) {
        return getDataQualityModel(GetDataQualityModelRequest.builder().applyMutation(getDataQualityModelRequest).build());
    }

    /**
     * <p>
     * Retrieve a statistic's predictions for a given Profile ID.
     * </p>
     *
     * @param getDataQualityModelResultRequest
     * @return A Java Future containing the result of the GetDataQualityModelResult operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetDataQualityModelResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataQualityModelResult"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDataQualityModelResultResponse> getDataQualityModelResult(
            GetDataQualityModelResultRequest getDataQualityModelResultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve a statistic's predictions for a given Profile ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataQualityModelResultRequest.Builder} avoiding
     * the need to create one manually via {@link GetDataQualityModelResultRequest#builder()}
     * </p>
     *
     * @param getDataQualityModelResultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetDataQualityModelResultRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDataQualityModelResult operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetDataQualityModelResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataQualityModelResult"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDataQualityModelResultResponse> getDataQualityModelResult(
            Consumer<GetDataQualityModelResultRequest.Builder> getDataQualityModelResultRequest) {
        return getDataQualityModelResult(GetDataQualityModelResultRequest.builder()
                .applyMutation(getDataQualityModelResultRequest).build());
    }

    /**
     * <p>
     * Retrieves the result of a data quality rule evaluation.
     * </p>
     *
     * @param getDataQualityResultRequest
     * @return A Java Future containing the result of the GetDataQualityResult operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetDataQualityResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataQualityResult" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDataQualityResultResponse> getDataQualityResult(
            GetDataQualityResultRequest getDataQualityResultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the result of a data quality rule evaluation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataQualityResultRequest.Builder} avoiding the
     * need to create one manually via {@link GetDataQualityResultRequest#builder()}
     * </p>
     *
     * @param getDataQualityResultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetDataQualityResultRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDataQualityResult operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetDataQualityResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataQualityResult" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDataQualityResultResponse> getDataQualityResult(
            Consumer<GetDataQualityResultRequest.Builder> getDataQualityResultRequest) {
        return getDataQualityResult(GetDataQualityResultRequest.builder().applyMutation(getDataQualityResultRequest).build());
    }

    /**
     * <p>
     * Gets the specified recommendation run that was used to generate rules.
     * </p>
     *
     * @param getDataQualityRuleRecommendationRunRequest
     * @return A Java Future containing the result of the GetDataQualityRuleRecommendationRun operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetDataQualityRuleRecommendationRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataQualityRuleRecommendationRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDataQualityRuleRecommendationRunResponse> getDataQualityRuleRecommendationRun(
            GetDataQualityRuleRecommendationRunRequest getDataQualityRuleRecommendationRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified recommendation run that was used to generate rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataQualityRuleRecommendationRunRequest.Builder}
     * avoiding the need to create one manually via {@link GetDataQualityRuleRecommendationRunRequest#builder()}
     * </p>
     *
     * @param getDataQualityRuleRecommendationRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetDataQualityRuleRecommendationRunRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetDataQualityRuleRecommendationRun operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetDataQualityRuleRecommendationRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataQualityRuleRecommendationRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDataQualityRuleRecommendationRunResponse> getDataQualityRuleRecommendationRun(
            Consumer<GetDataQualityRuleRecommendationRunRequest.Builder> getDataQualityRuleRecommendationRunRequest) {
        return getDataQualityRuleRecommendationRun(GetDataQualityRuleRecommendationRunRequest.builder()
                .applyMutation(getDataQualityRuleRecommendationRunRequest).build());
    }

    /**
     * <p>
     * Returns an existing ruleset by identifier or name.
     * </p>
     *
     * @param getDataQualityRulesetRequest
     * @return A Java Future containing the result of the GetDataQualityRuleset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetDataQualityRuleset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataQualityRuleset" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDataQualityRulesetResponse> getDataQualityRuleset(
            GetDataQualityRulesetRequest getDataQualityRulesetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an existing ruleset by identifier or name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataQualityRulesetRequest.Builder} avoiding the
     * need to create one manually via {@link GetDataQualityRulesetRequest#builder()}
     * </p>
     *
     * @param getDataQualityRulesetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetDataQualityRulesetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDataQualityRuleset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetDataQualityRuleset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataQualityRuleset" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDataQualityRulesetResponse> getDataQualityRuleset(
            Consumer<GetDataQualityRulesetRequest.Builder> getDataQualityRulesetRequest) {
        return getDataQualityRuleset(GetDataQualityRulesetRequest.builder().applyMutation(getDataQualityRulesetRequest).build());
    }

    /**
     * <p>
     * Retrieves a specific run where a ruleset is evaluated against a data source.
     * </p>
     *
     * @param getDataQualityRulesetEvaluationRunRequest
     * @return A Java Future containing the result of the GetDataQualityRulesetEvaluationRun operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetDataQualityRulesetEvaluationRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataQualityRulesetEvaluationRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDataQualityRulesetEvaluationRunResponse> getDataQualityRulesetEvaluationRun(
            GetDataQualityRulesetEvaluationRunRequest getDataQualityRulesetEvaluationRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a specific run where a ruleset is evaluated against a data source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataQualityRulesetEvaluationRunRequest.Builder}
     * avoiding the need to create one manually via {@link GetDataQualityRulesetEvaluationRunRequest#builder()}
     * </p>
     *
     * @param getDataQualityRulesetEvaluationRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetDataQualityRulesetEvaluationRunRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetDataQualityRulesetEvaluationRun operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetDataQualityRulesetEvaluationRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataQualityRulesetEvaluationRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDataQualityRulesetEvaluationRunResponse> getDataQualityRulesetEvaluationRun(
            Consumer<GetDataQualityRulesetEvaluationRunRequest.Builder> getDataQualityRulesetEvaluationRunRequest) {
        return getDataQualityRulesetEvaluationRun(GetDataQualityRulesetEvaluationRunRequest.builder()
                .applyMutation(getDataQualityRulesetEvaluationRunRequest).build());
    }

    /**
     * <p>
     * Retrieves the definition of a specified database.
     * </p>
     *
     * @param getDatabaseRequest
     * @return A Java Future containing the result of the GetDatabase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDatabaseResponse> getDatabase(GetDatabaseRequest getDatabaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the definition of a specified database.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDatabaseRequest.Builder} avoiding the need to
     * create one manually via {@link GetDatabaseRequest#builder()}
     * </p>
     *
     * @param getDatabaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetDatabaseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDatabase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDatabaseResponse> getDatabase(Consumer<GetDatabaseRequest.Builder> getDatabaseRequest) {
        return getDatabase(GetDatabaseRequest.builder().applyMutation(getDatabaseRequest).build());
    }

    /**
     * <p>
     * Retrieves all databases defined in a given Data Catalog.
     * </p>
     *
     * @param getDatabasesRequest
     * @return A Java Future containing the result of the GetDatabases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDatabases" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDatabasesResponse> getDatabases(GetDatabasesRequest getDatabasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all databases defined in a given Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDatabasesRequest.Builder} avoiding the need to
     * create one manually via {@link GetDatabasesRequest#builder()}
     * </p>
     *
     * @param getDatabasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetDatabasesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDatabases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDatabases" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDatabasesResponse> getDatabases(Consumer<GetDatabasesRequest.Builder> getDatabasesRequest) {
        return getDatabases(GetDatabasesRequest.builder().applyMutation(getDatabasesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #getDatabases(software.amazon.awssdk.services.glue.model.GetDatabasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetDatabasesPublisher publisher = client.getDatabasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetDatabasesPublisher publisher = client.getDatabasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetDatabasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetDatabasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDatabases(software.amazon.awssdk.services.glue.model.GetDatabasesRequest)} operation.</b>
     * </p>
     *
     * @param getDatabasesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDatabases" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDatabasesPublisher getDatabasesPaginator(GetDatabasesRequest getDatabasesRequest) {
        return new GetDatabasesPublisher(this, getDatabasesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #getDatabases(software.amazon.awssdk.services.glue.model.GetDatabasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetDatabasesPublisher publisher = client.getDatabasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetDatabasesPublisher publisher = client.getDatabasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetDatabasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetDatabasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDatabases(software.amazon.awssdk.services.glue.model.GetDatabasesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDatabasesRequest.Builder} avoiding the need to
     * create one manually via {@link GetDatabasesRequest#builder()}
     * </p>
     *
     * @param getDatabasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetDatabasesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDatabases" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDatabasesPublisher getDatabasesPaginator(Consumer<GetDatabasesRequest.Builder> getDatabasesRequest) {
        return getDatabasesPaginator(GetDatabasesRequest.builder().applyMutation(getDatabasesRequest).build());
    }

    /**
     * <p>
     * Transforms a Python script into a directed acyclic graph (DAG).
     * </p>
     *
     * @param getDataflowGraphRequest
     * @return A Java Future containing the result of the GetDataflowGraph operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetDataflowGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataflowGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDataflowGraphResponse> getDataflowGraph(GetDataflowGraphRequest getDataflowGraphRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Transforms a Python script into a directed acyclic graph (DAG).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataflowGraphRequest.Builder} avoiding the need
     * to create one manually via {@link GetDataflowGraphRequest#builder()}
     * </p>
     *
     * @param getDataflowGraphRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetDataflowGraphRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDataflowGraph operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetDataflowGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataflowGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDataflowGraphResponse> getDataflowGraph(
            Consumer<GetDataflowGraphRequest.Builder> getDataflowGraphRequest) {
        return getDataflowGraph(GetDataflowGraphRequest.builder().applyMutation(getDataflowGraphRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specified development endpoint.
     * </p>
     * <note>
     * <p>
     * When you create a development endpoint in a virtual private cloud (VPC), Glue returns only a private IP address,
     * and the public IP address field is not populated. When you create a non-VPC development endpoint, Glue returns
     * only a public IP address.
     * </p>
     * </note>
     *
     * @param getDevEndpointRequest
     * @return A Java Future containing the result of the GetDevEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetDevEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDevEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDevEndpointResponse> getDevEndpoint(GetDevEndpointRequest getDevEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specified development endpoint.
     * </p>
     * <note>
     * <p>
     * When you create a development endpoint in a virtual private cloud (VPC), Glue returns only a private IP address,
     * and the public IP address field is not populated. When you create a non-VPC development endpoint, Glue returns
     * only a public IP address.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDevEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link GetDevEndpointRequest#builder()}
     * </p>
     *
     * @param getDevEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetDevEndpointRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDevEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetDevEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDevEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDevEndpointResponse> getDevEndpoint(Consumer<GetDevEndpointRequest.Builder> getDevEndpointRequest) {
        return getDevEndpoint(GetDevEndpointRequest.builder().applyMutation(getDevEndpointRequest).build());
    }

    /**
     * <p>
     * Retrieves all the development endpoints in this Amazon Web Services account.
     * </p>
     * <note>
     * <p>
     * When you create a development endpoint in a virtual private cloud (VPC), Glue returns only a private IP address
     * and the public IP address field is not populated. When you create a non-VPC development endpoint, Glue returns
     * only a public IP address.
     * </p>
     * </note>
     *
     * @param getDevEndpointsRequest
     * @return A Java Future containing the result of the GetDevEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetDevEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDevEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDevEndpointsResponse> getDevEndpoints(GetDevEndpointsRequest getDevEndpointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all the development endpoints in this Amazon Web Services account.
     * </p>
     * <note>
     * <p>
     * When you create a development endpoint in a virtual private cloud (VPC), Glue returns only a private IP address
     * and the public IP address field is not populated. When you create a non-VPC development endpoint, Glue returns
     * only a public IP address.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDevEndpointsRequest.Builder} avoiding the need
     * to create one manually via {@link GetDevEndpointsRequest#builder()}
     * </p>
     *
     * @param getDevEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetDevEndpointsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDevEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetDevEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDevEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDevEndpointsResponse> getDevEndpoints(
            Consumer<GetDevEndpointsRequest.Builder> getDevEndpointsRequest) {
        return getDevEndpoints(GetDevEndpointsRequest.builder().applyMutation(getDevEndpointsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #getDevEndpoints(software.amazon.awssdk.services.glue.model.GetDevEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetDevEndpointsPublisher publisher = client.getDevEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetDevEndpointsPublisher publisher = client.getDevEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetDevEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetDevEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDevEndpoints(software.amazon.awssdk.services.glue.model.GetDevEndpointsRequest)} operation.</b>
     * </p>
     *
     * @param getDevEndpointsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetDevEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDevEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDevEndpointsPublisher getDevEndpointsPaginator(GetDevEndpointsRequest getDevEndpointsRequest) {
        return new GetDevEndpointsPublisher(this, getDevEndpointsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #getDevEndpoints(software.amazon.awssdk.services.glue.model.GetDevEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetDevEndpointsPublisher publisher = client.getDevEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetDevEndpointsPublisher publisher = client.getDevEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetDevEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetDevEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDevEndpoints(software.amazon.awssdk.services.glue.model.GetDevEndpointsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDevEndpointsRequest.Builder} avoiding the need
     * to create one manually via {@link GetDevEndpointsRequest#builder()}
     * </p>
     *
     * @param getDevEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetDevEndpointsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetDevEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDevEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDevEndpointsPublisher getDevEndpointsPaginator(Consumer<GetDevEndpointsRequest.Builder> getDevEndpointsRequest) {
        return getDevEndpointsPaginator(GetDevEndpointsRequest.builder().applyMutation(getDevEndpointsRequest).build());
    }

    /**
     * <p>
     * This API is used to query preview data from a given connection type or from a native Amazon S3 based Glue Data
     * Catalog.
     * </p>
     * <p>
     * Returns records as an array of JSON blobs. Each record is formatted using Jackson JsonNode based on the field
     * type defined by the <code>DescribeEntity</code> API.
     * </p>
     * <p>
     * Spark connectors generate schemas according to the same data type mapping as in the <code>DescribeEntity</code>
     * API. Spark connectors convert data to the appropriate data types matching the schema when returning rows.
     * </p>
     *
     * @param getEntityRecordsRequest
     * @return A Java Future containing the result of the GetEntityRecords operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetEntityRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetEntityRecords" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEntityRecordsResponse> getEntityRecords(GetEntityRecordsRequest getEntityRecordsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is used to query preview data from a given connection type or from a native Amazon S3 based Glue Data
     * Catalog.
     * </p>
     * <p>
     * Returns records as an array of JSON blobs. Each record is formatted using Jackson JsonNode based on the field
     * type defined by the <code>DescribeEntity</code> API.
     * </p>
     * <p>
     * Spark connectors generate schemas according to the same data type mapping as in the <code>DescribeEntity</code>
     * API. Spark connectors convert data to the appropriate data types matching the schema when returning rows.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEntityRecordsRequest.Builder} avoiding the need
     * to create one manually via {@link GetEntityRecordsRequest#builder()}
     * </p>
     *
     * @param getEntityRecordsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetEntityRecordsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetEntityRecords operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetEntityRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetEntityRecords" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEntityRecordsResponse> getEntityRecords(
            Consumer<GetEntityRecordsRequest.Builder> getEntityRecordsRequest) {
        return getEntityRecords(GetEntityRecordsRequest.builder().applyMutation(getEntityRecordsRequest).build());
    }

    /**
     * <p>
     * This API is used for fetching the <code>ResourceProperty</code> of the Glue connection (for the source) or Glue
     * database ARN (for the target)
     * </p>
     *
     * @param getIntegrationResourcePropertyRequest
     * @return A Java Future containing the result of the GetIntegrationResourceProperty operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>InternalServerException An internal server error occurred.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetIntegrationResourceProperty
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetIntegrationResourceProperty"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIntegrationResourcePropertyResponse> getIntegrationResourceProperty(
            GetIntegrationResourcePropertyRequest getIntegrationResourcePropertyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is used for fetching the <code>ResourceProperty</code> of the Glue connection (for the source) or Glue
     * database ARN (for the target)
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIntegrationResourcePropertyRequest.Builder}
     * avoiding the need to create one manually via {@link GetIntegrationResourcePropertyRequest#builder()}
     * </p>
     *
     * @param getIntegrationResourcePropertyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetIntegrationResourcePropertyRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetIntegrationResourceProperty operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>InternalServerException An internal server error occurred.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetIntegrationResourceProperty
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetIntegrationResourceProperty"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIntegrationResourcePropertyResponse> getIntegrationResourceProperty(
            Consumer<GetIntegrationResourcePropertyRequest.Builder> getIntegrationResourcePropertyRequest) {
        return getIntegrationResourceProperty(GetIntegrationResourcePropertyRequest.builder()
                .applyMutation(getIntegrationResourcePropertyRequest).build());
    }

    /**
     * <p>
     * This API is used to retrieve optional override properties for the tables that need to be replicated. These
     * properties can include properties for filtering and partition for source and target tables.
     * </p>
     *
     * @param getIntegrationTablePropertiesRequest
     * @return A Java Future containing the result of the GetIntegrationTableProperties operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InternalServerException An internal server error occurred.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetIntegrationTableProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetIntegrationTableProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIntegrationTablePropertiesResponse> getIntegrationTableProperties(
            GetIntegrationTablePropertiesRequest getIntegrationTablePropertiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is used to retrieve optional override properties for the tables that need to be replicated. These
     * properties can include properties for filtering and partition for source and target tables.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIntegrationTablePropertiesRequest.Builder}
     * avoiding the need to create one manually via {@link GetIntegrationTablePropertiesRequest#builder()}
     * </p>
     *
     * @param getIntegrationTablePropertiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetIntegrationTablePropertiesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetIntegrationTableProperties operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InternalServerException An internal server error occurred.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetIntegrationTableProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetIntegrationTableProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIntegrationTablePropertiesResponse> getIntegrationTableProperties(
            Consumer<GetIntegrationTablePropertiesRequest.Builder> getIntegrationTablePropertiesRequest) {
        return getIntegrationTableProperties(GetIntegrationTablePropertiesRequest.builder()
                .applyMutation(getIntegrationTablePropertiesRequest).build());
    }

    /**
     * <p>
     * Retrieves an existing job definition.
     * </p>
     *
     * @param getJobRequest
     * @return A Java Future containing the result of the GetJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetJobResponse> getJob(GetJobRequest getJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an existing job definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobRequest.Builder} avoiding the need to create
     * one manually via {@link GetJobRequest#builder()}
     * </p>
     *
     * @param getJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetJobResponse> getJob(Consumer<GetJobRequest.Builder> getJobRequest) {
        return getJob(GetJobRequest.builder().applyMutation(getJobRequest).build());
    }

    /**
     * <p>
     * Returns information on a job bookmark entry.
     * </p>
     * <p>
     * For more information about enabling and using job bookmarks, see:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-continuations.html">Tracking processed data using job
     * bookmarks</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Job parameters
     * used by Glue</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html#aws-glue-api-jobs-job-Job">Job
     * structure</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getJobBookmarkRequest
     * @return A Java Future containing the result of the GetJobBookmark operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetJobBookmark
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobBookmark" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetJobBookmarkResponse> getJobBookmark(GetJobBookmarkRequest getJobBookmarkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information on a job bookmark entry.
     * </p>
     * <p>
     * For more information about enabling and using job bookmarks, see:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-continuations.html">Tracking processed data using job
     * bookmarks</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Job parameters
     * used by Glue</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html#aws-glue-api-jobs-job-Job">Job
     * structure</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobBookmarkRequest.Builder} avoiding the need to
     * create one manually via {@link GetJobBookmarkRequest#builder()}
     * </p>
     *
     * @param getJobBookmarkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetJobBookmarkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetJobBookmark operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>ValidationException A value could not be validated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetJobBookmark
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobBookmark" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetJobBookmarkResponse> getJobBookmark(Consumer<GetJobBookmarkRequest.Builder> getJobBookmarkRequest) {
        return getJobBookmark(GetJobBookmarkRequest.builder().applyMutation(getJobBookmarkRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata for a given job run. Job run history is accessible for 90 days for your workflow and job
     * run.
     * </p>
     *
     * @param getJobRunRequest
     * @return A Java Future containing the result of the GetJobRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetJobRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetJobRunResponse> getJobRun(GetJobRunRequest getJobRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata for a given job run. Job run history is accessible for 90 days for your workflow and job
     * run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobRunRequest.Builder} avoiding the need to
     * create one manually via {@link GetJobRunRequest#builder()}
     * </p>
     *
     * @param getJobRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetJobRunRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetJobRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetJobRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetJobRunResponse> getJobRun(Consumer<GetJobRunRequest.Builder> getJobRunRequest) {
        return getJobRun(GetJobRunRequest.builder().applyMutation(getJobRunRequest).build());
    }

    /**
     * <p>
     * Retrieves metadata for all runs of a given job definition.
     * </p>
     *
     * @param getJobRunsRequest
     * @return A Java Future containing the result of the GetJobRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetJobRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetJobRunsResponse> getJobRuns(GetJobRunsRequest getJobRunsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves metadata for all runs of a given job definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobRunsRequest.Builder} avoiding the need to
     * create one manually via {@link GetJobRunsRequest#builder()}
     * </p>
     *
     * @param getJobRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetJobRunsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetJobRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetJobRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetJobRunsResponse> getJobRuns(Consumer<GetJobRunsRequest.Builder> getJobRunsRequest) {
        return getJobRuns(GetJobRunsRequest.builder().applyMutation(getJobRunsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #getJobRuns(software.amazon.awssdk.services.glue.model.GetJobRunsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetJobRunsPublisher publisher = client.getJobRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetJobRunsPublisher publisher = client.getJobRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetJobRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetJobRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getJobRuns(software.amazon.awssdk.services.glue.model.GetJobRunsRequest)} operation.</b>
     * </p>
     *
     * @param getJobRunsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetJobRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobRunsPublisher getJobRunsPaginator(GetJobRunsRequest getJobRunsRequest) {
        return new GetJobRunsPublisher(this, getJobRunsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #getJobRuns(software.amazon.awssdk.services.glue.model.GetJobRunsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetJobRunsPublisher publisher = client.getJobRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetJobRunsPublisher publisher = client.getJobRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetJobRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetJobRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getJobRuns(software.amazon.awssdk.services.glue.model.GetJobRunsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobRunsRequest.Builder} avoiding the need to
     * create one manually via {@link GetJobRunsRequest#builder()}
     * </p>
     *
     * @param getJobRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetJobRunsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetJobRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobRunsPublisher getJobRunsPaginator(Consumer<GetJobRunsRequest.Builder> getJobRunsRequest) {
        return getJobRunsPaginator(GetJobRunsRequest.builder().applyMutation(getJobRunsRequest).build());
    }

    /**
     * <p>
     * Retrieves all current job definitions.
     * </p>
     *
     * @param getJobsRequest
     * @return A Java Future containing the result of the GetJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetJobsResponse> getJobs(GetJobsRequest getJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all current job definitions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobsRequest.Builder} avoiding the need to create
     * one manually via {@link GetJobsRequest#builder()}
     * </p>
     *
     * @param getJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetJobsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetJobsResponse> getJobs(Consumer<GetJobsRequest.Builder> getJobsRequest) {
        return getJobs(GetJobsRequest.builder().applyMutation(getJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #getJobs(software.amazon.awssdk.services.glue.model.GetJobsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetJobsPublisher publisher = client.getJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetJobsPublisher publisher = client.getJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getJobs(software.amazon.awssdk.services.glue.model.GetJobsRequest)} operation.</b>
     * </p>
     *
     * @param getJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobsPublisher getJobsPaginator(GetJobsRequest getJobsRequest) {
        return new GetJobsPublisher(this, getJobsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #getJobs(software.amazon.awssdk.services.glue.model.GetJobsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetJobsPublisher publisher = client.getJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetJobsPublisher publisher = client.getJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getJobs(software.amazon.awssdk.services.glue.model.GetJobsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobsRequest.Builder} avoiding the need to create
     * one manually via {@link GetJobsRequest#builder()}
     * </p>
     *
     * @param getJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetJobsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobsPublisher getJobsPaginator(Consumer<GetJobsRequest.Builder> getJobsRequest) {
        return getJobsPaginator(GetJobsRequest.builder().applyMutation(getJobsRequest).build());
    }

    /**
     * <p>
     * Gets details for a specific task run on a machine learning transform. Machine learning task runs are asynchronous
     * tasks that Glue runs on your behalf as part of various machine learning workflows. You can check the stats of any
     * task run by calling <code>GetMLTaskRun</code> with the <code>TaskRunID</code> and its parent transform's
     * <code>TransformID</code>.
     * </p>
     *
     * @param getMlTaskRunRequest
     * @return A Java Future containing the result of the GetMLTaskRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetMLTaskRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTaskRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMlTaskRunResponse> getMLTaskRun(GetMlTaskRunRequest getMlTaskRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details for a specific task run on a machine learning transform. Machine learning task runs are asynchronous
     * tasks that Glue runs on your behalf as part of various machine learning workflows. You can check the stats of any
     * task run by calling <code>GetMLTaskRun</code> with the <code>TaskRunID</code> and its parent transform's
     * <code>TransformID</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMlTaskRunRequest.Builder} avoiding the need to
     * create one manually via {@link GetMlTaskRunRequest#builder()}
     * </p>
     *
     * @param getMlTaskRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetMlTaskRunRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetMLTaskRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetMLTaskRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTaskRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMlTaskRunResponse> getMLTaskRun(Consumer<GetMlTaskRunRequest.Builder> getMlTaskRunRequest) {
        return getMLTaskRun(GetMlTaskRunRequest.builder().applyMutation(getMlTaskRunRequest).build());
    }

    /**
     * <p>
     * Gets a list of runs for a machine learning transform. Machine learning task runs are asynchronous tasks that Glue
     * runs on your behalf as part of various machine learning workflows. You can get a sortable, filterable list of
     * machine learning task runs by calling <code>GetMLTaskRuns</code> with their parent transform's
     * <code>TransformID</code> and other optional parameters as documented in this section.
     * </p>
     * <p>
     * This operation returns a list of historic runs and must be paginated.
     * </p>
     *
     * @param getMlTaskRunsRequest
     * @return A Java Future containing the result of the GetMLTaskRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetMLTaskRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTaskRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMlTaskRunsResponse> getMLTaskRuns(GetMlTaskRunsRequest getMlTaskRunsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of runs for a machine learning transform. Machine learning task runs are asynchronous tasks that Glue
     * runs on your behalf as part of various machine learning workflows. You can get a sortable, filterable list of
     * machine learning task runs by calling <code>GetMLTaskRuns</code> with their parent transform's
     * <code>TransformID</code> and other optional parameters as documented in this section.
     * </p>
     * <p>
     * This operation returns a list of historic runs and must be paginated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMlTaskRunsRequest.Builder} avoiding the need to
     * create one manually via {@link GetMlTaskRunsRequest#builder()}
     * </p>
     *
     * @param getMlTaskRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetMlTaskRunsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetMLTaskRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetMLTaskRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTaskRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMlTaskRunsResponse> getMLTaskRuns(Consumer<GetMlTaskRunsRequest.Builder> getMlTaskRunsRequest) {
        return getMLTaskRuns(GetMlTaskRunsRequest.builder().applyMutation(getMlTaskRunsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #getMLTaskRuns(software.amazon.awssdk.services.glue.model.GetMlTaskRunsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetMLTaskRunsPublisher publisher = client.getMLTaskRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetMLTaskRunsPublisher publisher = client.getMLTaskRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetMlTaskRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetMlTaskRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getMLTaskRuns(software.amazon.awssdk.services.glue.model.GetMlTaskRunsRequest)} operation.</b>
     * </p>
     *
     * @param getMlTaskRunsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetMLTaskRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTaskRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMLTaskRunsPublisher getMLTaskRunsPaginator(GetMlTaskRunsRequest getMlTaskRunsRequest) {
        return new GetMLTaskRunsPublisher(this, getMlTaskRunsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #getMLTaskRuns(software.amazon.awssdk.services.glue.model.GetMlTaskRunsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetMLTaskRunsPublisher publisher = client.getMLTaskRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetMLTaskRunsPublisher publisher = client.getMLTaskRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetMlTaskRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetMlTaskRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getMLTaskRuns(software.amazon.awssdk.services.glue.model.GetMlTaskRunsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMlTaskRunsRequest.Builder} avoiding the need to
     * create one manually via {@link GetMlTaskRunsRequest#builder()}
     * </p>
     *
     * @param getMlTaskRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetMlTaskRunsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetMLTaskRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTaskRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMLTaskRunsPublisher getMLTaskRunsPaginator(Consumer<GetMlTaskRunsRequest.Builder> getMlTaskRunsRequest) {
        return getMLTaskRunsPaginator(GetMlTaskRunsRequest.builder().applyMutation(getMlTaskRunsRequest).build());
    }

    /**
     * <p>
     * Gets an Glue machine learning transform artifact and all its corresponding metadata. Machine learning transforms
     * are a special type of transform that use machine learning to learn the details of the transformation to be
     * performed by learning from examples provided by humans. These transformations are then saved by Glue. You can
     * retrieve their metadata by calling <code>GetMLTransform</code>.
     * </p>
     *
     * @param getMlTransformRequest
     * @return A Java Future containing the result of the GetMLTransform operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetMLTransform
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTransform" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMlTransformResponse> getMLTransform(GetMlTransformRequest getMlTransformRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Glue machine learning transform artifact and all its corresponding metadata. Machine learning transforms
     * are a special type of transform that use machine learning to learn the details of the transformation to be
     * performed by learning from examples provided by humans. These transformations are then saved by Glue. You can
     * retrieve their metadata by calling <code>GetMLTransform</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMlTransformRequest.Builder} avoiding the need to
     * create one manually via {@link GetMlTransformRequest#builder()}
     * </p>
     *
     * @param getMlTransformRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetMlTransformRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetMLTransform operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetMLTransform
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTransform" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMlTransformResponse> getMLTransform(Consumer<GetMlTransformRequest.Builder> getMlTransformRequest) {
        return getMLTransform(GetMlTransformRequest.builder().applyMutation(getMlTransformRequest).build());
    }

    /**
     * <p>
     * Gets a sortable, filterable list of existing Glue machine learning transforms. Machine learning transforms are a
     * special type of transform that use machine learning to learn the details of the transformation to be performed by
     * learning from examples provided by humans. These transformations are then saved by Glue, and you can retrieve
     * their metadata by calling <code>GetMLTransforms</code>.
     * </p>
     *
     * @param getMlTransformsRequest
     * @return A Java Future containing the result of the GetMLTransforms operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetMLTransforms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTransforms" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMlTransformsResponse> getMLTransforms(GetMlTransformsRequest getMlTransformsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a sortable, filterable list of existing Glue machine learning transforms. Machine learning transforms are a
     * special type of transform that use machine learning to learn the details of the transformation to be performed by
     * learning from examples provided by humans. These transformations are then saved by Glue, and you can retrieve
     * their metadata by calling <code>GetMLTransforms</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMlTransformsRequest.Builder} avoiding the need
     * to create one manually via {@link GetMlTransformsRequest#builder()}
     * </p>
     *
     * @param getMlTransformsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetMlTransformsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetMLTransforms operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetMLTransforms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTransforms" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMlTransformsResponse> getMLTransforms(
            Consumer<GetMlTransformsRequest.Builder> getMlTransformsRequest) {
        return getMLTransforms(GetMlTransformsRequest.builder().applyMutation(getMlTransformsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #getMLTransforms(software.amazon.awssdk.services.glue.model.GetMlTransformsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetMLTransformsPublisher publisher = client.getMLTransformsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetMLTransformsPublisher publisher = client.getMLTransformsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetMlTransformsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetMlTransformsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getMLTransforms(software.amazon.awssdk.services.glue.model.GetMlTransformsRequest)} operation.</b>
     * </p>
     *
     * @param getMlTransformsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetMLTransforms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTransforms" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMLTransformsPublisher getMLTransformsPaginator(GetMlTransformsRequest getMlTransformsRequest) {
        return new GetMLTransformsPublisher(this, getMlTransformsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #getMLTransforms(software.amazon.awssdk.services.glue.model.GetMlTransformsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetMLTransformsPublisher publisher = client.getMLTransformsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetMLTransformsPublisher publisher = client.getMLTransformsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetMlTransformsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetMlTransformsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getMLTransforms(software.amazon.awssdk.services.glue.model.GetMlTransformsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMlTransformsRequest.Builder} avoiding the need
     * to create one manually via {@link GetMlTransformsRequest#builder()}
     * </p>
     *
     * @param getMlTransformsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetMlTransformsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetMLTransforms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTransforms" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMLTransformsPublisher getMLTransformsPaginator(Consumer<GetMlTransformsRequest.Builder> getMlTransformsRequest) {
        return getMLTransformsPaginator(GetMlTransformsRequest.builder().applyMutation(getMlTransformsRequest).build());
    }

    /**
     * <p>
     * Creates mappings.
     * </p>
     *
     * @param getMappingRequest
     * @return A Java Future containing the result of the GetMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMapping" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMappingResponse> getMapping(GetMappingRequest getMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates mappings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMappingRequest.Builder} avoiding the need to
     * create one manually via {@link GetMappingRequest#builder()}
     * </p>
     *
     * @param getMappingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetMappingRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMapping" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMappingResponse> getMapping(Consumer<GetMappingRequest.Builder> getMappingRequest) {
        return getMapping(GetMappingRequest.builder().applyMutation(getMappingRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specified partition.
     * </p>
     *
     * @param getPartitionRequest
     * @return A Java Future containing the result of the GetPartition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetPartition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartition" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPartitionResponse> getPartition(GetPartitionRequest getPartitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specified partition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPartitionRequest.Builder} avoiding the need to
     * create one manually via {@link GetPartitionRequest#builder()}
     * </p>
     *
     * @param getPartitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetPartitionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPartition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetPartition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartition" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPartitionResponse> getPartition(Consumer<GetPartitionRequest.Builder> getPartitionRequest) {
        return getPartition(GetPartitionRequest.builder().applyMutation(getPartitionRequest).build());
    }

    /**
     * <p>
     * Retrieves the partition indexes associated with a table.
     * </p>
     *
     * @param getPartitionIndexesRequest
     * @return A Java Future containing the result of the GetPartitionIndexes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>ConflictException The <code>CreatePartitions</code> API was called on a table that has indexes
     *         enabled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetPartitionIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartitionIndexes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPartitionIndexesResponse> getPartitionIndexes(
            GetPartitionIndexesRequest getPartitionIndexesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the partition indexes associated with a table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPartitionIndexesRequest.Builder} avoiding the
     * need to create one manually via {@link GetPartitionIndexesRequest#builder()}
     * </p>
     *
     * @param getPartitionIndexesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetPartitionIndexesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPartitionIndexes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>ConflictException The <code>CreatePartitions</code> API was called on a table that has indexes
     *         enabled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetPartitionIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartitionIndexes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPartitionIndexesResponse> getPartitionIndexes(
            Consumer<GetPartitionIndexesRequest.Builder> getPartitionIndexesRequest) {
        return getPartitionIndexes(GetPartitionIndexesRequest.builder().applyMutation(getPartitionIndexesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getPartitionIndexes(software.amazon.awssdk.services.glue.model.GetPartitionIndexesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetPartitionIndexesPublisher publisher = client.getPartitionIndexesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetPartitionIndexesPublisher publisher = client.getPartitionIndexesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetPartitionIndexesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetPartitionIndexesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPartitionIndexes(software.amazon.awssdk.services.glue.model.GetPartitionIndexesRequest)}
     * operation.</b>
     * </p>
     *
     * @param getPartitionIndexesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>ConflictException The <code>CreatePartitions</code> API was called on a table that has indexes
     *         enabled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetPartitionIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartitionIndexes" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPartitionIndexesPublisher getPartitionIndexesPaginator(GetPartitionIndexesRequest getPartitionIndexesRequest) {
        return new GetPartitionIndexesPublisher(this, getPartitionIndexesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getPartitionIndexes(software.amazon.awssdk.services.glue.model.GetPartitionIndexesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetPartitionIndexesPublisher publisher = client.getPartitionIndexesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetPartitionIndexesPublisher publisher = client.getPartitionIndexesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetPartitionIndexesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetPartitionIndexesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPartitionIndexes(software.amazon.awssdk.services.glue.model.GetPartitionIndexesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPartitionIndexesRequest.Builder} avoiding the
     * need to create one manually via {@link GetPartitionIndexesRequest#builder()}
     * </p>
     *
     * @param getPartitionIndexesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetPartitionIndexesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>ConflictException The <code>CreatePartitions</code> API was called on a table that has indexes
     *         enabled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetPartitionIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartitionIndexes" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPartitionIndexesPublisher getPartitionIndexesPaginator(
            Consumer<GetPartitionIndexesRequest.Builder> getPartitionIndexesRequest) {
        return getPartitionIndexesPaginator(GetPartitionIndexesRequest.builder().applyMutation(getPartitionIndexesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about the partitions in a table.
     * </p>
     *
     * @param getPartitionsRequest
     * @return A Java Future containing the result of the GetPartitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>InvalidStateException An error that indicates your data is in an invalid state.</li>
     *         <li>ResourceNotReadyException A resource was not ready for a transaction.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetPartitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartitions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPartitionsResponse> getPartitions(GetPartitionsRequest getPartitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the partitions in a table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPartitionsRequest.Builder} avoiding the need to
     * create one manually via {@link GetPartitionsRequest#builder()}
     * </p>
     *
     * @param getPartitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetPartitionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPartitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>InvalidStateException An error that indicates your data is in an invalid state.</li>
     *         <li>ResourceNotReadyException A resource was not ready for a transaction.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetPartitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartitions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPartitionsResponse> getPartitions(Consumer<GetPartitionsRequest.Builder> getPartitionsRequest) {
        return getPartitions(GetPartitionsRequest.builder().applyMutation(getPartitionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #getPartitions(software.amazon.awssdk.services.glue.model.GetPartitionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetPartitionsPublisher publisher = client.getPartitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetPartitionsPublisher publisher = client.getPartitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetPartitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetPartitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPartitions(software.amazon.awssdk.services.glue.model.GetPartitionsRequest)} operation.</b>
     * </p>
     *
     * @param getPartitionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>InvalidStateException An error that indicates your data is in an invalid state.</li>
     *         <li>ResourceNotReadyException A resource was not ready for a transaction.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetPartitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartitions" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPartitionsPublisher getPartitionsPaginator(GetPartitionsRequest getPartitionsRequest) {
        return new GetPartitionsPublisher(this, getPartitionsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #getPartitions(software.amazon.awssdk.services.glue.model.GetPartitionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetPartitionsPublisher publisher = client.getPartitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetPartitionsPublisher publisher = client.getPartitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetPartitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetPartitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getPartitions(software.amazon.awssdk.services.glue.model.GetPartitionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPartitionsRequest.Builder} avoiding the need to
     * create one manually via {@link GetPartitionsRequest#builder()}
     * </p>
     *
     * @param getPartitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetPartitionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>InvalidStateException An error that indicates your data is in an invalid state.</li>
     *         <li>ResourceNotReadyException A resource was not ready for a transaction.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetPartitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartitions" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPartitionsPublisher getPartitionsPaginator(Consumer<GetPartitionsRequest.Builder> getPartitionsRequest) {
        return getPartitionsPaginator(GetPartitionsRequest.builder().applyMutation(getPartitionsRequest).build());
    }

    /**
     * <p>
     * Gets code to perform a specified mapping.
     * </p>
     *
     * @param getPlanRequest
     * @return A Java Future containing the result of the GetPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPlanResponse> getPlan(GetPlanRequest getPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets code to perform a specified mapping.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPlanRequest.Builder} avoiding the need to create
     * one manually via {@link GetPlanRequest#builder()}
     * </p>
     *
     * @param getPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetPlanRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPlanResponse> getPlan(Consumer<GetPlanRequest.Builder> getPlanRequest) {
        return getPlan(GetPlanRequest.builder().applyMutation(getPlanRequest).build());
    }

    /**
     * <p>
     * Describes the specified registry in detail.
     * </p>
     *
     * @param getRegistryRequest
     * @return A Java Future containing the result of the GetRegistry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetRegistry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRegistryResponse> getRegistry(GetRegistryRequest getRegistryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified registry in detail.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRegistryRequest.Builder} avoiding the need to
     * create one manually via {@link GetRegistryRequest#builder()}
     * </p>
     *
     * @param getRegistryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetRegistryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRegistry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetRegistry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRegistryResponse> getRegistry(Consumer<GetRegistryRequest.Builder> getRegistryRequest) {
        return getRegistry(GetRegistryRequest.builder().applyMutation(getRegistryRequest).build());
    }

    /**
     * <p>
     * Retrieves the resource policies set on individual resources by Resource Access Manager during cross-account
     * permission grants. Also retrieves the Data Catalog resource policy.
     * </p>
     * <p>
     * If you enabled metadata encryption in Data Catalog settings, and you do not have permission on the KMS key, the
     * operation can't return the Data Catalog resource policy.
     * </p>
     *
     * @param getResourcePoliciesRequest
     * @return A Java Future containing the result of the GetResourcePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetResourcePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetResourcePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetResourcePoliciesResponse> getResourcePolicies(
            GetResourcePoliciesRequest getResourcePoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the resource policies set on individual resources by Resource Access Manager during cross-account
     * permission grants. Also retrieves the Data Catalog resource policy.
     * </p>
     * <p>
     * If you enabled metadata encryption in Data Catalog settings, and you do not have permission on the KMS key, the
     * operation can't return the Data Catalog resource policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourcePoliciesRequest#builder()}
     * </p>
     *
     * @param getResourcePoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetResourcePoliciesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetResourcePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetResourcePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetResourcePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetResourcePoliciesResponse> getResourcePolicies(
            Consumer<GetResourcePoliciesRequest.Builder> getResourcePoliciesRequest) {
        return getResourcePolicies(GetResourcePoliciesRequest.builder().applyMutation(getResourcePoliciesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getResourcePolicies(software.amazon.awssdk.services.glue.model.GetResourcePoliciesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetResourcePoliciesPublisher publisher = client.getResourcePoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetResourcePoliciesPublisher publisher = client.getResourcePoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetResourcePoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetResourcePoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourcePolicies(software.amazon.awssdk.services.glue.model.GetResourcePoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param getResourcePoliciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetResourcePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetResourcePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourcePoliciesPublisher getResourcePoliciesPaginator(GetResourcePoliciesRequest getResourcePoliciesRequest) {
        return new GetResourcePoliciesPublisher(this, getResourcePoliciesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getResourcePolicies(software.amazon.awssdk.services.glue.model.GetResourcePoliciesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetResourcePoliciesPublisher publisher = client.getResourcePoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetResourcePoliciesPublisher publisher = client.getResourcePoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetResourcePoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetResourcePoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourcePolicies(software.amazon.awssdk.services.glue.model.GetResourcePoliciesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourcePoliciesRequest#builder()}
     * </p>
     *
     * @param getResourcePoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetResourcePoliciesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetResourcePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetResourcePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourcePoliciesPublisher getResourcePoliciesPaginator(
            Consumer<GetResourcePoliciesRequest.Builder> getResourcePoliciesRequest) {
        return getResourcePoliciesPaginator(GetResourcePoliciesRequest.builder().applyMutation(getResourcePoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a specified resource policy.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a specified resource policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourcePolicyRequest#builder()}
     * </p>
     *
     * @param getResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetResourcePolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(
            Consumer<GetResourcePolicyRequest.Builder> getResourcePolicyRequest) {
        return getResourcePolicy(GetResourcePolicyRequest.builder().applyMutation(getResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Describes the specified schema in detail.
     * </p>
     *
     * @param getSchemaRequest
     * @return A Java Future containing the result of the GetSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSchemaResponse> getSchema(GetSchemaRequest getSchemaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified schema in detail.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSchemaRequest.Builder} avoiding the need to
     * create one manually via {@link GetSchemaRequest#builder()}
     * </p>
     *
     * @param getSchemaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetSchemaRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSchemaResponse> getSchema(Consumer<GetSchemaRequest.Builder> getSchemaRequest) {
        return getSchema(GetSchemaRequest.builder().applyMutation(getSchemaRequest).build());
    }

    /**
     * <p>
     * Retrieves a schema by the <code>SchemaDefinition</code>. The schema definition is sent to the Schema Registry,
     * canonicalized, and hashed. If the hash is matched within the scope of the <code>SchemaName</code> or ARN (or the
     * default registry, if none is supplied), that schema’s metadata is returned. Otherwise, a 404 or NotFound error is
     * returned. Schema versions in <code>Deleted</code> statuses will not be included in the results.
     * </p>
     *
     * @param getSchemaByDefinitionRequest
     * @return A Java Future containing the result of the GetSchemaByDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetSchemaByDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSchemaByDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSchemaByDefinitionResponse> getSchemaByDefinition(
            GetSchemaByDefinitionRequest getSchemaByDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a schema by the <code>SchemaDefinition</code>. The schema definition is sent to the Schema Registry,
     * canonicalized, and hashed. If the hash is matched within the scope of the <code>SchemaName</code> or ARN (or the
     * default registry, if none is supplied), that schema’s metadata is returned. Otherwise, a 404 or NotFound error is
     * returned. Schema versions in <code>Deleted</code> statuses will not be included in the results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSchemaByDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link GetSchemaByDefinitionRequest#builder()}
     * </p>
     *
     * @param getSchemaByDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetSchemaByDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSchemaByDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetSchemaByDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSchemaByDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSchemaByDefinitionResponse> getSchemaByDefinition(
            Consumer<GetSchemaByDefinitionRequest.Builder> getSchemaByDefinitionRequest) {
        return getSchemaByDefinition(GetSchemaByDefinitionRequest.builder().applyMutation(getSchemaByDefinitionRequest).build());
    }

    /**
     * <p>
     * Get the specified schema by its unique ID assigned when a version of the schema is created or registered. Schema
     * versions in Deleted status will not be included in the results.
     * </p>
     *
     * @param getSchemaVersionRequest
     * @return A Java Future containing the result of the GetSchemaVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetSchemaVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSchemaVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSchemaVersionResponse> getSchemaVersion(GetSchemaVersionRequest getSchemaVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the specified schema by its unique ID assigned when a version of the schema is created or registered. Schema
     * versions in Deleted status will not be included in the results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSchemaVersionRequest.Builder} avoiding the need
     * to create one manually via {@link GetSchemaVersionRequest#builder()}
     * </p>
     *
     * @param getSchemaVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetSchemaVersionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSchemaVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetSchemaVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSchemaVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSchemaVersionResponse> getSchemaVersion(
            Consumer<GetSchemaVersionRequest.Builder> getSchemaVersionRequest) {
        return getSchemaVersion(GetSchemaVersionRequest.builder().applyMutation(getSchemaVersionRequest).build());
    }

    /**
     * <p>
     * Fetches the schema version difference in the specified difference type between two stored schema versions in the
     * Schema Registry.
     * </p>
     * <p>
     * This API allows you to compare two schema versions between two schema definitions under the same schema.
     * </p>
     *
     * @param getSchemaVersionsDiffRequest
     * @return A Java Future containing the result of the GetSchemaVersionsDiff operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetSchemaVersionsDiff
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSchemaVersionsDiff" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSchemaVersionsDiffResponse> getSchemaVersionsDiff(
            GetSchemaVersionsDiffRequest getSchemaVersionsDiffRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetches the schema version difference in the specified difference type between two stored schema versions in the
     * Schema Registry.
     * </p>
     * <p>
     * This API allows you to compare two schema versions between two schema definitions under the same schema.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSchemaVersionsDiffRequest.Builder} avoiding the
     * need to create one manually via {@link GetSchemaVersionsDiffRequest#builder()}
     * </p>
     *
     * @param getSchemaVersionsDiffRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetSchemaVersionsDiffRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSchemaVersionsDiff operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetSchemaVersionsDiff
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSchemaVersionsDiff" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSchemaVersionsDiffResponse> getSchemaVersionsDiff(
            Consumer<GetSchemaVersionsDiffRequest.Builder> getSchemaVersionsDiffRequest) {
        return getSchemaVersionsDiff(GetSchemaVersionsDiffRequest.builder().applyMutation(getSchemaVersionsDiffRequest).build());
    }

    /**
     * <p>
     * Retrieves a specified security configuration.
     * </p>
     *
     * @param getSecurityConfigurationRequest
     * @return A Java Future containing the result of the GetSecurityConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetSecurityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSecurityConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSecurityConfigurationResponse> getSecurityConfiguration(
            GetSecurityConfigurationRequest getSecurityConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a specified security configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSecurityConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetSecurityConfigurationRequest#builder()}
     * </p>
     *
     * @param getSecurityConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetSecurityConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSecurityConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetSecurityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSecurityConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSecurityConfigurationResponse> getSecurityConfiguration(
            Consumer<GetSecurityConfigurationRequest.Builder> getSecurityConfigurationRequest) {
        return getSecurityConfiguration(GetSecurityConfigurationRequest.builder().applyMutation(getSecurityConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of all security configurations.
     * </p>
     *
     * @param getSecurityConfigurationsRequest
     * @return A Java Future containing the result of the GetSecurityConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetSecurityConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSecurityConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSecurityConfigurationsResponse> getSecurityConfigurations(
            GetSecurityConfigurationsRequest getSecurityConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all security configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSecurityConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link GetSecurityConfigurationsRequest#builder()}
     * </p>
     *
     * @param getSecurityConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSecurityConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetSecurityConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSecurityConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSecurityConfigurationsResponse> getSecurityConfigurations(
            Consumer<GetSecurityConfigurationsRequest.Builder> getSecurityConfigurationsRequest) {
        return getSecurityConfigurations(GetSecurityConfigurationsRequest.builder()
                .applyMutation(getSecurityConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getSecurityConfigurations(software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetSecurityConfigurationsPublisher publisher = client.getSecurityConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetSecurityConfigurationsPublisher publisher = client.getSecurityConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSecurityConfigurations(software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getSecurityConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetSecurityConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSecurityConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSecurityConfigurationsPublisher getSecurityConfigurationsPaginator(
            GetSecurityConfigurationsRequest getSecurityConfigurationsRequest) {
        return new GetSecurityConfigurationsPublisher(this, getSecurityConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getSecurityConfigurations(software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetSecurityConfigurationsPublisher publisher = client.getSecurityConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetSecurityConfigurationsPublisher publisher = client.getSecurityConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSecurityConfigurations(software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSecurityConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link GetSecurityConfigurationsRequest#builder()}
     * </p>
     *
     * @param getSecurityConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetSecurityConfigurationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetSecurityConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSecurityConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSecurityConfigurationsPublisher getSecurityConfigurationsPaginator(
            Consumer<GetSecurityConfigurationsRequest.Builder> getSecurityConfigurationsRequest) {
        return getSecurityConfigurationsPaginator(GetSecurityConfigurationsRequest.builder()
                .applyMutation(getSecurityConfigurationsRequest).build());
    }

    /**
     * <p>
     * Retrieves the session.
     * </p>
     *
     * @param getSessionRequest
     * @return A Java Future containing the result of the GetSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSessionResponse> getSession(GetSessionRequest getSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSessionRequest.Builder} avoiding the need to
     * create one manually via {@link GetSessionRequest#builder()}
     * </p>
     *
     * @param getSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetSessionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSessionResponse> getSession(Consumer<GetSessionRequest.Builder> getSessionRequest) {
        return getSession(GetSessionRequest.builder().applyMutation(getSessionRequest).build());
    }

    /**
     * <p>
     * Retrieves the statement.
     * </p>
     *
     * @param getStatementRequest
     * @return A Java Future containing the result of the GetStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>IllegalSessionStateException The session is in an invalid state to perform a requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetStatement" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetStatementResponse> getStatement(GetStatementRequest getStatementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the statement.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStatementRequest.Builder} avoiding the need to
     * create one manually via {@link GetStatementRequest#builder()}
     * </p>
     *
     * @param getStatementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetStatementRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>IllegalSessionStateException The session is in an invalid state to perform a requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetStatement" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetStatementResponse> getStatement(Consumer<GetStatementRequest.Builder> getStatementRequest) {
        return getStatement(GetStatementRequest.builder().applyMutation(getStatementRequest).build());
    }

    /**
     * <p>
     * Retrieves the <code>Table</code> definition in a Data Catalog for a specified table.
     * </p>
     *
     * @param getTableRequest
     * @return A Java Future containing the result of the GetTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>ResourceNotReadyException A resource was not ready for a transaction.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTableResponse> getTable(GetTableRequest getTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the <code>Table</code> definition in a Data Catalog for a specified table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableRequest.Builder} avoiding the need to
     * create one manually via {@link GetTableRequest#builder()}
     * </p>
     *
     * @param getTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetTableRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>ResourceNotReadyException A resource was not ready for a transaction.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTableResponse> getTable(Consumer<GetTableRequest.Builder> getTableRequest) {
        return getTable(GetTableRequest.builder().applyMutation(getTableRequest).build());
    }

    /**
     * <p>
     * Returns the configuration of all optimizers associated with a specified table.
     * </p>
     *
     * @param getTableOptimizerRequest
     * @return A Java Future containing the result of the GetTableOptimizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>ThrottlingException The throttling threshhold was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetTableOptimizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTableOptimizer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTableOptimizerResponse> getTableOptimizer(GetTableOptimizerRequest getTableOptimizerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the configuration of all optimizers associated with a specified table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableOptimizerRequest.Builder} avoiding the need
     * to create one manually via {@link GetTableOptimizerRequest#builder()}
     * </p>
     *
     * @param getTableOptimizerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetTableOptimizerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTableOptimizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>AccessDeniedException Access to a resource was denied.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>ThrottlingException The throttling threshhold was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetTableOptimizer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTableOptimizer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTableOptimizerResponse> getTableOptimizer(
            Consumer<GetTableOptimizerRequest.Builder> getTableOptimizerRequest) {
        return getTableOptimizer(GetTableOptimizerRequest.builder().applyMutation(getTableOptimizerRequest).build());
    }

    /**
     * <p>
     * Retrieves a specified version of a table.
     * </p>
     *
     * @param getTableVersionRequest
     * @return A Java Future containing the result of the GetTableVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetTableVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTableVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTableVersionResponse> getTableVersion(GetTableVersionRequest getTableVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a specified version of a table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableVersionRequest.Builder} avoiding the need
     * to create one manually via {@link GetTableVersionRequest#builder()}
     * </p>
     *
     * @param getTableVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetTableVersionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTableVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetTableVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTableVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTableVersionResponse> getTableVersion(
            Consumer<GetTableVersionRequest.Builder> getTableVersionRequest) {
        return getTableVersion(GetTableVersionRequest.builder().applyMutation(getTableVersionRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of strings that identify available versions of a specified table.
     * </p>
     *
     * @param getTableVersionsRequest
     * @return A Java Future containing the result of the GetTableVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetTableVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTableVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTableVersionsResponse> getTableVersions(GetTableVersionsRequest getTableVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of strings that identify available versions of a specified table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link GetTableVersionsRequest#builder()}
     * </p>
     *
     * @param getTableVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetTableVersionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTableVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetTableVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTableVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTableVersionsResponse> getTableVersions(
            Consumer<GetTableVersionsRequest.Builder> getTableVersionsRequest) {
        return getTableVersions(GetTableVersionsRequest.builder().applyMutation(getTableVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getTableVersions(software.amazon.awssdk.services.glue.model.GetTableVersionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTableVersionsPublisher publisher = client.getTableVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTableVersionsPublisher publisher = client.getTableVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetTableVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetTableVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTableVersions(software.amazon.awssdk.services.glue.model.GetTableVersionsRequest)} operation.</b>
     * </p>
     *
     * @param getTableVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetTableVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTableVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTableVersionsPublisher getTableVersionsPaginator(GetTableVersionsRequest getTableVersionsRequest) {
        return new GetTableVersionsPublisher(this, getTableVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getTableVersions(software.amazon.awssdk.services.glue.model.GetTableVersionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTableVersionsPublisher publisher = client.getTableVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTableVersionsPublisher publisher = client.getTableVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetTableVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetTableVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTableVersions(software.amazon.awssdk.services.glue.model.GetTableVersionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTableVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link GetTableVersionsRequest#builder()}
     * </p>
     *
     * @param getTableVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetTableVersionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetTableVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTableVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTableVersionsPublisher getTableVersionsPaginator(Consumer<GetTableVersionsRequest.Builder> getTableVersionsRequest) {
        return getTableVersionsPaginator(GetTableVersionsRequest.builder().applyMutation(getTableVersionsRequest).build());
    }

    /**
     * <p>
     * Retrieves the definitions of some or all of the tables in a given <code>Database</code>.
     * </p>
     *
     * @param getTablesRequest
     * @return A Java Future containing the result of the GetTables operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTables" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTablesResponse> getTables(GetTablesRequest getTablesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the definitions of some or all of the tables in a given <code>Database</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTablesRequest.Builder} avoiding the need to
     * create one manually via {@link GetTablesRequest#builder()}
     * </p>
     *
     * @param getTablesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetTablesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTables operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTables" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTablesResponse> getTables(Consumer<GetTablesRequest.Builder> getTablesRequest) {
        return getTables(GetTablesRequest.builder().applyMutation(getTablesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #getTables(software.amazon.awssdk.services.glue.model.GetTablesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTablesPublisher publisher = client.getTablesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTablesPublisher publisher = client.getTablesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetTablesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetTablesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTables(software.amazon.awssdk.services.glue.model.GetTablesRequest)} operation.</b>
     * </p>
     *
     * @param getTablesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTables" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTablesPublisher getTablesPaginator(GetTablesRequest getTablesRequest) {
        return new GetTablesPublisher(this, getTablesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #getTables(software.amazon.awssdk.services.glue.model.GetTablesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTablesPublisher publisher = client.getTablesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTablesPublisher publisher = client.getTablesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetTablesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetTablesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTables(software.amazon.awssdk.services.glue.model.GetTablesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTablesRequest.Builder} avoiding the need to
     * create one manually via {@link GetTablesRequest#builder()}
     * </p>
     *
     * @param getTablesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetTablesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTables" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTablesPublisher getTablesPaginator(Consumer<GetTablesRequest.Builder> getTablesRequest) {
        return getTablesPaginator(GetTablesRequest.builder().applyMutation(getTablesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of tags associated with a resource.
     * </p>
     *
     * @param getTagsRequest
     * @return A Java Future containing the result of the GetTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTagsResponse> getTags(GetTagsRequest getTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of tags associated with a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTagsRequest.Builder} avoiding the need to create
     * one manually via {@link GetTagsRequest#builder()}
     * </p>
     *
     * @param getTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetTagsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTagsResponse> getTags(Consumer<GetTagsRequest.Builder> getTagsRequest) {
        return getTags(GetTagsRequest.builder().applyMutation(getTagsRequest).build());
    }

    /**
     * <p>
     * Retrieves the definition of a trigger.
     * </p>
     *
     * @param getTriggerRequest
     * @return A Java Future containing the result of the GetTrigger operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetTrigger
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTrigger" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTriggerResponse> getTrigger(GetTriggerRequest getTriggerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the definition of a trigger.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTriggerRequest.Builder} avoiding the need to
     * create one manually via {@link GetTriggerRequest#builder()}
     * </p>
     *
     * @param getTriggerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetTriggerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTrigger operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetTrigger
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTrigger" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTriggerResponse> getTrigger(Consumer<GetTriggerRequest.Builder> getTriggerRequest) {
        return getTrigger(GetTriggerRequest.builder().applyMutation(getTriggerRequest).build());
    }

    /**
     * <p>
     * Gets all the triggers associated with a job.
     * </p>
     *
     * @param getTriggersRequest
     * @return A Java Future containing the result of the GetTriggers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetTriggers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTriggers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTriggersResponse> getTriggers(GetTriggersRequest getTriggersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all the triggers associated with a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTriggersRequest.Builder} avoiding the need to
     * create one manually via {@link GetTriggersRequest#builder()}
     * </p>
     *
     * @param getTriggersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetTriggersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTriggers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetTriggers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTriggers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTriggersResponse> getTriggers(Consumer<GetTriggersRequest.Builder> getTriggersRequest) {
        return getTriggers(GetTriggersRequest.builder().applyMutation(getTriggersRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #getTriggers(software.amazon.awssdk.services.glue.model.GetTriggersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTriggersPublisher publisher = client.getTriggersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTriggersPublisher publisher = client.getTriggersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetTriggersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetTriggersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTriggers(software.amazon.awssdk.services.glue.model.GetTriggersRequest)} operation.</b>
     * </p>
     *
     * @param getTriggersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetTriggers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTriggers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTriggersPublisher getTriggersPaginator(GetTriggersRequest getTriggersRequest) {
        return new GetTriggersPublisher(this, getTriggersRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #getTriggers(software.amazon.awssdk.services.glue.model.GetTriggersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTriggersPublisher publisher = client.getTriggersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetTriggersPublisher publisher = client.getTriggersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetTriggersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetTriggersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTriggers(software.amazon.awssdk.services.glue.model.GetTriggersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTriggersRequest.Builder} avoiding the need to
     * create one manually via {@link GetTriggersRequest#builder()}
     * </p>
     *
     * @param getTriggersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetTriggersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetTriggers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTriggers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTriggersPublisher getTriggersPaginator(Consumer<GetTriggersRequest.Builder> getTriggersRequest) {
        return getTriggersPaginator(GetTriggersRequest.builder().applyMutation(getTriggersRequest).build());
    }

    /**
     * <p>
     * Retrieves partition metadata from the Data Catalog that contains unfiltered metadata.
     * </p>
     * <p>
     * For IAM authorization, the public IAM action associated with this API is <code>glue:GetPartition</code>.
     * </p>
     *
     * @param getUnfilteredPartitionMetadataRequest
     * @return A Java Future containing the result of the GetUnfilteredPartitionMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>PermissionTypeMismatchException The operation timed out.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetUnfilteredPartitionMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUnfilteredPartitionMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetUnfilteredPartitionMetadataResponse> getUnfilteredPartitionMetadata(
            GetUnfilteredPartitionMetadataRequest getUnfilteredPartitionMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves partition metadata from the Data Catalog that contains unfiltered metadata.
     * </p>
     * <p>
     * For IAM authorization, the public IAM action associated with this API is <code>glue:GetPartition</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUnfilteredPartitionMetadataRequest.Builder}
     * avoiding the need to create one manually via {@link GetUnfilteredPartitionMetadataRequest#builder()}
     * </p>
     *
     * @param getUnfilteredPartitionMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetUnfilteredPartitionMetadataRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetUnfilteredPartitionMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>PermissionTypeMismatchException The operation timed out.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetUnfilteredPartitionMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUnfilteredPartitionMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetUnfilteredPartitionMetadataResponse> getUnfilteredPartitionMetadata(
            Consumer<GetUnfilteredPartitionMetadataRequest.Builder> getUnfilteredPartitionMetadataRequest) {
        return getUnfilteredPartitionMetadata(GetUnfilteredPartitionMetadataRequest.builder()
                .applyMutation(getUnfilteredPartitionMetadataRequest).build());
    }

    /**
     * <p>
     * Retrieves partition metadata from the Data Catalog that contains unfiltered metadata.
     * </p>
     * <p>
     * For IAM authorization, the public IAM action associated with this API is <code>glue:GetPartitions</code>.
     * </p>
     *
     * @param getUnfilteredPartitionsMetadataRequest
     * @return A Java Future containing the result of the GetUnfilteredPartitionsMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>PermissionTypeMismatchException The operation timed out.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetUnfilteredPartitionsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUnfilteredPartitionsMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetUnfilteredPartitionsMetadataResponse> getUnfilteredPartitionsMetadata(
            GetUnfilteredPartitionsMetadataRequest getUnfilteredPartitionsMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves partition metadata from the Data Catalog that contains unfiltered metadata.
     * </p>
     * <p>
     * For IAM authorization, the public IAM action associated with this API is <code>glue:GetPartitions</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUnfilteredPartitionsMetadataRequest.Builder}
     * avoiding the need to create one manually via {@link GetUnfilteredPartitionsMetadataRequest#builder()}
     * </p>
     *
     * @param getUnfilteredPartitionsMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetUnfilteredPartitionsMetadataRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetUnfilteredPartitionsMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>PermissionTypeMismatchException The operation timed out.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetUnfilteredPartitionsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUnfilteredPartitionsMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetUnfilteredPartitionsMetadataResponse> getUnfilteredPartitionsMetadata(
            Consumer<GetUnfilteredPartitionsMetadataRequest.Builder> getUnfilteredPartitionsMetadataRequest) {
        return getUnfilteredPartitionsMetadata(GetUnfilteredPartitionsMetadataRequest.builder()
                .applyMutation(getUnfilteredPartitionsMetadataRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getUnfilteredPartitionsMetadata(software.amazon.awssdk.services.glue.model.GetUnfilteredPartitionsMetadataRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetUnfilteredPartitionsMetadataPublisher publisher = client.getUnfilteredPartitionsMetadataPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetUnfilteredPartitionsMetadataPublisher publisher = client.getUnfilteredPartitionsMetadataPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetUnfilteredPartitionsMetadataResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetUnfilteredPartitionsMetadataResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUnfilteredPartitionsMetadata(software.amazon.awssdk.services.glue.model.GetUnfilteredPartitionsMetadataRequest)}
     * operation.</b>
     * </p>
     *
     * @param getUnfilteredPartitionsMetadataRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>PermissionTypeMismatchException The operation timed out.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetUnfilteredPartitionsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUnfilteredPartitionsMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default GetUnfilteredPartitionsMetadataPublisher getUnfilteredPartitionsMetadataPaginator(
            GetUnfilteredPartitionsMetadataRequest getUnfilteredPartitionsMetadataRequest) {
        return new GetUnfilteredPartitionsMetadataPublisher(this, getUnfilteredPartitionsMetadataRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getUnfilteredPartitionsMetadata(software.amazon.awssdk.services.glue.model.GetUnfilteredPartitionsMetadataRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetUnfilteredPartitionsMetadataPublisher publisher = client.getUnfilteredPartitionsMetadataPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetUnfilteredPartitionsMetadataPublisher publisher = client.getUnfilteredPartitionsMetadataPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetUnfilteredPartitionsMetadataResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetUnfilteredPartitionsMetadataResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUnfilteredPartitionsMetadata(software.amazon.awssdk.services.glue.model.GetUnfilteredPartitionsMetadataRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUnfilteredPartitionsMetadataRequest.Builder}
     * avoiding the need to create one manually via {@link GetUnfilteredPartitionsMetadataRequest#builder()}
     * </p>
     *
     * @param getUnfilteredPartitionsMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetUnfilteredPartitionsMetadataRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>PermissionTypeMismatchException The operation timed out.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetUnfilteredPartitionsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUnfilteredPartitionsMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default GetUnfilteredPartitionsMetadataPublisher getUnfilteredPartitionsMetadataPaginator(
            Consumer<GetUnfilteredPartitionsMetadataRequest.Builder> getUnfilteredPartitionsMetadataRequest) {
        return getUnfilteredPartitionsMetadataPaginator(GetUnfilteredPartitionsMetadataRequest.builder()
                .applyMutation(getUnfilteredPartitionsMetadataRequest).build());
    }

    /**
     * <p>
     * Allows a third-party analytical engine to retrieve unfiltered table metadata from the Data Catalog.
     * </p>
     * <p>
     * For IAM authorization, the public IAM action associated with this API is <code>glue:GetTable</code>.
     * </p>
     *
     * @param getUnfilteredTableMetadataRequest
     * @return A Java Future containing the result of the GetUnfilteredTableMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>PermissionTypeMismatchException The operation timed out.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetUnfilteredTableMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUnfilteredTableMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetUnfilteredTableMetadataResponse> getUnfilteredTableMetadata(
            GetUnfilteredTableMetadataRequest getUnfilteredTableMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows a third-party analytical engine to retrieve unfiltered table metadata from the Data Catalog.
     * </p>
     * <p>
     * For IAM authorization, the public IAM action associated with this API is <code>glue:GetTable</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUnfilteredTableMetadataRequest.Builder} avoiding
     * the need to create one manually via {@link GetUnfilteredTableMetadataRequest#builder()}
     * </p>
     *
     * @param getUnfilteredTableMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetUnfilteredTableMetadataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetUnfilteredTableMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>PermissionTypeMismatchException The operation timed out.</li>
     *         <li>FederationSourceException A federation source failed.</li>
     *         <li>FederationSourceRetryableException A federation source failed, but the operation may be retried.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetUnfilteredTableMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUnfilteredTableMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetUnfilteredTableMetadataResponse> getUnfilteredTableMetadata(
            Consumer<GetUnfilteredTableMetadataRequest.Builder> getUnfilteredTableMetadataRequest) {
        return getUnfilteredTableMetadata(GetUnfilteredTableMetadataRequest.builder()
                .applyMutation(getUnfilteredTableMetadataRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified Glue usage profile.
     * </p>
     *
     * @param getUsageProfileRequest
     * @return A Java Future containing the result of the GetUsageProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>OperationNotSupportedException The operation is not available in the region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetUsageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUsageProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUsageProfileResponse> getUsageProfile(GetUsageProfileRequest getUsageProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified Glue usage profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUsageProfileRequest.Builder} avoiding the need
     * to create one manually via {@link GetUsageProfileRequest#builder()}
     * </p>
     *
     * @param getUsageProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetUsageProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetUsageProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>OperationNotSupportedException The operation is not available in the region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetUsageProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUsageProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUsageProfileResponse> getUsageProfile(
            Consumer<GetUsageProfileRequest.Builder> getUsageProfileRequest) {
        return getUsageProfile(GetUsageProfileRequest.builder().applyMutation(getUsageProfileRequest).build());
    }

    /**
     * <p>
     * Retrieves a specified function definition from the Data Catalog.
     * </p>
     *
     * @param getUserDefinedFunctionRequest
     * @return A Java Future containing the result of the GetUserDefinedFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetUserDefinedFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUserDefinedFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetUserDefinedFunctionResponse> getUserDefinedFunction(
            GetUserDefinedFunctionRequest getUserDefinedFunctionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a specified function definition from the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserDefinedFunctionRequest.Builder} avoiding the
     * need to create one manually via {@link GetUserDefinedFunctionRequest#builder()}
     * </p>
     *
     * @param getUserDefinedFunctionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetUserDefinedFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetUserDefinedFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUserDefinedFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetUserDefinedFunctionResponse> getUserDefinedFunction(
            Consumer<GetUserDefinedFunctionRequest.Builder> getUserDefinedFunctionRequest) {
        return getUserDefinedFunction(GetUserDefinedFunctionRequest.builder().applyMutation(getUserDefinedFunctionRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves multiple function definitions from the Data Catalog.
     * </p>
     *
     * @param getUserDefinedFunctionsRequest
     * @return A Java Future containing the result of the GetUserDefinedFunctions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetUserDefinedFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUserDefinedFunctions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetUserDefinedFunctionsResponse> getUserDefinedFunctions(
            GetUserDefinedFunctionsRequest getUserDefinedFunctionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves multiple function definitions from the Data Catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserDefinedFunctionsRequest.Builder} avoiding
     * the need to create one manually via {@link GetUserDefinedFunctionsRequest#builder()}
     * </p>
     *
     * @param getUserDefinedFunctionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetUserDefinedFunctions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetUserDefinedFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUserDefinedFunctions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetUserDefinedFunctionsResponse> getUserDefinedFunctions(
            Consumer<GetUserDefinedFunctionsRequest.Builder> getUserDefinedFunctionsRequest) {
        return getUserDefinedFunctions(GetUserDefinedFunctionsRequest.builder().applyMutation(getUserDefinedFunctionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getUserDefinedFunctions(software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetUserDefinedFunctionsPublisher publisher = client.getUserDefinedFunctionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetUserDefinedFunctionsPublisher publisher = client.getUserDefinedFunctionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUserDefinedFunctions(software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getUserDefinedFunctionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetUserDefinedFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUserDefinedFunctions" target="_top">AWS
     *      API Documentation</a>
     */
    default GetUserDefinedFunctionsPublisher getUserDefinedFunctionsPaginator(
            GetUserDefinedFunctionsRequest getUserDefinedFunctionsRequest) {
        return new GetUserDefinedFunctionsPublisher(this, getUserDefinedFunctionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getUserDefinedFunctions(software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetUserDefinedFunctionsPublisher publisher = client.getUserDefinedFunctionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetUserDefinedFunctionsPublisher publisher = client.getUserDefinedFunctionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUserDefinedFunctions(software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserDefinedFunctionsRequest.Builder} avoiding
     * the need to create one manually via {@link GetUserDefinedFunctionsRequest#builder()}
     * </p>
     *
     * @param getUserDefinedFunctionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>GlueEncryptionException An encryption operation failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetUserDefinedFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUserDefinedFunctions" target="_top">AWS
     *      API Documentation</a>
     */
    default GetUserDefinedFunctionsPublisher getUserDefinedFunctionsPaginator(
            Consumer<GetUserDefinedFunctionsRequest.Builder> getUserDefinedFunctionsRequest) {
        return getUserDefinedFunctionsPaginator(GetUserDefinedFunctionsRequest.builder()
                .applyMutation(getUserDefinedFunctionsRequest).build());
    }

    /**
     * <p>
     * Retrieves resource metadata for a workflow.
     * </p>
     *
     * @param getWorkflowRequest
     * @return A Java Future containing the result of the GetWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetWorkflowResponse> getWorkflow(GetWorkflowRequest getWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves resource metadata for a workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link GetWorkflowRequest#builder()}
     * </p>
     *
     * @param getWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetWorkflowRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetWorkflowResponse> getWorkflow(Consumer<GetWorkflowRequest.Builder> getWorkflowRequest) {
        return getWorkflow(GetWorkflowRequest.builder().applyMutation(getWorkflowRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata for a given workflow run. Job run history is accessible for 90 days for your workflow and
     * job run.
     * </p>
     *
     * @param getWorkflowRunRequest
     * @return A Java Future containing the result of the GetWorkflowRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetWorkflowRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflowRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetWorkflowRunResponse> getWorkflowRun(GetWorkflowRunRequest getWorkflowRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata for a given workflow run. Job run history is accessible for 90 days for your workflow and
     * job run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkflowRunRequest.Builder} avoiding the need to
     * create one manually via {@link GetWorkflowRunRequest#builder()}
     * </p>
     *
     * @param getWorkflowRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetWorkflowRunRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetWorkflowRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetWorkflowRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflowRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetWorkflowRunResponse> getWorkflowRun(Consumer<GetWorkflowRunRequest.Builder> getWorkflowRunRequest) {
        return getWorkflowRun(GetWorkflowRunRequest.builder().applyMutation(getWorkflowRunRequest).build());
    }

    /**
     * <p>
     * Retrieves the workflow run properties which were set during the run.
     * </p>
     *
     * @param getWorkflowRunPropertiesRequest
     * @return A Java Future containing the result of the GetWorkflowRunProperties operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetWorkflowRunProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflowRunProperties" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetWorkflowRunPropertiesResponse> getWorkflowRunProperties(
            GetWorkflowRunPropertiesRequest getWorkflowRunPropertiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the workflow run properties which were set during the run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkflowRunPropertiesRequest.Builder} avoiding
     * the need to create one manually via {@link GetWorkflowRunPropertiesRequest#builder()}
     * </p>
     *
     * @param getWorkflowRunPropertiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetWorkflowRunPropertiesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetWorkflowRunProperties operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetWorkflowRunProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflowRunProperties" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetWorkflowRunPropertiesResponse> getWorkflowRunProperties(
            Consumer<GetWorkflowRunPropertiesRequest.Builder> getWorkflowRunPropertiesRequest) {
        return getWorkflowRunProperties(GetWorkflowRunPropertiesRequest.builder().applyMutation(getWorkflowRunPropertiesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves metadata for all runs of a given workflow.
     * </p>
     *
     * @param getWorkflowRunsRequest
     * @return A Java Future containing the result of the GetWorkflowRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetWorkflowRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflowRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetWorkflowRunsResponse> getWorkflowRuns(GetWorkflowRunsRequest getWorkflowRunsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves metadata for all runs of a given workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkflowRunsRequest.Builder} avoiding the need
     * to create one manually via {@link GetWorkflowRunsRequest#builder()}
     * </p>
     *
     * @param getWorkflowRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetWorkflowRunsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetWorkflowRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetWorkflowRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflowRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetWorkflowRunsResponse> getWorkflowRuns(
            Consumer<GetWorkflowRunsRequest.Builder> getWorkflowRunsRequest) {
        return getWorkflowRuns(GetWorkflowRunsRequest.builder().applyMutation(getWorkflowRunsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #getWorkflowRuns(software.amazon.awssdk.services.glue.model.GetWorkflowRunsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetWorkflowRunsPublisher publisher = client.getWorkflowRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetWorkflowRunsPublisher publisher = client.getWorkflowRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetWorkflowRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetWorkflowRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getWorkflowRuns(software.amazon.awssdk.services.glue.model.GetWorkflowRunsRequest)} operation.</b>
     * </p>
     *
     * @param getWorkflowRunsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetWorkflowRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflowRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default GetWorkflowRunsPublisher getWorkflowRunsPaginator(GetWorkflowRunsRequest getWorkflowRunsRequest) {
        return new GetWorkflowRunsPublisher(this, getWorkflowRunsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #getWorkflowRuns(software.amazon.awssdk.services.glue.model.GetWorkflowRunsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetWorkflowRunsPublisher publisher = client.getWorkflowRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.glue.paginators.GetWorkflowRunsPublisher publisher = client.getWorkflowRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.glue.model.GetWorkflowRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.glue.model.GetWorkflowRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getWorkflowRuns(software.amazon.awssdk.services.glue.model.GetWorkflowRunsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkflowRunsRequest.Builder} avoiding the need
     * to create one manually via {@link GetWorkflowRunsRequest#builder()}
     * </p>
     *
     * @param getWorkflowRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.glue.model.GetWorkflowRunsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input provided was not valid.</li>
     *         <li>EntityNotFoundException A specified entity does not exist</li>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.GetWorkflowRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetWorkflowRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default GetWorkflowRunsPublisher getWorkflowRunsPaginator(Consumer<GetWorkflowRunsRequest.Builder> getWorkflowRunsRequest) {
        return getWorkflowRunsPaginator(GetWorkflowRunsRequest.builder().applyMutation(getWorkflowRunsRequest).build());
    }

    /**
     * <p>
     * Imports an existing Amazon Athena Data Catalog to Glue.
     * </p>
     *
     * @param importCatalogToGlueRequest
     * @return A Java Future containing the result of the ImportCatalogToGlue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException An internal service error occurred.</li>
     *         <li>OperationTimeoutException The operation timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GlueException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample GlueAsyncClient.ImportCatalogToGlue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ImportCatalogToGlue" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ImportCatalogToGlueResponse> importCatalogToGlue(
            ImportCatalogToGlueRequest importCatalogToGlueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports an