/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Separator {
    COMMA("comma"),
    CTRLA("ctrla"),
    PIPE("pipe"),
    SEMICOLON("semicolon"),
    TAB("tab"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Separator> VALUE_MAP;
    private final String value;

    private Separator(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Separator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Separator> knownValues() {
        EnumSet<Separator> knownValues = EnumSet.allOf(Separator.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Separator.class, Separator::toString);
    }
}

