/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.ConnectionPropertiesCopier;
import software.amazon.awssdk.services.glue.model.ConnectionPropertyKey;
import software.amazon.awssdk.services.glue.model.ConnectionType;
import software.amazon.awssdk.services.glue.model.MatchCriteriaCopier;
import software.amazon.awssdk.services.glue.model.PhysicalConnectionRequirements;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectionInput> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ConnectionInput.getter(ConnectionInput::name)).setter(ConnectionInput.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ConnectionInput.getter(ConnectionInput::description)).setter(ConnectionInput.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionType").getter(ConnectionInput.getter(ConnectionInput::connectionTypeAsString)).setter(ConnectionInput.setter(Builder::connectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()}).build();
    private static final SdkField<List<String>> MATCH_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MatchCriteria").getter(ConnectionInput.getter(ConnectionInput::matchCriteria)).setter(ConnectionInput.setter(Builder::matchCriteria)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchCriteria").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> CONNECTION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ConnectionProperties").getter(ConnectionInput.getter(ConnectionInput::connectionPropertiesAsStrings)).setter(ConnectionInput.setter(Builder::connectionPropertiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<PhysicalConnectionRequirements> PHYSICAL_CONNECTION_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PhysicalConnectionRequirements").getter(ConnectionInput.getter(ConnectionInput::physicalConnectionRequirements)).setter(ConnectionInput.setter(Builder::physicalConnectionRequirements)).constructor(PhysicalConnectionRequirements::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalConnectionRequirements").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, CONNECTION_TYPE_FIELD, MATCH_CRITERIA_FIELD, CONNECTION_PROPERTIES_FIELD, PHYSICAL_CONNECTION_REQUIREMENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String connectionType;
    private final List<String> matchCriteria;
    private final Map<String, String> connectionProperties;
    private final PhysicalConnectionRequirements physicalConnectionRequirements;

    private ConnectionInput(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.connectionType = builder.connectionType;
        this.matchCriteria = builder.matchCriteria;
        this.connectionProperties = builder.connectionProperties;
        this.physicalConnectionRequirements = builder.physicalConnectionRequirements;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final ConnectionType connectionType() {
        return ConnectionType.fromValue(this.connectionType);
    }

    public final String connectionTypeAsString() {
        return this.connectionType;
    }

    public final boolean hasMatchCriteria() {
        return this.matchCriteria != null && !(this.matchCriteria instanceof SdkAutoConstructList);
    }

    public final List<String> matchCriteria() {
        return this.matchCriteria;
    }

    public final Map<ConnectionPropertyKey, String> connectionProperties() {
        return ConnectionPropertiesCopier.copyStringToEnum(this.connectionProperties);
    }

    public final boolean hasConnectionProperties() {
        return this.connectionProperties != null && !(this.connectionProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> connectionPropertiesAsStrings() {
        return this.connectionProperties;
    }

    public final PhysicalConnectionRequirements physicalConnectionRequirements() {
        return this.physicalConnectionRequirements;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchCriteria() ? this.matchCriteria() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionProperties() ? this.connectionPropertiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalConnectionRequirements());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionInput)) {
            return false;
        }
        ConnectionInput other = (ConnectionInput)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.connectionTypeAsString(), other.connectionTypeAsString()) && this.hasMatchCriteria() == other.hasMatchCriteria() && Objects.equals(this.matchCriteria(), other.matchCriteria()) && this.hasConnectionProperties() == other.hasConnectionProperties() && Objects.equals(this.connectionPropertiesAsStrings(), other.connectionPropertiesAsStrings()) && Objects.equals(this.physicalConnectionRequirements(), other.physicalConnectionRequirements());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectionInput").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("ConnectionType", (Object)this.connectionTypeAsString()).add("MatchCriteria", this.hasMatchCriteria() ? this.matchCriteria() : null).add("ConnectionProperties", this.hasConnectionProperties() ? this.connectionPropertiesAsStrings() : null).add("PhysicalConnectionRequirements", (Object)this.physicalConnectionRequirements()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ConnectionType": {
                return Optional.ofNullable(clazz.cast(this.connectionTypeAsString()));
            }
            case "MatchCriteria": {
                return Optional.ofNullable(clazz.cast(this.matchCriteria()));
            }
            case "ConnectionProperties": {
                return Optional.ofNullable(clazz.cast(this.connectionPropertiesAsStrings()));
            }
            case "PhysicalConnectionRequirements": {
                return Optional.ofNullable(clazz.cast(this.physicalConnectionRequirements()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionInput, T> g) {
        return obj -> g.apply((ConnectionInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String connectionType;
        private List<String> matchCriteria = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> connectionProperties = DefaultSdkAutoConstructMap.getInstance();
        private PhysicalConnectionRequirements physicalConnectionRequirements;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionInput model) {
            this.name(model.name);
            this.description(model.description);
            this.connectionType(model.connectionType);
            this.matchCriteria(model.matchCriteria);
            this.connectionPropertiesWithStrings(model.connectionProperties);
            this.physicalConnectionRequirements(model.physicalConnectionRequirements);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getConnectionType() {
            return this.connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final Collection<String> getMatchCriteria() {
            if (this.matchCriteria instanceof SdkAutoConstructList) {
                return null;
            }
            return this.matchCriteria;
        }

        public final void setMatchCriteria(Collection<String> matchCriteria) {
            this.matchCriteria = MatchCriteriaCopier.copy(matchCriteria);
        }

        @Override
        public final Builder matchCriteria(Collection<String> matchCriteria) {
            this.matchCriteria = MatchCriteriaCopier.copy(matchCriteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchCriteria(String ... matchCriteria) {
            this.matchCriteria(Arrays.asList(matchCriteria));
            return this;
        }

        public final Map<String, String> getConnectionProperties() {
            if (this.connectionProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.connectionProperties;
        }

        public final void setConnectionProperties(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
        }

        @Override
        public final Builder connectionPropertiesWithStrings(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
            return this;
        }

        @Override
        public final Builder connectionProperties(Map<ConnectionPropertyKey, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copyEnumToString(connectionProperties);
            return this;
        }

        public final PhysicalConnectionRequirements.Builder getPhysicalConnectionRequirements() {
            return this.physicalConnectionRequirements != null ? this.physicalConnectionRequirements.toBuilder() : null;
        }

        public final void setPhysicalConnectionRequirements(PhysicalConnectionRequirements.BuilderImpl physicalConnectionRequirements) {
            this.physicalConnectionRequirements = physicalConnectionRequirements != null ? physicalConnectionRequirements.build() : null;
        }

        @Override
        public final Builder physicalConnectionRequirements(PhysicalConnectionRequirements physicalConnectionRequirements) {
            this.physicalConnectionRequirements = physicalConnectionRequirements;
            return this;
        }

        public ConnectionInput build() {
            return new ConnectionInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectionInput> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder connectionType(String var1);

        public Builder connectionType(ConnectionType var1);

        public Builder matchCriteria(Collection<String> var1);

        public Builder matchCriteria(String ... var1);

        public Builder connectionPropertiesWithStrings(Map<String, String> var1);

        public Builder connectionProperties(Map<ConnectionPropertyKey, String> var1);

        public Builder physicalConnectionRequirements(PhysicalConnectionRequirements var1);

        default public Builder physicalConnectionRequirements(Consumer<PhysicalConnectionRequirements.Builder> physicalConnectionRequirements) {
            return this.physicalConnectionRequirements((PhysicalConnectionRequirements)((PhysicalConnectionRequirements.Builder)PhysicalConnectionRequirements.builder().applyMutation(physicalConnectionRequirements)).build());
        }
    }
}

