/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUnfilteredTableMetadataResponse extends GlueResponse implements
        ToCopyableBuilder<GetUnfilteredTableMetadataResponse.Builder, GetUnfilteredTableMetadataResponse> {
    private static final SdkField<Table> TABLE_FIELD = SdkField.<Table> builder(MarshallingType.SDK_POJO).memberName("Table")
            .getter(getter(GetUnfilteredTableMetadataResponse::table)).setter(setter(Builder::table)).constructor(Table::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()).build();

    private static final SdkField<List<String>> AUTHORIZED_COLUMNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AuthorizedColumns")
            .getter(getter(GetUnfilteredTableMetadataResponse::authorizedColumns))
            .setter(setter(Builder::authorizedColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_REGISTERED_WITH_LAKE_FORMATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsRegisteredWithLakeFormation")
            .getter(getter(GetUnfilteredTableMetadataResponse::isRegisteredWithLakeFormation))
            .setter(setter(Builder::isRegisteredWithLakeFormation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsRegisteredWithLakeFormation")
                    .build()).build();

    private static final SdkField<List<ColumnRowFilter>> CELL_FILTERS_FIELD = SdkField
            .<List<ColumnRowFilter>> builder(MarshallingType.LIST)
            .memberName("CellFilters")
            .getter(getter(GetUnfilteredTableMetadataResponse::cellFilters))
            .setter(setter(Builder::cellFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CellFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnRowFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnRowFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> QUERY_AUTHORIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryAuthorizationId").getter(getter(GetUnfilteredTableMetadataResponse::queryAuthorizationId))
            .setter(setter(Builder::queryAuthorizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryAuthorizationId").build())
            .build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(GetUnfilteredTableMetadataResponse::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Permissions")
            .getter(getter(GetUnfilteredTableMetadataResponse::permissionsAsStrings))
            .setter(setter(Builder::permissionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_FIELD,
            AUTHORIZED_COLUMNS_FIELD, IS_REGISTERED_WITH_LAKE_FORMATION_FIELD, CELL_FILTERS_FIELD, QUERY_AUTHORIZATION_ID_FIELD,
            RESOURCE_ARN_FIELD, PERMISSIONS_FIELD));

    private final Table table;

    private final List<String> authorizedColumns;

    private final Boolean isRegisteredWithLakeFormation;

    private final List<ColumnRowFilter> cellFilters;

    private final String queryAuthorizationId;

    private final String resourceArn;

    private final List<String> permissions;

    private GetUnfilteredTableMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.table = builder.table;
        this.authorizedColumns = builder.authorizedColumns;
        this.isRegisteredWithLakeFormation = builder.isRegisteredWithLakeFormation;
        this.cellFilters = builder.cellFilters;
        this.queryAuthorizationId = builder.queryAuthorizationId;
        this.resourceArn = builder.resourceArn;
        this.permissions = builder.permissions;
    }

    /**
     * <p>
     * A Table object containing the table metadata.
     * </p>
     * 
     * @return A Table object containing the table metadata.
     */
    public final Table table() {
        return table;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthorizedColumns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAuthorizedColumns() {
        return authorizedColumns != null && !(authorizedColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of column names that the user has been granted access to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthorizedColumns} method.
     * </p>
     * 
     * @return A list of column names that the user has been granted access to.
     */
    public final List<String> authorizedColumns() {
        return authorizedColumns;
    }

    /**
     * <p>
     * A Boolean value that indicates whether the partition location is registered with Lake Formation.
     * </p>
     * 
     * @return A Boolean value that indicates whether the partition location is registered with Lake Formation.
     */
    public final Boolean isRegisteredWithLakeFormation() {
        return isRegisteredWithLakeFormation;
    }

    /**
     * For responses, this returns true if the service returned a value for the CellFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCellFilters() {
        return cellFilters != null && !(cellFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of column row filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCellFilters} method.
     * </p>
     * 
     * @return A list of column row filters.
     */
    public final List<ColumnRowFilter> cellFilters() {
        return cellFilters;
    }

    /**
     * <p>
     * A cryptographically generated query identifier generated by Glue or Lake Formation.
     * </p>
     * 
     * @return A cryptographically generated query identifier generated by Glue or Lake Formation.
     */
    public final String queryAuthorizationId() {
        return queryAuthorizationId;
    }

    /**
     * <p>
     * The resource ARN of the parent resource extracted from the request.
     * </p>
     * 
     * @return The resource ARN of the parent resource extracted from the request.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The Lake Formation data permissions of the caller on the table. Used to authorize the call when no view context
     * is found.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return The Lake Formation data permissions of the caller on the table. Used to authorize the call when no view
     *         context is found.
     */
    public final List<Permission> permissions() {
        return PermissionListCopier.copyStringToEnum(permissions);
    }

    /**
     * For responses, this returns true if the service returned a value for the Permissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Lake Formation data permissions of the caller on the table. Used to authorize the call when no view context
     * is found.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return The Lake Formation data permissions of the caller on the table. Used to authorize the call when no view
     *         context is found.
     */
    public final List<String> permissionsAsStrings() {
        return permissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(table());
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthorizedColumns() ? authorizedColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isRegisteredWithLakeFormation());
        hashCode = 31 * hashCode + Objects.hashCode(hasCellFilters() ? cellFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(queryAuthorizationId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissionsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUnfilteredTableMetadataResponse)) {
            return false;
        }
        GetUnfilteredTableMetadataResponse other = (GetUnfilteredTableMetadataResponse) obj;
        return Objects.equals(table(), other.table()) && hasAuthorizedColumns() == other.hasAuthorizedColumns()
                && Objects.equals(authorizedColumns(), other.authorizedColumns())
                && Objects.equals(isRegisteredWithLakeFormation(), other.isRegisteredWithLakeFormation())
                && hasCellFilters() == other.hasCellFilters() && Objects.equals(cellFilters(), other.cellFilters())
                && Objects.equals(queryAuthorizationId(), other.queryAuthorizationId())
                && Objects.equals(resourceArn(), other.resourceArn()) && hasPermissions() == other.hasPermissions()
                && Objects.equals(permissionsAsStrings(), other.permissionsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetUnfilteredTableMetadataResponse").add("Table", table())
                .add("AuthorizedColumns", hasAuthorizedColumns() ? authorizedColumns() : null)
                .add("IsRegisteredWithLakeFormation", isRegisteredWithLakeFormation())
                .add("CellFilters", hasCellFilters() ? cellFilters() : null).add("QueryAuthorizationId", queryAuthorizationId())
                .add("ResourceArn", resourceArn()).add("Permissions", hasPermissions() ? permissionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Table":
            return Optional.ofNullable(clazz.cast(table()));
        case "AuthorizedColumns":
            return Optional.ofNullable(clazz.cast(authorizedColumns()));
        case "IsRegisteredWithLakeFormation":
            return Optional.ofNullable(clazz.cast(isRegisteredWithLakeFormation()));
        case "CellFilters":
            return Optional.ofNullable(clazz.cast(cellFilters()));
        case "QueryAuthorizationId":
            return Optional.ofNullable(clazz.cast(queryAuthorizationId()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissionsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUnfilteredTableMetadataResponse, T> g) {
        return obj -> g.apply((GetUnfilteredTableMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetUnfilteredTableMetadataResponse> {
        /**
         * <p>
         * A Table object containing the table metadata.
         * </p>
         * 
         * @param table
         *        A Table object containing the table metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder table(Table table);

        /**
         * <p>
         * A Table object containing the table metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link Table.Builder} avoiding the need to
         * create one manually via {@link Table#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Table.Builder#build()} is called immediately and its result is
         * passed to {@link #table(Table)}.
         * 
         * @param table
         *        a consumer that will call methods on {@link Table.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #table(Table)
         */
        default Builder table(Consumer<Table.Builder> table) {
            return table(Table.builder().applyMutation(table).build());
        }

        /**
         * <p>
         * A list of column names that the user has been granted access to.
         * </p>
         * 
         * @param authorizedColumns
         *        A list of column names that the user has been granted access to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedColumns(Collection<String> authorizedColumns);

        /**
         * <p>
         * A list of column names that the user has been granted access to.
         * </p>
         * 
         * @param authorizedColumns
         *        A list of column names that the user has been granted access to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedColumns(String... authorizedColumns);

        /**
         * <p>
         * A Boolean value that indicates whether the partition location is registered with Lake Formation.
         * </p>
         * 
         * @param isRegisteredWithLakeFormation
         *        A Boolean value that indicates whether the partition location is registered with Lake Formation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isRegisteredWithLakeFormation(Boolean isRegisteredWithLakeFormation);

        /**
         * <p>
         * A list of column row filters.
         * </p>
         * 
         * @param cellFilters
         *        A list of column row filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cellFilters(Collection<ColumnRowFilter> cellFilters);

        /**
         * <p>
         * A list of column row filters.
         * </p>
         * 
         * @param cellFilters
         *        A list of column row filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cellFilters(ColumnRowFilter... cellFilters);

        /**
         * <p>
         * A list of column row filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.ColumnRowFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.ColumnRowFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.ColumnRowFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #cellFilters(List<ColumnRowFilter>)}.
         * 
         * @param cellFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.ColumnRowFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cellFilters(java.util.Collection<ColumnRowFilter>)
         */
        Builder cellFilters(Consumer<ColumnRowFilter.Builder>... cellFilters);

        /**
         * <p>
         * A cryptographically generated query identifier generated by Glue or Lake Formation.
         * </p>
         * 
         * @param queryAuthorizationId
         *        A cryptographically generated query identifier generated by Glue or Lake Formation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryAuthorizationId(String queryAuthorizationId);

        /**
         * <p>
         * The resource ARN of the parent resource extracted from the request.
         * </p>
         * 
         * @param resourceArn
         *        The resource ARN of the parent resource extracted from the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The Lake Formation data permissions of the caller on the table. Used to authorize the call when no view
         * context is found.
         * </p>
         * 
         * @param permissions
         *        The Lake Formation data permissions of the caller on the table. Used to authorize the call when no
         *        view context is found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithStrings(Collection<String> permissions);

        /**
         * <p>
         * The Lake Formation data permissions of the caller on the table. Used to authorize the call when no view
         * context is found.
         * </p>
         * 
         * @param permissions
         *        The Lake Formation data permissions of the caller on the table. Used to authorize the call when no
         *        view context is found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithStrings(String... permissions);

        /**
         * <p>
         * The Lake Formation data permissions of the caller on the table. Used to authorize the call when no view
         * context is found.
         * </p>
         * 
         * @param permissions
         *        The Lake Formation data permissions of the caller on the table. Used to authorize the call when no
         *        view context is found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<Permission> permissions);

        /**
         * <p>
         * The Lake Formation data permissions of the caller on the table. Used to authorize the call when no view
         * context is found.
         * </p>
         * 
         * @param permissions
         *        The Lake Formation data permissions of the caller on the table. Used to authorize the call when no
         *        view context is found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Permission... permissions);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private Table table;

        private List<String> authorizedColumns = DefaultSdkAutoConstructList.getInstance();

        private Boolean isRegisteredWithLakeFormation;

        private List<ColumnRowFilter> cellFilters = DefaultSdkAutoConstructList.getInstance();

        private String queryAuthorizationId;

        private String resourceArn;

        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetUnfilteredTableMetadataResponse model) {
            super(model);
            table(model.table);
            authorizedColumns(model.authorizedColumns);
            isRegisteredWithLakeFormation(model.isRegisteredWithLakeFormation);
            cellFilters(model.cellFilters);
            queryAuthorizationId(model.queryAuthorizationId);
            resourceArn(model.resourceArn);
            permissionsWithStrings(model.permissions);
        }

        public final Table.Builder getTable() {
            return table != null ? table.toBuilder() : null;
        }

        public final void setTable(Table.BuilderImpl table) {
            this.table = table != null ? table.build() : null;
        }

        @Override
        public final Builder table(Table table) {
            this.table = table;
            return this;
        }

        public final Collection<String> getAuthorizedColumns() {
            if (authorizedColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return authorizedColumns;
        }

        public final void setAuthorizedColumns(Collection<String> authorizedColumns) {
            this.authorizedColumns = NameStringListCopier.copy(authorizedColumns);
        }

        @Override
        public final Builder authorizedColumns(Collection<String> authorizedColumns) {
            this.authorizedColumns = NameStringListCopier.copy(authorizedColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedColumns(String... authorizedColumns) {
            authorizedColumns(Arrays.asList(authorizedColumns));
            return this;
        }

        public final Boolean getIsRegisteredWithLakeFormation() {
            return isRegisteredWithLakeFormation;
        }

        public final void setIsRegisteredWithLakeFormation(Boolean isRegisteredWithLakeFormation) {
            this.isRegisteredWithLakeFormation = isRegisteredWithLakeFormation;
        }

        @Override
        public final Builder isRegisteredWithLakeFormation(Boolean isRegisteredWithLakeFormation) {
            this.isRegisteredWithLakeFormation = isRegisteredWithLakeFormation;
            return this;
        }

        public final List<ColumnRowFilter.Builder> getCellFilters() {
            List<ColumnRowFilter.Builder> result = ColumnRowFilterListCopier.copyToBuilder(this.cellFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCellFilters(Collection<ColumnRowFilter.BuilderImpl> cellFilters) {
            this.cellFilters = ColumnRowFilterListCopier.copyFromBuilder(cellFilters);
        }

        @Override
        public final Builder cellFilters(Collection<ColumnRowFilter> cellFilters) {
            this.cellFilters = ColumnRowFilterListCopier.copy(cellFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cellFilters(ColumnRowFilter... cellFilters) {
            cellFilters(Arrays.asList(cellFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cellFilters(Consumer<ColumnRowFilter.Builder>... cellFilters) {
            cellFilters(Stream.of(cellFilters).map(c -> ColumnRowFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getQueryAuthorizationId() {
            return queryAuthorizationId;
        }

        public final void setQueryAuthorizationId(String queryAuthorizationId) {
            this.queryAuthorizationId = queryAuthorizationId;
        }

        @Override
        public final Builder queryAuthorizationId(String queryAuthorizationId) {
            this.queryAuthorizationId = queryAuthorizationId;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Collection<String> getPermissions() {
            if (permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return permissions;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
        }

        @Override
        public final Builder permissionsWithStrings(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithStrings(String... permissions) {
            permissionsWithStrings(Arrays.asList(permissions));
            return this;
        }

        @Override
        public final Builder permissions(Collection<Permission> permissions) {
            this.permissions = PermissionListCopier.copyEnumToString(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Permission... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        public GetUnfilteredTableMetadataResponse build() {
            return new GetUnfilteredTableMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
