/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.PrincipalsCopier;
import software.amazon.awssdk.services.globalaccelerator.model.Resource;
import software.amazon.awssdk.services.globalaccelerator.model.ResourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCrossAccountAttachmentRequest
extends GlobalAcceleratorRequest
implements ToCopyableBuilder<Builder, UpdateCrossAccountAttachmentRequest> {
    private static final SdkField<String> ATTACHMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttachmentArn").getter(UpdateCrossAccountAttachmentRequest.getter(UpdateCrossAccountAttachmentRequest::attachmentArn)).setter(UpdateCrossAccountAttachmentRequest.setter(Builder::attachmentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateCrossAccountAttachmentRequest.getter(UpdateCrossAccountAttachmentRequest::name)).setter(UpdateCrossAccountAttachmentRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> ADD_PRINCIPALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddPrincipals").getter(UpdateCrossAccountAttachmentRequest.getter(UpdateCrossAccountAttachmentRequest::addPrincipals)).setter(UpdateCrossAccountAttachmentRequest.setter(Builder::addPrincipals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddPrincipals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_PRINCIPALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemovePrincipals").getter(UpdateCrossAccountAttachmentRequest.getter(UpdateCrossAccountAttachmentRequest::removePrincipals)).setter(UpdateCrossAccountAttachmentRequest.setter(Builder::removePrincipals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemovePrincipals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Resource>> ADD_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddResources").getter(UpdateCrossAccountAttachmentRequest.getter(UpdateCrossAccountAttachmentRequest::addResources)).setter(UpdateCrossAccountAttachmentRequest.setter(Builder::addResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Resource>> REMOVE_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveResources").getter(UpdateCrossAccountAttachmentRequest.getter(UpdateCrossAccountAttachmentRequest::removeResources)).setter(UpdateCrossAccountAttachmentRequest.setter(Builder::removeResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_ARN_FIELD, NAME_FIELD, ADD_PRINCIPALS_FIELD, REMOVE_PRINCIPALS_FIELD, ADD_RESOURCES_FIELD, REMOVE_RESOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateCrossAccountAttachmentRequest.memberNameToFieldInitializer();
    private final String attachmentArn;
    private final String name;
    private final List<String> addPrincipals;
    private final List<String> removePrincipals;
    private final List<Resource> addResources;
    private final List<Resource> removeResources;

    private UpdateCrossAccountAttachmentRequest(BuilderImpl builder) {
        super(builder);
        this.attachmentArn = builder.attachmentArn;
        this.name = builder.name;
        this.addPrincipals = builder.addPrincipals;
        this.removePrincipals = builder.removePrincipals;
        this.addResources = builder.addResources;
        this.removeResources = builder.removeResources;
    }

    public final String attachmentArn() {
        return this.attachmentArn;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasAddPrincipals() {
        return this.addPrincipals != null && !(this.addPrincipals instanceof SdkAutoConstructList);
    }

    public final List<String> addPrincipals() {
        return this.addPrincipals;
    }

    public final boolean hasRemovePrincipals() {
        return this.removePrincipals != null && !(this.removePrincipals instanceof SdkAutoConstructList);
    }

    public final List<String> removePrincipals() {
        return this.removePrincipals;
    }

    public final boolean hasAddResources() {
        return this.addResources != null && !(this.addResources instanceof SdkAutoConstructList);
    }

    public final List<Resource> addResources() {
        return this.addResources;
    }

    public final boolean hasRemoveResources() {
        return this.removeResources != null && !(this.removeResources instanceof SdkAutoConstructList);
    }

    public final List<Resource> removeResources() {
        return this.removeResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddPrincipals() ? this.addPrincipals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemovePrincipals() ? this.removePrincipals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddResources() ? this.addResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveResources() ? this.removeResources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCrossAccountAttachmentRequest)) {
            return false;
        }
        UpdateCrossAccountAttachmentRequest other = (UpdateCrossAccountAttachmentRequest)((Object)obj);
        return Objects.equals(this.attachmentArn(), other.attachmentArn()) && Objects.equals(this.name(), other.name()) && this.hasAddPrincipals() == other.hasAddPrincipals() && Objects.equals(this.addPrincipals(), other.addPrincipals()) && this.hasRemovePrincipals() == other.hasRemovePrincipals() && Objects.equals(this.removePrincipals(), other.removePrincipals()) && this.hasAddResources() == other.hasAddResources() && Objects.equals(this.addResources(), other.addResources()) && this.hasRemoveResources() == other.hasRemoveResources() && Objects.equals(this.removeResources(), other.removeResources());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCrossAccountAttachmentRequest").add("AttachmentArn", (Object)this.attachmentArn()).add("Name", (Object)this.name()).add("AddPrincipals", this.hasAddPrincipals() ? this.addPrincipals() : null).add("RemovePrincipals", this.hasRemovePrincipals() ? this.removePrincipals() : null).add("AddResources", this.hasAddResources() ? this.addResources() : null).add("RemoveResources", this.hasRemoveResources() ? this.removeResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttachmentArn": {
                return Optional.ofNullable(clazz.cast(this.attachmentArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "AddPrincipals": {
                return Optional.ofNullable(clazz.cast(this.addPrincipals()));
            }
            case "RemovePrincipals": {
                return Optional.ofNullable(clazz.cast(this.removePrincipals()));
            }
            case "AddResources": {
                return Optional.ofNullable(clazz.cast(this.addResources()));
            }
            case "RemoveResources": {
                return Optional.ofNullable(clazz.cast(this.removeResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AttachmentArn", ATTACHMENT_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("AddPrincipals", ADD_PRINCIPALS_FIELD);
        map.put("RemovePrincipals", REMOVE_PRINCIPALS_FIELD);
        map.put("AddResources", ADD_RESOURCES_FIELD);
        map.put("RemoveResources", REMOVE_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCrossAccountAttachmentRequest, T> g) {
        return obj -> g.apply((UpdateCrossAccountAttachmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlobalAcceleratorRequest.BuilderImpl
    implements Builder {
        private String attachmentArn;
        private String name;
        private List<String> addPrincipals = DefaultSdkAutoConstructList.getInstance();
        private List<String> removePrincipals = DefaultSdkAutoConstructList.getInstance();
        private List<Resource> addResources = DefaultSdkAutoConstructList.getInstance();
        private List<Resource> removeResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCrossAccountAttachmentRequest model) {
            super(model);
            this.attachmentArn(model.attachmentArn);
            this.name(model.name);
            this.addPrincipals(model.addPrincipals);
            this.removePrincipals(model.removePrincipals);
            this.addResources(model.addResources);
            this.removeResources(model.removeResources);
        }

        public final String getAttachmentArn() {
            return this.attachmentArn;
        }

        public final void setAttachmentArn(String attachmentArn) {
            this.attachmentArn = attachmentArn;
        }

        @Override
        public final Builder attachmentArn(String attachmentArn) {
            this.attachmentArn = attachmentArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getAddPrincipals() {
            if (this.addPrincipals instanceof SdkAutoConstructList) {
                return null;
            }
            return this.addPrincipals;
        }

        public final void setAddPrincipals(Collection<String> addPrincipals) {
            this.addPrincipals = PrincipalsCopier.copy(addPrincipals);
        }

        @Override
        public final Builder addPrincipals(Collection<String> addPrincipals) {
            this.addPrincipals = PrincipalsCopier.copy(addPrincipals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addPrincipals(String ... addPrincipals) {
            this.addPrincipals(Arrays.asList(addPrincipals));
            return this;
        }

        public final Collection<String> getRemovePrincipals() {
            if (this.removePrincipals instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removePrincipals;
        }

        public final void setRemovePrincipals(Collection<String> removePrincipals) {
            this.removePrincipals = PrincipalsCopier.copy(removePrincipals);
        }

        @Override
        public final Builder removePrincipals(Collection<String> removePrincipals) {
            this.removePrincipals = PrincipalsCopier.copy(removePrincipals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removePrincipals(String ... removePrincipals) {
            this.removePrincipals(Arrays.asList(removePrincipals));
            return this;
        }

        public final List<Resource.Builder> getAddResources() {
            List<Resource.Builder> result = ResourcesCopier.copyToBuilder(this.addResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddResources(Collection<Resource.BuilderImpl> addResources) {
            this.addResources = ResourcesCopier.copyFromBuilder(addResources);
        }

        @Override
        public final Builder addResources(Collection<Resource> addResources) {
            this.addResources = ResourcesCopier.copy(addResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addResources(Resource ... addResources) {
            this.addResources(Arrays.asList(addResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addResources(Consumer<Resource.Builder> ... addResources) {
            this.addResources(Stream.of(addResources).map(c -> (Resource)((Resource.Builder)Resource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Resource.Builder> getRemoveResources() {
            List<Resource.Builder> result = ResourcesCopier.copyToBuilder(this.removeResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoveResources(Collection<Resource.BuilderImpl> removeResources) {
            this.removeResources = ResourcesCopier.copyFromBuilder(removeResources);
        }

        @Override
        public final Builder removeResources(Collection<Resource> removeResources) {
            this.removeResources = ResourcesCopier.copy(removeResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeResources(Resource ... removeResources) {
            this.removeResources(Arrays.asList(removeResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeResources(Consumer<Resource.Builder> ... removeResources) {
            this.removeResources(Stream.of(removeResources).map(c -> (Resource)((Resource.Builder)Resource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCrossAccountAttachmentRequest build() {
            return new UpdateCrossAccountAttachmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlobalAcceleratorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCrossAccountAttachmentRequest> {
        public Builder attachmentArn(String var1);

        public Builder name(String var1);

        public Builder addPrincipals(Collection<String> var1);

        public Builder addPrincipals(String ... var1);

        public Builder removePrincipals(Collection<String> var1);

        public Builder removePrincipals(String ... var1);

        public Builder addResources(Collection<Resource> var1);

        public Builder addResources(Resource ... var1);

        public Builder addResources(Consumer<Resource.Builder> ... var1);

        public Builder removeResources(Collection<Resource> var1);

        public Builder removeResources(Resource ... var1);

        public Builder removeResources(Consumer<Resource.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

