/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorClient;
import software.amazon.awssdk.services.globalaccelerator.internal.UserAgentUtils;
import software.amazon.awssdk.services.globalaccelerator.model.CrossAccountResource;
import software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountResourcesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountResourcesResponse;

public class ListCrossAccountResourcesIterable
implements SdkIterable<ListCrossAccountResourcesResponse> {
    private final GlobalAcceleratorClient client;
    private final ListCrossAccountResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCrossAccountResourcesIterable(GlobalAcceleratorClient client, ListCrossAccountResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCrossAccountResourcesResponseFetcher();
    }

    public Iterator<ListCrossAccountResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CrossAccountResource> crossAccountResources() {
        Function<ListCrossAccountResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.crossAccountResources() != null) {
                return response.crossAccountResources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCrossAccountResourcesResponseFetcher
    implements SyncPageFetcher<ListCrossAccountResourcesResponse> {
        private ListCrossAccountResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListCrossAccountResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCrossAccountResourcesResponse nextPage(ListCrossAccountResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListCrossAccountResourcesIterable.this.client.listCrossAccountResources(ListCrossAccountResourcesIterable.this.firstRequest);
            }
            return ListCrossAccountResourcesIterable.this.client.listCrossAccountResources((ListCrossAccountResourcesRequest)((Object)ListCrossAccountResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

