/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RouteTruckType {
    LIGHT_TRUCK("LightTruck"),
    STRAIGHT_TRUCK("StraightTruck"),
    TRACTOR("Tractor"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RouteTruckType> VALUE_MAP;
    private final String value;

    private RouteTruckType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RouteTruckType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RouteTruckType> knownValues() {
        EnumSet<RouteTruckType> knownValues = EnumSet.allOf(RouteTruckType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RouteTruckType.class, RouteTruckType::toString);
    }
}

