/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RouteSpanAdditionalFeature {
    BEST_CASE_DURATION("BestCaseDuration"),
    CAR_ACCESS("CarAccess"),
    COUNTRY("Country"),
    DISTANCE("Distance"),
    DURATION("Duration"),
    DYNAMIC_SPEED("DynamicSpeed"),
    FUNCTIONAL_CLASSIFICATION("FunctionalClassification"),
    GATES("Gates"),
    INCIDENTS("Incidents"),
    NAMES("Names"),
    NOTICES("Notices"),
    PEDESTRIAN_ACCESS("PedestrianAccess"),
    RAILWAY_CROSSINGS("RailwayCrossings"),
    REGION("Region"),
    ROAD_ATTRIBUTES("RoadAttributes"),
    ROUTE_NUMBERS("RouteNumbers"),
    SCOOTER_ACCESS("ScooterAccess"),
    SPEED_LIMIT("SpeedLimit"),
    TOLL_SYSTEMS("TollSystems"),
    TRUCK_ACCESS("TruckAccess"),
    TRUCK_ROAD_TYPES("TruckRoadTypes"),
    TYPICAL_DURATION("TypicalDuration"),
    ZONES("Zones"),
    CONSUMPTION("Consumption"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RouteSpanAdditionalFeature> VALUE_MAP;
    private final String value;

    private RouteSpanAdditionalFeature(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RouteSpanAdditionalFeature fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RouteSpanAdditionalFeature> knownValues() {
        EnumSet<RouteSpanAdditionalFeature> knownValues = EnumSet.allOf(RouteSpanAdditionalFeature.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RouteSpanAdditionalFeature.class, RouteSpanAdditionalFeature::toString);
    }
}

