/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteVehicleOverviewSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteVehicleOverviewSummary> {
    private static final SdkField<Long> BEST_CASE_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BestCaseDuration").getter(RouteVehicleOverviewSummary.getter(RouteVehicleOverviewSummary::bestCaseDuration)).setter(RouteVehicleOverviewSummary.setter(Builder::bestCaseDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BestCaseDuration").build()}).build();
    private static final SdkField<Long> DISTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Distance").getter(RouteVehicleOverviewSummary.getter(RouteVehicleOverviewSummary::distance)).setter(RouteVehicleOverviewSummary.setter(Builder::distance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distance").build()}).build();
    private static final SdkField<Long> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Duration").getter(RouteVehicleOverviewSummary.getter(RouteVehicleOverviewSummary::duration)).setter(RouteVehicleOverviewSummary.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<Long> TYPICAL_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TypicalDuration").getter(RouteVehicleOverviewSummary.getter(RouteVehicleOverviewSummary::typicalDuration)).setter(RouteVehicleOverviewSummary.setter(Builder::typicalDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypicalDuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEST_CASE_DURATION_FIELD, DISTANCE_FIELD, DURATION_FIELD, TYPICAL_DURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteVehicleOverviewSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long bestCaseDuration;
    private final Long distance;
    private final Long duration;
    private final Long typicalDuration;

    private RouteVehicleOverviewSummary(BuilderImpl builder) {
        this.bestCaseDuration = builder.bestCaseDuration;
        this.distance = builder.distance;
        this.duration = builder.duration;
        this.typicalDuration = builder.typicalDuration;
    }

    public final Long bestCaseDuration() {
        return this.bestCaseDuration;
    }

    public final Long distance() {
        return this.distance;
    }

    public final Long duration() {
        return this.duration;
    }

    public final Long typicalDuration() {
        return this.typicalDuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bestCaseDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.distance());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.typicalDuration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteVehicleOverviewSummary)) {
            return false;
        }
        RouteVehicleOverviewSummary other = (RouteVehicleOverviewSummary)obj;
        return Objects.equals(this.bestCaseDuration(), other.bestCaseDuration()) && Objects.equals(this.distance(), other.distance()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.typicalDuration(), other.typicalDuration());
    }

    public final String toString() {
        return ToString.builder((String)"RouteVehicleOverviewSummary").add("BestCaseDuration", (Object)(this.bestCaseDuration() == null ? null : "*** Sensitive Data Redacted ***")).add("Distance", (Object)(this.distance() == null ? null : "*** Sensitive Data Redacted ***")).add("Duration", (Object)(this.duration() == null ? null : "*** Sensitive Data Redacted ***")).add("TypicalDuration", (Object)(this.typicalDuration() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BestCaseDuration": {
                return Optional.ofNullable(clazz.cast(this.bestCaseDuration()));
            }
            case "Distance": {
                return Optional.ofNullable(clazz.cast(this.distance()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "TypicalDuration": {
                return Optional.ofNullable(clazz.cast(this.typicalDuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Long>> map = new HashMap<String, SdkField<Long>>();
        map.put("BestCaseDuration", BEST_CASE_DURATION_FIELD);
        map.put("Distance", DISTANCE_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("TypicalDuration", TYPICAL_DURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteVehicleOverviewSummary, T> g) {
        return obj -> g.apply((RouteVehicleOverviewSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long bestCaseDuration;
        private Long distance;
        private Long duration;
        private Long typicalDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteVehicleOverviewSummary model) {
            this.bestCaseDuration(model.bestCaseDuration);
            this.distance(model.distance);
            this.duration(model.duration);
            this.typicalDuration(model.typicalDuration);
        }

        public final Long getBestCaseDuration() {
            return this.bestCaseDuration;
        }

        public final void setBestCaseDuration(Long bestCaseDuration) {
            this.bestCaseDuration = bestCaseDuration;
        }

        @Override
        public final Builder bestCaseDuration(Long bestCaseDuration) {
            this.bestCaseDuration = bestCaseDuration;
            return this;
        }

        public final Long getDistance() {
            return this.distance;
        }

        public final void setDistance(Long distance) {
            this.distance = distance;
        }

        @Override
        public final Builder distance(Long distance) {
            this.distance = distance;
            return this;
        }

        public final Long getDuration() {
            return this.duration;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final Long getTypicalDuration() {
            return this.typicalDuration;
        }

        public final void setTypicalDuration(Long typicalDuration) {
            this.typicalDuration = typicalDuration;
        }

        @Override
        public final Builder typicalDuration(Long typicalDuration) {
            this.typicalDuration = typicalDuration;
            return this;
        }

        public RouteVehicleOverviewSummary build() {
            return new RouteVehicleOverviewSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteVehicleOverviewSummary> {
        public Builder bestCaseDuration(Long var1);

        public Builder distance(Long var1);

        public Builder duration(Long var1);

        public Builder typicalDuration(Long var1);
    }
}

