/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RouteRoadType {
    HIGHWAY("Highway"),
    RURAL("Rural"),
    URBAN("Urban"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RouteRoadType> VALUE_MAP;
    private final String value;

    private RouteRoadType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RouteRoadType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RouteRoadType> knownValues() {
        EnumSet<RouteRoadType> knownValues = EnumSet.allOf(RouteRoadType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RouteRoadType.class, RouteRoadType::toString);
    }
}

