/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.PositionCopier;
import software.amazon.awssdk.services.georoutes.model.SideOfStreetMatchingStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteMatrixSideOfStreetOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteMatrixSideOfStreetOptions> {
    private static final SdkField<List<Double>> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Position").getter(RouteMatrixSideOfStreetOptions.getter(RouteMatrixSideOfStreetOptions::position)).setter(RouteMatrixSideOfStreetOptions.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> USE_WITH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UseWith").getter(RouteMatrixSideOfStreetOptions.getter(RouteMatrixSideOfStreetOptions::useWithAsString)).setter(RouteMatrixSideOfStreetOptions.setter(Builder::useWith)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseWith").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POSITION_FIELD, USE_WITH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteMatrixSideOfStreetOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Double> position;
    private final String useWith;

    private RouteMatrixSideOfStreetOptions(BuilderImpl builder) {
        this.position = builder.position;
        this.useWith = builder.useWith;
    }

    public final boolean hasPosition() {
        return this.position != null && !(this.position instanceof SdkAutoConstructList);
    }

    public final List<Double> position() {
        return this.position;
    }

    public final SideOfStreetMatchingStrategy useWith() {
        return SideOfStreetMatchingStrategy.fromValue(this.useWith);
    }

    public final String useWithAsString() {
        return this.useWith;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPosition() ? this.position() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.useWithAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteMatrixSideOfStreetOptions)) {
            return false;
        }
        RouteMatrixSideOfStreetOptions other = (RouteMatrixSideOfStreetOptions)obj;
        return this.hasPosition() == other.hasPosition() && Objects.equals(this.position(), other.position()) && Objects.equals(this.useWithAsString(), other.useWithAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RouteMatrixSideOfStreetOptions").add("Position", (Object)(this.position() == null ? null : "*** Sensitive Data Redacted ***")).add("UseWith", (Object)this.useWithAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "UseWith": {
                return Optional.ofNullable(clazz.cast(this.useWithAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Position", POSITION_FIELD);
        map.put("UseWith", USE_WITH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteMatrixSideOfStreetOptions, T> g) {
        return obj -> g.apply((RouteMatrixSideOfStreetOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Double> position = DefaultSdkAutoConstructList.getInstance();
        private String useWith;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteMatrixSideOfStreetOptions model) {
            this.position(model.position);
            this.useWith(model.useWith);
        }

        public final Collection<Double> getPosition() {
            if (this.position instanceof SdkAutoConstructList) {
                return null;
            }
            return this.position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
        }

        @Override
        public final Builder position(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Double ... position) {
            this.position(Arrays.asList(position));
            return this;
        }

        public final String getUseWith() {
            return this.useWith;
        }

        public final void setUseWith(String useWith) {
            this.useWith = useWith;
        }

        @Override
        public final Builder useWith(String useWith) {
            this.useWith = useWith;
            return this;
        }

        @Override
        public final Builder useWith(SideOfStreetMatchingStrategy useWith) {
            this.useWith(useWith == null ? null : useWith.toString());
            return this;
        }

        public RouteMatrixSideOfStreetOptions build() {
            return new RouteMatrixSideOfStreetOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteMatrixSideOfStreetOptions> {
        public Builder position(Collection<Double> var1);

        public Builder position(Double ... var1);

        public Builder useWith(String var1);

        public Builder useWith(SideOfStreetMatchingStrategy var1);
    }
}

