/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.LineStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IsolineConnectionGeometry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IsolineConnectionGeometry> {
    private static final SdkField<List<List<Double>>> LINE_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LineString").getter(IsolineConnectionGeometry.getter(IsolineConnectionGeometry::lineString)).setter(IsolineConnectionGeometry.setter(Builder::lineString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineString").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> POLYLINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Polyline").getter(IsolineConnectionGeometry.getter(IsolineConnectionGeometry::polyline)).setter(IsolineConnectionGeometry.setter(Builder::polyline)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Polyline").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINE_STRING_FIELD, POLYLINE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IsolineConnectionGeometry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<List<Double>> lineString;
    private final String polyline;

    private IsolineConnectionGeometry(BuilderImpl builder) {
        this.lineString = builder.lineString;
        this.polyline = builder.polyline;
    }

    public final boolean hasLineString() {
        return this.lineString != null && !(this.lineString instanceof SdkAutoConstructList);
    }

    public final List<List<Double>> lineString() {
        return this.lineString;
    }

    public final String polyline() {
        return this.polyline;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLineString() ? this.lineString() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.polyline());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IsolineConnectionGeometry)) {
            return false;
        }
        IsolineConnectionGeometry other = (IsolineConnectionGeometry)obj;
        return this.hasLineString() == other.hasLineString() && Objects.equals(this.lineString(), other.lineString()) && Objects.equals(this.polyline(), other.polyline());
    }

    public final String toString() {
        return ToString.builder((String)"IsolineConnectionGeometry").add("LineString", (Object)(this.lineString() == null ? null : "*** Sensitive Data Redacted ***")).add("Polyline", (Object)(this.polyline() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LineString": {
                return Optional.ofNullable(clazz.cast(this.lineString()));
            }
            case "Polyline": {
                return Optional.ofNullable(clazz.cast(this.polyline()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LineString", LINE_STRING_FIELD);
        map.put("Polyline", POLYLINE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IsolineConnectionGeometry, T> g) {
        return obj -> g.apply((IsolineConnectionGeometry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<List<Double>> lineString = DefaultSdkAutoConstructList.getInstance();
        private String polyline;

        private BuilderImpl() {
        }

        private BuilderImpl(IsolineConnectionGeometry model) {
            this.lineString(model.lineString);
            this.polyline(model.polyline);
        }

        public final Collection<? extends Collection<Double>> getLineString() {
            if (this.lineString instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lineString;
        }

        public final void setLineString(Collection<? extends Collection<Double>> lineString) {
            this.lineString = LineStringCopier.copy(lineString);
        }

        @Override
        public final Builder lineString(Collection<? extends Collection<Double>> lineString) {
            this.lineString = LineStringCopier.copy(lineString);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineString(Collection<Double> ... lineString) {
            this.lineString((Collection<? extends Collection<Double>>)Arrays.asList(lineString));
            return this;
        }

        public final String getPolyline() {
            return this.polyline;
        }

        public final void setPolyline(String polyline) {
            this.polyline = polyline;
        }

        @Override
        public final Builder polyline(String polyline) {
            this.polyline = polyline;
            return this;
        }

        public IsolineConnectionGeometry build() {
            return new IsolineConnectionGeometry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IsolineConnectionGeometry> {
        public Builder lineString(Collection<? extends Collection<Double>> var1);

        public Builder lineString(Collection<Double> ... var1);

        public Builder polyline(String var1);
    }
}

